<?php

$page_security = 'SA_CUSTPAYMREP';

// ----------------------------------------------------------------
// $ Revision:  2.0 $
// Creator: Joe Hunt
// date_:   2005-05-19
// Title:   Customer Balances
// ----------------------------------------------------------------
$path_to_root="..";
include($path_to_root . "/reporting/includes/reporting.inc");

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/inventory/includes/db/invetory_db.inc");
// include_once($path_to_root . "/includes/ui/ui_input.inc");
include_once($path_to_root . "/includes/db/manufacturing_db.inc");





//----------------------------------------------------------------------------------------------------




print_customer_balances();


//----------------------------------------------------------------------------------------------------

function print_customer_balances()
{
        global $path_to_root, $systypes_array;

$destination =     $_POST['PARAM_0'];
$from =            $_POST['PARAM_1'];
$to =              $_POST['PARAM_2'];
$trans_type =      $_POST['PARAM_3'];
$def_orientation = $_POST['PARAM_4']=1;



    if ($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

    $def_orientation = ($def_orientation ? 'L' : 'P');
    $dec = user_price_dec();




    $cols = array(0,  100,  210, 350,450);


    $headers = array(_('Type'), _('Description'), _('Amount'), _('Outputs/Inputs') );


    $aligns = array('left', 'left',   'left', 'left');


    $params =   array(  0 => $comments,
                        1 => array('text' => _('Period'), 'from' => $from, 'to' => $to),
                        // 2 => array('text' => _('Bank Account'), 'from' => $act['bank_account_name']." - ".$act['bank_curr_code'])
                        // 3 => array('text' => _('Reference'), 'from' => (!$reference ? "ALL Reference    " : $reference) )
                        

                    );

    $rep = new FrontReport(_('Tax Inquiry'), "Tax Inquiry", user_pagesize(), 9, $def_orientation);

    if ($def_orientation == 'L')
    recalculate_cols($cols);
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();





    $total = 0;
    $taxes = get_tax_summary($from, $to);

// $rep->TextColLines(200, 300,'from date--->  '.$from."To Date--->  ".$to, -2,200);
if(db_num_rows($taxes) > 0)
{
    while ($tx = db_fetch($taxes))
    {


       $c=0;
        
        $payable = $tx['payable'];
        $collectible = -$tx['collectible'];
        $net = $collectible + $payable;
        $total += $net;

//-------First Row -------------------------------------------------------------
  
        $rep->TextCol(0, 1,  $tx['name']. " " .$tx['rate'] . "%");
        $rep->TextCol(1, 2,  _("Charged on sales") . " (" . _("Output Tax")."):");
        if($destination)
        $rep->TextCol(2, 3,  $payable,$dec);
        else
        $rep->AmountCol(2, 3,  $payable,$dec);
        $rep->TextCol(3, 4,  $tx['net_output']);
    

//-------Second Row -------------------------------------------------------------

        $rep->NewLine();
        $rep->TextCol(0, 1,  $tx['name']. " " .$tx['rate'] . "%");
        $rep->TextCol(1, 2,  _("Paid on purchases") . " (" . _("Input Tax")."):");
        if($destination)
        $rep->TextCol(2, 3,  $collectible,$dec);
        else
        $rep->AmountCol(2, 3,  $collectible,$dec);
        $rep->TextCol(3, 4,  -$tx['net_input']);

//-------Third Row -------------------------------------------------------------
        $rep->NewLine();
        $rep->Font('bold');        
        $rep->TextCol(0, 1,  $tx['name']. " " .$tx['rate'] . "%");
        $rep->TextCol(1, 2,  _("Net payable or collectible").":");
        if($destination)
        $rep->TextCol(2, 3,  $net,$dec);
        else
        $rep->AmountCol(2, 3,  $net,$dec);



//-------Third Row -------------------------------------------------------------

        $rep->NewLine();
            $rep->Font('bold');
        $rep->TextCol(1, 2,  _("Total payable or refund").":");
        if($destination)
        $rep->TextCol(2, 3,  $total,$dec);
        else
        $rep->AmountCol(2, 3,  $total,$dec);
            $rep->Font();
        $rep->Font();
        $newrow = $rep->row;
        $rep->row = $newrow;
        $rep->NewLine();
        

}
}
else

{
        $rep->TextCol(1, 2,  _("Total payable or refund").":");
        $rep->TextCol(2, 3,  '0.00');  
}
    



    $rep->Line($rep->row  - 4);
    // $rep->NewLine();
        $rep->End();
}