<?php

$page_security = 'SA_PAYMENT_VOUCHER_REPORT';
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/reporting/amount_words.php");

print_payment_report();

//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	 // display_error($sql);
	$result = db_query($sql,"Did not Executed");
	return $result;
}

//----------------------------------------------------------------------------------------------------

function print_payment_report()
{
	global $path_to_root, $SysPrefs, $bank_transfer_types;
	
	include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$trans_id = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$paylink = $_POST['PARAM_4'];
	$comments = $_POST['PARAM_5'];
	$orientation = $_POST['PARAM_6'];
	$REPORT_ID = 976;

	if (!$trans_id || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

 	
	$cols = array(4, 100, 220, 330, 430, 450);

	// $headers in doctext.inc
	$aligns = array('left',	'left',	'left', 'left', 'right');

	$params = array('comments' => $comments);

	$cur = get_company_Pref('curr_default');

		$rep = new FrontReport(_('Bank Payment'), "BankPayment", array(1280, 550), 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);


    $result = get_bank_trans(ST_BANKPAYMENT, $trans_id);
	if (db_num_rows($result) != 1){
		display_db_error("duplicate payment bank transaction found", "");
		exit;
	}

	$voided = is_voided_display(ST_BANKPAYMENT, $trans_id, _("This payment has been voided."));
	$myrow = db_fetch($result);
	
		// $myrow = get_customer_trans($trans_id, ST_CUSTCREDIT);
		
		$branch=null;
		$baccount=null;
		$sales_order = null;
		$contacts=null;
		if ($email == 1)
	 
		$rep->currency = $cur;
		$rep->Font();
		$rep->Info($params, $cols, null, $aligns);

		$rep->SetCommonData($myrow, $branch, $sales_order, $baccount, ST_BANKPAYMENT, $contacts);
		$rep->SetHeaderType('Header2');
		$rep->NewPage();

		
		$items = get_gl_trans(ST_BANKPAYMENT, $trans_id);
		if (db_num_rows($items)==0){
			display_error(_("There are no items for this payment."));
			exit;
		}
		
        $rep->Font('bold');
		$rep->fontSize = 14;
		
		if($myrow["ac_payee"])
			$rep->TextWrap(740,$rep->row-105,150, "A/C Payee", 'left');
			
			
		$rep->TextWrap(1090,$rep->row-110,150, sql2date($myrow["trans_date"]), 'left');
		$rep->TextWrap(630,$rep->row-180,1000, $myrow['party_name'], 'left'); 

		$words = price_in_words(replace_chars(abs($myrow["amount"]), array(",")), ST_SALESINVOICE);
		$rep->fontSize -= 1.5;
		$rep->TextWrap(522,$rep->row-230,1000, ($words), 'left'); 
		$rep->fontSize += 1.5;
		$rep->TextWrap(1090,$rep->row-265,500, "**".number_format2(abs($myrow["amount"]), 2), 'left'); 



	if ($email == 0)
		$rep->End();
}

