<?php

$page_security = 'SA_OPEN';

// ----------------------------------------------------------------
// $ Revision:  2.0 $
// Creator: Joe Hunt
// date_:   2005-05-19
// Title:   Customer Balances
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . '/CRM/pages/includes/db/project_db.inc');
include($path_to_root . "/CRM/includes/db/crm_contactform_db.inc");


//----------------------------------------------------------------------------------------------------

print_customer_balances();
function check_value($name){
    return (empty($_POST[$name]) ? 0 : 1);
}
function get_company($val){
 return  get_opportunity_detail_by_contact_person($val)['company'];
}
function get_mobile($val){
 return  get_opportunity_detail_by_contact_person($val)['phone'];
}

function get_name_user($val){
  $ret = get_opportunity_detail_by_contact_person($val)['user_name'];
  return get_user($ret)['real_name'];
}

function get_contact_person_name($val){
  return get_contact_person_id($val)['cont_per'];
}
function get_status($val){
  global  $crm_status ;
  return $crm_status[$val];
}

//----------------------------------------------------------------------------------------------------

function print_customer_balances(){

    global $path_to_root, $systypes_array;

    $destination = $_POST['PARAM_0'];
    $from = $_POST['PARAM_1'];
    $to = $_POST['PARAM_2'];
    $user = $_POST['PARAM_3'];
    $opportunity = $_POST['PARAM_4'];
    $status = $_POST['PARAM_5'];
    $public = $_POST['PARAM_6'];
    $closed = $_POST['PARAM_7'];
    $project = $_POST['PARAM_8'];
    $private = $_POST['PARAM_9'];
    $def_orientation = $_POST['PARAM_10']=1;

    if($public == 1 && $private != 1)
        $proj_type = 0;
    elseif($public != 1 && $private == 1)
        $proj_type = 1;
    else
        $proj_type = false;

      if($opportunity)
          $opportunity_name = get_items_name_description($opportunity)['description'];
      else
          $opportunity_name ='';

      if($user)
          $user_name = get_user($user)['real_name'];
      else
          $user_name ='';

      if($status){
          global $crm_status;
          $status_label = $crm_status[$status];
        }
      else
          $status_label ='';
       

    if ($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

    $def_orientation = ($def_orientation ? 'L' : 'P');


   $cols = array(5, 20, 70, 145, 210, 270, 320, 365, 400, 440, 495, 600);

   $headers = array(_('#'), _('Sales Person'), _('Opportunity Name'), _('Company Name'), _('Contact Person'), _('Mobile#'),_('Date'), _('Status'), _('Amount'), _('Last Remark')  , _('Received Amount'));



   $cols = array(5, 20, 70, 145, 210,  270, 320, 365, 400, 440, 495 , 600 );

if($user && !$opportunity &&  !$status){

    array_splice($headers, 1, 1);
    $cols = array(5, 20, 90, 155, 220,  280, 330, 375, 420, 480 );

 }
 if($opportunity && !$user &&  !$status){

    array_splice($headers, 2, 1);
    $cols = array(5, 25, 80, 145, 210,  270, 320, 365, 410, 480, 600 );

 }
 if($status && !$opportunity && !$user ){

    array_splice($headers, 7, 1);
    $cols = array(5, 25, 80, 145, 210,  270, 320, 365, 410, 480, 600 );

 }
 if($user  && $opportunity && !$status){

    array_splice($headers, 1, 1);
    array_splice($headers, 1, 1);
    $cols = array(5, 25, 100, 175, 230,  285, 340, 395, 455, 520);

 }

 if(!$user  && $opportunity && $status){
    array_splice($headers, 2, 1);
    array_splice($headers, 6, 1);
    $cols = array(5, 25, 90, 162, 235,  295, 350, 400, 460, 520);

 }


 if($user  && !$opportunity && $status){
    array_splice($headers, 1, 1);
    array_splice($headers, 6, 1);
    $cols = array(5, 25, 100, 180, 250,  305, 360, 400, 460, 520);

 }

  if($user  && $opportunity && $status){
    array_splice($headers, 1, 1);
    array_splice($headers, 1, 1);
    array_splice($headers, 5, 1);
    $cols = array(5, 25, 100, 180, 250,  305, 360, 425, 600, 520);

 }




    $aligns = array('left', 'left',   'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left');

    $params =   array(  0 => $comments,
                        1 => array('text' => _('Period'), 'from' => $from,'to'=>$to),
                        2 => array('text' => _('Opportunity'),  'from' => $opportunity_name),
                        3 => array('text' => _('User'),  'from' => $user_name),
                        4 => array('text' => _('Status'),  'from' => $status_label),

                    );
    $rep = new FrontReport(_('Opportunity Inquiry Report'), "Opportunity Inquiry Report", user_pagesize(), 9, $def_orientation);
  if ($def_orientation == 'L')
        recalculate_cols($cols);
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();





$sql =  get_projects(false, $closed, $proj_type ,'no', $status, $user, $project, $opportunity,$from, $to);
$ser = 1;
$result=db_query($sql);
while ($myrow = db_fetch($result))
    {

if($user && !$opportunity &&  !$status){
       $c=0;
        $rep->TextCol($c++, $c, $ser++);
        // $rep->TextCol($c, $c++,  get_name_user($myrow['contact_person']));
        $rep->TextCol($c++, $c,  get_items_name_description($myrow['opportunity'])['description']);
        if($destination)
           $rep->TextCol($c++, $c,  get_company($myrow['contact_person']));
        else{
            $oldrow = $rep->row;
            $rep->TextColLines($c++, $c,  get_company($myrow['contact_person']), -2);
            $newrow[] = $rep->row;
            $rep->row = $oldrow;
        }
        $rep->TextCol($c++, $c,  get_contact_person_name($myrow['contact_person']));
        $rep->TextCol($c++, $c, get_mobile($myrow['contact_person']));
        $rep->TextCol($c++, $c, sql2date($myrow['created_date']));
        $rep->TextCol($c++, $c, get_status($myrow['status']));
        $rep->TextCol($c++, $c, number_format($myrow['amount'],2));
        if($destination)
             $rep->TextCol($c++, $c, $myrow['proj_description']);
        else{
            $oldrow = $rep->row;
            $rep->TextColLines($c++, $c, $myrow['proj_description']);
            $newrow[] = $rep->row;
            $rep->row = $oldrow;
        }
        $rep->TextCol($c, $c++, "N/A");
        $rep->NewLine(2);
 }

 if($opportunity && !$user &&  !$status){
       $c=0;
        $rep->TextCol($c++, $c, $ser++);
        $rep->TextCol($c++, $c,  get_name_user($myrow['contact_person']));
        // $rep->TextCol($c, $c++,  get_items_name_description($myrow['opportunity'])['description']);
        if($destination)
           $rep->TextCol($c++, $c,  get_company($myrow['contact_person']));
        else{
            $oldrow = $rep->row;
            $rep->TextColLines($c++, $c,  get_company($myrow['contact_person']), -2);
            $newrow[] = $rep->row;
            $rep->row = $oldrow;
        }
        $rep->TextCol($c++, $c,  get_contact_person_name($myrow['contact_person']));
        $rep->TextCol($c++, $c, get_mobile($myrow['contact_person']));
        $rep->TextCol($c++, $c, sql2date($myrow['created_date']));
        $rep->TextCol($c++, $c, get_status($myrow['status']));
        $rep->TextCol($c++, $c, number_format($myrow['amount'],2));
        if($destination)
             $rep->TextCol($c++, $c, $myrow['proj_description']);
        else{
            $oldrow = $rep->row;
            $rep->TextColLines($c++, $c, $myrow['proj_description']);
            $newrow[] = $rep->row;
            $rep->row = $oldrow;
        }
        $rep->TextCol($c++, $c, "N/A");
        $rep->NewLine(2);
 }

 if($status && !$opportunity && !$user ){
        $c=0;
        $rep->TextCol($c++, $c, $ser++);
        $rep->TextCol($c++, $c,  get_name_user($myrow['contact_person']));
        $rep->TextCol($c++, $c,  get_items_name_description($myrow['opportunity'])['description']);
        if($destination)
           $rep->TextCol($c++, $c,  get_company($myrow['contact_person']));
        else{
            $oldrow = $rep->row;
            $rep->TextColLines($c++, $c,  get_company($myrow['contact_person']), -2);
            $newrow[] = $rep->row;
            $rep->row = $oldrow;
        }
        $rep->TextCol($c++, $c,  get_contact_person_name($myrow['contact_person']));
        $rep->TextCol($c++, $c, get_mobile($myrow['contact_person']));
        $rep->TextCol($c++, $c, sql2date($myrow['created_date']));
        // $rep->TextCol($c++, $c, get_status($myrow['status']));
        $rep->TextCol($c++, $c, number_format($myrow['amount'],2));
        if($destination)
             $rep->TextCol($c++, $c, $myrow['proj_description']);
        else{
            $oldrow = $rep->row;
            $rep->TextColLines($c++, $c, $myrow['proj_description']);
            $newrow[] = $rep->row;
            $rep->row = $oldrow;
        }
        $rep->TextCol($c++, $c, "N/A");
        $rep->NewLine(2);
 }
 if($user  && $opportunity && !$status){
        $c=0;
        $rep->TextCol($c++, $c, $ser++);
        // $rep->TextCol($c, $c++,  get_name_user($myrow['contact_person']));
        // $rep->TextCol($c, $c++,  get_items_name_description($myrow['opportunity'])['description']);
        if($destination)
           $rep->TextCol($c++, $c,  get_company($myrow['contact_person']));
        else{
            $oldrow = $rep->row;
            $rep->TextColLines($c++, $c,  get_company($myrow['contact_person']), -2);
            $newrow[] = $rep->row;
            $rep->row = $oldrow;
        }
        $rep->TextCol($c++, $c,  get_contact_person_name($myrow['contact_person']));
        $rep->TextCol($c++, $c, get_mobile($myrow['contact_person']));
        $rep->TextCol($c++, $c, sql2date($myrow['created_date']));
        $rep->TextCol($c++, $c, get_status($myrow['status']));
        $rep->TextCol($c++, $c, number_format($myrow['amount'],2));
        if($destination)
             $rep->TextCol($c++, $c, $myrow['proj_description']);
        else{
            $oldrow = $rep->row;
            $rep->TextColLines($c++, $c, $myrow['proj_description']);
            $newrow[] = $rep->row;
            $rep->row = $oldrow;
        }
        $rep->TextCol($c++, $c, "N/A");
        $rep->NewLine(2);
 }

 if(!$user  && $opportunity && $status){
        $c=0;
        $rep->TextCol($c++, $c, $ser++);
        $rep->TextCol($c++, $c,  get_name_user($myrow['contact_person']));
        // $rep->TextCol($c++, $c,  get_items_name_description($myrow['opportunity'])['description']);
        if($destination)
           $rep->TextCol($c++, $c,  get_company($myrow['contact_person']));
        else{
            $oldrow = $rep->row;
            $rep->TextColLines($c++, $c,  get_company($myrow['contact_person']), -2);
            $newrow[] = $rep->row;
            $rep->row = $oldrow;
        }
        $rep->TextCol($c++, $c,  get_contact_person_name($myrow['contact_person']));
        $rep->TextCol($c++, $c, get_mobile($myrow['contact_person']));
        $rep->TextCol($c++, $c, sql2date($myrow['created_date']));
        // $rep->TextCol($c++, $c, get_status($myrow['status']));
        $rep->TextCol($c++, $c, number_format($myrow['amount'],2));
        if($destination)
             $rep->TextCol($c++, $c, $myrow['proj_description']);
        else{
            $oldrow = $rep->row;
            $rep->TextColLines($c++, $c, $myrow['proj_description']);
            $newrow[] = $rep->row;
            $rep->row = $oldrow;
        }
        $rep->TextCol($c++, $c, "N/A");
        $rep->NewLine(2);
 }
 if($user  && !$opportunity && $status){
        $c=0;
        $rep->TextCol($c++, $c, $ser++);
        // $rep->TextCol($c, $c++,  get_name_user($myrow['contact_person']));
        $rep->TextCol($c++, $c,  get_items_name_description($myrow['opportunity'])['description']);
        if($destination)
           $rep->TextCol($c++, $c,  get_company($myrow['contact_person']));
        else{
            $oldrow = $rep->row;
            $rep->TextColLines($c++, $c,  get_company($myrow['contact_person']), -2);
            $newrow[] = $rep->row;
            $rep->row = $oldrow;
        }
        $rep->TextCol($c++, $c,  get_contact_person_name($myrow['contact_person']));
        $rep->TextCol($c++, $c, get_mobile($myrow['contact_person']));
        $rep->TextCol($c++, $c, sql2date($myrow['created_date']));
        // $rep->TextCol($c++, $c, get_status($myrow['status']));
        $rep->TextCol($c++, $c, number_format($myrow['amount'],2));
        if($destination)
             $rep->TextCol($c++, $c, $myrow['proj_description']);
        else{
            $oldrow = $rep->row;
            $rep->TextColLines($c++, $c, $myrow['proj_description']);
            $newrow[] = $rep->row;
            $rep->row = $oldrow;
        }
        $rep->TextCol($c++, $c, "N/A");
        $rep->NewLine(2);
 }

  if(!$user  && !$opportunity && !$status){
        $c=0;
        $rep->TextCol($c++, $c, $ser++);
        $rep->TextCol($c++, $c,  get_name_user($myrow['contact_person']));
        $rep->TextCol($c++, $c,  get_items_name_description($myrow['opportunity'])['description']);
        if($destination)
           $rep->TextCol($c++, $c,  get_company($myrow['contact_person']));
        else{
            $oldrow = $rep->row;
            $rep->TextColLines($c++, $c,  get_company($myrow['contact_person']), -2);
            $newrow[] = $rep->row;
            $rep->row = $oldrow;
        }
        $rep->TextCol($c++, $c,  get_contact_person_name($myrow['contact_person']));
        $rep->TextCol($c++, $c, get_mobile($myrow['contact_person']));
        $rep->TextCol($c++, $c, sql2date($myrow['created_date']));
        $rep->TextCol($c++, $c, get_status($myrow['status']));
        $rep->TextCol($c++, $c, number_format($myrow['amount'],2));
        if($destination)
             $rep->TextCol($c++, $c, $myrow['proj_description']);
        else{
            $oldrow = $rep->row;
            $rep->TextColLines($c++, $c, $myrow['proj_description']);
            $newrow[] = $rep->row;
            $rep->row = $oldrow;
        }
        $rep->TextCol($c++, $c, "N/A");
        $rep->NewLine(2);
 }

 if($user  && $opportunity && $status){
        $c=0;
        $rep->TextCol($c++, $c, $ser++);
        // $rep->TextCol($c, $c++,  get_name_user($myrow['contact_person']));
        // $rep->TextCol($c, $c++,  get_items_name_description($myrow['opportunity'])['description']);
        if($destination)
           $rep->TextCol($c++, $c,  get_company($myrow['contact_person']));
        else{
            $oldrow = $rep->row;
            $rep->TextColLines($c++, $c,  get_company($myrow['contact_person']), -2);
            $newrow[] = $rep->row;
            $rep->row = $oldrow;
        }
        $rep->TextCol($c++, $c,  get_contact_person_name($myrow['contact_person']));
        $rep->TextCol($c++, $c, get_mobile($myrow['contact_person']));
        $rep->TextCol($c++, $c, sql2date($myrow['created_date']));
        // $rep->TextCol($c++, $c, get_status($myrow['status']));
        $rep->TextCol($c++, $c, number_format($myrow['amount'],2));
        if($destination)
             $rep->TextCol($c++, $c, $myrow['proj_description']);
        else{
            $oldrow = $rep->row;
            $rep->TextColLines($c++, $c, $myrow['proj_description']);
            $newrow[] = $rep->row;
            $rep->row = $oldrow;
        }
        $rep->TextCol($c++, $c, "N/A");
        $rep->NewLine(2);
 }


        $rep->row = min($newrow);
        unset($newrow);

        if($rep->row <= 80){
         $rep->NewPage();
        }
        
    }   
//--------------------------------------------------------------------------------------------------------

    $rep->Line($rep->row  - 4);
    $rep->End();
}