<?php

if(isset($_GET['customer_id'],$_GET['SInvoice'])){
	$page_security = 'SA_SALESINVOICECUSTOMER';
}else{
    $page_security = 'SA_SALESPAYMNT';
}
$path_to_root = "..";
include_once($path_to_root . "/includes/ui/allocation_cart.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/banking.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");


$js = "";
if ($SysPrefs->use_popup_windows) {
	$js .= get_js_open_window(900, 500);
}
if (user_use_date_picker()) {
	$js .= get_js_date_picker();
}
add_js_file('payalloc.js');

page(_($help_context = "Customer Payment Entry"), false, false, "", $js);

//----------------------------------------------------------------------------------------------

check_db_has_customers(_("There are no Customers defined in the system."));

check_db_has_bank_accounts(_("There are no bank accounts defined in the system."));

//----------------------------------------------------------------------------------------
function get_bankName($bank_no =null)
{
	$acc_no_flag = strtoupper($bank_no);
	$sql = "SELECT * FROM ".TB_PREF."bank_accounts WHERE inactive = 0 AND UPPER(account_code) = ".db_escape($acc_no_flag)."";
	$result = db_query($sql, "could not get bank get_bankName");
	return db_fetch($result);
}

if (isset($_GET['customer_id']))
{
	$_POST['customer_id'] = $_GET['customer_id'];
}

if (!isset($_POST['bank_account'])) { // first page call
	$_SESSION['alloc'] = new allocation(ST_CUSTPAYMENT, 0, get_post('customer_id'));

	if (isset($_GET['SInvoice'])) {
		//  get date and supplier
		$inv = get_customer_trans($_GET['SInvoice'], ST_SALESINVOICE);
		$dflt_act = get_default_bank_account($inv['curr_code']);
		$_POST['bank_account'] = $dflt_act['id'];
		if($inv) {
			$_SESSION['alloc']->person_id = $_POST['customer_id'] = $inv['debtor_no'];
			$_SESSION['alloc']->read();
			$_POST['BranchID'] = $inv['branch_code'];
			$_POST['DateBanked'] = sql2date($inv['tran_date']);
			foreach($_SESSION['alloc']->allocs as $line => $trans) {
				if ($trans->type == ST_SALESINVOICE && $trans->type_no == $_GET['SInvoice']) {
					$un_allocated = $trans->amount - $trans->amount_allocated;
					if ($un_allocated){
						$_SESSION['alloc']->allocs[$line]->current_allocated = $un_allocated;
						$_POST['amount'] = $_POST['amount'.$line] = price_format($un_allocated);
					}
					break;
				}
			}
			unset($inv);
		} else
			display_error(_("Invalid sales invoice number."));
	}
}

if (list_updated('BranchID')) {
	// when branch is selected via external editor also customer can change
	$br = get_branch(get_post('BranchID'));
	$_POST['customer_id'] = $br['debtor_no'];
	$_SESSION['alloc']->person_id = $br['debtor_no'];
	$Ajax->activate('customer_id');
}

if (!isset($_POST['customer_id'])) {
	$_SESSION['alloc']->person_id = $_POST['customer_id'] = get_global_customer(false);
	$_SESSION['alloc']->read();
}
if (!isset($_POST['DateBanked'])) {
	$_POST['DateBanked'] = new_doc_date();
	if (!is_date_in_fiscalyear($_POST['DateBanked'])) {
		$_POST['DateBanked'] = end_fiscalyear();
	}
}


if (isset($_GET['AddedID'])) {
	$payment_no = $_GET['AddedID'];

	display_notification_centered(_("The Customer payment has been successfully entered."));
echo '<ol class="rounded-list">';
	echo '<li>';
	submenu_print(_("&Print This Receipt A4"), ST_CUSTPAYMENT, $payment_no."-".ST_CUSTPAYMENT, 'prtopt',null,null,A4);
	echo '</li><li>';
	submenu_print(_("&Print This Receipt A5"), ST_CUSTPAYMENT, $payment_no."-".ST_CUSTPAYMENT, 'prtopt',null,null,A5);
	echo '</li><li>';
	submenu_view(_("&View this Customer Payment"), ST_CUSTPAYMENT, $payment_no,null,$path_to_root,basename($_SERVER['PHP_SELF']));
	echo '</li><li>';
	submenu_option(_("Enter Another Customer Payment"), "/sales/customer_payments.php");
	echo '</li><li>';
	submenu_option(_("Enter Other &Deposit"), "/gl/gl_bank.php?NewDeposit=Yes");
		echo '</li><li>';
	submenu_option(_("Enter Payment to &Supplier"), "/purchasing/supplier_payment.php");
	echo '</li><li>';
	submenu_option(_("Enter Other &Payment"), "/gl/gl_bank.php?NewPayment=Yes");
	echo '</li><li>';
	submenu_option(_("Bank Account &Transfer"), "/gl/bank_transfer.php");
	echo '</li><li>';
	display_note(get_gl_view_str(ST_CUSTPAYMENT, $payment_no, _("&View the GL Journal Entries for this Customer Payment")));
echo '</li></ol>';
	display_footer_exit();
}
elseif (isset($_GET['UpdatedID'])) {
	$payment_no = $_GET['UpdatedID'];

	display_notification_centered(_("The Customer payment has been successfully updated."));
	echo '<ol class="rounded-list">';
	echo '<li>';
	submenu_print(_("&Print This Receipt"), ST_CUSTPAYMENT, $payment_no."-".ST_CUSTPAYMENT, 'prtopt');
	echo '</li><li>';
	display_note(get_gl_view_str(ST_CUSTPAYMENT, $payment_no, _("&View the GL Journal Entries for this Customer Payment")));
	echo '</li><li><span>';
//	hyperlink_params($path_to_root . "/sales/allocations/customer_allocate.php", _("&Allocate this Customer Payment"), "trans_no=$payment_no&trans_type=12");

	hyperlink_no_params($path_to_root . "/sales/inquiry/customer_inquiry.php?", _("Select Another Customer Payment for &Edition"));
	echo '</span></li><li><span>';
	hyperlink_no_params($path_to_root . "/sales/customer_payments.php", _("Enter Another Customer Payment"));
	echo '</span></li></ol>';
	display_footer_exit();
}

//----------------------------------------------------------------------------------------------

function can_process()
{
	global $Refs;
	
	if(!isset($_POST['ref']))
		$_POST['ref'] = $Refs->get_next(ST_CUSTPAYMENT, null, array(
			'customer' => get_post('customer_id'), 'date' => get_post('DateBanked')));

	 if (isset($_POST['date_pdc']))
	{

		if( strtotime(date2sql($_POST['DateBanked'])) > strtotime(date2sql($_POST['date_pdc'])) )
		{
		display_error(_("Deposit Date should be less than the PDC Date."));
		set_focus('date_pdc');
		return false;

		}
	} 



	if (!get_post('customer_id'))
	{
		display_error(_("There is no Customer selected."));
		set_focus('customer_id');
		return false;
	} 
	
	if (!get_post('BranchID'))
	{
		display_error(_("This Customer has no branch defined."));
		set_focus('BranchID');
		return false;
	} 
	
	if (!isset($_POST['DateBanked']) || !is_date($_POST['DateBanked'])) {
		display_error(_("The entered date is invalid. Please enter a valid date for the payment."));
		set_focus('DateBanked');
		return false;
	} elseif (!is_date_in_fiscalyear($_POST['DateBanked'])) {
		display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
		set_focus('DateBanked');
		return false;
	}


	

	if (!check_reference($_POST['ref'], ST_CUSTPAYMENT, @$_POST['trans_no'])) {
		set_focus('ref');
		return false;
	}

	if (!check_num('amount', 0)) {
		display_error(_("The entered amount is invalid or negative and cannot be processed."));
		set_focus('amount');
		return false;
	}

	if (isset($_POST['charge']) && !check_num('charge', 0)) {
		display_error(_("The entered amount is invalid or negative and cannot be processed."));
		set_focus('charge');
		return false;
	}
	if (isset($_POST['charge']) && input_num('charge') > 0) {
		$charge_acct = get_bank_charge_account($_POST['bank_account']);
		if (get_gl_account($charge_acct) == false) {
			display_error(_("The Bank Charge Account has not been set in System and General GL Setup."));
			set_focus('charge');
			return false;
		}	
	}

	if (@$_POST['discount'] == "") 
	{
		$_POST['discount'] = 0;
	}

	if (!check_num('discount')) {
		display_error(_("The entered discount is not a valid number."));
		set_focus('discount');
		return false;
	}

	if (input_num('amount') <= 0) {
		display_error(_("The balance of the amount and discount is zero or negative. Please enter valid amounts."));
		set_focus('discount');
		return false;
	}

	if (isset($_POST['bank_amount']) && input_num('bank_amount')<=0)
	{
		display_error(_("The entered payment amount is zero or negative."));
		set_focus('bank_amount');
		return false;
	}

// 	if (!$_POST['dimension_id'])
// 	{
// 		display_error(_("Please Select Dimension To Process."));
// 		set_focus('dimension_id');
// 		return false;
// 	}

	if (!db_has_currency_rates(get_customer_currency($_POST['customer_id']), $_POST['DateBanked'], true))
		return false;

	$_SESSION['alloc']->amount = input_num('amount');

	if (isset($_POST["TotalNumberOfAllocs"]))
		return check_allocations();
	else
		return true;
}

//----------------------------------------------------------------------------------------------

if (isset($_POST['_customer_id_button'])) {
//	unset($_POST['branch_id']);
	$Ajax->activate('BranchID');
}

//----------------------------------------------------------------------------------------------

if (get_post('AddPaymentItem') && can_process()) {
 global $Refs, $SysPrefs;


	new_doc_date($_POST['DateBanked']);
	if(!isset($_POST['ref']))
		$_POST['ref'] = $Refs->get_next(ST_CUSTPAYMENT, null, array(
			'customer' => get_post('customer_id'), 'date' => get_post('DateBanked')));
// 			display_error($_POST['ref']);
// 			exit;
	$new_pmt = !$_SESSION['alloc']->trans_no;
	//Chaitanya : 13-OCT-2011 - To support Edit feature
	$payment_no = write_customer_payment($_SESSION['alloc']->trans_no, $_POST['customer_id'], $_POST['BranchID'],
	$_POST['bank_account'], $_POST['DateBanked'], $_POST['ref'],
	input_num('amount'), input_num('discount'), $_POST['memo_'], 0, input_num('charge'), input_num('bank_amount', input_num('amount'))
	, $_POST['check_pdc'], $_POST['date_pdc'], $_POST['dimension_id'], $_POST['sales_discount_account'], $_POST['party_name']);

	$_SESSION['alloc']->trans_no = $payment_no;
	$_SESSION['alloc']->write();

	unset($_SESSION['alloc']);
	meta_forward($_SERVER['PHP_SELF'], $new_pmt ? "AddedID=$payment_no" : "UpdatedID=$payment_no");
}

//----------------------------------------------------------------------------------------------

function read_customer_data()
{
	global $Refs;

	$myrow = get_customer_habit($_POST['customer_id']);

	$_POST['HoldAccount'] = $myrow["dissallow_invoices"];
	$_POST['pymt_discount'] = $myrow["pymt_discount"];
	// To support Edit feature
	// If page is called first time and New entry fetch the nex reference number
	if (!$_SESSION['alloc']->trans_no && !isset($_POST['charge'])) 
		$_POST['ref'] = $Refs->get_next(ST_CUSTPAYMENT, null, array(
			'customer' => get_post('customer_id'), 'date' => get_post('DateBanked')));
}

//----------------------------------------------------------------------------------------------
$new = 1;

// To support Edit feature
if (isset($_GET['trans_no']) && $_GET['trans_no'] > 0 )
{
	$_POST['trans_no'] = $_GET['trans_no'];

	$new = 0;
	$myrow = get_customer_trans($_POST['trans_no'], ST_CUSTPAYMENT);
	$_POST['customer_id'] = $myrow["debtor_no"];
	$_POST['customer_name'] = $myrow["DebtorName"];
	$_POST['BranchID'] = $myrow["branch_code"];
	$_POST['bank_account'] = $myrow["bank_act"];
	$_POST['party_name'] = $myrow["party_name"];
	$_POST['ref'] =  $myrow["reference"];
	$charge = get_cust_bank_charge(ST_CUSTPAYMENT, $_POST['trans_no']);
	$_POST['charge'] =  price_format($charge);
	$_POST['DateBanked'] =  sql2date($myrow['tran_date']);
	$_POST["amount"] = price_format($myrow['Total'] - $myrow['ov_discount']);
	$_POST["bank_amount"] = price_format($myrow['bank_amount']+$charge);
	$_POST["discount"] = price_format($myrow['ov_discount']);
	$_POST["memo_"] = get_comments_string(ST_CUSTPAYMENT,$_POST['trans_no']);

	//Prepare allocation cart 
	if (isset($_POST['trans_no']) && $_POST['trans_no'] > 0 )
		$_SESSION['alloc'] = new allocation(ST_CUSTPAYMENT,$_POST['trans_no']);
	else
	{
		$_SESSION['alloc'] = new allocation(ST_CUSTPAYMENT, $_POST['trans_no']);
		$Ajax->activate('alloc_tbl');
	}
}

//----------------------------------------------------------------------------------------------
$new = !$_SESSION['alloc']->trans_no;
start_form();

hidden('trans_no');

start_outer_table(TABLESTYLE5_BOX,'');

table_section(1);


$myrow2 = get_company_prefs();

// display_error($myrow2["debtors_pdc_act"]);
$bankName = get_bankName($myrow2["debtors_pdc_act"]);
// if(get_post('check_pdc') ==1)
// {
// 	label_cells(_("Into Bank Account:"), $bankName['bank_account_name'], "class=''");
// 	hidden('bank_account', $bankName['id']);
// }
// else
// {
	bank_accounts_list_row(_("Into Bank Account:"), 'bank_account', null, true, $myrow2["debtors_pdc_act"], $myrow2["creditors_pdc_act"]);
// }

// bank_accounts_list_row(_("Into Bank Account:"), 'bank_account', null, true);

if ($new){
	//______________   CUSTOMER Already Created In User Managment Form   ________________________
			
		$user_id=($_SESSION["wa_current_user"]->user);// Current User online Id
		$myrow=get_user($user_id);// Putting User Id Into it to fetch customer_id From USers Table
		$customer_name=get_customer_name($myrow['customer_id']);//Putting customer_id to Get Its Name From customer Table
		$branch_name=get_branch_name($myrow['branch_id']);		
		// $user_id=$_SESSION["wa_current_user"]->user;
		if($myrow['customer_id']>=1)
		{start_row();
	// customer_list_row(_("From Customer:"), 'customer_id', null, false, true);
		label_cells(_('From Customer: '),$customer_name);
         hidden('customer_id', $myrow['customer_id']);
         end_row();
		//___________________________________________________________________________________________
		}else
	customer_list_row(_("From Customer:"), 'customer_id', null, false, true);
}
else {
	label_cells(_("From Customer:"), $_SESSION['alloc']->person_name, "class=''");
	hidden('customer_id', $_POST['customer_id']);
}

if (list_updated('customer_id') || ($new && list_updated('bank_account'))) {
	$_SESSION['alloc']->read();
	$_POST['memo_'] = $_POST['amount'] = $_POST['discount'] = '';
	$Ajax->activate('alloc_tbl');
}


if($myrow['branch_id']>=1)
		{start_row();
		label_cells(_('From Branch: '),$customer_name);
         hidden('branch_id', $myrow['branch_id']);
         end_row();
		//___________________________________________________________________________________________
		}else{
if (db_customer_has_branches($_POST['customer_id'])) {
	customer_branches_list_row(_("Branch:"), $_POST['customer_id'], 'BranchID', null, false, true, true);
} else {
	hidden('BranchID', ANY_NUMERIC);
}

if(list_updated('customer_id')){
	$_POST['party_name'] = 	get_customer_name($_POST['customer_id']);
}
text_row_ex(_("Party Name: "), 'party_name');
}

if (list_updated('customer_id') || ($new && list_updated('bank_account'))) {
	$_SESSION['alloc']->set_person($_POST['customer_id'], PT_CUSTOMER);
	$_SESSION['alloc']->read();
	$_POST['memo_'] = $_POST['amount'] = $_POST['discount'] = '';
	$Ajax->activate('alloc_tbl');
}

if (isset($_POST['RefreshInquiry'])) {


	$_SESSION['alloc']->reference = $_POST['reference'];
	$_SESSION['alloc']->from_date = $_POST['from_date'];
	$_SESSION['alloc']->to_date = $_POST['to_date'];
	$_SESSION['alloc']->read();

	$Ajax->activate('alloc_tbl');
}

read_customer_data();

set_global_customer($_POST['customer_id']);
if (isset($_POST['HoldAccount']) && $_POST['HoldAccount'] != 0)	
	display_warning(_("This Customer account is on hold."));
$display_discount_percent = percent_format($_POST['pymt_discount']*100) . "%";

table_section(2);

date_row(_("Date of Deposit:"), 'DateBanked', '', true, 0, 0, 0, null, true);

ref_row(_("Reference:"), 'ref','' , null, '', ST_CUSTPAYMENT);

dimensions_list_row(_("Dimension").":", 'dimension_id', null, _("Select Dimension"), ' ', false, 1, false);

table_section(3);

$comp_currency = get_company_currency();
$cust_currency = $_SESSION['alloc']->set_person($_POST['customer_id'], PT_CUSTOMER);
if (!$cust_currency)
	$cust_currency = $comp_currency;
$_SESSION['alloc']->currency = $bank_currency = get_bank_account_currency($_POST['bank_account']);

if ($cust_currency != $bank_currency)
{
	amount_row(_("Payment Amount:"), 'bank_amount', null, '', $bank_currency);
}

amount_row(_("Bank Charge:"), 'charge', null, '', $bank_currency);

check_cells(_('PDC:'), 'check_pdc',null, true);


if(get_post('check_pdc') =='' || get_post('check_pdc') ==1 )
{
	$Ajax->activate('_page_body');
}

if(get_post('check_pdc') ==1 )
date_row(_("Date:"), 'date_pdc', '', true, 0, 0, 0, null, true);

$statusPDC = get_post('check_pdc');
$datePDC = get_post('date_pdc');

end_outer_table(1);

div_start('alloc_tbl');
start_table(TABLESTYLE, "style='width:55% !important'");
br();
// start_table(TABLESTYLE6_BOX,"",0,0,0,null,"25%","3px solid #656E79;");
		text_cells(_("Ref:"),"reference",null);
		date_cells(_("From:"), 'from_date', '', null,null,0,0,null,true);
		date_cells(_("To:"), 'to_date', '', null,0,0,0,null,true);
		submit_cells('RefreshInquiry', _("Search"),'',_('Refresh Inquiry'), 'default');
		end_table();
		
show_allocatable(false,$path_to_root,basename($_SERVER['PHP_SELF']));
div_end();

// start_table(TABLESTYLE, "style=''");
start_table(TABLESTYLE6_BOX,"",0,0,0,null,"45%","3px solid #656E79;");
br();
br();
	

label_row(_("Customer prompt payment discount :"), $display_discount_percent);

gl_all_accounts_list_row(_("Sales Discount Account:"), 'sales_discount_account', false, false, false, _("Select Discount Ledger"));

amount_row(_("Amount of Discount:"), 'discount', null, '', $cust_currency);

amount_row(_("Amount:"), 'amount', null, '', $cust_currency);

textarea_row(_("Memo:"), 'memo_', null, 22, 4);

end_table(1);

if ($new)
	submit_center('AddPaymentItem', _("Add Payment"), true, '', 'default');
else
	submit_center('AddPaymentItem', _("Update Payment"), true, '', 'default');

br();

end_form();
end_page();
