<?php

//----------------------------------------------------------------------------------------

function get_customer_trans_details($debtor_trans_type, $debtor_trans_no)
{
if (!is_array($debtor_trans_no))
	$debtor_trans_no = array( 0=>$debtor_trans_no );

	$sql = "SELECT line.*,
		line.unit_price+line.unit_tax AS FullUnitPrice,
		line.description As StockDescription,
		item.units, item.mb_flag
		FROM "
			.TB_PREF."debtor_trans_details line,"
			.TB_PREF."stock_master item
		WHERE (";

	$tr=array();
	foreach ($debtor_trans_no as $trans_no)
		$tr[] = 'debtor_trans_no='.db_escape($trans_no);

	$sql .= implode(' OR ', $tr);


	$sql.=	") AND debtor_trans_type=".db_escape($debtor_trans_type)."
		AND item.stock_id=line.stock_id
		ORDER BY id";
// 		display_error($sql);exit;
	return db_query($sql, "The debtor transaction detail could not be queried");
}

//----------------------------------------------------------------------------------------

function void_customer_trans_details($type, $type_no)
{
	$sql = "UPDATE ".TB_PREF."debtor_trans_details SET quantity=0, unit_price=0,
		unit_tax=0, discount_percent=0, standard_cost=0, src_id=0
		WHERE debtor_trans_no=".db_escape($type_no)."
		AND debtor_trans_type=".db_escape($type);

	db_query($sql, "The debtor transaction details could not be voided");

	// clear the stock move items
	void_stock_move($type, $type_no);
}
//----------------------------------------------------------------------------------------

function write_customer_trans_detail_item($debtor_trans_type, $debtor_trans_no, $stock_id, $description,
	$quantity, $unit_price, $unit_tax, $discount_percent, $std_cost, $src_id, $line_id=0,$kit_id=0, $against=0,$fixed_asset=0, 
	$line_ref=null, $line_date=null, $item_specs=null, $spec_description=null)
{
	if ($line_id!=0){
		// ,src_id=".db_escape($src_id)."
		$sql = "UPDATE ".TB_PREF."debtor_trans_details SET
			stock_id=".db_escape($stock_id).",
			description=".db_escape($description).",
			quantity=".db_escape($quantity).",
			unit_price=".db_escape($unit_price).",
			unit_tax=".db_escape($unit_tax).",
			discount_percent=".db_escape($discount_percent).",
			standard_cost=".db_escape($std_cost).",
			sale_kit_id=".db_escape($kit_id).",
			line_ref=".db_escape($line_ref).",
			line_date=".db_escape(date2sql($line_date)).",
			item_specs=".db_escape(implode(",", $item_specs)).",
			spec_description=".db_escape($spec_description)."
			WHERE
			id=".db_escape($line_id);

		add_audit_trail($debtor_trans_type, $debtor_trans_no, Today(), _("Update Sales Delivery Note"));
	}
	else{
			$sql = "INSERT INTO ".TB_PREF."debtor_trans_details (debtor_trans_no,
				debtor_trans_type, stock_id, description, quantity, unit_price,
				unit_tax, discount_percent, standard_cost, src_id,sale_kit_id, line_ref, line_date, item_specs, spec_description)
			VALUES (".db_escape($debtor_trans_no).", ".db_escape($debtor_trans_type).", ".db_escape($stock_id).
			", ".db_escape($description).",
				$quantity, $unit_price, $unit_tax, 
				$discount_percent, $std_cost,".db_escape($src_id).",".db_escape($kit_id).",".db_escape($line_ref)." ,".db_escape(date2sql($line_date)).",".db_escape(implode(",", $item_specs)).",".db_escape($spec_description).")";
         }
         if($debtor_trans_type == 13){
         	if ($fixed_asset) {
         		$msg = "Create FA Sales Delivery Note";
         	}else if($against != 0)
         		$msg = "Create Sales Delivery Note against Sales order no ".$against;
	        else
	         	$msg = _("Create Sales Delivery Note");
         }elseif($debtor_trans_type == 10){
         	if ($fixed_asset) {
         		$msg = "Create FA Sales Invoice";
         	}else if($against != 0)
         		$msg = "Create Sales Invoice against Sales Delivery note ".$against;
	         else
	         	$msg = _("Create Sales Invoice");
         }
         elseif($debtor_trans_type == 11){
         	if ($fixed_asset) {
         		$msg = "Create FA Credit Note";
         	}else if($against != 0)
         		$msg = "Create Customer Credit Note against Sales Invoice ".$against;
	         else
	         	$msg = _("Create Customer Credit Note ");
         }
         
         add_audit_trail($debtor_trans_type, $debtor_trans_no, Today(), $msg);
	db_query($sql, "The debtor transaction detail could not be written");
	return db_insert_id();
}

