<?php

//----------------------------------------------------------------------------------------
function add_sales_order(&$order){
	$user_login = $_SESSION['wa_current_user']->user;
	global $SysPrefs, $path_to_root, $Refs;
	begin_transaction();
	hook_db_prewrite($order, $order->trans_type);
	$order_no = get_next_trans_no($order->trans_type);
	$del_date = date2sql($order->due_date);
	$order_type = 0; // this is default on new order
	$total = $order->get_trans_total();
	$sql = "INSERT INTO ".TB_PREF."sales_orders (order_no, type, debtor_no, trans_type, branch_code, customer_ref, reference, comments, ord_date,
		order_type, ship_via, deliver_to, delivery_address, contact_phone,
		freight_cost, from_stk_loc, delivery_date, payment_terms, total, prep_amount,country,cust_name,cust_email,cust_phone,branch,ov_discount,country_code, opp_id, quote_id, user, inquiry_type, dimension_id, dimension2_id)
		VALUES (" .db_escape($order_no) . "," .db_escape($order_type) . "," . db_escape($order->customer_id) .
		 ", " .db_escape($order->trans_type) . "," .db_escape($order->Branch) . ", ".
			db_escape($order->cust_ref) .",". 
			db_escape($order->reference) .",". 
			db_escape($order->Comments) .",'" . 
			date2sql($order->document_date) . "', " .
			db_escape($order->sales_type) . ", " .
			db_escape($order->ship_via)."," . 
			db_escape($order->deliver_to) . "," .
			db_escape($order->delivery_address) . ", " .
			db_escape($order->phone) . ", " . 
			db_escape($order->freight_cost) .", " . 
			db_escape($order->Location) .", " .
			db_escape($del_date) . "," .
			db_escape($order->payment) . "," .
			db_escape($total) . "," .
			db_escape($order->prep_amount) . "," .
			db_escape($order->country) . "," .
			db_escape($order->customer_) . "," .
			db_escape($order->customer_email_) . "," .
			db_escape($order->customer_phone_) . "," .
			db_escape($order->branch) . "," .
			db_escape($order->ov_discount) . "," .
			db_escape($order->country_code)."," .
			db_escape($order->opp_id)."," .
			db_escape($order->quote_id)."," .
			db_escape($user_login)."," .
			db_escape($order->inquiry_type)."," .
			db_escape($order->dimension_id)."," .
			db_escape($order->dimension2_id).")";

	db_query($sql, "order Cannot be Added");

	$order->trans_no = array($order_no=>0);

	if ($SysPrefs->loc_notification() == 1)
	{
		include_once($path_to_root . "/inventory/includes/inventory_db.inc");
		$st_ids = array();
		$st_names = array();
		$st_num = array();
		$st_reorder = array();
	}

	foreach ($order->line_items as $line)
	{
		if ($SysPrefs->loc_notification() == 1 && is_inventory_item($line->stock_id))
			$loc = calculate_reorder_level($order->Location, $line, $st_ids, $st_names, $st_num, $st_reorder); 

		$sql = "INSERT INTO ".TB_PREF."sales_order_details (order_no, trans_type, stk_code, description, unit_price, quantity, discount_percent,sale_kit_id, item_specs, spec_description) VALUES (";
		$sql .= $order_no . ",".$order->trans_type .
				",".db_escape($line->stock_id).", "
				.db_escape($line->item_description).", '$line->price',
				'$line->quantity',
				'$line->discount_percent',
				'$line->kit_id', 
				".db_escape(implode(",", $line->item_specs)).", 
				".db_escape(str_replace("	", '',trim($line->spec_description))).")";
		db_query($sql, "order Details Cannot be Added");
		$line_id = db_insert_id();
	// Now mark quotation line as processed
		if ($order->trans_type == ST_SALESORDER && $line->src_id)
			update_parent_line(ST_SALESORDER, $line->src_id, $line->qty_dispatched); // clear all the quote despite all or the part was ordered

		// Updating Opportunity Status
		if($order->trans_type == ST_SALESQUOTE)
				update_opportunity_status($order->opp_id, 2);
		if($order->trans_type == ST_SALESORDER)
				update_opportunity_status($order->opp_id, 3);
		

		// Work for Automated Work order.
		if ($_POST['is_wo'] == 1){
			$bank_act = get_default_bank_account();
			$cr_lab_acc = $bank_act['account_code'];
			$cr_acc = $bank_act['account_code'];
			if (get_item($line->stock_id)['mb_flag'] == 'M') {
				$wo_ref = $Refs->get_next(ST_WORKORDER, null, $_SESSION['Items']->document_date);
				$id = add_work_order($wo_ref, $_SESSION['Items']->Location, $line->quantity,
				$line->stock_id,  2, $_SESSION['Items']->document_date,
				$_POST['wo_required_date'], '', 0, $cr_acc, 0, $cr_lab_acc,$order_no,$line_id);
			}
		}
	} /* inserted line items into sales order details */
	
	// Sending SMS 
    if($order->reference != 'auto'){
       $Message = CheckMessageBodyExist($order->trans_type); 
        if($Message){
            $Contact = $order->phone;
            SendTransactionalSMS($Contact, $Message);
        }
    }
    // 	====
	

	if ($order->trans_type == ST_SALESORDER ) // checking type and insert record in audit trail
    {     
    	if($order->fixed_asset == 1){
            add_audit_trail(ST_SALESORDER, $order_no,$order->document_date,'Create Fixed Assets Sale');
    	}
        else if($order->fixed_asset != 1){
        	if($order->against != 0)
        		$msg = "Create New Sales Order against Quotation no ".$order->against;
        	else
        		$msg = 'Create New Sales Order';
        	add_audit_trail(ST_SALESORDER, $order_no,$order->document_date,$msg);
        }
    }
    else if($order->trans_type == ST_SALESQUOTE ) // checking type and insert record in audit trail
    {
    	add_audit_trail(ST_SALESQUOTE, $order_no,$order->document_date,'Create New Sales Quotation');
    }

	$Refs->save($order->trans_type, $order_no, $order->reference, null, $order->fixed_asset);

	hook_db_postwrite($order, $order->trans_type);
	commit_transaction();

	if ($SysPrefs->loc_notification() == 1 && count($st_ids) > 0)
		send_reorder_email($loc, $st_ids, $st_names, $st_num, $st_reorder);
	return $order_no;
}

//----------------------------------------------------------------------------------------

function delete_sales_order($order_no, $trans_type, $opp_id)
{


	begin_transaction();
	hook_db_prevoid($trans_type, $order_no);

if($trans_type == ST_SALESORDER)
	update_opportunity_status($opp_id, 2);
elseif($trans_type == ST_SALESQUOTE)
	update_opportunity_status($opp_id, 1);

	$sql = "DELETE FROM ".TB_PREF."sales_orders WHERE order_no=" . db_escape($order_no) 
		. " AND trans_type=".db_escape($trans_type);

	db_query($sql, "order Header Delete");

	$sql = "DELETE FROM ".TB_PREF."sales_order_details WHERE order_no =" 
		.db_escape($order_no) . " AND trans_type=".db_escape($trans_type);
	db_query($sql, "order Detail Delete");

	//insert record in aduit trail & checking type
	if ($trans_type == ST_SALESORDER )
    add_audit_trail(ST_SALESORDER, $order_no,date('d-m-Y'),'Delete Sales Order');

   //insert record in aduit trail & checking type
   else if($trans_type == ST_SALESQUOTE )
    add_audit_trail(ST_SALESQUOTE, $order_no,date('d-m-Y'),'Delete Sales Quotation');
	commit_transaction();
}

//----------------------------------------------------------------------------------------
// Mark changes in sales_order_details
//
function update_sales_order_version($order)
{
  foreach ($order as $so_num => $so_ver) {
  $sql= 'UPDATE '.TB_PREF.'sales_orders SET version=version+1 WHERE order_no='. db_escape($so_num).
	' AND version='.$so_ver . " AND trans_type=".ST_SALESORDER;
  db_query($sql, 'Concurrent editing conflict while sales order update');
  }
}

//----------------------------------------------------------------------------------------

function update_sales_order($order)
{
	global $SysPrefs, $path_to_root, $Refs;

	$del_date = date2sql($order->due_date);
	$ord_date = date2sql($order->document_date);
	$order_no =  key($order->trans_no);
	$version= current($order->trans_no);
	$total = $order->get_trans_total();

	begin_transaction();
	hook_db_prewrite($order, $order->trans_type);

	if ($order->trans_type == ST_SALESORDER)
		$allocs = get_payments_for($order_no, $order->trans_type, $order->customer_id);

	$sql = "UPDATE ".TB_PREF."sales_orders SET type =".db_escape($order->so_type)." ,
		debtor_no = " . db_escape($order->customer_id) . ",
		branch_code = " . db_escape($order->Branch) . ",
		customer_ref = ". db_escape($order->cust_ref) .",
		reference = ". db_escape($order->reference) .",
		comments = ". db_escape($order->Comments) .",
		ord_date = " . db_escape($ord_date) . ",
		order_type = " .db_escape($order->sales_type) . ",
		ship_via = " . db_escape($order->ship_via) .",
		deliver_to = " . db_escape($order->deliver_to) . ",
		delivery_address = " . db_escape($order->delivery_address) . ",
		contact_phone = " .db_escape($order->phone) . ",
		freight_cost = " .db_escape($order->freight_cost) .",
		from_stk_loc = " .db_escape($order->Location) .",
		delivery_date = " .db_escape($del_date). ",
		version = ".($version+1).",
		payment_terms = " .db_escape($order->payment). ",
		country = " .db_escape($order->country). ",
		country_code = " .db_escape($order->country_code). ",
		cust_phone = " .db_escape($order->customer_phone_). ",
		cust_email = " .db_escape($order->customer_email_). ",
		total = ". db_escape($total). ",
		prep_amount = ". db_escape($order->prep_amount) .",
		dimension_id = ". db_escape($order->dimension_id) ."
	 WHERE order_no=" . db_escape($order_no) ."
	 AND trans_type=".$order->trans_type." AND version=".$version;
	db_query($sql, "order Cannot be Updated, this can be concurrent edition conflict");

	$id_tokeep = array();
	foreach ($order->line_items as $line) {
	    if($line->id)
		array_push($id_tokeep , $line->id);
	}
	$id_list = implode(', ', $id_tokeep);
	
	$sql = "DELETE FROM ".TB_PREF."sales_order_details WHERE order_no =" . db_escape($order_no) . " AND trans_type=".$order->trans_type;
	$sql .= " AND id NOT IN ($id_list)";

	db_query($sql, "Old order Cannot be Deleted");

	if ($SysPrefs->loc_notification() == 1)
	{
		include_once($path_to_root . "/inventory/includes/inventory_db.inc");
		$st_ids = array();
		$st_names = array();
		$st_num = array();
		$st_reorder = array();
	}
	foreach ($order->line_items as $line)
	{
		if ($SysPrefs->loc_notification() == 1 && is_inventory_item($line->stock_id))
			$loc = calculate_reorder_level($order->Location, $line, $st_ids, $st_names, $st_num, $st_reorder); 

		if (!$line->id) //new line
			$sql = "INSERT INTO ".TB_PREF."sales_order_details
			 (order_no, trans_type, stk_code,  description, unit_price, quantity,
			  discount_percent, qty_sent, item_specs, spec_description)
			 VALUES (".$order_no . ",".$order->trans_type.","
				  .db_escape($line->stock_id) . ","
				  .db_escape($line->item_description) . ", "
				  .db_escape($line->price) . ", "
				  .db_escape($line->quantity) . ", "
				  .db_escape($line->discount_percent) . ", "
				  .db_escape($line->qty_done) .", 
				  ".db_escape(implode(",", $line->item_specs)).", 
				  ".db_escape(str_replace("	", '',trim($line->spec_description))).")";
		else
		$sql = "UPDATE ".TB_PREF."sales_order_details
			SET id=".db_escape($line->id).",
				order_no=$order_no,
				trans_type=".$order->trans_type.",
				stk_code=".db_escape($line->stock_id).",
				description=".db_escape($line->item_description).",
				unit_price=".db_escape($line->price).",
				quantity=".db_escape($line->quantity).",
		    	discount_percent=".db_escape($line->discount_percent).",
			    qty_sent=".db_escape($line->qty_done).",
			    spec_description=".db_escape(str_replace("	", '',trim($line->spec_description))).",
			    item_specs=".db_escape(implode(",", $line->item_specs))."
			 WHERE id = ".db_escape($line->id);

		db_query($sql, "Old order Cannot be updated");
	} /* inserted line items into sales order details */
	// 	if ($trans_type == ST_SALESORDER )	
	// add_audit_trail(ST_SALESORDER, $order_no, $order->document_date,'Update Sales Order');
	// else if ($trans_type == ST_SALESQUOTE )	
	// add_audit_trail(ST_SALESQUOTE, $order_no, $order->document_date,'Update Sales Quotation');

	if ($order->trans_type == ST_SALESORDER){
		reallocate_payments($order_no, ST_SALESORDER, $ord_date, $total, $allocs, $order->customer_id);
	add_audit_trail(ST_SALESORDER, $order_no, $order->document_date,'Update Sales Order');
	}

	if ($order->trans_type == ST_SALESQUOTE){
		reallocate_payments($order_no, ST_SALESQUOTE, $ord_date, $total, $allocs, $order->customer_id);
	add_audit_trail(ST_SALESQUOTE, $order_no, $order->document_date,'Update Sales Quotation');
	}
	$Refs->save($order->trans_type, $order_no, $order->reference, null, $order->fixed_asset);

	hook_db_postwrite($order, $order->trans_type);
	commit_transaction();
	if ($SysPrefs->loc_notification() == 1 && count($st_ids) > 0)
		send_reorder_email($loc, $st_ids, $st_names, $st_num, $st_reorder);
}

//----------------------------------------------------------------------------------------

function get_sales_order_header($order_no, $trans_type)
{
	$dropdown_language = $_SESSION['wa_current_user']->dropdown_language; // 2 arabic // 1 English

	// IF(".$dropdown_language."='2',IF(loc.location_name_arabic = '',loc.location_name,loc.location_name_arabic),loc.location_name ) as location_name,

	$sql = "SELECT sorder.*,
	  IF(".$dropdown_language."='2',IF(cust.CustName_arabic = '',cust.name,cust.CustName_arabic),cust.name ) as name,
	  cust.curr_code,
	  cust.address,
	  IF(".$dropdown_language."='2',IF(loc.location_name_arabic = '',loc.location_name,loc.location_name_arabic),loc.location_name ) as location_name, 
	  cust.discount,
	  stype.sales_type,
	  stype.id AS sales_type_id,
	  stype.tax_included,
	  stype.factor,
 	  ship.shipper_name,
	  tax_group.name AS tax_group_name,
	  tax_group.id AS tax_group_id,
	  cust.tax_id,
	  sorder.alloc,
	  IFNULL(allocs.ord_allocs, 0)+IFNULL(inv.inv_allocs ,0) AS sum_paid,
	  sorder.prep_amount>0 as prepaid,
	  IF(".$dropdown_language."='2',IF(branch.br_name_arabic = '',branch.br_name,branch.br_name_arabic),branch.br_name ) as br_name,
	  sorder.inquiry_type 
	FROM ".TB_PREF."sales_orders sorder
			LEFT JOIN (SELECT trans_no_to, sum(amt) ord_allocs FROM ".TB_PREF."cust_allocations
				WHERE trans_type_to=".ST_SALESORDER." AND trans_no_to=".db_escape($order_no)." GROUP BY trans_no_to)
				 allocs ON sorder.trans_type=".ST_SALESORDER." AND allocs.trans_no_to=sorder.order_no
			LEFT JOIN (SELECT order_, sum(alloc) inv_allocs FROM ".TB_PREF."debtor_trans 
				WHERE type=".ST_SALESINVOICE." AND order_=".db_escape($order_no)."  GROUP BY order_)
				 inv ON sorder.trans_type=".ST_SALESORDER." AND inv.order_=sorder.order_no
			LEFT JOIN ".TB_PREF."shippers ship ON  ship.shipper_id = sorder.ship_via,"
	  .TB_PREF."debtors_master cust,"
	  .TB_PREF."sales_types stype, "
	  .TB_PREF."tax_groups tax_group, "
	  .TB_PREF."cust_branch branch,"
	  .TB_PREF."locations loc
	WHERE sorder.order_type=stype.id
		AND branch.branch_code = sorder.branch_code
		AND branch.tax_group_id = tax_group.id
		AND sorder.debtor_no = cust.debtor_no
		AND loc.loc_code = sorder.from_stk_loc
		AND sorder.trans_type = " . db_escape($trans_type) ."
		AND sorder.order_no = " . db_escape($order_no );

	$result = db_query($sql, "order Retreival");

	$num = db_num_rows($result);
	if ($num > 1)
	{
		display_warning("You have duplicate document in database: (type:$trans_type, number:$order_no).");
	}
	else if ($num == 1)
	{
		return db_fetch($result);
	}
	else
		display_warning("You have missing or invalid sales document in database (type:$trans_type, number:$order_no).");

}

//----------------------------------------------------------------------------------------

function get_sales_order_details($order_no, $trans_type, $src_id=0) {
	$sql = "SELECT id, stk_code, unit_price,
				line.description,
				line.quantity,
				discount_percent,
				qty_sent as qty_done,
				item.units,
				item.mb_flag,
				item.material_cost,
				line.sale_kit_id,
				line.item_specs,
				line.spec_description   
			FROM ".TB_PREF."sales_order_details line,"
				.TB_PREF."stock_master item
			WHERE line.stk_code = item.stock_id
				AND order_no =".db_escape($order_no) 
				." AND trans_type = ".db_escape($trans_type) . " ";

	if($src_id)
		$sql .= " AND id=".$src_id;
	$sql .= " ORDER BY id";

	return db_query($sql, "Retreive order Line Items");
}
//----------------------------------------------------------------------------------------
	function get_debtor_email($cust_id)
	{
		$sql = "Select cp.email as email
		FROM ".TB_PREF."crm_persons cp,"
   			  .TB_PREF."crm_contacts cc  
   			   WHERE  cc.entity_id = ".db_escape($cust_id)." 
   			   AND cp.id = cc.person_id
   			   "
   			  ;

   			  $run = db_query($sql,'asdsad');
   			  $fetch= db_fetch($run);
   			  return $fetch['email'];
	}


function read_sales_order($order_no, &$order, $trans_type, $order_creation=false, $src_id=0)
{
	$myrow = get_sales_order_header($order_no, $trans_type);
		$email = get_debtor_email($myrow["debtor_no"]);

	$order->approvedQuotation = $myrow['approved'];
	$order->trans_type = $myrow['trans_type'];
	$order->so_type =  $myrow["type"];
	$order->trans_no = array($order_no=> $myrow["version"]);

	$order->set_customer($myrow["debtor_no"], $myrow["name"],
	  $myrow["curr_code"], $myrow["discount"], $myrow["payment_terms"]);

	$order->set_branch($myrow["branch_code"], $myrow["tax_group_id"],
	  $myrow["tax_group_name"], $myrow["contact_phone"],$email, $myrow["br_name"]);

	$order->set_sales_type($myrow["sales_type_id"], $myrow["sales_type"], 
	    $myrow["tax_included"], $myrow["factor"]); // no default price calculations on edit

	$order->set_location($myrow["from_stk_loc"], $myrow["location_name"]);

	$order->set_delivery($myrow["ship_via"], $myrow["deliver_to"],
	  $myrow["delivery_address"], $myrow["freight_cost"]);


  $order->customer_ =$myrow["cust_name"];
	$order->cust_ref = $myrow["customer_ref"];
	$order->sales_type =$myrow["order_type"];
	$order->reference = $myrow["reference"];
	$order->Comments = $myrow["comments"];
	$order->due_date = sql2date($myrow["delivery_date"]);
	$order->document_date = sql2date($myrow["ord_date"]);

	$order->prepaid = $myrow["prepaid"];
	$order->alloc = $myrow['alloc'];
	$order->sum_paid = $myrow["sum_paid"]; // sum of all prepayments to so (also invoiced)
	$order->prep_amount = $myrow["prep_amount"];
	$order->country = $myrow["country"];
	$order->country_code = $myrow["country_code"];
	$order->customer_email_ = $myrow["cust_email"];
	$order->customer_phone_ = $myrow["cust_phone"];
	$order->prepayments = get_payments_for($order_no, $myrow['trans_type'], $myrow['debtor_no']);
	$order->opp_id = $myrow["opp_id"];
	$order->quote_id = $myrow['quote_id'];
	$order->inquiry_type = $myrow["inquiry_type"];
	$order->dimension_id = $myrow["dimension_id"];
	$order->dimension2_id = $myrow["dimension2_id"];

	$result = get_sales_order_details($order_no, $order->trans_type, $src_id);
	if (db_num_rows($result) > 0)
	{
		$line_no=0;
		while ($myrow = db_fetch($result)){
			$order->add_to_cart($line_no,$myrow["stk_code"],$myrow["quantity"],
				$myrow["unit_price"], $myrow["discount_percent"],
				$myrow["qty_done"], $myrow["material_cost"], $myrow["description"], $myrow["id"],0,0,null,null,null,null,null,$myrow["sale_kit_id"], 0, null, explode(",", $myrow['item_specs']), $myrow['spec_description']);
				$line_no++;
		}
	}

	return true;
}

//----------------------------------------------------------------------------------------

function sales_order_has_deliveries($order_no)
{
	$sql = "SELECT SUM(qty_sent) FROM ".TB_PREF.
	"sales_order_details WHERE order_no=".db_escape($order_no)
	." AND trans_type=".ST_SALESORDER;

	$result = db_query($sql, "could not query for sales order usage");

	$row = db_fetch_row($result);

	if ($row[0] > 0)
		return true;  // 2010-04-21 added check for eventually voided deliveries, Joe Hunt
	$sql = "SELECT order_ FROM ".TB_PREF."debtor_trans WHERE type=".ST_CUSTDELIVERY." AND order_=".db_escape($order_no);
	$result = db_query($sql,"The related delivery notes could not be retreived");
	return (db_num_rows($result) > 0);	
}

//----------------------------------------------------------------------------------------

function close_sales_order($order_no)
{
	// set the quantity of each item to the already sent quantity. this will mark item as closed.
	$sql = "UPDATE ".TB_PREF."sales_order_details
		SET quantity = qty_sent WHERE order_no = ".db_escape($order_no)
		." AND trans_type=".ST_SALESORDER;

	db_query($sql, "The sales order detail record could not be updated");
}

//---------------------------------------------------------------------------------------------------------------

function get_invoice_duedate($terms, $invdate)
{
	if (!is_date($invdate))
	{
		return new_doc_date();
	}
	
	$myrow = get_payment_terms($terms);
	
	if (!$myrow)
		return $invdate;

	if ($myrow['day_in_following_month'] > 0)
		$duedate = add_days(end_month($invdate), $myrow['day_in_following_month']);
	elseif ($myrow['days_before_due'] > 0)
		$duedate = add_days($invdate, $myrow['days_before_due']);
	else
		$duedate = $invdate;
	return $duedate;
}

function get_customer_to_order($customer_id) {

	// Now check to ensure this account is not on hold */
	$sql = "SELECT cust.name, 
		  cust.address,
		  credit_status.dissallow_invoices, 
		  cust.sales_type AS salestype,
		  cust.dimension_id,
		  cust.dimension2_id,
		  stype.sales_type,
		  stype.tax_included,
		  stype.factor,
		  cust.curr_code,
		  cust.discount,
		  cust.payment_terms,
		  cust.pymt_discount,
		  cust.discount_criteria,
		  cust.credit_limit - Sum(IFNULL(IF(trans.type IN(".implode(',', array(ST_CUSTCREDIT, ST_CUSTPAYMENT, ST_BANKDEPOSIT))."),
			-1, 1) * (ov_amount + ov_gst + ov_freight + ov_freight_tax + ov_discount),0)) as cur_credit
		FROM ".TB_PREF."debtors_master cust
		  LEFT JOIN ".TB_PREF."debtor_trans trans ON trans.type!=".ST_CUSTDELIVERY." AND trans.debtor_no = cust.debtor_no,"
		  .TB_PREF."credit_status credit_status,"
		  .TB_PREF."sales_types stype
		WHERE cust.sales_type=stype.id
			AND cust.credit_status=credit_status.id
			AND cust.debtor_no=".db_escape($customer_id)
		." GROUP by cust.debtor_no";

	$result =db_query($sql,"Customer Record Retreive");
	return 	db_fetch($result);
}

function get_branch_to_order($customer_id, $branch_id) {

    	// the branch was also selected from the customer selection so default the delivery details from the customer branches table cust_branch. The order process will ask for branch details later anyway
	 	$sql = "SELECT branch.br_name,
					branch.br_address,
					branch.br_post_address,
					default_location, location_name, default_ship_via,
					tax_group.name AS tax_group_name,
					tax_group.id AS tax_group_id
				FROM ".TB_PREF."cust_branch branch,"
			  		.TB_PREF."tax_groups tax_group,"
			  		.TB_PREF."locations location
			WHERE branch.tax_group_id = tax_group.id
				AND location.loc_code=default_location
				AND branch.branch_code=".db_escape($branch_id)."
				AND branch.debtor_no=".db_escape($customer_id);

  	    return db_query($sql,"Customer Branch Record Retreive");
}

/*
	Supported filters:

	InvoiceTemplates
	DeliveryTemplates
	OutstandingOnly
	PrepaidOrders
*/
function get_sql_for_sales_orders_view($trans_type, $trans_no, $filter, 
	$stock_item='', $from='', $to='', $ref='', $location=ALL_TEXT, $customer_id=ALL_TEXT, $showUnApproved = 0, $show_all=null, $dimension_id=null)
{

	if($trans_type == 32 && $showUnApproved == 0)
		$approved = 1;
	elseif($trans_type == 32 && $showUnApproved == 1)
		$approved = 0;
	if($trans_type == 30)
		$approved = 0;

	$sql = "SELECT 
			sorder.order_no,
			sorder.reference,
			debtor.name,
			branch.br_name,"
			.($filter=='InvoiceTemplates' 
				|| $filter=='DeliveryTemplates' ?
			 "sorder.comments, " : "sorder.customer_ref, ")
			."sorder.ord_date,
			sorder.delivery_date,
			sorder.deliver_to,
			Sum((line.unit_price*line.quantity)-line.discount_percent)+freight_cost AS OrderValue,
			sorder.type,
			debtor.curr_code,
			Sum(line.qty_sent) AS TotDelivered,
			Sum(line.quantity) AS TotQuantity,
			Sum(line.invoiced) AS TotInvoiced,
			alloc,
			prep_amount,
			allocs.ord_payments,
			inv.inv_payments,
			sorder.total,
			sorder.trans_type,
			sorder.dimension_id 
		FROM ".TB_PREF."sales_orders as sorder
		LEFT JOIN (SELECT trans_no_to, sum(amt) ord_payments FROM ".TB_PREF."cust_allocations WHERE trans_type_to=".ST_SALESORDER." GROUP BY trans_no_to)
			 allocs ON sorder.trans_type=".ST_SALESORDER." AND allocs.trans_no_to=sorder.order_no
		LEFT JOIN (SELECT order_, sum(prep_amount) inv_payments	FROM ".TB_PREF."debtor_trans WHERE type=".ST_SALESINVOICE." GROUP BY order_)
				 inv ON sorder.trans_type=".ST_SALESORDER." AND inv.order_=sorder.order_no,"
			.TB_PREF."sales_order_details as line, "
			.TB_PREF."debtors_master as debtor, "
			.TB_PREF."cust_branch as branch
			WHERE sorder.order_no = line.order_no
			AND sorder.trans_type = line.trans_type
			AND sorder.trans_type = ".db_escape($trans_type)."
			AND sorder.debtor_no = debtor.debtor_no
			AND sorder.branch_code = branch.branch_code
			AND debtor.debtor_no = branch.debtor_no";

	if (isset($trans_no) && $trans_no != "")
	{
		// search orders with number like 
		$number_like = "%".$trans_no;
		$sql .= " AND sorder.order_no LIKE ".db_escape($number_like);
//				." GROUP BY sorder.order_no";
	}
	elseif ($ref != "")
	{
		// search orders with reference like 
		$sql .= " AND sorder.reference LIKE ".db_escape('%' . $ref . '%');
//				." GROUP BY sorder.order_no";
	}
	else	// ... or select inquiry constraints
	{
		if ($filter!='DeliveryTemplates' && $filter!='InvoiceTemplates' && $filter!='OutstandingOnly')
		{
			$date_after = date2sql($from);
			$date_before = date2sql($to);

			$sql .=  " AND sorder.ord_date >= '$date_after'"
					." AND sorder.ord_date <= '$date_before'";
		}
	}
		if ($trans_type == ST_SALESQUOTE && $show_all)
			$sql .= " AND sorder.delivery_date >= '".date2sql(Today())."' AND line.qty_sent=0"; // show only outstanding, not realized quotes

		//if ($selected_customer != -1)
		//	$sql .= " AND sorder.debtor_no=".db_escape($selected_customer);

		if ($stock_item != ALL_TEXT)
			$sql .= " AND line.stk_code=".db_escape($stock_item);

		if ($location != ALL_TEXT)
			$sql .= " AND sorder.from_stk_loc = ".db_escape($location);

		if ($filter=='OutstandingOnly')
			$sql .= " AND line.qty_sent < line.quantity";

		if ($filter=='PrepaidOrders')
			$sql .= " AND prep_amount>0";

		elseif ($filter=='InvoiceTemplates' || $filter=='DeliveryTemplates')
			$sql .= " AND sorder.type=1";

		//Chaiatanya : New Filter
		if ($customer_id != ALL_TEXT)
			$sql .= " AND sorder.debtor_no = ".db_escape($customer_id);	

		$sql .= " AND sorder.approved = ".db_escape($approved);	
		
		if($dimension_id)
			$sql .= " AND sorder.dimension_id = ".db_escape($dimension_id);	

		$sql .= " GROUP BY sorder.order_no,
					sorder.debtor_no,
					sorder.branch_code,
					sorder.customer_ref,
					sorder.ord_date,
					sorder.deliver_to";

	return $sql;
}

//--------------------------------------------------------------------------------------------------
function update_prepaid_so_line($line_id, $qty_invoiced)
{
	$sql = "UPDATE ".TB_PREF."sales_order_details
		SET invoiced = invoiced + ".(float)$qty_invoiced."
		WHERE id=".db_escape($line_id);

	db_query($sql, "The document detail record could not be updated with invoiced qty");
	return true;
}
/*
	Returns array of all issued invoices to sales order $order_no, optinally up to trans_no==$up_to
*/
function get_sales_order_invoices($order_no)
{
	$sql = "SELECT trans_no, dt.type as type, tran_date, reference, prep_amount
	    FROM ".TB_PREF."debtor_trans dt
		LEFT JOIN ".TB_PREF."voided v ON v.type=dt.type AND v.id=dt.trans_no
		WHERE ISNULL(v.id) AND dt.type=".ST_SALESINVOICE." AND dt.order_=".db_escape($order_no)
		." ORDER BY dt.tran_date, dt.reference, dt.trans_no";

	return db_query($sql, "cannot retrieve sales invoices for sales order");
}

function is_sales_order_started($order_no)
{
	$sql = "SELECT count(*) FROM ".TB_PREF."sales_order_details WHERE order_no=".db_escape($order_no)." AND trans_type=".ST_SALESORDER
		." AND (invoiced!=0 OR qty_sent!=0)";

	$result = db_fetch(db_query($sql, "cannot retrieve sales invoices for sales order"));
	return $result[0];
}

//---------------------------------------------------------------------------------------------
//
// Mark/unmark sales order as template.
//
function sales_order_set_template($id, $status)
{
  	$sql = "UPDATE ".TB_PREF."sales_orders SET type = ".db_escape($status)." WHERE order_no=".db_escape($id);
  	db_query($sql, "Can't change sales order type");
}

//--------------------------------------------pk--------------------------------------------------
function update_editable_sales_order_and_delivery(&$order){
	global $SysPrefs, $path_to_root, $Refs;
	$order_no =  get_customer_trans($order->ModifyInvoice, ST_SALESINVOICE)['order_'];

	$delivery_num = get_delivery_num($order_no,ST_CUSTDELIVERY);

	write_sales_delivery($order,0,$delivery_num);

	$del_date = date2sql($order->due_date);
	$ord_date = date2sql($order->document_date);
	$total = $order->get_trans_total();

	$sql = "UPDATE ".TB_PREF."sales_orders SET 
		ord_date = " . db_escape($ord_date) . ",
		order_type = " .db_escape($order->sales_type) . ",
		ship_via = " . db_escape($order->ship_via) .",
		delivery_date = " .db_escape($del_date). ",
		payment_terms = " .db_escape($order->payment). ",
		total = ". db_escape($total). "
	WHERE order_no=" . db_escape($order_no) ."
	AND trans_type=".ST_SALESORDER;
	db_query($sql, "order Cannot be Updated, this can be concurrent edition conflict");
	//display_error($sql);
	
	// for getting sales_order details id to update correctly.
	$result = get_sales_order_details($order_no, ST_SALESORDER);
	if (db_num_rows($result) > 0){
		$line_no=0;
		while ($myrow = db_fetch($result)){
			$order->line_items[$line_no]->id = $myrow["id"];
			$line_no++;
		}
	}
	foreach ($order->line_items as $line){
		
		$sql = "UPDATE ".TB_PREF."sales_order_details
			SET 
			stk_code=".db_escape($line->stock_id).",
			description=".db_escape($line->item_description).",
			unit_price=".db_escape($line->price).",
			quantity=".db_escape($line->qty_dispatched).",
		    discount_percent=".db_escape($line->discount_percent).",
			qty_sent=".db_escape($line->qty_dispatched)."
			WHERE id = ".db_escape($line->id);
	//display_error($sql);
		db_query($sql, "Old order Cannot be updated");
	}	
}

function get_delivery_num($order,$type){
	$sql = " SELECT trans_no FROM ".TB_PREF."debtor_trans WHERE order_ = '$order' AND type = '$type' ";
	$result = db_query($sql,"  ");
	$row = db_fetch($result);
	return $row['trans_no'];
}
//--------------------------------------------pk--------------------------------------------------


/*
	Check whether sales order is issued in prepaid mode and already opened
*/

function is_prepaid_order_open($order_no)
{
	$sql = "SELECT count(*)
		FROM ".TB_PREF."sales_orders o,
		((SELECT trans_no_to FROM ".TB_PREF."cust_allocations
				WHERE trans_type_to=".ST_SALESORDER." AND trans_no_to=".db_escape($order_no).")
		UNION
		  (SELECT order_ FROM ".TB_PREF."debtor_trans 
			WHERE type=".ST_SALESINVOICE." AND order_=".db_escape($order_no).")) related
	WHERE
		o.prep_amount>0
		AND o.trans_type = ".ST_SALESORDER."
		AND o.order_no = " . db_escape($order_no);

	$result = db_fetch(db_query($sql, "cannot check prepaid order open"));

	return $result[0];
}

//----------------------------------------------------------------------------------------------
// get Audit trail report amount
function get_sales_order_total($id)
{
	$sql = "SELECT total FROM ".TB_PREF."sales_orders WHERE order_no=".db_escape($id)."";
	$result = db_query($sql);
    $myrow = db_fetch($result);

    return $myrow['total'];
}

//----------------------------------------------------------------------------------------------

//select delivery Note Amount And GST

function get_delivery_note_gst($id){

	$sql = "SELECT SUM(ov_amount + ov_gst) total FROM ".TB_PREF."debtor_trans WHERE trans_no=".db_escape($id)." AND type=13";
	$result = db_query($sql);
    $myrow = db_fetch($result);
     return $myrow['total'];
}

//----------------------------------------------------------------------------------------------
//purchase order amount get with gst

function get_purchase_amount_gst($id){
	$sql = "SELECT SUM(total + tax_included) total FROM ".TB_PREF."purch_orders WHERE order_no=".db_escape($id)."";
	$result = db_query($sql);
	$myrow = db_fetch($result);
	return $myrow['total'];
}
//----------------------------------------------------------------------------------------------
//Check ITem HAve Specification

function check_item_spec($stock_id){
	$sql = "SELECT * FROM ".TB_PREF."item_specification WHERE stock_id=".db_escape($stock_id)."";
	$result = db_query($sql);
	$myrow = db_fetch($result);
	$rows=db_num_rows($result);
	if($rows>0)
		return 1;
	else
		return 0;
	// display_error($rows);
	// die;
	// return $result;
}
function get_specification1($stock_id)
{
	$sql = "SELECT * FROM ".TB_PREF."item_specification WHERE stock_id=".db_escape($stock_id)." AND specification_id!=-1 ORDER BY specification_id asc";
	$result = db_query($sql);
	return $result;
}

function salesQuotationSetApprove($id, $status=1){
	$status=1;
	$transType = ST_SALESQUOTE;
  	$sql = "UPDATE ".TB_PREF."sales_orders SET approved = ".db_escape($status)." WHERE order_no=".db_escape($id)." 
  	AND trans_type = ".db_escape($transType)." ";
  	db_query($sql, "Can't change sales quotation approved salesQuotationSetApprove function ");
  	
  	add_audit_trail(ST_SALESQUOTE, $id, date('d/m/Y'),'Sales Quotation is approved');	//pk
}

// get width for form feilds

function get_form_feilds_status($type){
	$sql = " SELECT * FROM ".TB_PREF."forms_feilds WHERE type = '$type' ";
	$res = db_query($sql, "no feilds founds");
	return $res;
}

function check_feild_status_of_invoice_form($tag_name, $type){
	$sql = " SELECT * FROM ".TB_PREF."forms_feilds WHERE type = '$type' AND tag_name = '$tag_name' ";
	$res = db_query($sql, "no status founds");
	$row = db_fetch($res);
	return $row;
}

function update_form_feild_status($type, $feild_array, $feild_array2){

	foreach($feild_array as $name => $value) {
		if($value == null )
			$value = 0;
		$name = str_replace('pc_', '', $name);
		$sql = "UPDATE ".TB_PREF."forms_feilds SET status_pc = '$value' ";
		$sql .= " WHERE name = '$name' AND type = '$type'  ";
		db_query($sql); 
	}

	foreach($feild_array2 as $name => $value) {
		if($value == null )
			$value = 0;
		$name = str_replace('mbl_', '', $name);
		$sql = "UPDATE ".TB_PREF."forms_feilds SET status_mbl = '$value' ";
		$sql .= " WHERE name = '$name' AND type = '$type' ";
		db_query($sql); 
	}
}
function get_branch_by_debtor_no($debtor_no){
	$sql = " SELECT * FROM ".TB_PREF."cust_branch WHERE debtor_no = '$debtor_no' ";
	$res = db_query($sql);
	$row = db_fetch($res);
	return $row['branch_code'];
}

function get_all_customers(){

	$sql = "SELECT * FROM ".TB_PREF."debtors_master ";

	$result = db_query($sql, "could not get customer");

	return db_fetch($result);


}


function update_draft_sales_order($order_no,$status)
{
   $sql = "UPDATE ".TB_PREF."sales_orders SET draft_pos = ".db_escape($status)." WHERE trans_type = ".db_escape(ST_SALESORDER)."  AND order_no=".db_escape($order_no);
	$res = db_query($sql, "no feilds founds");

}



//----------------------------------------------------------------------------------------
// 14oct21
function set_ord_cancel_status($ord_number){
	$sql = "UPDATE ".TB_PREF."sales_orders SET ord_cancel = 1  WHERE order_no = ".db_escape($ord_number);
	db_query($sql);
}


//----------------------------------------------------------------------------------------