<?php
include_once($path_to_root . "/includes/ui.inc");



function add_to_order(&$order, $new_item, $new_item_qty, $price, $discount,$description='', $bar_code=null)
{
	// calculate item price to sum of kit element prices factor for 
	// value distribution over all exploded kit items
	 $std_price = get_kit_price($new_item, $order->customer_currency, 
		$order->sales_type,	$order->price_factor, get_post('OrderDate'), true);

	if ($std_price == 0)
		$price_factor = 0;
	else
		$price_factor = $price/$std_price;

	$kit = get_item_kit($new_item);
	$item_num = db_num_rows($kit);

	while($item = db_fetch($kit)) {
		$std_price = get_kit_price($item['stock_id'], $order->customer_currency, 
			$order->sales_type,	$order->price_factor, get_post('OrderDate'), true);

		// rounding differences are included in last price item in kit
		$item_num--;
		if ($item_num) {
			$price -= $item['quantity']*$std_price*$price_factor;
			$item_price = $std_price*$price_factor;
		} else {
			if ($item['quantity']) 
				$price = $price/$item['quantity'];
			$item_price = $price;
			
		}
		$item_price = round($item_price, user_price_dec());

		if (!$item['is_foreign'] && $item['item_code'] != $item['stock_id'])
		{	// this is sales kit - recurse 
			add_to_order($order, $item['stock_id'], $new_item_qty*$item['quantity'],
				$item_price, $discount);
		}
		else
		{	// stock item record eventually with foreign code

			// check duplicate stock item
			foreach ($order->line_items as $order_item)
			{
				if (strcasecmp($order_item->stock_id, $item['stock_id']) == 0)
				{
					display_warning(_("For Part :").$item['stock_id']. " " 
						. _("This item is already on this document. You have been warned."));
					break;
				}
			}
			// display_error($spec1.'______'.$spec2.'______'.$spec3.'______'.$spec4.'______'.$spec5);
			// die;

			$order->add_to_cart (count($order->line_items),	$item['stock_id'], 
				$new_item_qty*$item['quantity'], $item_price, $discount, 0,0, $description,null,null,null,null,null,null,nullnull,null , $bar_code);
		}
	}

}

//---------------------------------------------------------------------------------

function get_customer_details_to_order(&$order, $customer_id, $branch_id)
{
	global $SysPrefs;
	
	$ret_error = "";

	$myrow = get_customer_to_order($customer_id);
    // display_error($myrow['curr_code']."ssss".$customer_id);
	$name = $myrow['name'];

	if ($myrow['dissallow_invoices'] == 1)
		$ret_error = _("The selected customer account is currently on hold. Please contact the credit control personnel to discuss.");

	$deliver = $myrow['address']; // in case no branch address use company address

	$order->set_customer($customer_id, $name, $myrow['curr_code'], 
		$myrow['discount'], $myrow['payment_terms'], $myrow['pymt_discount']);

	// the sales type determines the price list to be used by default
	$order->set_sales_type($myrow['salestype'], $myrow['sales_type'], $myrow['tax_included'],
	    $myrow['factor']);

	$order->credit = $myrow['cur_credit'];

	if ($order->trans_type != ST_SALESORDER && $order->trans_type != ST_SALESQUOTE)
	{
		$order->dimension_id = $myrow['dimension_id'];
		$order->dimension2_id = $myrow['dimension2_id'];
	}
	$result = get_branch_to_order($customer_id, $branch_id);

	if (db_num_rows($result) == 0)
	{
		return _("The selected customer and branch are not valid, or the customer does not have any branches.");
	}

	$myrow = db_fetch($result);

	// FIX - implement editable contact selector in sales order 
	$contact = get_branch_contacts($branch_id, 'order', $customer_id);
	$order->set_branch($branch_id, $myrow["tax_group_id"],
	$myrow["tax_group_name"], @$contact["phone"], @$contact["email"]);

	$address = trim($myrow["br_post_address"]) != '' ? $myrow["br_post_address"]
		: (trim($myrow["br_address"]) != '' ? $myrow["br_address"]:$deliver);

	$order->set_delivery($myrow["default_ship_via"], $myrow["br_name"],
		$address);
	if ($order->trans_type == ST_SALESINVOICE) {
		$order->due_date = get_invoice_duedate($order->payment, $order->document_date);
	}
	elseif ($order->trans_type == ST_SALESORDER)
		$order->due_date = add_days($order->document_date, $SysPrefs->default_delivery_required_by());
	elseif ($order->trans_type == ST_SALESQUOTE)
		$order->due_date = add_days($order->document_date, $SysPrefs->default_quote_valid_days());

	if($order->payment_terms['cash_sale']) {
		$order->set_location($order->pos["pos_location"], $order->pos["location_name"]);
	} else
		$order->set_location($myrow["default_location"], $myrow["location_name"]);

	return $ret_error;
}
//---------------------------------------------------------------------------------


function display_new_sale_header(&$order){
    global $path_to_root, $Ajax;
     	$div_style='';
	?>

	<!-- work for gird -->
		<div class="row">
 			<div class="col-sm-2 col-md-2 col-xs-2 col-2" style="width: min-content;">
				<?php
				div_start('cata_search_div');
					start_outer_table(TABLESTYLE2 ,'width:20% !important ;','0','0',false,1);
					echo '<ul class="tab">';
					$result = get_cat($_POST['search_cata']);
					$a = 'aaa';
					$b = 'bbb';
					$d = 'Deals';
					$src=company_path().'/images/category/'.$my_row['category_id'].'.jpg';
					if(!file_exists($src))
						$src='../company/0/images/profile_image.png';

					echo '<a href="#" class="tablinks" title="All Categories" onclick="openCity(event, \''.$b.'\')">
					<li><img style="width: 40px;" src="../company/0/images/profile_image.png" class="user-image" alt="User Image"></li></a>';

					while($my_row = db_fetch($result)){
						$src = company_path().'/images/category/'.$my_row['category_id'].'.jpg';
						if(!file_exists($src))
							$src='../company/0/images/profile_image.png';
						echo '<a href="#" class="tablinks" title="'.$my_row['description'].'" 
						onclick="openCity(event, \''.$my_row['category_id'].'\')"><li>
				 		<img style="width: 40px;" src="'.$src.'?nocache=.rand()" class="user-image" alt="User Image"></li></a>';
					}
					echo '<a href="#" class="tablinks" title="Deals" onclick="openCity(event, \''.$a.'\')"><li>
			      <img style="width: 40px;" src="../company/0/images/profile_image.png" class="user-image" alt="User Image"></li></a>';

					echo'</ul>';
					end_outer_table(1);
				div_end();
			echo "</div>"; // cols div end 

			echo '<div class="col-sm-6 col-md-7 col-xs-6" id="cata_item" style="display:none;">';
			start_outer_table(TABLESTYLE2 ,'width:100% !important ;');

				div_start('search_item_div');
					// code for sale kit seperatly
					echo '<div id="'.$b.'" class="tabcontent">
				  	<h2 style="text-align: center; background: #489ee7;padding: 20px; margin-top: 0; color: white;" >All Categories</h2>';
	  					echo '<div style="max-height:300px;background-color:;width:99%; ">';//overflow-x: scroll;
							echo '<div style="height:;background-color:white;width:auto;">';
							
							//all sql Catrgory 
							$result2 = get_cat();
							$i=0;
							while ($my_row2 = db_fetch($result2)){
								$new = get_cat_for_box($my_row2['category_id'],0, $_POST['cata_stock_id'.$i]);
								while ($myrow = db_fetch($new)){
									echo '<div class="col-md-3">';
										
										echo '<div style="width: 100%;margin-top:5px;float: left;padding-bottom: 5px;box-shadow: 1px 1px 6px 0px #ccc;
										border-width: 1px;border-color: #e8ebf1;border-style: solid;border-radius: 3px;background-color: #ffffff;
										padding: 0px !important;overflow: hidden;cursor: pointer;"> ';  
                						
                						echo '<div style="width: 200px;background-color:;margin-left:8px;margin-top:10px;">';

                							echo '<div style="width:100px;height: auto;overflow:hidden;"><p title="'.$myrow['stock_id'].
                							'" style="font-size: 12	px;font-family:Arial, Helvetica, sans-serif; ">' .get_item_names($myrow['stock_id'],
                							$my_row2['category_id'], $myrow['stock_id']). '</p></div>';

												echo '<input type="text" style="width:90px;margin-top:5px"  id="' . $myrow['stock_id'] . '" 
												onclick="set_id(this)" name="qty_num' . $myrow['stock_id'] . '" value="1" onmouseout="set_qty(this)" >';

												echo button_new("AddItem2".$myrow['stock_id'] , _("Edit"), _('Edit document line'), ICON_ADD_BTN,'');

											echo '</div>';
										echo '</div>';
									echo '</div>';

								}
							}
							echo'</div>';
						echo'</div>';
					div_end();

					$result2 = get_cat();
					$i=0;
					while ($my_row2 = db_fetch($result2)){
						$i++;
						if(list_updated('cata_stock_id'.$i)){
							$Ajax->activate('search_item_div'.$i);
						}
						echo '<div id="'.$my_row2['category_id'].'" class="tabcontent">
				  		<h2 style="text-align: center; background: #489ee7;padding: 20px; margin-top: 0; color: white;" >'.$my_row2['description'].
				  		'<i style="float: right;" id="close_category" onclick="hide_gird()" class="fa fa-window-close" aria-hidden="true"></i></h2>';

							start_table(TABLESTYLE2, 'width:100% !important ;', 10);
							echo "<td>";
							echo sales_items_list('cata_stock_id'.$i,  $_POST['cata_stock_id'.$i], 'Select Items', true, true, array(), 
							$my_row2['category_id']);
							echo "</td>";
							if (isset($_POST['bar_code'])) {
								$barcode = $_POST['bar_code'];
								unset($_POST['bar_code']);
								$Ajax->activate('bar_code');
							}

							if($i==1)
								ref_cells(null, 'bar_code', '',null, '', true,null,null,'','placeholder=" Add Barcode"');
							else
								echo label_cells();	
							end_table(1);
              	
	  						div_start('search_item_div'.$i);
		  	
		  					echo '<div style="max-height:300px;background-color:;width:99%; ">';//overflow-x: scroll;
								echo '<div style="height:;background-color:;width:auto; ">';
									
									$new = get_cat_for_box($my_row2['category_id'],0, $_POST['cata_stock_id'.$i]);
			
										while ($myrow = db_fetch($new)){
				
             							echo '<div class="col-md-4">';
                							
                							echo '<div style="width: 100%;margin-top:5px;float: left;padding-bottom: 5px;
                							box-shadow: 1px 1px 6px 0px #ccc;border-width: 1px;border-color: #e8ebf1;border-style: solid;
                							border-radius: 3px;background-color: #ffffff;padding: 0px !important;overflow: hidden;cursor: pointer;">';  
                								
                								echo '<div style="background-color:;margin-left:8px;margin-top:10px;">';
                   
                									echo '<div style="height: auto;overflow:hidden;"> <p title="'.get_item_names($myrow['stock_id'], 
                									$my_row2['category_id'], $myrow['item_code']).'" style="font-size: 12	px; 
                									font-family:Arial, Helvetica, sans-serif; " >' . get_item_names($myrow['stock_id'], 
                									$my_row2['category_id'], $myrow['item_code']) . '</p></div>';

														echo '<input type="text" style="width:90px;margin-top:5px"  id="'.$myrow['stock_id'].'" 
														onclick="set_id(this)" name="qty_num'.$myrow['stock_id'].'" value="1" onmouseout="set_qty(this)" >';

														echo button_new("AddItem2".$myrow['stock_id'] , _("Edit"), _('Edit document line'), ICON_ADD_BTN,'');

													echo '</div>';
												echo '</div>';
											echo '</div>';
										}
								echo '</div>';
							echo '</div>';
							div_end();
						echo'</div>';
					}

					echo '<div id="'.$a.'" class="tabcontent"><h2 style="text-align: center; background: #489ee7;padding: 20px; margin-top: 0; 
					color: white;" >Deal</h2>';
	  					echo '<div style="max-height:300px;background-color:;width:99%; ">';//overflow-x: scroll;
							echo '<div style="height:;background-color:white;width:auto;">';
							
							$new = get_cat_for_box(0,$a);
							while ($myrow = db_fetch($new)){
								echo '<div class="col-md-3">';
									echo '<div style="width: 100%;margin-top:5px;float: left;padding-bottom: 5px;
                				box-shadow: 1px 1px 6px 0px #ccc;border-width: 1px;border-color: #e8ebf1;border-style: solid;
                				border-radius: 3px;background-color: #ffffff;padding: 0px !important;overflow: hidden;cursor: pointer;">';  
                					echo '<div style="width: 150px; background-color:;margin-left:8px;margin-top:10px;">';
                						echo '<div style="width:100px;height: auto;overflow:hidden;"><p title="'.$myrow['item_code'].
                						'" style="font-size: 12	px;font-family:Arial, Helvetica, sans-serif; " >' .substr($myrow['item_code'],0,10).
                						'</p></div>';

											echo '<input type="text" style="width:90px;margin-top:5px"  id="' . $myrow['stock_id'] . '" 
											onclick="set_id(this)" name="qty_num' . $myrow['item_code'] . '" value="1" onmouseout="set_qty(this)" >';

											echo button_new("AddItem2".$myrow['item_code'] , _("Edit"), _('Edit document line'), ICON_ADD_BTN,'');

										echo '</div>';
									echo '</div>';
								echo '</div>';
							}
							echo '</div>';
						echo '</div>';
					echo'</div>';
				end_outer_table(1);
				echo "</div>"; // cols div end 
  ?>



	<script type="text/javascript">
		function show_gird(){
			$("#gird_div").slideDown();
			$('#show_gird_anchor').hide();
			$('#hide_gird_anchor').show();

		}

		function hide_gird(){
			$("#gird_div").slideUp();
			$('#show_gird_anchor').show();
			$('#hide_gird_anchor').hide();
		}

	</script>		

	
	<?php

                    $cash_customer_id = get_cash_customer_data()['debtor_no'];
					if(!$cash_customer_id)
					{
					    display_error(_("Any customer with selection of Cash Customer is missing."));
					    end_page();
					    exit();
					}
					$cust_branch_id = get_default_branch($cash_customer_id)['branch_code'];
					// 13/10/2021
					$customer_error = get_customer_details_to_order($order, $cash_customer_id, $_POST['branch_id']? $_POST['branch_id'] :  $cust_branch_id);	
					
					if(list_updated('branch_id'))
						$customer_error = get_customer_details_to_order($order, $cash_customer_id, $_POST['branch_id']);	

					// 13/10/2021	
						
	
}

function display_new_sale_summary($title, &$order){
	global $SysPrefs,$Ajax;

	echo '<div class = "col-sm-2 col-md-2 col-xs-2 col-2">';
	div_start('summary_div');
	?>
	<div id="" class="register-box register-items paper-cut" style="">
		<div class="register-items-holder">
			<!-- pop box for price  -->
			<div class="container" id="price_container" style="top :10%" >
				<!-- Modal -->
				<div class="modal fade" id="price_modal" role="dialog" style="margin: auto; 
				position: fixed; top: 30%;  background: transparent;">
					<div class="modal-dialog">
						<!-- Modal content-->
						<div class="modal-content" style="width:60%;">
							<div class="modal-header" style="padding-top: 9px; padding-bottom: 3px; background-color: #f0f2f5; color: #555555;">
								<a type="button" class="close" data-dismiss="modal">&times;</a>
								<p class="modal-title">Price.</p>
							</div>
							<div class="modal-body">
								<input type="text" name="modalprice" id="modalprice" style="padding-right: 24px; height: 36px !important; 
								line-height: 24px;color: #000;">
								<input type="hidden" name="price_hidden_id" id="price_hidden_id">
								<input type="hidden" name="price_modalqty" id="price_modalqty">
								<input type="hidden" name="price_modaldisc" id="price_modaldisc">
								<?php
								button_cell('UpdateItem', _("Update"),_('Confirm changes'), ICON_UPDATE, '',"modal");
								button_cell('CancelItemChanges', _("Cancel"),_('Cancel changes'), ICON_CANCEL, '',"modal");
								?>
							</div>
						</div>
					</div>
				</div>
			</div>

			<!-- pop box for qty  -->
			<div class="container" style="top :10%" >
				<!-- Modal -->
				<div class="modal fade" id="qty_modal" role="dialog" style="margin: auto; position: fixed; top: 30%;  background: transparent;">
					<div class="modal-dialog">
						<!-- Modal content-->
						<div class="modal-content" style="width:60%;">
							<div class="modal-header" style="padding-top: 9px; padding-bottom: 3px; background-color: #f0f2f5; color: #555555;">
								<a type="button" class="close" data-dismiss="modal">&times;</a>
								<p class="modal-title">Qty.</p>
							</div>
							<div class="modal-body">
								<input type="text" name="modalqty" id="modalqty" style="padding-right: 24px; height: 36px !important; 
								line-height: 24px; color: #000;">
								<input type="hidden" name="qty_hidden_id" id="qty_hidden_id">
								<input type="hidden" name="qty_modalprice" id="qty_modalprice">
								<input type="hidden" name="qty_modaldisc" id="qty_modaldisc">
								<?php
								button_cell('UpdateItem1', _("Update"),_('Confirm changes'), ICON_UPDATE, '',"modal");
								button_cell('CancelItemChanges', _("Cancel"),_('Cancel changes'), ICON_CANCEL, '',"modal");
								?>
							</div>
						</div>
					</div>
				</div>
			</div>

			<!-- pop box for disc  -->
			<div class="container" style="top :10%" >
				<!-- Modal -->
				<div class="modal fade" id="disc_modal" role="dialog" style="margin: auto; position: fixed; top: 30%;  background: transparent;">
					<div class="modal-dialog">
						<!-- Modal content-->
						<div class="modal-content" style="width:60%;">
							<div class="modal-header" style="padding-top: 9px; padding-bottom: 3px; background-color: #f0f2f5; color: #555555;">
								<a type="button" class="close" data-dismiss="modal">&times;</a>
								<p class="modal-title">Disc.</p>
							</div>
							<div class="modal-body">
								<input type="text" name="modaldisc" id="modaldisc" style="padding-right: 24px; height: 36px !important; line-height:24px;
								color: #000;">
								<input type="hidden" name="disc_hidden_id" id="disc_hidden_id">
								<input type="hidden" name="disc_modalprice" id="disc_modalprice">
								<input type="hidden" name="disc_modalqty" id="disc_modalqty">
								<?php
								button_cell('UpdateItem2', _("Update"),_('Confirm changes'), ICON_UPDATE, '',"modal");
								button_cell('CancelItemChanges', _("Cancel"),_('Cancel changes'), ICON_CANCEL, '',"modal");
								?>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div style="height: 280px;overflow-y: auto; border: 2px solid #e8ebf1;border-radius: 7px;">
				<table id="register" class="table table-hover" style="width: 100% !important;">
					<thead>
						<tr class="register-items-header" style="position: sticky;top: -4px;border-top: 5px solid #f9fbfc;">
							<th></th>
							<th class="item_name_heading" >Item Name</th>
							<th class="sales_price">Price</th>
							<th class="sales_quantity">Qty</th>
							<th class="sales_discount">Disc</th>
							<th>Total</th>
						</tr>
					</thead>
					<tbody class="register-item-content">
						<?php 
						if(count($order->line_items) == 0){ ?>
							<tr class="cart_content_area">
								<td colspan='6'>
									<div class='text-center text-warning' > <h3>There are no items in the cart<span class="flatGreenc"> [Sales]</span></h3></div>
								</td>
							</tr>
						<?php 
						}
						else{
							$total_discount_display = 0;
							foreach($order->get_items() as $line_no=>$stock_item){
								$line_total = round(($stock_item->qty_dispatched * $stock_item->price )-$stock_item->discount_percent,user_price_dec());
								$total_discount_display += $stock_item->discount_percent;
						?>
								<tr class="register-item-details">
									<?php remove_button_cell("delete$line_no", ("delete"), ('Delete')); ?>
									<td class="text-center">
										<a id="<?php echo '../inventory/inquiry/stock_status.php?stock_id='.$stock_item->stock_id.
										'&popup=1' ?>" href="javascript:void(0)" onclick="open_pop_box(this.id)"><?php echo $stock_item->stock_id."  ".
										$stock_item->item_description; ?></a>
									</td>
									<td class="text-center">
										<?php 
										if($_SESSION['wa_current_user']->access==22)
											echo $stock_item->price;
										else{
										?>
										<a onclick="get_price(<?php echo $line_no; ?>,<?php echo $stock_item->price; ?>,<?php echo $stock_item->quantity; ?>,
										<?php echo $stock_item->discount_percent; ?>)" href="#" id="price_<?php echo $line_no; ?>" 
										class="xeditable xeditable-price " data-validate-number="true" data-type="text" 
										data-value="<?php echo $stock_item->price; ?>" data-pk="1" data-name="price" data-title="Price">
										<?php echo $stock_item->price; ?></a>
										<?php } ?>
									</td>
									<td class="text-center">
										<a onclick="get_qty(<?php echo $line_no; ?>,<?php echo $stock_item->price; ?>,<?php echo $stock_item->quantity; ?>,
										<?php echo $stock_item->discount_percent; ?>)" href="#"><?php echo $stock_item->quantity; ?></a>
									</td>
									<td class="text-center">
										<a onclick="get_disc(<?php echo $line_no; ?>,<?php echo $stock_item->price; ?>,<?php echo $stock_item->quantity;?>,
										<?php echo $stock_item->discount_percent; ?>)" href="#"><?php echo $stock_item->discount_percent; ?></a>
									</td>
									<td class="text-center">
										<?php echo $line_total; ?>
									</td>
								</tr>
							<?php
								$total += $line_total;
							}
						}
						?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
	<?php
	div_end();
	?>

	<div class="register">
		<div class="register-box register-right" style="">
			<?php
			div_start('cancel_div');
			?>
				<div class="sale-buttons">
					<?php 
					if(count($order->line_items) != 0){ ?>
						<button type="submit" name="cancel_sale_button" class="btn btn-cancel"  id="cancel_sale_button" >
							<i class="ion-close-circled"></i>Cancel Sale
						</button>
					<?php  
				 	}
					?>
					<div class="input-group contacts" style="display: inline-flex;">
						<?php
        				echo "&nbsp&nbsp&nbsp&nbsp&nbsp";
                	br();
               	sale_draft_order_cells(null,'draft_order_list', $_POST['draft_order_list'], true);
				   ?> 
			   	</div>
				</div>
			<?php
			div_end();
			
			$cash_customer_id = get_cash_customer_data()['debtor_no'];
			
			hidden('customer_id',$cash_customer_id); 
			?>
			<div class="customer-form" id='customer-form'>
				<?php 
				customer_branches_list_row(_(""), $cash_customer_id, 'branch_id', null, false, true, true, true);
				br();
				?>

				<div class="input-group contacts">
					<span class="input-group-addon" style="width: 15% !important;"> <i class='ion-person-add'></i>
					</span>
					<span role="status" aria-live="polite" class="ui-helper-hidden-accessible"></span>	
					<input style="height: 35;" type="text" id="customer" name="customer_" class="add-customer-input" value="<?php echo $_POST['customer_']; ?>" placeholder="    Type a customer name">
				</div>
					
				<br>

				<div class="input-group contacts" style="display: inline-flex;">
					<span class="input-group-addon" style="height: 35 !important;width: 21% !important;"> <i class='fa fa-mobile'></i></span>
					<?php $country_code = get_country_phone_code(get_company_pref('country')); ?>
					<input type="hidden" id="country_code" name="country_code" value="<?php echo $country_code; ?>">
					<label class="add-customer-input" style="height: 35; width: 20%; padding-top: 0.6rem; border-radius: 0px;" >
						<?php echo "+".$country_code; ?>
					</label>
					<?php ref_cells(null, 'customer_phone_', null, null, null, true,null,null,'',"Style = 'height:35 !important;'"); ?>
				</div>
				
				<style>
					#_branch_sel{
						width: 100%
					}
					#_branch_sel > div >input{
						height: 35 !important;
					}
					#_payment_sel{
						width: 100%
					}
					#_payment_sel > div >input{
						height: 35 !important;
					}
				</style>
				<?php hidden('branch',2); ?>

				<br>
				<br>
				
				<div class="input-group contacts" style="display: inline-flex;">
					<span class="input-group-addon" style="height: 35 !important;width: 17% !important;"> 
						<i class='glyphicon glyphicon-usd'></i>
					</span>
					<?php sale_payment_list_cells(null, 'payment', PM_CASH, null); ?>
				</div>

				<br>
				<br>

				<div class="input-group contacts" style="display: inline-flex;">
					<?php
					if ($_POST['customer_phone_'] != null) {
					$phone_number = $_POST['country_code'].$_POST['customer_phone_'];
					}

					if($_POST['customer_phone_'] != null )//|| $_POST['customer_email_'] != null
						$Ajax->activate('point_div');
					else
						$Ajax->activate('point_div');
				
					div_start('point_div');

						if($SysPrefs->prefs['customer_loyality_check']==1 && $_POST['customer_id']!=null && get_loyality_points($_POST['customer_id'],
						10, null, $_POST['customer_phone_'], $_POST['customer_email_'], $_POST['country_code']) != 0){
						
							echo '<div class="input-group contacts" >';
								
								label_cells("Points:", "<a href='javascript:void(0);' onclick='open_loyality(".$_POST['customer_id'].",\"".
								$_POST['customer_phone_']."\",\"".$_POST['customer_email_']."\",\"".$_POST['country_code']."\")' >".
								price_format2(get_loyality_points($_POST['customer_id'], 10,null,$_POST['customer_phone_'],$_POST['customer_email_'],
								$_POST['country_code']))."</a>"."     &nbsp;&nbsp;        ".checkbox(null, "points_check", null, true));
							echo '</div>';
						} 
					div_end();
				?>
				</div>
			</div>
		</div>
		
		<?php 
		div_start('total_price_div'); 
		?>
		
			<div class="register-box register-summary paper-cut" style="">
				<ul class="list-group">
					<li class="list-group-item global-discount-group"></li>
					<?php
					$total_taxes =0;
					$taxes = $order->get_taxes(null);
					foreach ($taxes as $taxitem){
						$amount = isset($taxitem['Override']) ? $taxitem['Override'] : $taxitem['Value'];
						
						if($taxitem['Value'] != 0){
							if($editable){
								$taxitem['Value'] = 0;
							}
							else{
								if($order->tax_included)
									$value = number_format2($taxitem['Value'],user_price_dec());
								else{
									$value = number_format2($taxitem['Value'],user_price_dec());
									$total_taxes += $value;
								}
							}
						}
					}
					?>

					<li class="sub-total list-group-item">
						<span class="key">Sub Total:</span>
						<span class="value" style="font-size: 18px;"><?php echo price_format($total+$total_taxes+ $total_discount_display); ?></span>
					</li>
					
					<?php $taxes = $order->get_taxes(null); ?>
					
					<li class="list-group-item">
						<?php
						foreach ($taxes as $taxitem){
							if($taxitem['Value'] != 0){
								if($editable) {
									$taxitem['Value'] = 0;
								}
								else{
									$value = number_format2($taxitem['Value'],user_price_dec());
									if ($order->tax_included){
						?>
										<span class="key">
											<?php echo "Included".$taxitem['tax_type_name'];  ?>
										</span>
										<span class="value pull-right">
											<?php echo $value; ?>
										</span>
							<?php
									}
									else{
							?>
										<span class="key">
											<?php echo $taxitem['tax_type_name'];  ?>
										</span>
										<span class="value pull-right"><?php echo $value; ?></span>
							<?php
									}
								}
							}
						}
						?>
					</li>
					<li class="list-group-item">
						<span class="key">Total Discount:</span>
						<span class="value pull-right"><?php echo number_format2($total_discount_display,2);  ?> </span>
					</li>
				</ul>
				<div class="amount-block">
					<div class="total amount">
						<div class="side-heading"> Total </div>
						<div class="amount total-amount" data-speed="1000" data-currency="PKR" data-decimals="2">
							<?php echo price_format($total+$total_taxes); ?>
							<input type="text" name="total_pr" id='total_pr' hidden value="<?php echo price_format($total+$total_taxes); ?>">
						</div>
					</div>
					<div class="total amount-due">
						<div class="side-heading"> Balance </div>
						<div class="amount">
						   <p id='hide_me'> <?php echo price_format($total+$total_taxes); ?></p>
							<p id="calc_price"></p>
						</div>
					</div>
				</div>
			
				<?php 
				if(count($order->line_items) != 0){
					
					echo '<br>';
					global $Ajax;
					
					if(isset($_POST['points_check']) && !isset($_POST['add_points_counter']) && !isset($_POST['add_otp_code'])){
						$Ajax->activate('total_price_div');
					
						echo '&nbsp <input readonly class="amount form-control" type="text" name="points_counter" size="15" maxlength="15" 
						dec="4" value="'. price_format(get_loyality_points($_POST['customer_id'], 10,null,$_POST['customer_phone_'], 
						$_POST['customer_email_'],$_POST['country_code'])).'" style=" float: left; width:50%; height: 33px !important;"> &nbsp';
						submit('add_points_counter', 'Add Points', true, '', true, false, null, 0, '', '', 0, 0, "", '33px;');
						echo '<br><br>';
					}
					else{
						$Ajax->activate('total_price_div');
					}
				
					if(isset($_POST['points_check']) &&  isset($_POST['add_points_counter'])){
						
						$Ajax->activate('total_price_div');
						$otp_code = get_otp_code($_POST['customer_id'],$_POST['country_code'],$_POST['customer_phone_']);
					 	if ($otp_code && $phone_number && get_company_pref('is_sms') == 1){
					 		$contact = $phone_number;
        					$contact = str_replace(array('(',')','_','-',' '), '', $contact);
        					$msg = "Your OTP code is \n$otp_code \n.";
        					send_sms($contact,$msg);
					 	}
					 	else{
					 		echo $otp_code.'<br/>';
					 	}

						echo '<input id="OTP_Code" class="  form-control" type="text" name="OTP_Code" size="30" maxlength="30" 
						style="float: left; width:50%; height: 33px !important;"> &nbsp &nbsp';
						submit('add_otp_code', 'Submit OTP Code', true, '', true, false, null, 0, '', '', 0, 0, "", '33px;');
						echo '<br><br>';
					}
					else{
						$Ajax->activate('total_price_div');
					}

					$points_amount_ = 0;
					
					if(isset($_POST['points_check']) && isset($_POST['add_otp_code']) && 
					$_POST['OTP_Code'] == get_otp_code($_POST['customer_id'],$_POST['country_code'],$_POST['customer_phone_'])){

						delete_otp_code($_POST['customer_id'],$_POST['country_code'],$_POST['customer_phone_']);
						$points_ = get_loyality_points($_POST['customer_id'], 10, null, $_POST['customer_phone_'], $_POST['customer_email_'], 
						$_POST['country_code']);
						$points_amount_ = $points_ * $SysPrefs->prefs['loyality_points_value'];
						$Ajax->activate('total_price_div');
					}

					if(isset($_POST['add_otp_code'])){
						
						start_table(TABLESTYLE2);	
						label_row("Total Amount of Points",price_format2($points_amount_)." ".$SysPrefs->prefs['curr_default']);
						$val_ = $points_amount_ - ($total+$total_taxes);
						label_row("Total Amount of Points Remaining", ($val_ <= 0) ? price_format(0)." ".$SysPrefs->prefs['curr_default'] :
						price_format2($val_)." ".$SysPrefs->prefs['curr_default']);

						if($points_amount_ < ($total+$total_taxes)){
							hidden('points_counter_hidden', $points_amount_/$SysPrefs->prefs['loyality_points_value']);
							hidden('ov_discount', $points_amount_);// to check the formula for ov_disount 
						}
						else{
							hidden('points_counter_hidden', ($total+$total_taxes));
							hidden('ov_discount', ($total+$total_taxes));
						}
						end_table();
						br();
						$Ajax->activate('total_price_div');	
					}
					else{
						$Ajax->activate('total_price_div');
					}
					?>
					<div class="input-group add-payment-form">
						<input type="number" name="amount_recived" id="amount_recived" placeholder="Enter Received Amount"  class="add-input " 
						style="font-size: 20px;" oninput="flex_amount()">
					</div>
					<br>

					<div class="input-group add-payment-form">
						<?php
						if($points_amount_ < ($total+$total_taxes)){
							$amt = ($total+$total_taxes)-$points_amount_ ;
						}
						else{
							$amt = $points_amount_ - ($total+$total_taxes) ;
						}
						?>
						
						<input type="text" name="amount_tendered" hidden value="<?php echo ($amt < 0)? price_format(0) : price_format($amt) ?>" id="amount_tendered"  style="font-size: 20px;">

						<input type="text" name="" readonly="true" value="<?php echo ($amt < 0)? price_format(0) : price_format($amt) ?>" id="amount_tendered" class="add-input " style="font-size: 20px;">
					
						<span class="input-group-addon">
							<input style="background: transparent; border: none; color: white;" id="finish_sale_alternate_button" type="submit" name="process" value ="Complete Sale">
						</span>

						<span class="input-group-addon" style="background-color: #512fa0 !important">
							<input style="background: transparent; border: none; color: white;" id="finish_sale_alternate_button" type="submit" name="draft_sale" value ="Draft Sale">
						</span>
					</div>
				<?php } ?>
			</div>
		<?php div_end(); ?>
	</div>
	</div>
	</div>

	<script type="text/javascript">
		function formate_trim(x) {
			return x.replace(',', '');;
		}

		function flex_amount(){
			document.getElementById('hide_me').style.display = 'none';
			$.total_pr = formate_trim(total_pr.value);
			$.calc_price =  amount_recived.value;
			$.ret = $.total_pr - $.calc_price;
			if($.ret < 0) 
				document.getElementById('calc_price').style.color = 'red';
			else
				document.getElementById('calc_price').style.color = '#ff9e28';

			if(amount_recived.value=='')
				document.getElementById('calc_price').innerHTML=total_pr.value;
			else	
				document.getElementById('calc_price').innerHTML= $.ret.toFixed(2);	
		}
	
		function open_pop_box(id){
			window.open(id, "child","toolbar=no, scrollbars=no, resizable=yes, top=130, left=120, width=800, height=500, location=no, title=no");
		}

		function get_price(id,price,qty,disc){
			$('#modalprice').val(price);
			$('#price_modalqty').val(qty);
			$('#price_modaldisc').val(disc);
			$('#price_hidden_id').val(id); 
			$('#price_modal').modal('toggle');
		}

		function get_qty(id,price,qty,disc){
			$('#qty_modalprice').val(price);
			$('#modalqty').val(qty);
			$('#qty_modaldisc').val(disc);
			$('#qty_hidden_id').val(id); 
			$('#qty_modal').modal('toggle');	
		}

		function get_disc(id,price,qty,disc){
			$('#disc_modalprice').val(price);
			$('#disc_modalqty').val(qty);
			$('#modaldisc').val(disc);
			$('#disc_hidden_id').val(id); 
			$('#disc_modal').modal('toggle');
		}
	</script>
	<?php
}


function processing_start()
{
	page_processing(false);
    processing_end();
    $_SESSION['Processing'] = $_SERVER['PHP_SELF'];
}

function processing_end()
{
	page_processing(true);
    unset($_SESSION['Processing']);
    if ( isset($_SESSION['Items']) ) {
		unset($_SESSION['Items']->line_items);
		unset($_SESSION['Items']);
    }
}


function get_cat($cata_desc=null){
	$sql=" SELECT category_id, description FROM ".TB_PREF."stock_category WHERE dflt_mb_flag != 'F' AND inactive = '0' '0' AND dflt_no_sale=0 ";
	if($cata_desc != null)
		$sql .= " AND description LIKE '%$cata_desc%' ";
	// display_error($sql);
	$db = db_query($sql,'error');
	return $db;
}

function get_cat_for_box($id,$id2=0,$search_item=null){
	
	/*$sql = "SELECT s.stock_id, i.item_code, i.description, c.description, count(*)>1 as kit,
	 		i.inactive, if(count(*)>1, '0', s.editable) as editable FROM ".TB_PREF."stock_master s,
	 		".TB_PREF."item_codes i LEFT JOIN ".TB_PREF."stock_category c ON i.category_id=c.category_id
	 		WHERE i.stock_id=s.stock_id AND c.category_id='$id' 
	 		GROUP BY i.item_code ORDER BY i.id";*/

	if($id != 0){
		$sql = " SELECT stock_id, s.description, c.category_id, c.description, s.inactive, s.editable FROM ".TB_PREF."stock_master s,".TB_PREF."stock_category c 
			WHERE s.category_id=c.category_id AND mb_flag!='F' AND c.category_id = '$id' ";
		
		if($search_item != null)
			$sql .= " AND stock_id = '$search_item' ";

	}else{
		$sql = " SELECT i.item_code, IF(1='2',IF(s.description_arabic = '',s.description,s.description_arabic),s.description ) as description, c.description, count(*)>1 as kit, i.inactive, if(count(*)>1, '0', s.editable) as editable FROM ".TB_PREF."stock_master s, ".TB_PREF."item_codes i LEFT JOIN ".TB_PREF."stock_category c ON i.category_id=c.category_id WHERE i.stock_id=s.stock_id AND mb_flag != 'F' AND !i.is_foreign AND i.item_code!=i.stock_id AND !i.inactive AND !s.inactive AND !s.no_sale GROUP BY i.item_code ";

	
	}

		// display_error($sql);

	$db  = db_query($sql,'error');
	return $db;
}
function get_item_names($id,$cat,$stid){
			$sql = "SELECT description FROM ".TB_PREF."stock_master where stock_id=" . db_escape($id) . " ";
			$db = db_query($sql, 'error');
			$ft = db_fetch($db);
			return $ft[0];
}


?>
<style type="text/css">

ul.tab {
    list-style-type: none;
    margin: 0;
    padding: 0;
    overflow: hidden;
    border: 1px solid #ccc;
    background-color: #f1f1f1;
}


/*ul.tab li {float: left;}*/


ul.tab a li  {
    /*display: inline-block;*/
    color: black;
    /*text-align: center;*/
    padding: 10px 10px;
    text-decoration: none;
    transition: 0.3s;
    font-size: 17px;
}


ul.tab li:hover {background-color: #ddd;}

ul.tab a:focus li {background-color: #ffff;}


.tabcontent {
    display: none;
    padding: 3px 6px;
    /*border: 1px solid #ccc;*/
    border-top: none;
}

/**{
  border: 1px solid red !important;

}
.row{
	  border: 2px solid green !important;
}*/
</style>



<script>
function openCity(evt, cityName) {
	var i, tabcontent, tablinks;
	tabcontent = document.getElementsByClassName("tabcontent");
	for (i = 0; i < tabcontent.length; i++) {
		tabcontent[i].style.display = "none";
	}
	tablinks = document.getElementsByClassName("tablinks");
   for (i = 0; i < tablinks.length; i++) {
      tablinks[i].className = tablinks[i].className.replace(" active", "");
   }
   document.getElementById('cata_item').style.display = "block";
	if(cityName!=0)
    	document.getElementById(cityName).style.display = "block";
	if(evt != 'undefined'){
    	evt.currentTarget.className += " active";
   }
}

function set_id(a){
	var b = a.id;
	document.getElementById("_stock_id_edit").value = b;
}

function set_qty(b){
	var id = b.id;
	var c = document.getElementById(id).value ;
	document.getElementById("qty_item").value = c;
				
}
function open_loyality(customer_id,cust_phone,cust_email,country_code){
			window.open("inquiry/loyality_dashboard.php?customer_id="+customer_id+"&phone="+cust_phone+"&email="+cust_email+"&country_code="+country_code, "child", "toolbar=no,scrollbars=no,resizable=yes,top=70,left=10,width=1000,height=590,location=no, title=no");
		}
</script>