<?php

include_once($path_to_root . "/includes/banking.inc");
include_once($path_to_root . "/includes/inventory.inc");
include_once($path_to_root . "/includes/db/allocations_db.inc");
include_once($path_to_root . "/sales/includes/db/sales_order_db.inc");
include_once($path_to_root . "/sales/includes/db/sales_credit_db.inc");
include_once($path_to_root . "/sales/includes/db/sales_invoice_db.inc");
include_once($path_to_root . "/sales/includes/db/sales_delivery_db.inc");
include_once($path_to_root . "/sales/includes/db/sales_types_db.inc");
include_once($path_to_root . "/sales/includes/db/sales_points_db.inc");
include_once($path_to_root . "/sales/includes/db/sales_groups_db.inc");
include_once($path_to_root . "/sales/includes/db/recurrent_invoices_db.inc");
include_once($path_to_root . "/sales/includes/db/custalloc_db.inc");
include_once($path_to_root . "/sales/includes/db/cust_trans_db.inc");
include_once($path_to_root . "/sales/includes/db/cust_trans_details_db.inc");
include_once($path_to_root . "/sales/includes/db/payment_db.inc");
include_once($path_to_root . "/sales/includes/db/branches_db.inc");
include_once($path_to_root . "/sales/includes/db/schedules_db.inc");
include_once($path_to_root . "/sales/includes/db/customers_db.inc");
include_once($path_to_root . "/payroll/includes/db/payroll_trans_db.inc");


//----------------------------------------------------------------------------------------
// add a debtor-related gl transaction
// $date_ is display date (non-sql)
// $amount is in CUSTOMER'S currency


//pk----------------------------------------------------------------------------------------
function get_refund($trans_no){
	$sql = " SELECT trans_no, tran_date, reference, alloc FROM ".TB_PREF."debtor_trans WHERE trans_no = '$trans_no' AND type = 11 ";
	// display_error($sql);
	return db_query($sql," ");

}
//----------------------------------------------------------------------------------------
function add_gl_trans_customer($type, $type_no, $date_, $account, $dimension, $dimension2,
	$amount, $customer_id, $err_msg="", $rate=0)
{
	if ($err_msg == "")
		$err_msg = "The customer GL transaction could not be inserted";

	return add_gl_trans($type, $type_no, $date_, $account, $dimension, $dimension2, "", $amount,
		get_customer_currency($customer_id),
		PT_CUSTOMER, $customer_id, $err_msg, $rate);
}

//----------------------------------------------------------------------------------------

function get_calculated_price($stock_id, $add_pct)
{
	$avg = get_unit_cost($stock_id);
	if ($avg == 0)
		return 0;
	return round2($avg * (1 + $add_pct / 100), user_price_dec());
}

function round_to_nearest($price, $round_to)
{
	if ($price == 0)
		return 0;
	$pow = pow(10, user_price_dec());
	if ($pow >= $round_to)
		$mod = ($pow % $round_to);
	else
		$mod = ($round_to % $pow);
	if ($mod != 0)
		$price = ceil($price) - ($pow - $round_to) / $pow;
	else	
    	$price = ceil($price * ($pow / $round_to)) / ($pow / $round_to);
    return $price;

}

function get_price ($stock_id, $currency, $sales_type_id, $factor=null, $date=null)
{
	if ($date == null)
	    $date = new_doc_date();

	if ($factor === null) 
	{
		$myrow = get_sales_type($sales_type_id);
		$factor = $myrow['factor'];
	}

	$add_pct = get_company_pref('add_pct');
	$base_id = get_base_sales_type();
    $home_curr = get_company_currency();
	//	AND (sales_type_id = $sales_type_id	OR sales_type_id = $base_id)
	$sql = "SELECT price, curr_abrev, sales_type_id
		FROM ".TB_PREF."prices
		WHERE stock_id = ".db_escape($stock_id)."
			AND (curr_abrev = ".db_escape($currency)." OR curr_abrev = ".db_escape($home_curr).")";

	$result = db_query($sql, "There was a problem retrieving the pricing information for the part $stock_id for customer");
	$num_rows = db_num_rows($result);
	$rate = round2(get_exchange_rate_from_home_currency($currency, $date),
	    user_exrate_dec());
	$round_to = get_company_pref('round_to');
	$prices = array();
	while($myrow = db_fetch($result)) 
	{
	    $prices[$myrow['sales_type_id']][$myrow['curr_abrev']] = $myrow['price'];
	}
	$price = false;
	if (isset($prices[$sales_type_id][$currency])) 
	{
	    $price = $prices[$sales_type_id][$currency];
	}
	elseif (isset($prices[$base_id][$currency])) 
	{
	    $price = $prices[$base_id][$currency] * $factor;
	}
	elseif (isset($prices[$sales_type_id][$home_curr])) 
	{
	    $price = $prices[$sales_type_id][$home_curr] / $rate;
	}
	elseif (isset($prices[$base_id][$home_curr])) 
	{
	    $price = $prices[$base_id][$home_curr] * $factor / $rate;
	}
	elseif ($num_rows == 0 && $add_pct != -1)
	{
		$price = get_calculated_price($stock_id, $add_pct);
		if ($currency != $home_curr)
			$price /= $rate;
		if ($factor != 0)
			$price *= $factor;
	}	
	if ($price === false)
		return 0;
	elseif ($round_to != 1)	
		return round_to_nearest($price, $round_to);
	else
		return round2($price, user_price_dec());
}
//----------------------------------------------------------------------------------------
//
//	Get price for given item or kit.
//  When $std==true price is calculated as a sum of all included stock items,
//	otherwise all prices set for kits and items are accepted.
//
function get_kit_price($item_code, $currency, $sales_type_id, $factor=null, 
	$date=null, $std = false)
{
	$kit_price = 0.00;
	if (!$std) {
		$kit_price = get_price( $item_code, $currency, $sales_type_id, 
			$factor, $date);

		if ($kit_price !== 0) {
			return $kit_price;
		}
	}	
	// no price for kit found, get total value of all items
	$kit = get_item_kit($item_code);
	
	while($item = db_fetch($kit)) {
		if ($item['item_code'] != $item['stock_id']) {
			// foreign/kit code
			$kit_price += $item['quantity'] * get_kit_price( $item['stock_id'], 
				$currency, $sales_type_id, $factor, $date, $std);

		} else {
			// stock item
			$kit_price += $item['quantity'] * get_price( $item['stock_id'], 
				$currency, $sales_type_id, $factor, $date);
		}
	}
	return $kit_price;
}

//--------------------------------------------------------------------------------------------------
function update_parent_line($doc_type, $line_id, $qty_dispatched, $auto=false)
{
	$doc_type = get_parent_type($doc_type);

        $qty_dispatched = (float)$qty_dispatched;

	if ($doc_type == 0)
		return false;
	else {
		if ($doc_type==ST_SALESORDER || $doc_type==ST_SALESQUOTE)
		{
			$sql = "UPDATE ".TB_PREF."sales_order_details
				SET qty_sent = qty_sent + $qty_dispatched";
			if ($auto)
				$sql .= ", quantity = quantity + $qty_dispatched";
			$sql .= " WHERE id=".db_escape($line_id);
		}
		else
			$sql = "UPDATE ".TB_PREF."debtor_trans_details
				SET qty_done = qty_done + $qty_dispatched
				WHERE id=".db_escape($line_id);
	}
	db_query($sql, "The parent document detail record could not be updated");
	return true;
}

//--------------------------------------------------------------------------------------------------
// find inventory location for given transaction
//
function get_location(&$cart)
{
	$sql = "SELECT location.*
		FROM ".TB_PREF."stock_moves move,"
			.TB_PREF."locations location".
		" WHERE type=".db_escape($cart->trans_type).
		" AND trans_no=".key($cart->trans_no).
		" AND qty!=0 ".
		" AND location.loc_code=move.loc_code";

	$result = db_query($sql, 'Retreiving inventory location');

	if (db_num_rows($result)) {
		return db_fetch($result);
	}
	return null;
}
//--------------------------------------------------------------------------------------------------
// Generic read debtor transaction into cart
//
//	$trans_no - array of trans nums; special case trans_no==0 - new doc
//
function read_sales_trans($doc_type, $trans_no, &$cart)
{
	if (!is_array($trans_no) && $trans_no)
		$trans_no = array($trans_no);

	$cart->trans_type = $doc_type;
	if (!$trans_no) { // new document
		$cart->trans_no = $trans_no;
	} else {
		// read header data from first document
		$myrow = get_customer_trans($trans_no[0],$doc_type);
		if (count($trans_no)>1)
			$cart->trans_no = get_customer_trans_version($doc_type, $trans_no);
		else
			$cart->trans_no = array($trans_no[0]=>$myrow["version"]);

		$cart->set_sales_type($myrow["tpe"], $myrow["sales_type"], $myrow["tax_included"],0);

		$cart->set_customer($myrow["debtor_no"], $myrow["DebtorName"],
			$myrow["curr_code"], $myrow["discount"], $myrow["payment_terms"]);

		$cart->set_branch($myrow["branch_code"], $myrow["tax_group_id"],
			$myrow["tax_group_name"]);

		$cart->reference = $myrow["reference"];
		$cart->prepaid = $myrow["prepaid"];
		$cart->order_no = $myrow["order_"];
		$cart->master_order = $myrow["master_order"];
		$cart->schedule_id = $myrow["schedule_id"];
		$cart->due_date = sql2date($myrow["due_date"]);
		$cart->document_date = sql2date($myrow["tran_date"]);
		$cart->dimension_id = $myrow['dimension_id']; // added 2.1 Joe Hunt 2008-11-12
		$cart->dimension2_id = $myrow['dimension2_id'];
		$cart->Comments = '';
		foreach ( $trans_no as $trans ) {
			$cart->Comments .= get_comments_string($doc_type,$trans);
		}

		// FIX this should be calculated sum() for multiply parents

		$cart->set_delivery($myrow["ship_via"], $myrow["br_name"],
		$myrow["br_address"], $myrow["ov_freight"]);

		$location = 0;
		$myrow = get_location($cart); // find location from movement

		if($myrow!=null) {
			$cart->set_location($myrow['loc_code'], $myrow['location_name']);
		}

		$result = get_customer_trans_details($doc_type,$trans_no);
		if (db_num_rows($result) > 0) {
			for($line_no=0; $myrow = db_fetch($result); $line_no++)	{
				$cart->line_items[$line_no] = new line_details(
					$myrow["stock_id"],$myrow["quantity"],
					$myrow["unit_price"], ($myrow["discount_percent"]/$myrow["quantity"]),
					$myrow["qty_done"], $myrow["standard_cost"],
					$myrow["StockDescription"],$myrow["id"], $myrow["debtor_trans_no"],
					@$myrow["src_id"],null,null,null,null,null,$myrow["sale_kit_id"], 0, null, explode(",", $myrow['item_specs']), $myrow['spec_description'], $myrow["line_ref"], $myrow["line_date"]);
			}
		}
//  this $cart->customer_id replace to	$myrow["debtor_no"]

		$cart->prepayments = get_payments_for($trans_no, $doc_type, $cart->customer_id);

	} // !newdoc

	return true;
}
//----------------------------------------------------------------------------------------

function get_sales_child_lines($trans_type, $trans_no, $lines=true)
{
	if (!($ctype = get_child_type($trans_type)))
		return false;
	if (!is_array($trans_no)) {
		$trans_no = array($trans_no);
	}

	$par_tbl = $trans_type == ST_SALESORDER ? "sales_order_details" : "debtor_trans_details";
	$par_no = $trans_type == ST_SALESORDER ? "trans.order_no" : "trans.debtor_trans_no";

	foreach($trans_no as $n => $trans) {
		$trans_no[$n] = db_escape($trans);
	}
	$sql = "SELECT child.*
			FROM
				".TB_PREF."debtor_trans_details child
			LEFT JOIN ".TB_PREF."$par_tbl trans 
				ON child.src_id=trans.id AND child.debtor_trans_type=$ctype
			WHERE $par_no IN(". implode(',', array_values($trans_no)).")";

	if (!$lines)
		$sql .= " GROUP BY child.debtor_trans_no";

	$sql .= " ORDER BY child.debtor_trans_no";
	

	return db_query($sql, "can't retrieve child trans");
}

function get_sales_child_numbers($trans_type, $trans_no)
{
	$trans = array();
	$res = get_sales_child_lines($trans_type, $trans_no, false);
	while ($line = db_fetch($res)) {
		$trans[] = $line['debtor_trans_no'];
	}
	return $trans;
}

function get_sales_parent_lines($trans_type, $trans_no, $lines=true)
{
	$partype = get_parent_type($trans_type);

	if (!$partype)
		return false;

	$par_tbl = $partype == ST_SALESORDER ? "sales_order_details" : "debtor_trans_details";
	$par_no = $partype == ST_SALESORDER ? "parent.order_no" : "parent.debtor_trans_no";
	$sql = "SELECT parent.*
			FROM
				".TB_PREF."$par_tbl parent
			LEFT JOIN ".TB_PREF."debtor_trans_details trans 
				ON trans.src_id=parent.id
			WHERE
				trans.debtor_trans_type=".db_escape($trans_type)
				." AND trans.debtor_trans_no=".db_escape($trans_no);
	if (!$lines)
		$sql .= " GROUP BY $par_no";
	
	$sql .= " ORDER BY $par_no";
	
	return db_query($sql, "can't retrieve child trans");

}

function get_sales_parent_numbers($trans_type, $trans_no)
{
	$trans = array();
	$res = get_sales_parent_lines($trans_type, $trans_no, false);
	while ($line = db_fetch($res))
		$trans[] = $line[$trans_type==ST_CUSTDELIVERY ? 'order_no' : 'debtor_trans_no'];
	return $trans;
}

//----------------------------------------------------------------------------------------

function get_sales_child_documents($trans_type, $trans_no)
{
	// FIXME -  credit notes retrieved here should be those linked to invoices containing 
	// at least one line from related invoice

	if (!count($trans_no))
		return false;
	$childs = get_sales_child_numbers($trans_type, $trans_no, false);
	if (!count($childs))
		return false;
		
	$sql = "SELECT * FROM ".TB_PREF."debtor_trans
		WHERE type=".get_child_type($trans_type)." AND trans_no IN(". implode(',', array_values($childs)).")";

	return db_query($sql,"The related credit notes could not be retreived");
}

function get_debtor_name_arabic($id){

$sql = "SELECT CustName_arabic FROM ".TB_PREF."debtors_master WHERE debtor_no = ".db_escape($id);
$result = db_query($sql, "no customer found in query");
$myrow = db_fetch($result);
// display_error($sql);
return $myrow[0];

}

function check_bar_code($bar_code, $foreign=1)
{
	$sql="SELECT i.*, c.description as cat_name FROM "
		.TB_PREF."item_codes as i,"
		.TB_PREF."stock_category as c
		WHERE item_code=".db_escape($bar_code)."
		AND i.category_id=c.category_id
		AND i.is_foreign=".db_escape($foreign);

	$result = db_query($sql,"all item codes could not be retrieved");

	return $result;
}

function get_customer_trans_invoice($trans_id, $trans_type)
{
	$sql = "SELECT trans.*,"
		."ov_amount+ov_gst+ov_freight+ov_freight_tax+ov_discount AS Total,"
		."cust.name AS DebtorName, cust.address, "
		."cust.curr_code, "
		."cust.tax_id ";

	if ($trans_type == ST_CUSTPAYMENT) {
		// it's a payment so also get the bank account
		// Chaitanya : Added bank_act to support Customer Payment Edit
		$sql .= ",bank_act,".TB_PREF."bank_accounts.bank_name, ".TB_PREF."bank_accounts.bank_account_name,
			".TB_PREF."bank_accounts.account_type AS BankTransType ";
	}

	if ($trans_type == ST_SALESINVOICE || $trans_type == ST_CUSTCREDIT || $trans_type == ST_CUSTDELIVERY) {
		// it's an invoice so also get the shipper and salestype
		$sql .= ", ".TB_PREF."shippers.shipper_name, "
			.TB_PREF."sales_types.sales_type, "
			.TB_PREF."sales_types.tax_included, "
			."branch.*, "
			."cust.discount, "
			.TB_PREF."tax_groups.name AS tax_group_name, "
			.TB_PREF."tax_groups.id AS tax_group_id ";
	}

	$sql .= " FROM ".TB_PREF."debtor_trans trans LEFT JOIN ".TB_PREF."comments com ON trans.type=com.type AND trans.trans_no=com.id
					LEFT JOIN ".TB_PREF."shippers ON ".TB_PREF."shippers.shipper_id=trans.ship_via, 
					".TB_PREF."debtors_master cust";

	if ($trans_type == ST_CUSTPAYMENT) {
		// it's a payment so also get the bank account
		$sql .= ", ".TB_PREF."bank_trans, ".TB_PREF."bank_accounts";
	}

	if ($trans_type == ST_SALESINVOICE || $trans_type == ST_CUSTCREDIT || $trans_type == ST_CUSTDELIVERY) {
		// it's an invoice so also get the shipper, salestypes
		$sql .= ", ".TB_PREF."sales_types, "
			.TB_PREF."cust_branch branch, "
			.TB_PREF."tax_groups  ";
	}

	$sql .= " WHERE trans.trans_no=".db_escape($trans_id)."
		AND trans.type=".db_escape($trans_type)."
		AND trans.debtor_no=cust.debtor_no";

	if ($trans_type == ST_CUSTPAYMENT) {
		// it's a payment so also get the bank account
		$sql .= " AND ".TB_PREF."bank_trans.trans_no =".db_escape($trans_id)."
			AND ".TB_PREF."bank_trans.type=$trans_type
			AND ".TB_PREF."bank_trans.amount != 0
			AND ".TB_PREF."bank_accounts.id=".TB_PREF."bank_trans.bank_act LIMIT 1";
	}
	if ($trans_type == ST_SALESINVOICE || $trans_type == ST_CUSTCREDIT || $trans_type == ST_CUSTDELIVERY) {
		// it's an invoice so also get the shipper
		$sql .= " AND ".TB_PREF."sales_types.id = trans.tpe
			AND branch.branch_code = trans.branch_code
			AND branch.tax_group_id = ".TB_PREF."tax_groups.id  ";
	}
	// display_error($sql);
	$result = db_query($sql, "Cannot retreive a debtor transaction");

	if (db_num_rows($result) == 0) {
		// can't return nothing
		display_db_error("no debtor trans found for given params", $sql, true);
		exit;
	}

	if (db_num_rows($result) > 1) {
		// can't return multiple
		display_db_error("duplicate debtor transactions found for given params", $sql, true);
		exit;
	}

	$row = db_fetch($result);
	return $row;
}

////new jogar of zeeshan

function get_customer_trans_details_invoice($debtor_trans_type, $debtor_trans_no)
{
	if (!is_array($debtor_trans_no))
		$debtor_trans_no = array( 0=>$debtor_trans_no );

	$sql = "SELECT ".TB_PREF."debtor_trans_details.*,
		".TB_PREF."debtor_trans_details.unit_price+".TB_PREF."debtor_trans_details.unit_tax AS FullUnitPrice,
		".TB_PREF."debtor_trans_details.description As StockDescription,
		".TB_PREF."stock_master.units,  ".TB_PREF."stock_master.mb_flag
		FROM ".TB_PREF."debtor_trans_details, ".TB_PREF."stock_master
		WHERE (";

	$tr=array();
	foreach ($debtor_trans_no as $trans_no)
		$tr[] = 'debtor_trans_no='.db_escape($trans_no);

	$sql .= implode(' OR ', $tr);


	$sql.=	") AND debtor_trans_type=".db_escape($debtor_trans_type)."
		AND ".TB_PREF."stock_master.stock_id=".TB_PREF."debtor_trans_details.stock_id
		ORDER BY id";
	return db_query($sql, "The debtor transaction detail could not be queried");
}
function get_kit_detail_by_id($id){
	$sql = " SELECT * FROM " .TB_PREF."item_codes WHERE id=".db_escape($id);
	$result = db_query($sql, "where used query failed");
	return db_fetch($result);
}
function get_kit_price_by_id($trans_no, $trans_type, $kit_id){
	$item_code = get_kit_detail_by_id($kit_id)['item_code'];
	$kit = get_item_kit($item_code);
	while($new_row = db_fetch($kit)){
	    $array[] = $new_row['id'];
	}
    $array_ = implode(', ', $array);
    if($trans_type == 30 || $trans_type == 32){
        $sql = " SELECT quantity*unit_price as price FROM " .TB_PREF."sales_order_details WHERE order_no = '$trans_no' AND trans_type = '$trans_type' AND sale_kit_id IN (".$array_.") AND unit_price != 0";
    }else{
        $sql = " SELECT quantity*unit_price as price FROM " .TB_PREF."debtor_trans_details WHERE debtor_trans_no = '$trans_no' AND debtor_trans_type = '$trans_type' AND sale_kit_id IN (".$array_.") AND unit_price != 0";
    }
	
// 		display_error($sql);exit;
	$result = db_query($sql, "where used query failed");
	return db_fetch($result)['price'];

}
// function get_kit_data_by_id($trans_no, $trans_type, $kit_id){
// 	$item_code = get_kit_detail_by_id($kit_id)['item_code'];
// 	$kit = get_item_kit($item_code);
// 	while($new_row = db_fetch($kit)){
// 	    $array[] = $new_row['id'];
// 	}
//     $array_ = implode(', ', $array);
// 	$sql = " SELECT * FROM " .TB_PREF."debtor_trans_details WHERE debtor_trans_no = '$trans_no' AND debtor_trans_type = '$trans_type' AND sale_kit_id IN (".$array_.") AND unit_price != 0";
// 	$result = db_query($sql, "where used query failed");
// 	return db_fetch($result);

// }

function get_country_name($id){
	$sql = "SELECT name FROM ".TB_PREF."countries WHERE id = '$id'";
	$result = db_query($sql);
	return db_fetch($result)[0];
}

function get_country_phone_code($id){
	$sql = "SELECT phonecode FROM ".TB_PREF."countries WHERE id = '$id'";
	$result = db_query($sql);
	return db_fetch($result)[0];
}

function get_payment_of_invoice($type,$trans_no){
    $sql = "SELECT * FROM 0_cust_allocations WHERE trans_no_to = '$trans_no' AND trans_type_to = '$type' ";
    $run = db_query($sql);
    return $run;

}
function get_payment($trans_no){
    $sql = "SELECT * FROM `0_debtor_trans` WHERE type = 12 AND trans_no = '$trans_no'";
    $run = db_query($sql);
    return db_fetch($run);
}

function get_sql_for_client_dashboard($cust, $branch, $sales_type, $fromdate, $todate){

    $sql = "SELECT so.debtor_no, so.branch_code, 
    (SELECT contact_phone FROM ".TB_PREF."sales_orders WHERE debtor_no=so.debtor_no 
    AND branch_code=so.branch_code AND trans_type =30
    ORDER BY order_no DESC LIMIT 1) AS phone, 
    (SELECT contact_email FROM ".TB_PREF."sales_orders WHERE debtor_no=so.debtor_no 
    AND branch_code=so.branch_code AND trans_type =30 
    ORDER BY order_no DESC LIMIT 1) AS email, 
    COUNT(so.order_no) AS ord_count,
    MAX(so.ord_date) AS order_date, SUM(so.total) AS value
    FROM ".TB_PREF."sales_orders AS so";

    $sql .= " WHERE so.trans_type = 30";

    if($cust){
        $sql .= " AND so.debtor_no = ".db_escape($cust);
    }
    if($branch){
        $sql .= " AND so.branch_code = ".db_escape($branch);
    }
    if($sales_type){
        $sql .= " AND so.order_type = ".db_escape($sales_type);
    }
    
    $sql .= " GROUP BY so.debtor_no, so.branch_code";

    if($fromdate && $todate){
        $sql .= " HAVING order_date >=".db_escape(date2sql($fromdate))." 
        AND order_date <=".db_escape(date2sql($todate));
    }
    return $sql;
}

function get_sql_for_retention_dashboard($cust, $branch, $sales_type, $date=null, $amount=0, $stock_id=null, $days=0){

    $sql = "SELECT so.debtor_no, so.branch_code, 
    (SELECT contact_phone FROM ".TB_PREF."sales_orders WHERE debtor_no=so.debtor_no 
    AND branch_code=so.branch_code AND trans_type =30 ORDER BY order_no DESC LIMIT 1) 
    AS phone, 
    (SELECT contact_email FROM ".TB_PREF."sales_orders WHERE debtor_no=so.debtor_no 
    AND branch_code=so.branch_code AND trans_type =30 ORDER BY order_no DESC LIMIT 1) 
    AS email, 
    COUNT(so.order_no) AS ord_count,
    MAX(so.ord_date) AS order_date, SUM(so.total) AS value
    FROM ".TB_PREF."sales_orders AS so";


    if($stock_id){
    	$sql .= " LEFT JOIN ".TB_PREF."sales_order_details AS line
    	ON line.order_no = so.order_no AND line.trans_type=so.trans_type ";
    }

    $sql .= " WHERE so.trans_type = 30";

    if($cust){
        $sql .= " AND so.debtor_no = ".db_escape($cust);
    }
    if($branch){
        $sql .= " AND so.branch_code = ".db_escape($branch);
    }
    if($sales_type){
        $sql .= " AND so.order_type = ".db_escape($sales_type);
    }

    if($stock_id){
    	$sql .= " AND line.stk_code =".db_escape($stock_id);
    }

    $sql .= " GROUP BY so.debtor_no, so.branch_code";

    if($amount){
        $sql .= " HAVING value >=".db_escape($amount);
    }
    if($date){
        $sql .= " HAVING order_date <".db_escape(date2sql($date));
    }
    elseif($days){
    	$new_date = add_days(Today(), -$days);
    	$sql .= " HAVING order_date <".db_escape(date2sql($new_date));
    }
    return $sql;
}

function get_specs_for_ids($item_specs, $newline=false){
    
    $string = "";
    foreach($item_specs as $item_spec){
        $sql = "SELECT * FROM ".TB_PREF."item_specs WHERE id=".$item_spec;
        $row = db_fetch(db_query($sql));
        if($row['spec'] && $row['value'])
            $string .= $row['spec'].": ".$row['value'];
        if($newline)
        	$string .="\n ";
        else
        	$string .=", ";

    }
    return rtrim($string, ", ");
    
}



function CheckMessageBodyExist($trans_type=null){
    $sql = " SELECT sms_body FROM ".TB_PREF."transaction_sms WHERE trans_type = ".db_escape($trans_type)." AND inactive = 0 ";
    $result = db_query($sql);
    return db_fetch($result)['sms_body'];
}


function SendTransactionalSMS($To, $Message=null){
  $To = str_replace(array('_', '-', '(', ')', ' '), '',  trim($To));
  $user = '7negc0bf';
  $pass = 'ryA3HxuT';
  $from = 'Test';
  $Message = urlencode($Message);
  $url = "https://api.smsglobal.com/http-api.php?action=sendsms&user=$user&password=$pass&from=$from&to=$To&text=$Message";
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  $response = curl_exec($ch);
  curl_close($ch);
  return $response;
}




///Task#2389
function GetInvoiceSumByDimension($dimension_id){
	$sql = "SELECT SUM(total) as amount FROM ".TB_PREF."sales_orders 
             WHERE trans_type = ".db_escape(ST_SALESORDER)." AND dimension_id = ".db_escape($dimension_id)." AND total != 0 ";
    $result = db_query($sql);
    return db_fetch($result)['amount'];
        
}

///Task#2389