<?php 

class schedule_cart{

	var $soline;
	var $order_no;
	var $order_date;
	var $address;
	var $schedules = array();
	var $cart_id;
	var $item_code;
	var $item_desc;
	var $customer;

	function __construct($line=0){
		$this->cart_id = uniqid('');
		$this->soline = $line;
		$this->read($line);
	}


	function read(){

		//If soline id not found than return empty
		if(!$this->soline)
			return;

		//First read basic so & line info
		$row = get_soline_info($this->soline);

		$this->order_no = $row['order_no'];
		$this->reference = $row['reference'];		
		$this->customer = $row['debtor_no'];
		$this->address = $row['delivery_address'];
		$this->item_code = $row['stk_code'];
		$this->item_desc = $row['description'];
		$this->dimension_id = $row['dimension_id'];
		$this->order_date = sql2date($row['ord_date']);
		$this->quantity = $row['quantity'];


		//Now read all schedules against this soline
		$res = get_schedules_by_order_no($this->order_no);
		if(!$res->field_count)
			$res = get_schedules($this->soline);
		while($row = db_fetch($res)){
			$this->add_schedule($row['id'],sql2date($row['date']),sql2date($row['end_date']),
			$row['start_time'], $row['end_time'],$row['ov_time'],$row['location'], 
			$row['type'], $row['technician'], $row['remarks'], $row['status'], 
			$row['loc_cordinates'], $row['quantity'], $row['soline']);
		}

		return true;
	}


	function add_schedule($id, $date,$end_date,$start_time,$end_time,$ov_time,$location,$type, $technician, $remarks, $status=0, $loc_cordinates="", $quantity=null, $line_id=null){
		$this->schedules[count($this->schedules)] = new schedule($id,$date,$end_date,
		$start_time,$end_time,$ov_time,$location, $type, $technician, $remarks, $status, $loc_cordinates, $quantity, $line_id);
	}
}

class schedule{

	var $id;
	var $line_id;
	var $date;
	var $end_date;
	var $start_time;
	var $end_time;
	var $ov_time;
	var $location;
	var $type;
	var $technician;
	var $remarks;
	var $status;
	var $loc_cordinates;
	var $quantity;


	function __construct($id, $date, $end_date,$start_time, $end_time,$ov_time,$location, $type, $technician, $remarks, $status=0, $loc_cordinates="", $quantity=null, $line_id=null){
		$this->id = $id;
		$this->line_id = $line_id;
		$this->date = $date;
		$this->end_date = $end_date;
		$this->start_time = $start_time;
		$this->end_time = $end_time;
		$this->ov_time = $ov_time;

		$this->location = $location;
		$this->type = $type;
		$this->technician = $technician;
		$this->remarks = $remarks;
		$this->status = $status;
		$this->loc_cordinates = $loc_cordinates;
		$this->quantity = $quantity;
	}
}