<?php

include_once($path_to_root . "/sales/includes/cart_class.inc");
//--------------------------------------------------------------------------------
function add_to_order(&$order, $new_item, $new_item_qty, $price, $discount, $description='', $spec1=null, $spec2=null, $spec3=null, $spec4=null, $spec5=null,$kit_id=0,$wo_type=0, $line_salestype=null, $item_specs=array(), $spec_desciption=null){
	// calculate item price to sum of kit element prices factor for 
	// value distribution over all exploded kit items
	 $std_price = get_kit_price($new_item, $order->customer_currency, 
		$order->sales_type,	$order->price_factor, get_post('OrderDate'), true);

	if ($std_price == 0)
		$price_factor = 0;
	else
		$price_factor = $price/$std_price;

	$kit = get_item_kit($new_item);
	$item_num = db_num_rows($kit);
	$kit_price = $price; // We will use this value as the reference to calculate dicount percent
	$kit_discount = $discount;

	while($item = db_fetch($kit)) {
		$std_price = get_kit_price($item['stock_id'], $order->customer_currency, 
			$order->sales_type,	$order->price_factor, get_post('OrderDate'), true);

		// rounding differences are included in last price item in kit
		$item_num--;
		if ($item_num) {
			$price -= $item['quantity']*$std_price*$price_factor;
			$item_price = $std_price*$price_factor;
			//To apply proper discount we need to multiply total discount from the proportion of price given component will have
			$item_discount = $kit_discount * (($item['quantity']*$std_price*$price_factor)/$kit_price);
			$discount -= $item_discount;
		} else {
			if ($item['quantity']) 
				$price = $price/$item['quantity'];
				
			$item_price = $price;
			$item_discount = $discount;
		}
		// $item_price = round($item_price, user_price_dec());
		// $item_price = round($item_price, user_price_dec());

		if (!$item['is_foreign'] && $item['item_code'] != $item['stock_id'])
		{	// this is sales kit - recurse 
			add_to_order($order, $item['stock_id'], $new_item_qty*$item['quantity'],
				$item_price, $item_discount,'', null, null, null, null, null, $item['id'],$wo_type);
		}
		else
		{	// stock item record eventually with foreign code

			// check duplicate stock item
			foreach ($order->line_items as $order_item)
			{
				if (strcasecmp($order_item->stock_id, $item['stock_id']) == 0)
				{
					display_warning(_("For Part :").$item['stock_id']. " " 
						. _("This item is already on this document. You have been warned."));
					break;
				}
			}

// 			if($order->against && $order->trans_type == ST_SALESORDER){
// 				for ($i=0; $i < $new_item_qty; $i++) { 
// 					 $order->add_to_cart(count($order->line_items),	$item['stock_id'], 
// 					1, $item_price/$new_item_qty, $item_discount/$new_item_qty, 0,0, $description,null,null,null,$spec1,$spec2,$spec3,$spec4,$spec5,$kit_id,$wo_type, $line_salestype, $item_specs);
// 				}
// 			}else{
			$order->add_to_cart(count($order->line_items),	$item['stock_id'], 
				$new_item_qty*$item['quantity'], $item_price, $item_discount, 0,0, $description,null,null,null,$spec1,$spec2,$spec3,$spec4,$spec5,$kit_id,$wo_type, $line_salestype, $item_specs, $spec_desciption);
// 			}


		}
	}

}
//---------------------------------------------------------------------------------

function get_customer_details_to_order(&$order, $customer_id, $branch_id)
{
	global $SysPrefs;
	
	$ret_error = "";

	$myrow = get_customer_to_order($customer_id);
    // display_error($myrow['curr_code']."ssss".$customer_id);
	$name = $myrow['name'];

	if ($myrow['dissallow_invoices'] == 1)
		$ret_error = _("The selected Customer account is currently on hold. Please contact the credit control personnel to discuss.");

	$deliver = $myrow['address']; // in case no branch address use company address

	$order->set_customer($customer_id, $name, $myrow['curr_code'], 
		$myrow['discount'], $myrow['payment_terms'], $myrow['pymt_discount'], $myrow['discount_criteria']);

	// the sales type determines the price list to be used by default
	$order->set_sales_type($myrow['salestype'], $myrow['sales_type'], $myrow['tax_included'],
	    $myrow['factor']);

	$order->credit = $myrow['cur_credit'];

	if ($order->trans_type != ST_SALESORDER && $order->trans_type != ST_SALESQUOTE)
	{
		$order->dimension_id = $myrow['dimension_id'];
		$order->dimension2_id = $myrow['dimension2_id'];
	}
	$result = get_branch_to_order($customer_id, $branch_id);

	if (db_num_rows($result) == 0)
	{
		return _("The selected Customer and branch are not valid, or the customer does not have any branches.");
	}

	$myrow = db_fetch($result);

	// FIX - implement editable contact selector in sales order 
	$contact = get_branch_contacts($branch_id, 'order', $customer_id);
	$order->set_branch($branch_id, $myrow["tax_group_id"],
	$myrow["tax_group_name"], @$contact["phone"], @$contact["email"]);

	$address = trim($myrow["br_post_address"]) != '' ? $myrow["br_post_address"]
		: (trim($myrow["br_address"]) != '' ? $myrow["br_address"]:$deliver);

	$order->set_delivery($myrow["default_ship_via"], $myrow["br_name"],
		$address);
	if ($order->trans_type == ST_SALESINVOICE) {
		$order->due_date = get_invoice_duedate($order->payment, $order->document_date);
	}
	elseif ($order->trans_type == ST_SALESORDER)
		$order->due_date = add_days($order->document_date, $SysPrefs->default_delivery_required_by());
	elseif ($order->trans_type == ST_SALESQUOTE)
		$order->due_date = add_days($order->document_date, $SysPrefs->default_quote_valid_days());

	if($order->payment_terms['cash_sale']) {
		$order->set_location($order->pos["pos_location"], $order->pos["location_name"]);
	} else
		$order->set_location($myrow["default_location"], $myrow["location_name"]);

	return $ret_error;
}

//---------------------------------------------------------------------------------

function display_order_summary($title, &$order, $editable_items=false)
{
global $Ajax, $SysPrefs;
	display_heading($title);

    div_start('items_table');
	start_table(TABLESTYLE, "style='width:100% !important;'");
// display_error(get_post('spec_need'));
	if(list_updated('spec_need'))
	{
			$Ajax->activate('items_table');
			$Ajax->activate('_page_body');

	}
	//---------------- HEADERS AND DROP DOWN CONDITION IN SPECIFICATION -----------------//
		$th_spec_name1=$th_spec_name2=$th_spec_name3=$th_spec_name4=$th_spec_name5=null;
	$th_spec_id1=$th_spec_id2=$th_spec_id3=$th_spec_id4=$th_spec_id5=null;
	$result=get_specification_all();
	$i=1;
	while($myrow=db_fetch($result))
	{
	if($i==1){
		$th_spec_name1=$myrow['specification_name'];
		$th_spec_id1=$myrow['id'];
	}

	if($i==2){
		$th_spec_name2=$myrow['specification_name'];
		$th_spec_id2=$myrow['id'];
	}

	if($i==3){
		$th_spec_name3=$myrow['specification_name'];
		$th_spec_id3=$myrow['id'];
	}

	if($i==4){
		$th_spec_name4=$myrow['specification_name'];
		$th_spec_id4=$myrow['id'];
	}

	if($i==5){
		$th_spec_name5=$myrow['specification_name'];
		$th_spec_id5=$myrow['id'];
}
		// display_error($th_spec2);
	
	$i++;
	}
	//---------------- ENDING HEADERS AND DROP DOWN CONDITION IN SPECIFICATION -----------------//

	if(get_post('spec_need')==1){
		$th = array(_("Item Code "),_("Description"), _($th_spec_name1),_($th_spec_name2),_($th_spec_name3),_($th_spec_name4),_($th_spec_name5),_("Quantity"), _("Delivered"),
		_("Unit"), $order->tax_included ? _("Price after Tax") : _("Price before Tax"), $order->discount_criteria ? _("Discount ") : _("Discount (%)"), _("Total"), "");
	if ($order->trans_no == 0) {
	unset( $th[8] );
	}
}
	else{
	    if(!list_updated('stock_id1')){
        	$th = array(_("Item Code "),_("Description"), _("Specification"), 
        	_("Quantity"), _("Delivered"), _("Sales Price"), _("Unit"), 
        	$order->tax_included ? _("Price after Tax") : 
        	_("Price before Tax"),$order->discount_criteria ? _("Discount ") : 
        	 _("Discount (%)"), _("Total"), "", "");
        	
        	if($order->trans_type == ST_SALESORDER)
	        	unset($th[5]);

        	if ($order->trans_no == 0){
        	    unset( $th[4] );
        	}
	    }
	    else
	    {
    		$th = array(_("Item Code "), _("Description"), 
    		_(""), ("Specification"), _("Quantity"), _("Delivered"), 
    		_("Sales Price"), _("Unit"), $order->tax_included ? 
    		_("Price after Tax") : _("Price before Tax"), 
    		$order->discount_criteria ? _("Discount ") : _("Discount (%)"),
    		_("Total"), "", "");
    		
    		if ($order->trans_type == ST_SALESORDER) {
    			unset($th[6]);
    		} 
    		if ($order->trans_no == 0) {
    			unset($th[5]);
    		}   		
	    }
    }
	//-------------- specification not exist then remove header from item table
    if(get_post('spec_need')==1){
	if ($th_spec_name1=='' || $th_spec_name1==null)
	unset( $th[2] );

	if ($th_spec_name2=='' || $th_spec_name2==null)
	unset( $th[3] );

	if ($th_spec_name3=='' || $th_spec_name3==null)
	unset( $th[4] );

	if ($th_spec_name4=='' || $th_spec_name4==null)
	unset( $th[5] );

	if ($th_spec_name5=='' || $th_spec_name5==null)
	unset( $th[6] );
	}
	//-------------- ENDING specification not exist then remove header from item table
    $spec_headers_name=array('th_spec_name1' => $th_spec_name1, 
    'th_spec_name2' => $th_spec_name2, 'th_spec_name3' => $th_spec_name3, 
    'th_spec_name4' => $th_spec_name4,'th_spec_name5' => $th_spec_name5);

    $spec_headers_id=array('th_spec_id1' => $th_spec_id1, 
    'th_spec_id2' => $th_spec_id2,'th_spec_id3' => $th_spec_id3, 
    'th_spec_id4' => $th_spec_id4,'th_spec_id5' => $th_spec_id5);
	
	$id = find_submit('Edit');
	$total = 0;
	$k = 0;  //row colour counter

	table_header($th);

	$low_stock = $order->check_qoh($_POST['OrderDate'], $_POST['Location']);

	if ($id==-1 && $editable_items)
		sales_order_item_controls($order, $k,null, $spec_headers_name, $spec_headers_id);

	foreach ($order->get_items() as $line_no=>$stock_item){

		$line_total = round(($stock_item->qty_dispatched * $stock_item->price) 
		- $stock_item->discount_percent, user_price_dec());

		$qoh_msg = '';
		if (!$editable_items || $id != $line_no)
		{



			if (in_array($stock_item->stock_id, $low_stock))
				start_row("style='background-color:#e08b8b85;'");	// notice low stock status
			else 
				alt_table_row_color($k);

          	

			view_stock_status_cell($stock_item->stock_id);
			label_cell($stock_item->item_description);
// 			label_cell(get_specs_for_ids($stock_item->item_specs));
			long_text_cell(null ,$stock_item->spec_description."<br>".get_specs_for_ids($stock_item->item_specs),"", "style='width:20px;'",'','colapse'.rand());

			
			if(list_updated('stock_id1'))
			{
			    label_cell("");
			}

			//---------------------- LINE ITEM SAVED SPECIFICATION AFTER ADD ___________________________//
			// display_error(get_post('spec_need'));
			if(get_post('spec_need')==1)
			{

			label_cell(get_specification_name($stock_item->specification1));
			label_cell(get_specification_name($stock_item->specification2));
			label_cell(get_specification_name($stock_item->specification3));
			label_cell(get_specification_name($stock_item->specification4));
			label_cell(get_specification_name($stock_item->specification5));
			}
			else
			{

			}
			//---------------------- LINE ITEM SAVED SPECIFICATION AFTER ADD ___________________________//

			/*if ($_POST['is_wo'] == 1) {
				global $wo_types_array;
				label_cell($wo_types_array[$stock_item->wo_type]);
 			}*/
			$dec = get_qty_dec($stock_item->stock_id);
			qty_cell($stock_item->qty_dispatched, false, $dec,null,false,true);

			if ($order->trans_no!=0)
				qty_cell($stock_item->qty_done, false, $dec,null,false,true);

			if($order->trans_type == ST_SALESQUOTE){
				if($stock_item->line_salestype)
					$sales_type = $stock_item->line_salestype;
				else
					$sales_type = get_sales_type($order->sales_type)['sales_type'];
					label_cell($sales_type);
			}


			label_cell($stock_item->units);
			amount_cell($stock_item->price);
			percent_cell($stock_item->discount_percent,false,null,true);
			amount_cell($line_total);

			if ($editable_items)
			{
				edit_button_cell("Edit$line_no", _("Edit"),
				_('Edit document line'));
				delete_button_cell("Delete$line_no", _("Delete"),
				_('Remove line from document'));
			}
			end_row();
		}
		else
		{
			sales_order_item_controls($order, $k,  $line_no, $spec_headers_name, $spec_headers_id);
		}

		$total += $line_total;
	}


	$colspan = 6;
	if ($order->trans_no!=0)
		++$colspan;
	start_row();
	label_cell("");
	
	label_cell(_("Shipping Charge"), "colspan=$colspan align=right");
	small_amount_cells(null, 'freight_cost', price_format(get_post('freight_cost',0)));
	label_cell('', 'colspan=2');
	end_row();
	label_cell("");
	$display_sub_total = price_format($total + input_num('freight_cost'));
	label_cells(_("Sub-total"), $display_sub_total, "colspan=$colspan align=right","align=left", 2);
		label_cell('', 'colspan=2');
	$taxes = $order->get_taxes(input_num('freight_cost'));
	$tax_total = display_edit_tax_items($taxes, 7, $order->tax_included, 2);
// loyality Points
	if ($order->trans_type == ST_SALESINVOICE) {
		if(isset($_POST['points_check']) && !isset($_POST['add_points_counter']) && !isset($_POST['add_otp_code'])){
		// display_error($SysPrefs->prefs['customer_loyality_check']."===".$_POST['customer_id']."===".get_loyality_points($_POST['customer_id'], 10,null,$_POST['customer_phone_'],$_POST['customer_email_'],$_POST['country_code']));
					// $Ajax->activate('total_price_div');
					// amount_cells(null, 'points_counter', null, null, null, 4);
					// submit_center_last('add_points_counter', _("Add"), '', true);
					start_row();
					label_cell("","colspan=$colspan align=right");
					echo '<td>&nbsp  <input readonly class="amount form-control" type="text" name="points_counter" size="15" maxlength="15" dec="4" value="'. price_format(get_loyality_points($_POST['customer_id'], 10,null,$_POST['customer_phone_'],$_POST['customer_email_'],$_POST['country_code'])).'" style=" float: left; width:50%; height: 33px !important;"> &nbsp</td>';
					echo '<td>';
					submit('add_points_counter', 'Add Points', true, '', true, false, null, 0, '', '', 0, 0, "", '33px;');
					echo '</td>';
					label_cell('', 'colspan=2');
					end_row();
					// echo '<br><br>';
				}
				// else
					// $Ajax->activate('total_price_div');
				if(isset($_POST['points_check']) &&  isset($_POST['add_points_counter'])){
					// $Ajax->activate('total_price_div');
					$otp_code = get_otp_code($_POST['customer_id'],$_POST['country_code'],$_POST['customer_phone_']);
					$phone_number = $_POST['country_code'].$_POST['customer_phone_'];
					// echo $otp_code.'<br/>';
					 if ($otp_code && $phone_number && get_company_pref('is_sms') == 1) {
					 	// $contact =get_customer_contacts($_POST['customer_id'],'general')[0]['name'];
					 	$contact = $phone_number;
        				$contact = str_replace(array('(',')','_','-',' '), '', $contact);
        				$msg = "Your OTP code is \n$otp_code \n.";
        				// echo $contact;
        				// display_error($contact."===".$msg);
        				send_sms($contact,$msg);
					 }/*else if($otp_code && $_POST['customer_email_'] != null){
					 	send_otp_email($_POST['customer_'],$_POST['customer_email_'],$otp_code);
					 }*/else{
					 	start_row();
						label_cell("","colspan=$colspan align=right");
					 	echo '<td>'.$otp_code.'<td/>';
					 	label_cell('', 'colspan=2');
						end_row();
					 }
					start_row();
					label_cell("","colspan=$colspan align=right");
					echo '<td><input id="OTP_Code" class="  form-control" type="text" name="OTP_Code" size="30" maxlength="30" style="float: left; width:50%; height: 33px !important;"> </td><td>';
					submit('add_otp_code', 'Submit OTP Code', true, '', true, false, null, 0, '', '', 0, 0, "", '33px;');
					echo '<td/>';
					label_cell('', 'colspan=2');
					end_row();
				}
				// else
					// $Ajax->activate('total_price_div');

					$points_amount_ = 0;
					if(isset($_POST['points_check']) && isset($_POST['add_otp_code']) && $_POST['OTP_Code'] == get_otp_code($_POST['customer_id'],$_POST['country_code'],$_POST['customer_phone_'])){
						delete_otp_code($_POST['customer_id'],$_POST['country_code'],$_POST['customer_phone_']);
						$points_ = get_loyality_points($_POST['customer_id'], 10,null,$_POST['customer_phone_'],$_POST['customer_email_'],$_POST['country_code']);
						$points_amount_ = $points_ * $SysPrefs->prefs['loyality_points_value'];
						// $Ajax->activate('total_price_div');
					}

					

					if(isset($_POST['add_otp_code'])){
						// start_table(TABLESTYLE2);	

						start_row();
						label_cell("","colspan=$colspan align=right");
						label_cells("Total Amount of Points",price_format2($points_amount_)." AED");
						label_cell('', 'colspan=2');
						end_row();
						/*if($SysPrefs->prefs['loyality_points_tax'] == 1)
							$val_ = $points_amount_ - ($total);
						else*/
							$val_ = $points_amount_ - ($total+$tax_total);
						start_row();
						label_cell("","colspan=$colspan align=right");
						label_cells("Total Amount of Points Remaining", ($val_ <= 0) ? price_format(0)." AED" : price_format2($val_)." AED");
						label_cell('', 'colspan=2');
						end_row();

						/*if($SysPrefs->prefs['loyality_points_tax'] == 1){
							if($points_amount_ < ($total)){
								hidden('points_counter_hidden', 0);
								hidden('ov_discount', $points_amount_);// to check the formula for ov_disount 
							}else{
								hidden('points_counter_hidden', $val_);
								hidden('ov_discount', ($total));
							}

						}else{*/
							if($points_amount_ < ($total+$tax_total)){
								// display_error($points_amount_."/".$SysPrefs->prefs['loyality_points_value']);
								hidden('points_counter_hidden', $points_amount_/$SysPrefs->prefs['loyality_points_value']);
								hidden('ov_discount', $points_amount_);// to check the formula for ov_disount 
							}else{
								hidden('points_counter_hidden', ($total+$tax_total));
								hidden('ov_discount', ($total+$tax_total));
							}
						// }
						// end_table();
						// br();
						// $Ajax->activate('total_price_div');	
					}/*else
						$Ajax->activate('total_price_div');*/

	}

	if($points_amount_ < ($total+$tax_total)){
		// $amt = ($total+$total_taxes)-$points_amount_ ;
		$display_total = price_format(($total + input_num('freight_cost') + $tax_total)-$points_amount_);
	}else{
		// $amt = $points_amount_ - ($total+$total_taxes) ;
		$display_total = price_format($points_amount_ - ($total + input_num('freight_cost') + $tax_total));
	}


	start_row();
	label_cell("");
	label_cells(_("Amount Total"), $display_total, "colspan=$colspan align=right","align=left");
	submit_cells('update', _("Update"), "colspan=2 align='left'", _("Refresh"), true);
	end_row();

	end_table();
	if ($low_stock)
		display_note(_("Marked items have insufficient quantities in stock as on day of delivery."), 0, 1, "class='stockmankofg'");

    div_end();
}

// ------------------------------------------------------------------------------

function display_order_header(&$order, $editable, $date_text)
{
	global $Ajax, $SysPrefs;
	


	start_outer_table(TABLESTYLE2 ,'width:90% !important ;');

	table_section(1);
	
	$customer_error = "";
	$change_prices = 0;

	if (isset($order) && !$editable)
	{
		label_row("Customer", $order->customer_name . " - " . $order->deliver_to);
		hidden('customer_id', $order->customer_id);
		hidden('branch_id', $order->Branch);
		hidden('sales_type', $order->sales_type);
		if ($order->trans_type != ST_SALESORDER  && $order->trans_type != ST_SALESQUOTE) {
			hidden('dimension_id', $order->dimension_id); // 2008-11-12 Joe Hunt
			hidden('dimension2_id', $order->dimension2_id);
		}	
	}


	else
	{


		//______________   CUSTOMER Already Created In User Managment Form   ________________________
			
		$user_id=($_SESSION["wa_current_user"]->user);// Current User online Id
		$myrow=get_user($user_id);// Putting User Id Into it to fetch customer_id From USers Table
		$customer_name=get_customer_name($myrow['customer_id']);//Putting customer_id to Get Its Name From customer Table
		$branch_name=get_branch_name($myrow['branch_id']);		
		// $user_id=$_SESSION["wa_current_user"]->user;
		if($myrow['customer_id']>=1)
		{
		start_row();
		label_cells(_('Customer: '),$customer_name);
        hidden('customer_id', $myrow['customer_id']);
        end_row();
		//___________________________________________________________________________________________
		}else{
			if(check_feild_status_of_invoice_form("Customer", 10)['status_pc'] == 1)
				customer_list_row(_('Customer: '), 'customer_id', null, false, true, false, true);
			else{
				if(!isset($_SESSION['wa_global_customer_id'])){
					$_POST['customer_id'] = get_all_customers()['debtor_no'];
					hidden('customer_id', get_all_customers()['debtor_no']);
				}else{
					$_POST['customer_id'] = $order->customer_id;
					hidden('customer_id', $order->customer_id);
				}

				

			}
		}
		if (get_customer($_POST['customer_id'])['is_cash_cust']) {
			ref_row(_("Customer Email:"), 'customer_email_', 'Type a Email here', null, false);
			$country_code = get_country_phone_code(get_company_pref('country'));
			label_row(_("Country Code:"),"+".$country_code);
			echo '<input type="hidden" id="country_code" name="country_code" value="'.$country_code.'">';
			// hidden('country_code',$country_code);
			ref_row(_("Customer Phone:"), 'customer_phone_', null, null, true);
		}

		if ($order->customer_id != get_post('customer_id', -1))
		{
			// customer has changed
			$Ajax->activate('branch_id');
  		}
  		if($myrow['branch_id']>=1)
		{start_row();
		label_cells(_('Branch: '),$branch_name);
         hidden('branch_id', $myrow['branch_id']);
         end_row();
		//___________________________________________________________________________________________
		}else{
			if(check_feild_status_of_invoice_form("Branch", 10)['status_pc'] == 1)
				customer_branches_list_row(_("Branch:"), $_POST['customer_id'], 'branch_id', null, false, true, true, true);
			else{
				$_POST['branch_id'] = get_branch_by_debtor_no($_POST['customer_id']);
				hidden('branch_id', get_branch_by_debtor_no($_POST['customer_id']));
			}
		}


		if( ($order->customer_id != get_post('customer_id', -1)) ||
			($order->Branch != get_post('branch_id', -1)) ||
				list_updated('customer_id')) 
		{

			if (!isset($_POST['branch_id']) || $_POST['branch_id'] == "")
			{
				// ignore errors on customer search box call
				if ($_POST['customer_id'] == '')
					$customer_error = _("No Customer found for entered text.");
				// else
				// 	$customer_error = _("The selected customer does not have any branches. Please create at least one branch.");
				unset($_POST['branch_id']);
				$order->Branch = 0;
			} 
			else
			{

				$old_order = (PHP_VERSION<5) ? $order : clone $order;

				$customer_error = get_customer_details_to_order($order, $_POST['customer_id'], $_POST['branch_id']);
				$_POST['Location'] = $order->Location;
				$_POST['deliver_to'] = $order->deliver_to;
				$_POST['delivery_address'] = $order->delivery_address;
				$_POST['phone'] = $order->phone;
				$_POST['delivery_date'] = $order->due_date;

				if (!in_array($order->trans_type, array(ST_SALESQUOTE, ST_SALESORDER))
					&& ($order->pos['cash_sale'] != $order->pos['credit_sale'])
					&& (($order->payment_terms['cash_sale'] && !$order->pos['cash_sale']) ||
						(!$order->payment_terms['cash_sale'] && !$order->pos['credit_sale']))) {
							// force payment terms refresh if terms are editable
							// and pos have no permitions for terms selected in customer record.
							// Terms are set to first terms in allowed category below.
							display_warning(
								sprintf(_("Customer's payment terms '%s' cannot be selected on this POS"),
									$order->payment_terms['terms']));
							$order->payment = '';
				} elseif (get_post('payment') !== $order->payment) {
					$_POST['payment'] = $order->payment;
					$Ajax->activate('delivery');
					$Ajax->activate('payment');
				} else {
					if ($order->trans_type == ST_SALESINVOICE)
					{
						$_POST['delivery_date'] = $order->due_date;
						$Ajax->activate('delivery_date');
					}
					$Ajax->activate('Location');
					$Ajax->activate('deliver_to');
					$Ajax->activate('phone');
					$Ajax->activate('delivery_address');
				}
				// change prices if necessary
				// what about discount in template case?
				if ($old_order->customer_currency != $order->customer_currency) {
					$change_prices = 1;
				}
				if ($old_order->sales_type != $order->sales_type) {
				//  || $old_order->default_discount!=$order->default_discount
					$_POST['sales_type'] = $order->sales_type;
					$Ajax->activate('sales_type');
					$change_prices = 1;
				}
				if ($old_order->dimension_id != $order->dimension_id) {
					$_POST['dimension_id'] = $order->dimension_id;
				    $Ajax->activate('dimension_id');
				}
				if ($old_order->dimension2_id != $order->dimension2_id) {
					$_POST['dimension2_id'] = $order->dimension2_id;
				    $Ajax->activate('dimension2_id');
				}
				unset($old_order);
			}
			set_global_customer($_POST['customer_id']);
		} // changed branch
		else
		{
			$row = get_customer_to_order($_POST['customer_id']);
			if ($row['dissallow_invoices'] == 1)
				$customer_error = _("The selected Customer account is currently on hold. Please contact the credit control personnel to discuss.");
		}
	}
	
	
	if(check_feild_status_of_invoice_form("Reference", 10)['status_pc'] == 1)
		ref_row(_("Reference").':', 'ref', _('Reference number unique for this document type'), null, '', $order->trans_type, array('date'=> @$_POST['OrderDate']));
	else{
		global  $Refs;
		hidden('ref', $Refs->get_next($order->trans_type));
	}


	table_section(2);

	if (!is_company_currency($order->customer_currency) && in_array($order->trans_type, array(ST_SALESINVOICE, ST_CUSTDELIVERY)))
	{
		if(check_feild_status_of_invoice_form("Customer Currency", 10)['status_pc'] == 1)
			label_row(_("Customer Currency:"), $order->customer_currency);

		if(check_feild_status_of_invoice_form("Exchange Rate", 10)['status_pc'] == 1)
				exchange_rate_display(get_company_currency(), $order->customer_currency, ($editable ? $_POST['OrderDate'] : $order->document_date));

	}
	if(check_feild_status_of_invoice_form("Current Credit", 10)['status_pc'] == 1)
		customer_credit_row($_POST['customer_id'], $order->credit);

	if(check_feild_status_of_invoice_form("Customer Discount", 10)['status_pc'] == 1){
		if($order->discount_criteria)
			label_row(_("Customer Discount:"), $order->default_discount." ".
				$order->customer_currency);
		else
			label_row(_("Customer Discount:"), $order->default_discount. " %");

	}

// Site 
check_cells(_('Existing Site:'),'site_exist',null,true);
if($_POST['site_exist']){
	dimensions_list_row(_('Site: '), 'dimension_id', null, true, _('Default'), false, 1, false, 0, 1);
	global $Ajax;
	$Ajax->activate('_page_body');
}

// Site Work	
	
//loyality work
	if ($order->trans_type == ST_SALESINVOICE && $_POST['payment'] == 4) {
		div_start('point_div');
				if($SysPrefs->prefs['customer_loyality_check'] == 1 && $_POST['customer_id'] != null && get_loyality_points($_POST['customer_id'], 10,null,$_POST['customer_phone_'],$_POST['customer_email_'],$_POST['country_code']) != 0){
					// start_row();
					echo '<div class="input-group contacts" >';
					label_cells("Points:", "<a href='javascript:void(0);' onclick='open_loyality(".$_POST['customer_id'].",\"".$_POST['customer_phone_']."\",\"".$_POST['customer_email_']."\",\"".$_POST['country_code']."\")' >".price_format2(get_loyality_points($_POST['customer_id'], 10,null,$_POST['customer_phone_'],$_POST['customer_email_'],$_POST['country_code']))."</a>"."     &nbsp;&nbsp;        ".checkbox(null, "points_check", null, true));
					echo '</div>';
					// checkbox($label, $name, $value=null, $submit_on_change=false, $title=false, $class=null)
					// end_row();
				} 
		div_end();

		
	}

	table_section(3);
	start_row();
	if (($order->pos['cash_sale'] || $order->pos['credit_sale']) 
		&& !$order->is_started()) {
		 // editable payment type 
		if (get_post('payment') !== $order->payment) {
			$order->payment = get_post('payment');
			$order->payment_terms = get_payment_terms($order->payment);
			$order->due_date = get_invoice_duedate($order->payment, $order->document_date);
			if ($order->payment_terms['cash_sale']) {
				$_POST['Location'] = $order->Location = $order->pos['pos_location'];
				$order->location_name = $order->pos['location_name'];
			}
			$Ajax->activate('items_table');
			$Ajax->activate('delivery');
		}
		$paymcat = !$order->pos['cash_sale'] ? PM_CREDIT : 
			(!$order->pos['credit_sale'] ? PM_CASH : PM_ANY);
		// all terms are available for SO
		$is_order = in_array($order->trans_type, array(ST_SALESQUOTE, ST_SALESORDER));
		if(check_feild_status_of_invoice_form("Payment", 10)['status_pc'] == 1)
			sale_payment_list_cells(_('Payment:'), 'payment', $is_order ? PM_ANY : $paymcat, null, true, $is_order);
		else
			hidden('payment', $is_order ? PM_ANY : $paymcat);

	} else {
		if(check_feild_status_of_invoice_form("Payment", 10)['status_pc'] == 1)
			label_cells(_('Payment:'), $order->payment_terms['terms'], "class=''");
	}
	end_row();

	if($editable) {
		if(check_feild_status_of_invoice_form("Price List", 10)['status_pc'] == 1)
			$str = sales_types_list_row(_("Price List:"), 'sales_type', null, true);
		else{
			$_POST['sales_type'] = $order->sales_type;
			hidden('sales_type' , $order->sales_type);
		}

	} else {
		if(check_feild_status_of_invoice_form("Price List", 10)['status_pc'] == 1)
			label_row(_("Price List:"), $order->sales_type_name);
	}
	if ($order->trans_type == ST_SALESINVOICE) {
	countries_list_row(_('Country'), 'country',null, false, true);
	}
	if ($order->sales_type != $_POST['sales_type']) {
		$myrow = get_sales_type($_POST['sales_type']);
		$order->set_sales_type($myrow['id'], $myrow['sales_type'],
			$myrow['tax_included'], $myrow['factor']);
		$Ajax->activate('sales_type');
		$change_prices = 1;
	}

	table_section(4);

	if ($editable)
	{
		if (!isset($_POST['OrderDate']) || $_POST['OrderDate'] == "")
			$_POST['OrderDate'] = $order->document_date;
		if(check_feild_status_of_invoice_form("Date", 10)['status_pc'] == 1){
			date_row($date_text, 'OrderDate', _('Date of order receive'),
				$order->trans_no==0, 0, 0, 0, null, true);
		}else
			$_POST['OrderDate'] = $order->document_date;

		if ($order->trans_type == ST_SALESORDER) {	
			check_cells(_('Add automated Work Order'),'is_wo',null,true);
		}

		if ($_POST['is_wo'] == 1) {
			date_row(_("Required Date"), 'wo_required_date', _('Work Order required date.'),
				$order->trans_no==0, 0, 0, 0, null, true);
			$Ajax->activate('_page_body');
		}else{
			$Ajax->activate('_page_body');
		}

		if (isset($_POST['_OrderDate_changed']) || list_updated('payment')) {
			if (!is_company_currency($order->customer_currency) 
				&& (get_base_sales_type()>0)) {
					$change_prices = 1;
			}
			$Ajax->activate('_ex_rate');
			if ($order->trans_type == ST_SALESINVOICE) {
				$_POST['delivery_date'] = get_invoice_duedate(get_post('payment'), get_post('OrderDate'));
			} else 
				$_POST['delivery_date'] = add_days(get_post('OrderDate'), $SysPrefs->default_delivery_required_by());
			$Ajax->activate('items_table');
			$Ajax->activate('delivery_date');
		}
// 		if ($order->trans_type != ST_SALESORDER && $order->trans_type != ST_SALESQUOTE)
// 		{	// 2008-11-12 Joe Hunt added dimensions
// 			$dim = get_company_pref('use_dimension');
// 			if ($dim > 0){
// 				if(check_feild_status_of_invoice_form("Dimension", 10)['status_pc'] == 1){
// 					dimensions_list_row(_("Dimension").":", 'dimension_id', 
// 						null, true, ' ', false, 1, false);
// 				}else
// 					hidden('dimension_id', 0);
// 			}
// 			else
// 				hidden('dimension_id', 0);

// 			if ($dim > 1){
// 				if(check_feild_status_of_invoice_form("Dimension 2", 10)['status_pc'] == 1){
// 					dimensions_list_row(_("Dimension")." 2:", 'dimension2_id', 
// 						null, true, ' ', false, 2, false);
// 				}else
// 					hidden('dimension2_id', 0);
// 			}
// 			else
// 				hidden('dimension2_id', 0);
// 		}	
	}
	else
	{
		label_row($date_text, $order->document_date);
		hidden('OrderDate', $order->document_date);
	}

//specification_with_without(_('Specification'), 'spec_need', $selected_id=null, $submit_on_change=true);

	if ($change_prices != 0) {
		foreach ($order->line_items as $line_no=>$item) {
			$line = &$order->line_items[$line_no];
			$line->price = get_kit_price($line->stock_id, $order->customer_currency,
				$order->sales_type, $order->price_factor, get_post('OrderDate'));
		}
	    $Ajax->activate('items_table');
	}



	// table_section();

	table_section(5);
div_start('image',null,false,'style=""');
    if (list_updated('stock_id') && file_exists(company_path().'/images/'.item_img_name($_POST['stock_id']).".jpg")) 
	{
	 // 31/08/08 - rand() call is necessary here to avoid caching problems.
		// sssdisplay_error(company_path().'/images/'.item_img_name($_POST['stock_id']));
		$stock_img_link = "<img id='item_img' alt = '[".$_POST['stock_id'].".jpg".
			"]' class='img-thumbnail '  src='".company_path().'/images/'.item_img_name($_POST['stock_id']).
			".jpg?nocache=".rand()."'"."    style='      height: 130px;
    width: 130px;     
 ' border='0' onclick='view_img(this)'>";
		$check_remove_image = true;
	label_row("&nbsp;                                   ", $stock_img_link);
		br();
	} 
	


// close_img()
     div_end();
	




	end_outer_table(1); // outer table


	return $customer_error;
}

//--------------------------------------------------------------------------------

function sales_order_item_controls(&$order, &$rowcounter, $line_no=-1, $spec_headers_name=null, $spec_headers_id=null)
{

    global $Ajax;
    $itm_Name=get_items_name_description(get_post('stock_id1'));
	$check_desc_language = check_description_language($order->line_items[$id]->stock_id); //note: english 1, // arabic 0

	alt_table_row_color($rowcounter);

	$id = find_submit('Edit');
	if ($line_no!=-1 && $line_no == $id) // edit old line
	{
		$_POST['stock_id'] = $order->line_items[$id]->stock_id;
		$_POST['item_specs'] = $order->line_items[$id]->item_specs;
		$_POST['spec_description'] = $order->line_items[$id]->spec_description;
		$dec = get_qty_dec($_POST['stock_id']);
		$_POST['qty'] = number_format2($order->line_items[$id]->qty_dispatched, $dec);
		$_POST['price'] = price_format($order->line_items[$id]->price);
		if($order->discount_criteria)
			$_POST['Disc'] = percent_format($order->line_items[$id]->discount_percent);
		else{ // Convert the amount back to percentage
			$_POST['Disc'] = ($order->line_items[$id]->discount_percent/$order->line_items[$id]->price * 
			$order->line_items[$id]->qty_dispatched)*100;
		}
		$units = $order->line_items[$id]->units;
		$_POST['item_description'] = $order->line_items[$id]->item_description;
		hidden('stock_id', $_POST['stock_id']);


		label_cell($_POST['stock_id'] );
		// text_cells($_POST['item_description']););
		//hidden('item_description', $_POST['item_description']);
	$itm_Name=get_items_name_description(get_post('stock_id1'));
	$check_desc_language = check_description_language($order->line_items[$id]->stock_id); //note: english 1, // arabic 0
		if ($order->line_items[$id]->descr_editable)
				{
				if($check_desc_language == 0) // for arabic text box
				text_cells_arbic(null, 'item_description', 50, 50 , null,null,null,null,true, 1);
				else// for english text box
				text_cells(null, 'item_description', null, 25, 50,_('Item Name'));
				}		
			// textarea_cells(null,'item_description', null, 45, 2);
		  
		
		else 
		{ 
		  //  display_error(abc);
				if($check_desc_language == 0) // for arabic text box
				text_cells_arbic(null, 'item_description', 50, 50 , $_POST['item_description'],null,null,null,true, 1);
				else// for english text box
				text_cells(null, 'item_description', $_POST['item_description'], 25, 50,_('Item Name'));
		}
		// textarea_cells(null,'item_description', null, 45, 2);
        item_spec_list_cells("", 'item_specs', null, $_POST['stock_id']);
	    $Ajax->activate('items_table');
	    
	    global $Ajax;
	    $Ajax->addScript(true, "spec_read_more();");//read spec
	}
	else	// prepare new line
	{   
	    label_cell($_POST['stock_id1'], '', 'stock_id' );
		hidden('stock_id', $_POST['stock_id1']);
			if (list_updated('stock_id1')) {
			    global $Ajax;
				$Ajax->addScript(true, "spec_read_more();");//read spec
			    // $Ajax->activate('price');
			    // $Ajax->activate('units');
			    // $Ajax->activate('qty');
			    $Ajax->activate('items_table');
			    $Ajax->activate('image');
			    
			    
			    // $Ajax->activate('line_total');
			}

					//label_cell("");	

		
		if ($order->fixed_asset){
		    if (!list_updated('stock_id1')){
				stock_disposable_fa_list_cells(null,'stock_id1', null, _('[Select item]'), true, $order->line_items);
			}else{
			    $itm_Name=get_items_name_description(get_post('stock_id1'));
				text_cells(null, 'stock_name', $itm_Name['description'], 25, 50,_('Item Name'));
			}
		}
		else{
			if (!list_updated('stock_id1')){
				sales_items_list_cells(null,'stock_id1', null, false, true, true);
			}else{

		$Items_Spec_result = GetItemsSpecification($_POST['stock_id1']);
		$_POST['item_specs'] = $Items_Spec_result;


		$check_desc_language = check_description_language(get_post('stock_id1')); //note: english 1, // arabic 0
				

				if($check_desc_language == 0) // for arabic text box
				text_cells_arbic(null, 'stock_name', 50, 50 , $itm_Name['description'],null,null,null,true, 1);
				else{// for english text box
					if($itm_Name['description'] == null){
						$res_ = get_item_kit(get_post('stock_id1'),1);
						$row_ = db_fetch($res_);
						$itm_Name['description'] = $row_['description'];
				     }
					text_cells(null, 'stock_name', $itm_Name['description'], 25, 50,_('Item Name'));
				}
				remove_button_cell("AAA", ("AAA"), ('Cancel'));
			}
		}
		
		item_spec_list_cells("", 'item_specs', null, $_POST['stock_id1']);
		if (get_post('AAA')){
			     $Ajax->activate('items_table');
		}

		// $check_spec=check_item_spec($_POST['stock_id']);
		// if($check_spec!=0)
		// {
		// 	sales_items_list_cells(null,'asd', null, false, true, true);
		// }

		// $spec_data=get_specification1($_POST['stock_id']);
		// $i=1;
		// while($myrow3=db_fetch($spec_data))
		// {
		// 	if($i=1)
		// 	{
		// 		$spec_id=$myrow3['specification_id'];
		// 		$spec_detail_id=$myrow3['specification_detail_id'];
		// 		$spec_name=get_specification_name1();
		// 	}
		// 	if($i=2)
		// 	{
		// 		$spec_id=$myrow3['specification_id'];
		// 		$spec_detail_id=$myrow3['specification_detail_id'];
		// 		$spec_name=get_specification_name1();
		// 	}
		// 	if($i=3)
		// 	{
		// 		$spec_id=$myrow3['specification_id'];
		// 		$spec_detail_id=$myrow3['specification_detail_id'];
		// 		$spec_name=get_specification_name1();
		// 	}
		// 	if($i=4)
		// 	{
		// 		$spec_id=$myrow3['specification_id'];
		// 		$spec_detail_id=$myrow3['specification_detail_id'];
		// 		$spec_name=get_specification_name1();
		// 	}
		// 	if($i=5)
		// 	{
		// 		$spec_id=$myrow3['specification_id'];
		// 		$spec_detail_id=$myrow3['specification_detail_id'];
		// 		$spec_name=get_specification_name1();
		// 	}

		// 	// display_error($myrow3['specification_id']);
		// 	$i++;
		// }

		$item_info = get_item_edit_info($_POST['stock_id']);
		$units = $item_info["units"];
		$dec = $item_info['decimals'];
		$_POST['qty'] = number_format2(1, $dec);
		$price = get_kit_price($_POST['stock_id'],
			$order->customer_currency, $order->sales_type,
			$order->price_factor, get_post('OrderDate'));

		if($price)
			$sales_type = get_sales_type($order->sales_type)['sales_type'];
		else
			$sales_type = '';

		$_POST['price'] = price_format($price);
			// default to the customer's discount %
		$discount = $order->default_discount;
			if($order->discount_criteria)
			$_POST['Disc'] = price_format($discount);
		    else
			$_POST['Disc'] = percent_format($discount);
	}
// display_error($_POST['specc2']);
// 	display_error($spec_headers_name['th_spec_name1']);

//--------------------------------------------------------- DROP DOWNS SPECIFICATION ---------------------------//
	if(get_post('spec_need')==1)
	{
			if($spec_headers_name['th_spec_name1']!='' || $spec_headers_name['th_spec_name1']!=null)
		specification_property_list_cells(null, 'specc', $_POST['specc'], ''.$spec_headers_name['th_spec_name1'] , true, get_post('stock_id'), $spec_headers_id['th_spec_id1'] );

			if($spec_headers_name['th_spec_name2']!='' || $spec_headers_name['th_spec_name2']!=null)
		specification_property_list_cells(null, 'specc2', $_POST['specc2'], ''.$spec_headers_name['th_spec_name2'] , true, get_post('stock_id'), $spec_headers_id['th_spec_id2'] );

			if($spec_headers_name['th_spec_name3']!='' || $spec_headers_name['th_spec_name3']!=null)
		specification_property_list_cells(null, 'specc3', $_POST['specc3'], ''.$spec_headers_name['th_spec_name3'] , true, get_post('stock_id'), $spec_headers_id['th_spec_id3'] );

			if($spec_headers_name['th_spec_name4']!='' || $spec_headers_name['th_spec_name4']!=null)
		specification_property_list_cells(null, 'specc4', $_POST['specc4'], ''.$spec_headers_name['th_spec_name4'] , true, get_post('stock_id'), $spec_headers_id['th_spec_id4'] );

			if($spec_headers_name['th_spec_name5']!='' || $spec_headers_name['th_spec_name5']!=null)
		specification_property_list_cells(null, 'specc5', $_POST['specc5'], ''.$spec_headers_name['th_spec_name5'] , true, get_post('stock_id'), $spec_headers_id['th_spec_id5'] );
}
//--------------------------------------------------------- ENDING DROP DOWNS SPECIFICATION ---------------------------//
// display_error(get_post('specc4'));
	  if ($_POST['is_wo'] == 1) {
        	// echo "<td>".wo_types_list('wo_type', null,false,false)."</td>";
        	hidden('wo_type',2);// for advance manufacturing
	    }
	if ($order->fixed_asset) {
		label_cell(1, '', 'qty');
		hidden('qty', 1);
	} 
	else 
		qty_cells(null, 'qty', $_POST['qty'], null, null, $dec);


	if ($order->trans_no!=0) {
		qty_cell($line_no==-1 ? 0 :$order->line_items[$line_no]->qty_done, false, $dec);
	}


	if($order->trans_type == ST_SALESQUOTE){
		if($order->line_items[$line_no]->line_salestype)
			$sales_type = $order->line_items[$line_no]->line_salestype;
		label_cell($sales_type);
		hidden('stype_line', $sales_type);
	}


	label_cell($units, '', 'units');

	amount_cells(null, 'price');

	small_amount_cells(null, 'Disc', percent_format($_POST['Disc']), null, '', user_percent_dec());

$discount_value = $order->discount_criteria ? input_num('Disc') : 
					  (input_num('qty')*input_num('price'))*input_num('Disc')/100;
	$line_total = (input_num('qty') * input_num('price')) - $discount_value;

	amount_cell($line_total);

	if ($id!=-1)
	{
		button_cell('UpdateItem', _("Update"),
				_('Confirm changes'), ICON_UPDATE);
		button_cell('CancelItemChanges', _("Cancel"),
				_('Cancel changes'), ICON_CANCEL);
		hidden('LineNo', $line_no);
		set_focus('qty');
	}
	else
	{
		submit_cells('AddItem', _("Add Item"), "colspan=2 align='left'",
		    _('Add new item to document'), true);
	}

	end_row();
}

//--------------------------------------------------------------------------------

function display_delivery_details(&$order)
{
	global $Ajax;

	div_start('delivery');	


	if ($order->payment_terms['cash_sale']) {	// Direct payment sale
		$Ajax->activate('items_table');
		display_heading(_('Cash payment'));
		//($_GET['NewOrder']=='Yes' ? 'width: 38% !important;' :'width: 100% !important;'  )
		start_table(TABLESTYLE2, 'width:90% !important ;');



		locations_list_row(_("Deliver from Location:"), 'Location', null, false, true);
 		if (list_updated('Location'))
 			$Ajax->activate('items_table');
		label_row(_("Cash account:"), $order->pos['bank_account_name']);
		textarea_row(_("Comments:"), "Comments", $order->Comments, 31, 5);
		end_table();
		hidden('delivery_date', $order->due_date);
		// hidden('email',($order->email);)
	} else {
		if ($order->trans_type==ST_SALESINVOICE)
		{
			$title = _("Delivery Details");
			$delname = _("Due Date").':';
		}
		elseif ($order->trans_type==ST_CUSTDELIVERY)
		{
			$title = _("Invoice Delivery Details");
			$delname = _("Invoice before").':';
		}
		elseif ($order->trans_type==ST_SALESQUOTE)
		{
			$title = _("Quotation Delivery Details");
			$delname = _("Valid until").':';
		}
		else
		{
			$title = _("Order Delivery Details");
			$delname = _("Required Delivery Date").':';
		}
		display_heading($title);
		if($title=="Order Delivery Details")
		start_outer_table(TABLESTYLE2,  "style='width: 79% !important'");
	    else if($title=="Quotation Delivery Details"|| $title=="Invoice Delivery Details"||$title=="Delivery Details")
		start_outer_table(TABLESTYLE2,"style='width: 100% !important'");
	    else
		start_outer_table(TABLESTYLE2,"style='width: 87% !important;'");
		table_section(1);

		locations_list_row(_("Deliver from Location:"), 'Location', null, false, true, $order->fixed_asset);
		if ($order->payment_terms['days_before_due'] == -1)
		{
			$Ajax->addUpdate('items_table', 'prep_amount', price_format($order->get_trans_total())); // bind to items_table update
			if (!$order->is_started())
				amount_row(_("Pre-Payment Required:"), 'prep_amount');
			else
				label_row(_("Pre-Payment Required:"), price_format($order->prep_amount), "class=''");
		}
		if (list_updated('Location'))
			$Ajax->activate('items_table');


		date_row($delname, 'delivery_date',
			$order->trans_type==ST_SALESORDER ?  _('Enter requested day of delivery') 
				: $order->trans_type==ST_SALESQUOTE ? _('Enter Valid until Date') : '');
	$user_id=($_SESSION["wa_current_user"]->user);// Current User online Id
	$myrow=get_user($user_id);// Putting User Id Into it to fetch customer_id From USers Table
		if($myrow['customer_id']>=1)
		text_row(_("Deliver To:"), 'deliver_to', get_branch_name($myrow['branch_id']), 50, 60,
			_('Additional identifier for delivery e.g. name of receiving person'));
		else
		text_row(_("Deliver To:"), 'deliver_to', $order->deliver_to, 50, 60,
			_('Additional identifier for delivery e.g. name of receiving person'));

		textarea_row(_("Address:"), 'delivery_address', $order->delivery_address, 35, 5,
			_('Delivery address. Default is address of customer branch'));

		table_section(2);
		text_row(_("Contact Phone Number:"), 'phone', $order->phone, 25, 25,
		    _('Phone number of ordering person. Defaults to branch phone number'));
		text_row(_("Customer Reference:"), 'cust_ref', $order->cust_ref, 25, 25,
		  _('Customer reference number for this order (if any)'));
		textarea_row(_("Comments:"), "Comments", $order->Comments, 31, 5);

		shippers_list_row(_("Shipping Company:"), 'ship_via', $order->ship_via);

		end_outer_table(1);
	}
	div_end();
}

function display_order_header_for_mobile(&$order, $editable, $date_text){
	global $Ajax, $SysPrefs;
	start_table(TABLESTYLE2 ,'width:90% !important ;');
	// table_section(1);
		$Ajax->activate('_page_body');
	$customer_error = "";
	$change_prices = 0;
	if (isset($order) && !$editable)
	{
		label_row('Customer', $order->customer_name . " - " . $order->deliver_to);
		hidden('customer_id', $order->customer_id);
		hidden('branch_id', $order->Branch);
		hidden('sales_type', $order->sales_type);
		if ($order->trans_type != ST_SALESORDER  && $order->trans_type != ST_SALESQUOTE) {
			hidden('dimension_id', $order->dimension_id); // 2008-11-12 Joe Hunt
			hidden('dimension2_id', $order->dimension2_id);
		}	
	}else{
		//______________   CUSTOMER Already Created In User Managment Form   ________________________
		$user_id=($_SESSION["wa_current_user"]->user);// Current User online Id
		$myrow=get_user($user_id);// Putting User Id Into it to fetch customer_id From USers Table
		$customer_name=get_customer_name($myrow['customer_id']);//Putting customer_id to Get Its Name From customer Table
		$branch_name=get_branch_name($myrow['branch_id']);		
		// $user_id=$_SESSION["wa_current_user"]->user;
		if($myrow['customer_id']>=1){
			//start_row();
			label_row(_('Customer: '),$customer_name);
	        hidden('customer_id', $myrow['customer_id']);
	        //end_row();
		//___________________________________________________________________________________________
		}else{

			if(check_feild_status_of_invoice_form("Customer", 10)['status_mbl'] == 1)
				customer_list_row(_("Customer:"), 'customer_id', null, false, true, false, true);
			else{
				if(!isset($_SESSION['wa_global_customer_id'])){
					$_POST['customer_id'] = get_all_customers()['debtor_no'];
					hidden('customer_id', get_all_customers()['debtor_no']);
				}else{
					$_POST['customer_id'] = $order->customer_id;
					hidden('customer_id', $order->customer_id);
				}
			}
		}
		if (get_customer($_POST['customer_id'])['is_cash_cust']) {
			ref_row(_("Customer Email:"), 'customer_email_', 'Type a Email here', null, false);
			$country_code = get_country_phone_code(get_company_pref('country'));
			label_row(_("Country Code:"),"+".$country_code);
			echo '<input type="hidden" id="country_code" name="country_code" value="'.$country_code.'">';
			// hidden('country_code',$country_code);
			ref_row(_("Customer Phone:"), 'customer_phone_', null, null, true);
		}

		if ($order->customer_id != get_post('customer_id', -1)){
			$Ajax->activate('branch_id');
  		}
  		if($myrow['branch_id']>=1){
  			//start_row();
			label_row(_('Branch: '),$branch_name);
			hidden('branch_id', $myrow['branch_id']);
			//end_row();
		//___________________________________________________________________________________________
		}else{
			if(check_feild_status_of_invoice_form("Branch", 10)['status_mbl'] == 1)
				customer_branches_list_row(_("Branch:"), $_POST['customer_id'], 'branch_id', null, false, true, true, true);
			else{
				$_POST['branch_id'] = get_branch_by_debtor_no($_POST['customer_id']);
				hidden('branch_id', get_branch_by_debtor_no($_POST['customer_id']));
			}
		}

		if( ($order->customer_id != get_post('customer_id', -1)) || ($order->Branch != get_post('branch_id', -1)) || list_updated('customer_id')){
			if (!isset($_POST['branch_id']) || $_POST['branch_id'] == ""){
				// ignore errors on customer search box call
				if ($_POST['customer_id'] == '')
					$customer_error = _("No customer found for entered text.");
				// else
				// 	$customer_error = _("The selected customer does not have any branches. Please create at least one branch.");
				unset($_POST['branch_id']);
				$order->Branch = 0;
			} 
			else{

				$old_order = (PHP_VERSION<5) ? $order : clone $order;
				$customer_error = get_customer_details_to_order($order, $_POST['customer_id'], $_POST['branch_id']);
				$_POST['Location'] = $order->Location;
				$_POST['deliver_to'] = $order->deliver_to;
				$_POST['delivery_address'] = $order->delivery_address;
				$_POST['phone'] = $order->phone;
				$_POST['delivery_date'] = $order->due_date;

				if (!in_array($order->trans_type, array(ST_SALESQUOTE, ST_SALESORDER))
					&& ($order->pos['cash_sale'] != $order->pos['credit_sale'])
					&& (($order->payment_terms['cash_sale'] && !$order->pos['cash_sale']) ||
						(!$order->payment_terms['cash_sale'] && !$order->pos['credit_sale']))) {
							// force payment terms refresh if terms are editable
							// and pos have no permitions for terms selected in customer record.
							// Terms are set to first terms in allowed category below.
							display_warning(
								sprintf(_("Customer's payment terms '%s' cannot be selected on this POS"),
									$order->payment_terms['terms']));
							$order->payment = '';
				} elseif (get_post('payment') !== $order->payment) {
					$_POST['payment'] = $order->payment;
					$Ajax->activate('delivery');
					$Ajax->activate('payment');
				} else {
					if ($order->trans_type == ST_SALESINVOICE)
					{
						$_POST['delivery_date'] = $order->due_date;
						$Ajax->activate('delivery_date');
					}
					$Ajax->activate('Location');
					$Ajax->activate('deliver_to');
					$Ajax->activate('phone');
					$Ajax->activate('delivery_address');
				}
				// change prices if necessary
				// what about discount in template case?
				if ($old_order->customer_currency != $order->customer_currency) {
					$change_prices = 1;
				}
				if ($old_order->sales_type != $order->sales_type) {
				//  || $old_order->default_discount!=$order->default_discount
					$_POST['sales_type'] = $order->sales_type;
					$Ajax->activate('sales_type');
					$change_prices = 1;
				}
				if ($old_order->dimension_id != $order->dimension_id) {
					$_POST['dimension_id'] = $order->dimension_id;
				    $Ajax->activate('dimension_id');
				}
				if ($old_order->dimension2_id != $order->dimension2_id) {
					$_POST['dimension2_id'] = $order->dimension2_id;
				    $Ajax->activate('dimension2_id');
				}
				unset($old_order);
			}
			set_global_customer($_POST['customer_id']);
		} // changed branch
		else
		{
			$row = get_customer_to_order($_POST['customer_id']);
			if ($row['dissallow_invoices'] == 1)
				$customer_error = _("The selected customer account is currently on hold. Please contact the credit control personnel to discuss.");
		}
	}

	if(check_feild_status_of_invoice_form("Reference", 10)['status_mbl'] == 1)
		ref_row(_("Reference").':', 'ref', _('Reference number unique for this document type'), null, '', $order->trans_type, array('date'=> @$_POST['OrderDate']));
	else{
		global  $Refs;
		hidden('ref', $Refs->get_next($order->trans_type));
	}
	

	// table_section(2);

	if (!is_company_currency($order->customer_currency) && in_array($order->trans_type, array(ST_SALESINVOICE, ST_CUSTDELIVERY)))
	{
		if(check_feild_status_of_invoice_form("Customer Currency", 10)['status_mbl'] == 1)
			label_row(_("Customer Currency:"), $order->customer_currency);
		if(check_feild_status_of_invoice_form("Exchange Rate", 10) == 1)
			exchange_rate_display(get_company_currency(), $order->customer_currency, ($editable ? $_POST['OrderDate'] : $order->document_date));
	}
	
	if(check_feild_status_of_invoice_form("Current Credit", 10)['status_mbl'] == 1)
		customer_credit_row($_POST['customer_id'], $order->credit);
	
	if(check_feild_status_of_invoice_form("Customer Discount", 10)['status_mbl'] == 1)
		label_row(_("Customer Discount:"), ($order->default_discount * 100) . "%");

	// table_section(3);
	start_row();
	if (($order->pos['cash_sale'] || $order->pos['credit_sale']) 
		&& !$order->is_started()) {
		 // editable payment type 
		if (get_post('payment') !== $order->payment) {
			$order->payment = get_post('payment');
			$order->payment_terms = get_payment_terms($order->payment);
			$order->due_date = get_invoice_duedate($order->payment, $order->document_date);
			if ($order->payment_terms['cash_sale']) {
				$_POST['Location'] = $order->Location = $order->pos['pos_location'];
				$order->location_name = $order->pos['location_name'];
			}
			$Ajax->activate('items_table');
			$Ajax->activate('delivery');
		}
		$paymcat = !$order->pos['cash_sale'] ? PM_CREDIT : 
			(!$order->pos['credit_sale'] ? PM_CASH : PM_ANY);
		// all terms are available for SO
		$is_order = in_array($order->trans_type, array(ST_SALESQUOTE, ST_SALESORDER));

		if(check_feild_status_of_invoice_form("Payment", 10)['status_mbl'] == 1)
			sale_payment_list_cells(_('Payment:'), 'payment', $is_order ? PM_ANY : $paymcat, null, true, $is_order);
		else
			hidden('payment', $is_order ? PM_ANY : $paymcat);


	} else {
		if(check_feild_status_of_invoice_form("Payment", 10)['status_mbl'] == 1)
			label_cells(_('Payment:'), $order->payment_terms['terms'], "class=''");
	}
	end_row();

	if($editable) {
		if(check_feild_status_of_invoice_form("Price List", 10)['status_mbl'] == 1)
			$str = sales_types_list_row(_("Price List:"), 'sales_type', null, true);
		else{
			$_POST['sales_type'] = $order->sales_type;
			hidden('sales_type' , $order->sales_type);
		}
	} else {
		if(check_feild_status_of_invoice_form("Price List", 10)['status_mbl'] == 1)
			label_row(_("Price List:"), $order->sales_type_name);
	}
	if ($order->sales_type != $_POST['sales_type']) {
		$myrow = get_sales_type($_POST['sales_type']);
		$order->set_sales_type($myrow['id'], $myrow['sales_type'],
			$myrow['tax_included'], $myrow['factor']);
		$Ajax->activate('sales_type');
		$change_prices = 1;
	}

	// table_section(4);

	if ($editable)
	{
		if (!isset($_POST['OrderDate']) || $_POST['OrderDate'] == "")
			$_POST['OrderDate'] = $order->document_date;

		if(check_feild_status_of_invoice_form("Date", 10)['status_mbl'] == 1)
			date_row($date_text, 'OrderDate', _('Date of order receive'), $order->trans_no==0, 0, 0, 0, null, true);
		else{
				$_POST['OrderDate'] = $order->document_date;
				hidden('OrderDate', $order->document_date);
			}

		if (isset($_POST['_OrderDate_changed']) || list_updated('payment')) {
			if (!is_company_currency($order->customer_currency) 
				&& (get_base_sales_type()>0)) {
					$change_prices = 1;
			}
			$Ajax->activate('_ex_rate');
			if ($order->trans_type == ST_SALESINVOICE) {
				$_POST['delivery_date'] = get_invoice_duedate(get_post('payment'), get_post('OrderDate'));
			} else 
				$_POST['delivery_date'] = add_days(get_post('OrderDate'), $SysPrefs->default_delivery_required_by());
			$Ajax->activate('items_table');
			$Ajax->activate('delivery_date');
		}
		if ($order->trans_type != ST_SALESORDER && $order->trans_type != ST_SALESQUOTE)
		{	// 2008-11-12 Joe Hunt added dimensions
			$dim = get_company_pref('use_dimension');
			if ($dim > 0){
				if(check_feild_status_of_invoice_form("Dimension", 10)['status_mbl'] == 1)
					dimensions_list_row(_("Dimension").":", 'dimension_id',  null, true, ' ', false, 1, false);
				else
					hidden('dimension_id', 0);
			}
			else
				hidden('dimension_id', 0);
			if ($dim > 1){
				if(check_feild_status_of_invoice_form("Dimension 2", 10)['status_mbl'] == 1)
					dimensions_list_row(_("Dimension")." 2:", 'dimension2_id', null, true, ' ', false, 2, false);
				else
					hidden('dimension2_id', 0);
			}
			else
				hidden('dimension2_id', 0);
		}	
	}
	else
	{
		label_row($date_text, $order->document_date);
		hidden('OrderDate', $order->document_date);
	}

	if ($order->trans_type == ST_SALESORDER) {	
			check_cells(_('Add automated Work Order'),'is_wo',null,true);
		}

		if ($_POST['is_wo'] == 1) {
			date_row(_("Required Date"), 'wo_required_date', _('Work Order required date.'),
				$order->trans_no==0, 0, 0, 0, null, true);
			$Ajax->activate('_page_body');
		}else{
			$Ajax->activate('_page_body');
		}

//specification_with_without(_('Specification'), 'spec_need', $selected_id=null, $submit_on_change=true);

	if ($change_prices != 0) {
		foreach ($order->line_items as $line_no=>$item) {
			$line = &$order->line_items[$line_no];
			$line->price = get_kit_price($line->stock_id, $order->customer_currency,
				$order->sales_type, $order->price_factor, get_post('OrderDate'));
		}
	    $Ajax->activate('items_table');
	}



	// table_section();

	// table_section(5);
	div_start('image',null,false,'style=""');
    if (list_updated('stock_id') && file_exists(company_path().'/images/'.item_img_name($_POST['stock_id']).".jpg")) 
	{
	 
		$stock_img_link = "<img id='item_img' alt = '[".$_POST['stock_id'].".jpg".
			"]' class='img-thumbnail '  src='".company_path().'/images/'.item_img_name($_POST['stock_id']).
			".jpg?nocache=".rand()."'"."    style='      height: 130px;
    	width: 130px;     
 		' border='0' onclick='view_img(this)'>";
		$check_remove_image = true;
		label_row("&nbsp;                                   ", $stock_img_link);
		br();
	} 
    div_end();
	end_table(); // outer table
	return $customer_error;
}
// adding function 
function display_order_summary_for_mobile($title, &$order, $editable_items=false)
{
	global $Ajax;


    div_start('items_table');
	//start_table(TABLESTYLE2, 'width:90% !important ;');
	
	
	$id = find_submit('Edit');
	$total = 0;
	$k = 0;  //row colour counter
	if (count($order->line_items))
	     $th[]= '';


	$low_stock = $order->check_qoh($_POST['OrderDate'], $_POST['Location']);

	

	//end_table();
	br(2);

	
	//table_header($th);
	foreach (array_reverse($order->get_items(), true) as $line_no=>$stock_item)
	{

		$line_total = round(($stock_item->qty_dispatched * $stock_item->price ) - $stock_item->discount_percent,
		   user_price_dec());

		$qoh_msg = '';
		/*if (!$editable_items || $id != $line_no)
		{*/
		start_table(TABLESTYLE2, 'width:90% !important ;', 10);
		start_row();

        line_item_image_for_mobile($stock_item->stock_id,get_kit_price($stock_item->stock_id,
			$order->customer_currency, $order->sales_type,
			$order->price_factor, get_post('OrderDate')) ,$stock_item->item_description,1);

        $dec = get_qty_dec($stock_item->stock_id);

        echo "<td>";
        
        echo "<div> <b>Item Code</b>   &nbsp;&nbsp;&nbsp;:  ";
        view_stock_status($stock_item->stock_id);
        echo "</div>";
        echo "<div> <b>Description</b>   :  ".$stock_item->item_description."</div>";
        echo "<div> <b>Quantity</b>   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:  ".number_format2($stock_item->qty_dispatched , $dec)."  ".$stock_item->units."</div>";
        echo "<div> <b>Price</b>    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:  ".number_format2($stock_item->price,2)."</div>";
        echo "<div> <b>Discount</b>   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:  ".number_format2($stock_item->discount_percent, 1)."</div>";
        echo "<div> <b>Total Price</b>   &nbsp;&nbsp;&nbsp;:  ".number_format2($line_total, 2)."</div>";

        	//view_stock_status_cell($stock_item->stock_id);
        echo "</td>";

        end_row();  

        start_row("style='border : 2px solid #2cace3;'");
        if ($editable_items)
			{
				edit_button_cell("Edit$line_no", _("Edit"),
				_('Edit document line'));
				delete_button_cell("Delete$line_no", _("Delete"),
				_('Remove line from document'));
			}
		end_row();
		end_table();

			
			//view_stock_status_cell($stock_item->stock_id.' - '.$stock_item->item_description );
			
			// label_cell($stock_item->item_description);
			
			// if(list_updated('stock_id1'))
			// {
			//     label_cell("");
			// }



			
			//qty_cell($stock_item->qty_dispatched, false, $dec,null,false,true);

			// if ($order->trans_no!=0)
			// 	qty_cell($stock_item->qty_done, false, $dec,null,false,true);

			// label_cell($stock_item->units);
			//amount_cell($stock_item->price);

			// percent_cell($stock_item->discount_percent,false,null,true);
			// amount_cell($line_total);

			// if ($editable_items)
			// {
			// 	edit_button_cell("Edit$line_no", _("Edit"),
			// 	_('Edit document line'));
			// 	delete_button_cell("Delete$line_no", _("Delete"),
			// 	_('Remove line from document'));
			// }
			// end_row();
		//}
		/*else
		{
			sales_order_item_controls_for_mobile($order, $k,  $line_no, $spec_headers_name, $spec_headers_id);
		}*/

		$total += $line_total;
	}


	$colspan = 6;
	if ($order->trans_no!=0)
		++$colspan;
	if($order->line_items){
		start_table(TABLESTYLE2, 'width:90% !important ;', 10);
		start_row();
		label_cell("");
		
		label_cell(_("Shipping Charge"), "colspan=$colspan align=right");
		small_amount_cells(null, 'freight_cost', price_format(get_post('freight_cost',0)));
		label_cell('', 'colspan=2');
		end_row();
		label_cell("");
		$display_sub_total = price_format($total + input_num('freight_cost'));
		label_cells(_("Sub-total"), $display_sub_total, "colspan=$colspan align=right","align=left", 2);
			label_cell('', 'colspan=2');
		$taxes = $order->get_taxes(input_num('freight_cost'));
		$tax_total = display_edit_tax_items($taxes, 7, $order->tax_included, 2);

		$display_total = price_format(($total + input_num('freight_cost') + $tax_total));

		start_row();
		label_cell("");
		label_cells(_("Amount Total"), $display_total, "colspan=$colspan align=right","align=left");
		submit_cells('update', _("Update"), "colspan=2 align='left'", _("Refresh"), true);
		end_row();
		end_table();
	
	if ($low_stock)
		display_note(_("Marked items have insufficient quantities in stock as on day of delivery."), 0, 1, "class='stockmankofg'");
	}
    div_end();
}

function sales_order_item_controls_for_mobile($title, &$order){
    global $Ajax;
    
    $itm_Name=get_items_name_description(get_post('stock_id1'));
	$check_desc_language = check_description_language($order->line_items[$id]->stock_id); //note: english 1, // arabic 0


	if (list_updated('stock_id1')) {   
		$Ajax->activate('mobile_form');
	}

	display_heading($title);

	$id = find_submit('Edit');
	if ($id != -1){
		foreach ($order->line_items as $line_no=>$stock_item){
			if ($line_no !=-1 && $line_no == $id) // edit old line
			{
				$_POST['stock_id'] = $order->line_items[$id]->stock_id;
				$dec = get_qty_dec($_POST['stock_id']);
				$_POST['qty'] = number_format2($order->line_items[$id]->qty_dispatched, $dec);
				$_POST['price'] = price_format($order->line_items[$id]->price);
				$_POST['Disc'] = percent_format($order->line_items[$id]->discount_percent);
				$units = $order->line_items[$id]->units;
				$_POST['item_description'] = $order->line_items[$id]->item_description;
				hidden('stock_id', $_POST['stock_id']);
				if ($_POST['is_wo'] == 1) {

				hidden('wo_type',2);// for advance manufacturing
				}
		        /*line_item_image($order->line_items[$id]->stock_id,get_kit_price($order->line_items[$id]->stock_id,
				$order->customer_currency, $order->sales_type,
				$order->price_factor, get_post('OrderDate')) ,$order->line_items[$id]->item_description);*/

				label_row( "Item Code", $_POST['stock_id'] );

				$itm_Name=get_items_name_description(get_post('stock_id1'));
				$check_desc_language = check_description_language($order->line_items[$id]->stock_id); //note: english 1, // arabic 0
				if ($order->line_items[$id]->descr_editable){
					if($check_desc_language == 0) // for arabic text box
					{
						start_row();
						text_cells_arbic(_("Description"), 'item_description', 50, 50 , null,null,null,null,true, 1);
						end_row();
					}
					else// for english text box
					{
						start_row();
						text_cells(_("Description"), 'item_description', null, 25, 50,_('Item Name'));
						end_row();
					}
			}else 
			{ 
				if($check_desc_language == 0) // for arabic text box
				{	
					start_row();
					text_cells_arbic(_("Description"), 'item_description', 50, 50 , $_POST['item_description'],null,null,null,true, 1);
					end_row();
				}
				else// for english text box
				{
					start_row();
					text_cells(_("Description"), 'item_description', $_POST['item_description'], 25, 50,_('Item Name'));
					end_row();
				}
			}
		// textarea_cells(null,'item_description', null, 45, 2);

	   		$Ajax->activate('mobile_form');
	   	}
	   }
	}
	else	// prepare new line
	{   
	    
		
		start_row();
		if (isset($_POST['bar_code'])) {
						unset($_POST['bar_code']);
						$Ajax->activate('bar_code');
						set_focus('bar_code');
					}
	   	ref_row(_('Barcode'), 'bar_code', '',null, true);
		label_cell("Item Code");
	    label_cell($_POST['stock_id1'], '', 'stock_id' );
		end_row();
		
		hidden('stock_id', $_POST['stock_id1']);
		if (list_updated('stock_id1')) {  
			$Ajax->activate('items_table');
			$Ajax->activate('image');	    
		}

		if ($order->fixed_asset){
		    if (!list_updated('stock_id1')){
		    	start_row();
				stock_disposable_fa_list_cells(_("Description"),'stock_id1', null, _('[Select item]'), true, $order->line_items);
				end_row();
			}else{
			    $itm_Name=get_items_name_description(get_post('stock_id1'));
			    start_row();
				text_cells(_("Description"), 'stock_name', $itm_Name['description'], 25, 50,_('Item Name'));
				end_row();
			}
		}
		else{
			if (!list_updated('stock_id1')){
				start_row();
				sales_items_list_cells(_("Description"), 'stock_id1', null, false, true, true);
				end_row();
			}else{
				$check_desc_language = check_description_language(get_post('stock_id1')); //note: english 1, // arabic 0
				
				start_row();
				if($check_desc_language == 0) // for arabic text box
				{
					text_cells_arbic(_("Description"), 'stock_name', 50, 50 , $itm_Name['description'],null,null,null,true, 1);
				}
				else// for english text box
				{
					text_cells(_("Description"), 'stock_name', $itm_Name['description'], 25, 50,_('Item Name'));
				}	
				remove_button_cell("AAA", ("AAA"), ('Cancel'));
				end_row();
			}
		}
		
		item_spec_list_cells("Item Specification", 'item_specs', null, $_POST['stock_id1']);
		if (get_post('AAA')){
			$Ajax->activate('mobile_form');
		}

		$item_info = get_item_edit_info($_POST['stock_id']);
		$units = $item_info["units"];
		$dec = $item_info['decimals'];
		$_POST['qty'] = number_format2(1, $dec);
		$price = get_kit_price($_POST['stock_id'],
			$order->customer_currency, $order->sales_type,
			$order->price_factor, get_post('OrderDate'));
		$_POST['price'] = price_format($price);
		// default to the customer's discount %
		$_POST['Disc'] = percent_format($order->default_discount);
	}




	if ($order->fixed_asset) {
		start_row();
		label_cell("Quantity");
		label_cell(1, '', 'qty');
		end_row();
		hidden('qty', 1);
	} 
	else{ 
		start_row();
		label_cell("Quantity");
		qty_cells(null, 'qty', $_POST['qty'], null, null, $dec);
		end_row();
	}

	 if ($_POST['is_wo'] == 1) {
        	// echo "<td>".wo_types_list('wo_type', null,false,false)."</td>";
        	hidden('wo_type',2);// for advance manufacturing
	    }
	if ($order->trans_no!=0) {
		start_row();
		label_cell("Quantity");
		qty_cell($line_no==-1 ? 0 :$order->line_items[$line_no]->qty_done, false, $dec);
		end_row();
	}
	start_row();
	label_cell("Unit");
	label_cell($units, '', 'units');
	end_row();
	
	start_row();
	label_cell("Price before Tax");
	amount_cells(null, 'price');
	end_row();

	start_row();
	label_cell("Discount");
	small_amount_cells(null, 'Disc', percent_format($_POST['Disc']), null, '', user_percent_dec());
	end_row();
		$discount_value = $order->discount_criteria ? input_num('Disc') : 
					  (input_num('qty')*input_num('price'))*input_num('Disc')/100;

	$line_total = ( input_num('qty') * input_num('price') ) - $discount_value ;


	if ($id!=-1)
	{
		button_cell('UpdateItem', _("Update"),
				_('Confirm changes'), ICON_UPDATE);
		button_cell('CancelItemChanges', _("Cancel"),
				_('Cancel changes'), ICON_CANCEL);
		hidden('LineNo', $line_no);
		set_focus('qty');
	}
	else
	{
		submit_cells('AddItem', _("Add Item"), "colspan=2 align='left'",
		    _('Add new item to document'), true);
	}


}
function display_delivery_details_for_mobile(&$order)
{
	global $Ajax;

	div_start('delivery');	


	if ($order->payment_terms['cash_sale']) {	// Direct payment sale
		$Ajax->activate('items_table');
		display_heading(_('Cash payment'));
		//($_GET['NewOrder']=='Yes' ? 'width: 38% !important;' :'width: 100% !important;'  )
		start_table(TABLESTYLE2, 'width:90% !important ;');



		locations_list_row(_("Deliver from Location:"), 'Location', null, false, true);
 		if (list_updated('Location'))
 			$Ajax->activate('items_table');
		label_row(_("Cash account:"), $order->pos['bank_account_name']);
		textarea_row(_("Comments:"), "Comments", $order->Comments, 31, 5);
		end_table();
		hidden('delivery_date', $order->due_date);
		// hidden('email',($order->email);)
	} else {
		if ($order->trans_type==ST_SALESINVOICE)
		{
			$title = _("Delivery Details");
			$delname = _("Due Date").':';
		}
		elseif ($order->trans_type==ST_CUSTDELIVERY)
		{
			$title = _("Invoice Delivery Details");
			$delname = _("Invoice before").':';
		}
		elseif ($order->trans_type==ST_SALESQUOTE)
		{
			$title = _("Quotation Delivery Details");
			$delname = _("Valid until").':';
		}
		else
		{
			$title = _("Order Delivery Details");
			$delname = _("Required Delivery Date").':';
		}
		display_heading($title);
		if($title=="Order Delivery Details")
			start_table(TABLESTYLE2,  "style='width: 79% !important'");
	    else if($title=="Quotation Delivery Details"|| $title=="Invoice Delivery Details"||$title=="Delivery Details")
			start_table(TABLESTYLE2,"style='width: 100% !important'");
	    else
			start_table(TABLESTYLE2,"style='width: 87% !important;'");
		// table_section(1);

		locations_list_row(_("Deliver from Location:"), 'Location', null, false, true, $order->fixed_asset);
		if ($order->payment_terms['days_before_due'] == -1)
		{
			$Ajax->addUpdate('items_table', 'prep_amount', price_format($order->get_trans_total())); // bind to items_table update
			if (!$order->is_started())
				amount_row(_("Pre-Payment Required:"), 'prep_amount');
			else
				label_row(_("Pre-Payment Required:"), price_format($order->prep_amount), "class=''");
		}
		if (list_updated('Location'))
			$Ajax->activate('items_table');


		date_row($delname, 'delivery_date',
			$order->trans_type==ST_SALESORDER ?  _('Enter requested day of delivery') 
				: $order->trans_type==ST_SALESQUOTE ? _('Enter Valid until Date') : '');
	$user_id=($_SESSION["wa_current_user"]->user);// Current User online Id
	$myrow=get_user($user_id);// Putting User Id Into it to fetch customer_id From USers Table
		if($myrow['customer_id']>=1)
		text_row(_("Deliver To:"), 'deliver_to', get_branch_name($myrow['branch_id']), 50, 60,
			_('Additional identifier for delivery e.g. name of receiving person'));
		else
		text_row(_("Deliver To:"), 'deliver_to', $order->deliver_to, 50, 60,
			_('Additional identifier for delivery e.g. name of receiving person'));

		textarea_row(_("Address:"), 'delivery_address', $order->delivery_address, 35, 5,
			_('Delivery address. Default is address of customer branch'));

		// table_section(2);
		text_row(_("Contact Phone Number:"), 'phone', $order->phone, 25, 25,
		    _('Phone number of ordering person. Defaults to branch phone number'));
		text_row(_("Customer Reference:"), 'cust_ref', $order->cust_ref, 25, 25,
		  _('Customer reference number for this order (if any)'));
		textarea_row(_("Comments:"), "Comments", $order->Comments, 31, 5);

		shippers_list_row(_("Shipping Company:"), 'ship_via', $order->ship_via);

		end_table(1);
	}
	div_end();
}


?>
<script type="text/javascript">
	function open_loyality(customer_id,cust_phone,cust_email,country_code){
			window.open("inquiry/loyality_dashboard.php?customer_id="+customer_id+"&phone="+cust_phone+"&email="+cust_email+"&country_code="+country_code, "child", "toolbar=no,scrollbars=no,resizable=yes,top=70,left=10,width=1000,height=590,location=no, title=no");
		}
</script>
<style>

#myImg {
    border-radius: 5px;
    cursor: pointer;
    transition: 0.3s;
}

#myImg:hover {opacity: 2;}

/* The Modal (background) */
.modal .modal_n {
    /*display: block;*/

    display: none; /* Hidden by default */
    position: fixed; /* Stay in place */
    z-index: 2; /* Sit on top */
    padding-top: 100px; /* Location of the box */
    left: 0;
    top: 10px;
    width: 100%; /* Full width */
    height: 100%; /* Full height */
    overflow: auto; /* Enable scroll if needed */
    background-color: rgb(0,0,0); /* Fallback color */
    background-color: rgba(0,0,0,0.9); /* Black w/ opacity */
}

/* Modal Content (image) */
.modal-content .modal_m {

    margin: auto;
    display: block;
    width: 50%;
    max-width: 400px;
}

/* Caption of Modal Image */
#caption {
    margin: auto;
    display: block;
    width: 80%;
    max-width: 700px;
    text-align: center;
    color: #ccc;
    padding: 10px 0;
    height: 150px;
}

/* Add Animation */
.modal-content .modal_m, #caption {    
    -webkit-animation-name: zoom;
    -webkit-animation-duration: 0.6s;
    animation-name: zoom;
    animation-duration: 0.6s;
}

@-webkit-keyframes zoom {
    from {-webkit-transform:scale(0)} 
    to {-webkit-transform:scale(1)}
}

@keyframes zoom {
    from {transform:scale(0)} 
    to {transform:scale(1)}
}

/* The Close Button */
.close {
    position: absolute;
    top: 15px;
    right: 35px;
    color: #f1f1f1;
    font-size: 40px;
    font-weight: bold;
    transition: 0.3s;
}

.close:hover,
.close:focus {
    color: #bbb;
    text-decoration: none;
    cursor: pointer;
}

/* 100% Image Width on Smaller Screens */
@media only screen and (max-width: 700px){
    .modal-content .modal_m {
        width: 100%;
    }
}


.zoom {
    padding: 50px;
    background-color: green;
    transition: transform .2s;
    width: 200px;
    height: 200px;
    margin: 0 auto;
}

.zoom:hover {
    -ms-transform: scale(1.3);  IE 9 
    -webkit-transform: scale(1.3); /* Safari 3-8 */
    transform: scale(1.3); 
}

#section1{

width:213px;
    /*padding: 0px 0px 0px 4px;*/
    /*margin: -30px 0px 0px 0px;*/
    font-size: 12px !important;
    float: left;
    /*text-decoration: underline;*/
    text-align: -webkit-auto;
    line-height: 20px;

}
#section2{

	width: 348px;
	/*padding: 3px 40px 0px 0px;*/
    /*margin: -30px 0px 0px 0px;*/
    font-size: 12px !important;
    float: left;
    /*text-decoration: underline;*/
    text-align: -webkit-auto;
    line-height: 20px;
    /*box-shadow: -6px 4px 11px -9px*/
        border-left: 2px solid #0e909d;

}
.divider {
  width: 2px;
  margin: 6px 0;
      background: #464c54;
    box-shadow: -5px 0px 0px 1px;
}
.divider h3{
    color: #464c54;
    font-weight: 900;
/*    text-decoration-line: underline;
    text-decoration-style: double;*/

}

</style>
