<?php

if (isset($_GET['tab_view'])) {
$path_to_root = "..";
}
else
$path_to_root = "../..";


include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");


$page_security = 'SA_SALESTRANSVIEW';

set_page_security( @$_POST['order_view_mode'],
	array(	'OutstandingOnly'   => 'SA_SALESORDERDELIVERY',
			'InvoiceTemplates'  => 'SA_SALESINVOICETEMPLATES',
			'DeliveryTemplates' => 'SA_SALESTEMPLATEDELIVERY',
			'PrepaidOrders'     => 'SA_SALESINVOICEPREPAID',
	         ST_SALESQUOTE      => 'SA_SALESQUOTATIONINQUIRY',
	         ST_SALESORDER      => 'SA_SALESORDERINQUIRY'),
	array(	'OutstandingOnly'   => 'SA_SALESORDERDELIVERY',
			'InvoiceTemplates'  => 'SA_SALESINVOICETEMPLATES',
			'DeliveryTemplates' => 'SA_SALESTEMPLATEDELIVERY',
			'PrepaidOrders'     => 'SA_SALESINVOICEPREPAID',
		    'type'              => 'SA_SALESQUOTATIONINQUIRY',
		    'type'              => 'SA_SALESORDERINQUIRY')
);


// set_page_security( @$_POST['order_view_mode'],
// 	array(	'OutstandingOnly' => 'SA_SALESDELIVERY',
// 			'InvoiceTemplates' => 'SA_SALESINVOICE',
// 			'DeliveryTemplates' => 'SA_SALESDELIVERY',
// 			'PrepaidOrders' => 'SA_SALESINVOICE'),
// 	array(	'OutstandingOnly' => 'SA_SALESDELIVERY',
// 			'InvoiceTemplates' => 'SA_SALESINVOICE',
// 			'DeliveryTemplates' => 'SA_SALESDELIVERY',
// 			'PrepaidOrders' => 'SA_SALESINVOICE')
// );

if (get_post('type'))
	$trans_type = $_POST['type'];
elseif (isset($_GET['type']) && $_GET['type'] == ST_SALESQUOTE)
	$trans_type = ST_SALESQUOTE;
else
	$trans_type = ST_SALESORDER;

if ($trans_type == ST_SALESORDER)
{   	$Ajax->activate('ext_tbl');
	if (isset($_GET['OutstandingOnly']) && ($_GET['OutstandingOnly'] == true))
	{
		$_POST['order_view_mode'] = 'OutstandingOnly';
		$_SESSION['page_title'] = _($help_context = "Search Outstanding Sales Orders");
	}
	elseif (isset($_GET['InvoiceTemplates']) && ($_GET['InvoiceTemplates'] == true))
	{
		$_POST['order_view_mode'] = 'InvoiceTemplates';
		$_SESSION['page_title'] = _($help_context = "Search Template for Invoicing");
	}
	elseif (isset($_GET['DeliveryTemplates']) && ($_GET['DeliveryTemplates'] == true))
	{
		$_POST['order_view_mode'] = 'DeliveryTemplates';
		$_SESSION['page_title'] = _($help_context = "Select Template for Delivery");
	}
	elseif (isset($_GET['PrepaidOrders']) && ($_GET['PrepaidOrders'] == true))
	{
		$_POST['order_view_mode'] = 'PrepaidOrders';
		$_SESSION['page_title'] = _($help_context = "Invoicing Prepayment Orders");
	}
	elseif (!isset($_POST['order_view_mode']))
	{
		$_POST['order_view_mode'] = false;
		$_SESSION['page_title'] = _($help_context = "Search All Sales Orders");
	}
}
else
{
	$_POST['order_view_mode'] = "Quotations";
	$_SESSION['page_title'] = _($help_context = "Search All Sales Quotations");
}

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 600);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page($_SESSION['page_title'], false, false, "", $js);
//---------------------------------------------------------------------------------------------
//	Query format functions
//

function check_overdue($row)
{
	global $trans_type;
	if ($trans_type == ST_SALESQUOTE)
		return (date1_greater_date2(Today(), sql2date($row['delivery_date'])));
	else
		return ($row['type'] == 0
			&& date1_greater_date2(Today(), sql2date($row['delivery_date']))
			&& ($row['TotDelivered'] < $row['TotQuantity']));
}

function check_overdue2($row){

	$so_details = get_sales_order_details($row['order_no'], ST_SALESORDER);
	while($so_line = db_fetch($so_details)){
		if(key_in_foreign_table($so_line['id'], 'schedules', 'soline'))
			return true;
		else 
			return false;
	}

}

function view_link($dummy, $order_no)
{
	global $trans_type, $path_to_root;
	return  get_customer_trans_view_str($trans_type, $order_no, "", false, '', '', $path_to_root);
}

function prt_link($row)
{	global $trans_type;
	if(!$_SESSION['wa_current_user']->can_access_page('SA_SALESEQUOTATIONREPORT') && $trans_type == ST_SALESQUOTE){
		return '';
	}

	return print_document_link($row['order_no'], _("Print"), true, $trans_type, ICON_PRINT);
}

function edit_link($row) 
{
	global $page_nested, $trans_type;
	if(!$_SESSION['wa_current_user']->can_access_page('SA_SALESORDERMODIFY') && $trans_type == ST_SALESORDER )
		return '';

	if (is_prepaid_order_open($row['order_no']))
		return '';

	return $page_nested ? '' : trans_editor_link($row['trans_type'], $row['order_no']);
}



function attach($row){
	if(!$_SESSION['wa_current_user']->can_access_page('SA_ATTACHDOCUMENT'))
		return '';
	else
		return pager_link(_("Link Document"), $path_to_root."/admin/attachments.php?filterType=".$row['trans_type']."&trans_no=".$row['order_no'], ICON_ATTACH);
}

function dispatch_link($row)
{
	global $trans_type;

	if ($row['ord_payments'] + $row['inv_payments'] < $row['prep_amount'])
 		return '';

 	if(!$_SESSION['wa_current_user']->can_access_page('SA_DISPATACHITEMSAGAINSTSO') && $trans_type == ST_SALESORDER){
 		return '';
 	}

	if ($trans_type == ST_SALESORDER)
  		return pager_link( _("Dispatch"),
			"/sales/customer_delivery.php?OrderNumber=" .$row['order_no'], ICON_DOC);
	else
  		return pager_link( _("Sales Order"),
			"/sales/sales_order_entry.php?OrderNumber=" .$row['order_no'], ICON_DOC);
}

function invoice_link($row)
{
	global $trans_type;
	if ($trans_type == ST_SALESORDER)
  		return pager_link( _("Invoice"),
			"/sales/sales_order_entry.php?NewInvoice=" .$row["order_no"], ICON_DOC);
	else
		return '';
}

function delivery_link($row)
{
  return pager_link( _("Delivery"),
	"/sales/sales_order_entry.php?NewDelivery=" .$row['order_no'], ICON_DOC);
}

function order_link($row)
{
	if(!$_SESSION['wa_current_user']->can_access_page('SA_SALESNEWQUOTETOSALEORDER')){
			return '';
	}
  return pager_link( _("Sales Order"),
	"/sales/sales_order_entry.php?NewQuoteToSalesOrder=" .$row['order_no'], ICON_DOC);
}

function tmpl_checkbox($row)
{
	global $trans_type, $page_nested;

	if ($trans_type == ST_SALESQUOTE || !check_sales_order_type($row['order_no']))
		return '';

	if ($page_nested)
		return '';
	$name = "chgtpl" .$row['order_no'];
	$value = $row['type'] ? 1:0;

// save also in hidden field for testing during 'Update'

 return checkbox(null, $name, $value, true,
 	_('Set this order as a template for direct deliveries/invoices'))
	. hidden('last['.$row['order_no'].']', $value, false);
}

function invoice_prep_link($row)
{
	// invoicing should be available only for partially allocated orders
	return 
		$row['inv_payments'] < $row['total'] ?
		pager_link($row['ord_payments']  ? _("Prepayment Invoice") : _("Final Invoice"),
		"/sales/customer_invoice.php?InvoicePrepayments=" .$row['order_no'], ICON_DOC) : '';
}

function checkOwner($user_id = null)
{
	$sql = " SELECT * FROM ".TB_PREF."users WHERE id = ".db_escape($user_id)." AND owner = ".db_escape(1)." ";
	$run = db_query($sql, "Couldnot run checkowner()");
	$ft = db_fetch($run);
	$numOfRows = db_num_rows($run);
	return $numOfRows;

}

function show_project($row){
	if(!$row['dimension_id'])
		return '';
	return get_dimensions_trans_view_str(ST_DIMENSION, $row["dimension_id"]);
}

function show_site($row){
	if($row['dimension_id'])
		return get_dimension($row['dimension_id'])['name'];
	else return '';
}

function approved_link($row){
	$name = "approved".$row['order_no'];
	$value = $row['approved'] ? 1:0;

	return checkbox(null, $name,$value , true, _('Approved this quotation'))
	. hidden('last['.$row['order_no'].']', $value, false);
}



$id = find_submit('_approved');
if ($id != -1){
	salesQuotationSetApprove($id, check_value('approved'.$id));
	$trans_type = ST_SALESQUOTE;
	$_GET['type'] = ST_SALESQUOTE;
	$_POST['show_unapproved'] = 1;
	$Ajax->activate('orders_tbl');
}


$id = find_submit('_chgtpl');
if ($id != -1)
{
	sales_order_set_template($id, check_value('chgtpl'.$id));
	$Ajax->activate('orders_tbl');
}

if (isset($_POST['Update']) && isset($_POST['last'])) {
	foreach($_POST['last'] as $id => $value)
		if ($value != check_value('chgtpl'.$id))
			sales_order_set_template($id, !check_value('chgtpl'.$id));
}

$show_dates = !in_array($_POST['order_view_mode'], array('OutstandingOnly', 'InvoiceTemplates', 'DeliveryTemplates'));
//---------------------------------------------------------------------------------------------
//	Order range form
//
if (get_post('_OrderNumber_changed') || get_post('_OrderReference_changed')) // enable/disable selection controls
{
	$disable = get_post('OrderNumber') !== '' || get_post('OrderReference') !== '';

  	if ($show_dates) {
		$Ajax->addDisable(true, 'OrdersAfterDate', $disable);
		$Ajax->addDisable(true, 'OrdersToDate', $disable);
	$Ajax->activate('orders_tbl');
	}
	// $Ajax->activate('OrdersAfterDate');
	// $Ajax->activate('OrdersToDate');


}

 div_start('ext_tbl');

start_form();

start_table(TABLESTYLE_NOBORDER);
start_row();
$checkowner = checkOwner($_SESSION['wa_current_user']->user);
// if($checkowner > 0 && isset($_GET['QuotToApprove']) )
// $_POST['OrderNumber'] = $_GET['QuotToApprove'];

ref_cells(_("#:"), 'OrderNumber', '',null, '', true);
ref_cells(_("Ref"), 'OrderReference', '',null, '', true);
if ($show_dates)
{
  	date_cells(_("from:"), 'OrdersAfterDate', '', null, -user_transaction_days(),0,0,null,true);
  	date_cells(_("to:"), 'OrdersToDate', '', null, 1);
}
locations_list_cells(_("Location:"), 'StockLocation', null, true, true);

if($show_dates) {
	end_row();
	end_table();

	start_table(TABLESTYLE_NOBORDER);
	start_row();
}
stock_items_list_cells(_("Item:"), 'SelectStockFromList', null, true, true);

if (!$page_nested)
	customer_list_cells(_("Select a Customer"), 'customer_id', null, true, true);

dimensions_list_cells(_("Site :"), 'dimension_id', null, _("Select Site"), ' ', false, 1, false);
	
	
if ($trans_type == ST_SALESQUOTE)
	check_cells(_("Show All:"), 'show_all');


if($checkowner > 0 && $trans_type == ST_SALESQUOTE){

	if(isset($_GET['QuotToApprove'])){
		$value = 1;
		
	}
	else
		$value = check_value('show_unapproved');
	check_cells(_("Show Unapproved :"), 'show_unapproved',$value,true);
	
}

if(isset($_GET['QuotToApprove']))
	$_POST['show_unapproved'] = 1;

if(get_post('show_unapproved') == 1 || get_post('show_unapproved') == 0 )
	$Ajax->activate('ext_tbl');

// if(isset($_POST['OrdersToDate']) )
// 	$Ajax->activate('page_body');


if(isset($_POST['OrderNumber']) )
	$Ajax->activate('ext_tbl');
//PRINT BUTTON//
	// $orders_AD=get_post('OrdersAfterDate');
	// $orders_TD=get_post('OrdersToDate');
	// $stocklist=get_post('SelectStockFromList');
	// $orders_ref=get_post('OrderReference');
	// $stock_loc=get_post('StockLocation');
	// $cust_id=get_post('customer_id');
	// $doc_no=get_post('OrderNumber');
	// $view_mode=get_post('order_view_mode');
	// $type_no=get_post('order_view_mode');
	 // display_error($trans_type);
	// if ($trans_type == ST_SALESQUOTE){

if(isset($_POST['OrderNumber']) || isset($_POST['OrdersAfterDate']) )
	$Ajax->activate('ext_tbl');

	echo  "<td>". print_sal_dashboard_print(_("<img src =".$path_to_root."/themes/".user_theme()."/images/".ICON_PRINT.">"), true, $trans_type, null, '','', get_post('OrdersAfterDate'),get_post('OrdersToDate'), get_post('SelectStockFromList'), get_post('OrderReference'), get_post('StockLocation'),
get_post('customer_id'), get_post('OrderNumber'), get_post('order_view_mode') ,0, null, $_POST['dimension_id']) ."</td>"; 


	echo  "<td>". print_sal_dashboard_print(_("<img  style='width: 20px;' src =".$path_to_root."/themes/".user_theme()."/images/excel.png>"), true, $trans_type, null, '','', get_post('OrdersAfterDate'),get_post('OrdersToDate'), get_post('SelectStockFromList'), get_post('OrderReference'), get_post('StockLocation'),
get_post('customer_id'), get_post('OrderNumber'), get_post('order_view_mode') ,1, null, $_POST['dimension_id']) ."</td>"; 


// }

// else{
// 	echo  "<td>". print_dashboard_print( $doc_no, _("Print Dashboard"), true, $trans_type, false, 'btn btn-info','', get_post('OrdersAfterDate'),get_post('OrdersToDate'), get_post('SelectStockFromList'), get_post('OrderReference'), get_post('StockLocation') ,
// get_post('customer_id'), get_post('OrderNumber'), get_post('order_view_mode')  ) ."</td>"; 
// }

// echo  "<td>". print_document_link( $doc_no, _("Print Dashboard"), true, 850, false, 'btn btn-info','','','',
// 				 $view_mode, $stocklist, $orders_AD, $orders_TD, $orders_ref, $stock_loc, $cust_id, $trans_type) ."</td>";

	// ($doc_no, $link_text, $link=true, $type_no, 
	// $icon=false, $class='printlink', $id='', $email=0, $extra=0)


// function print_sal_dashboard_print($link_text, $link=true, $trans_type='', 
// 	$icon=false, $class='printlink', $id='',$from = '', $to = '', $stocklist= '', $ref='', $loc='' , $cust_id='', $order_no='', $order_view='',$destination=0 )

//-----------------------------------------------------------------------------------------------------------------

submit_cells('SearchOrders', _("Search"),'',_('Select documents'), 'default');
hidden('order_view_mode', $_POST['order_view_mode']);
hidden('type', $trans_type);

end_row();

end_table(1);
    div_end();
//---------------------------------------------------------------------------------------------
//	Orders inquiry table
//

if(get_post('show_unapproved') == 1 || get_post('show_unapproved') == null)
    $Ajax->activate('_page_body');

if($_POST['show_unapproved'] > 0)
	display_note(_("<p style='color:green;'>Search All Unapproved Sales Order.</p>"), 0, 0, "class='overduefg'");
else
	display_note(_("<p style='color:green;'>Search All Sales Order.</p>"), 0, 0, "class='overduefg'");


$sql = get_sql_for_sales_orders_view($trans_type, get_post('OrderNumber'), get_post('order_view_mode'),
	get_post('SelectStockFromList'), get_post('OrdersAfterDate'), get_post('OrdersToDate'), get_post('OrderReference'), get_post('StockLocation'),
	get_post('customer_id'), $_POST['show_unapproved'], null, $_POST['dimension_id']);
// display_error($sql);

if ($trans_type == ST_SALESORDER)
	$cols = array(
		_("Order&nbsp#") => array('fun'=>'view_link', 'align'=>'left'),
		_("Ref") => array('type' => 'sorder.reference', 'ord' => '') ,
		_("Customer") => array('type' => 'debtor.name' , 'ord' => '') ,
		_("Branch"), 
		_("Cust Order Ref"),
		_("Order Date") => array('type' =>  'date', 'ord' => ''),
		_("Required By") =>array('type'=>'date', 'ord'=>''),
		_("Delivery To"), 
		_("Order Total") => array('type'=>'amount', 'ord'=>''),
		'Type' => 'skip',
		_("Currency") => array('align'=>'center'),
		_("Project ID") => array('fun'=>'show_project', 'align'=>'left'),
        _("Site Name") => array('fun'=>'show_site', 'align'=>'left'),

	);
else
	$cols = array(
		_("Quote&nbsp#") => array('fun'=>'view_link', 'align'=>'left'),
		_("Ref"),
		_("Customer"),
		_("Branch"), 
		_("Cust Order Ref"),
		_("Quote Date") => 'date',
		_("Valid until") =>array('type'=>'date', 'ord'=>''),
		_("Delivery To"), 
		_("Quote Total") => array('type'=>'amount', 'ord'=>''),
		'Type' => 'skip',
		_("Currency") => array('align'=>'center')
	);
if ($_POST['order_view_mode'] == 'OutstandingOnly') {
	array_append($cols, array(
		array('insert'=>true, 'fun'=>'dispatch_link'),
		array('insert'=>true, 'fun'=>'edit_link')));

} elseif ($_POST['order_view_mode'] == 'InvoiceTemplates') {
	array_substitute($cols, 4, 1, _("Description"));
	array_append($cols, array( array('insert'=>true, 'fun'=>'invoice_link')));

} else if ($_POST['order_view_mode'] == 'DeliveryTemplates') {
	array_substitute($cols, 4, 1, _("Description"));
	array_append($cols, array(
			array('insert'=>true, 'fun'=>'delivery_link'))
	);
} else if ($_POST['order_view_mode'] == 'PrepaidOrders') {
	array_append($cols, array(
			array('insert'=>true, 'fun'=>'invoice_prep_link'))
	);

} elseif ($trans_type == ST_SALESQUOTE) {


if($_SESSION["wa_current_user"]->can_access_page('SA_SALESQUOTEMODIFY')){
	 array_append($cols,array(
				array('insert'=>true, 'fun'=>'edit_link')
				));
	}
	
	array_append($cols,array(
				array('insert'=>true, 'fun'=>'order_link'),
				array('insert'=>true, 'fun'=>'prt_link')));

	if($_POST['show_unapproved'] > 0)
		array_append($cols, array( _("Approve") => array('insert'=>true, 'fun'=>'approved_link')));

} elseif ($trans_type == ST_SALESORDER) {
	 array_append($cols,array(
			_("Tmpl") => array('insert'=>true, 'fun'=>'tmpl_checkbox')));

if($_SESSION["wa_current_user"]->can_access_page('SA_SALESORDERMODIFY')){
	 array_append($cols,array(array('insert'=>true, 'fun'=>'edit_link')));
	}

array_append($cols,array(
	array('insert'=>true, 'fun'=>'prt_link')));

}

array_append($cols,array(array('insert'=>true, 'fun'=>'attach')));


$table =& new_db_pager('orders_tbl', $sql, $cols);
$table->set_marker('check_overdue', _("Red marked orders are overdue,"));
$table->set_marker_sec('check_overdue2', _(" green marked orders are converted to schedule."), 'bg-green');

$table->width = "80% !important";

display_db_pager($table);
submit_center('Update', _("Update"), true, '', null);
echo'<br/>';
end_form();
end_page();
