<?php

$page_security = 'SA_SCHEDULEAGAINSTSO';
$path_to_root = "../..";
include($path_to_root . "/includes/db_pager.inc");
include($path_to_root . "/includes/session.inc");

include($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/CRM/includes/db/inquiry_type_db.inc");


$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 600);
if (user_use_date_picker())
	$js .= get_js_date_picker();


page(_($help_context = "Schedule Against SO"), false, false, "", $js);


//-----------------------------------------------------------------------------------------------------------------------
//Pager Helper Functions
function check_overdue($row){
	if(in_array($row['status'], array(1, 2)))
		return true;
	else 
		return false; 
}

function trans_view($row){
    global $path_to_root;
    
	return get_customer_trans_view_str(ST_SALESORDER, $row['order_no'], $row['reference'], false, '', '', $path_to_root);
}
function cust_name($row){
	return get_customer_name($row['debtor_no']);
}
function schedule($row){
	return pager_link(_('Schedule'), "/sales/schedule.php?order_no=".$row['order_no']."&line=".$row['id']."&schedule=1", ICON_DOC);
}
function complain($row){
	return pager_link(_('Complain'), "/sales/schedule.php?order_no=".$row['order_no']."&line=".$row['id']."&complain=1", ICON_DOC);
}
function maintenance($row){
	return pager_link(_('Maintenance'), "/sales/schedule.php?order_no=".$row['order_no']."&line=".$row['id']."&maintenance=1", ICON_DOC);
}
function history($row){
    global $path_to_root;
    
	return get_customer_trans_view_str(ST_SCHEDULE, $row['id'], "View History", false, '', '', $path_to_root);
}
function user_name($row){
	return get_user($row['user'])['real_name'];
}
function inquiry_type($row){
	return get_inquiry_type_name($row['inquiry_type']);
}
//------------------------------------------------------------------------------------------------------------------------

start_form();

start_table(TABLESTYLE_NOBORDER);

ref_cells(_("Sales Order Ref #:"), 'so_ref', '',null, '', true);
customer_list_cells(_("Customer"), 'customer', null, _("Select Customer"), true);

date_cells(_("SO From Date:"), 'FromDate', '', null, -user_transaction_days());
date_cells(_("SO To Date:"), 'ToDate', '', null, 1);

end_table();


start_table(TABLESTYLE_NOBORDER);

stock_items_list_cells(_("Item:"), 'stock_id', null, true);
user_list_cells("Created", 'user', null, true, false, _("Select User"));
generic_list_cells(_("Order Status"), 'status', array("Scheduled", "Not Scheduled"), null, _("Show All"), true);
inquiry_type_list_cells(_("Order Type"), 'order_type', null, false, _("Select Order Type"));
submit_cells('SearchOrders', _("Search"),'',_('Select documents'), 'default');

end_table(1);

$sql = get_sql_for_schedule_against_so($_POST['so_ref'], $_POST['customer'], $_POST['FromDate'], $_POST['ToDate'], $_POST['stock_id'], 
$_POST['user'], $_POST['status'], $_POST['order_type']);

$cols = array(
	_("S.No"), 
	_("Sales Order Ref") => array('fun'=>'trans_view'), 
	_("Sales Order Line Detail #"), 
	_("Customer Name") => array('fun'=>'cust_name'),
	_("Item"),
	_("Order Type") => array('fun'=> 'inquiry_type'), 
	_("Order Date") => array('type'=>'date'), 
	_("Created By") => array('fun'=>'user_name'),
	_("Schedule Against Order") => array('fun'=>'schedule'),
	_("Complain Against Order") => array('fun'=>'complain'),
	_("Maintenance Against Order") => array('fun'=>'maintenance'),
	_("View History") => array('fun'=>'history'),
);

$table =& new_db_pager('schedule_tbl', $sql, $cols);
$table->set_marker('check_overdue', _(" Green marked Schedules are converted to Job Cards."), 'bg-green');

display_db_pager($table);


end_page();
?>