<?php

$page_security = 'SA_JOBCARD';
$path_to_root = "..";

include_once($path_to_root . "/sales/includes/cart_class.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/taxes/tax_calc.inc");
include_once($path_to_root . "/sales/includes/ui/sales_order_ui.inc");
include_once($path_to_root . "/sales/includes/db/sales_types_db.inc");
include_once($path_to_root . "/sales/includes/ui/sales_order_ui.inc");
include_once($path_to_root . "/CRM/pages/includes/db/project_db.inc");
include_once($path_to_root . "/admin/db/attach_inquiry_db.inc");


echo '<link href="' . $path_to_root . '/admin/includes/signature/css/jquery.signaturepad.css" rel="stylesheet">';
echo '<script src="' . $path_to_root . '/admin/includes/signature/js/numeric-1.2.6.min.js"></script>'; 
echo '<script src="' . $path_to_root . '/admin/includes/signature/js/bezier.js"></script>';
echo '<script src="' . $path_to_root . '/admin/includes/signature/js/json2.min.js"></script>';
echo '<script type="text/javascript" src="https://github.com/niklasvh/html2canvas/releases/download/0.4.1/html2canvas.js"></script>';


$js = "";
if ($SysPrefs->use_popup_windows) {
	$js .= get_js_open_window(900, 500);
}
if (user_use_date_picker()) {
	$js .= get_js_date_picker();
}


page("Job Card Against Schedule", false, false, "", $js);

echo '<script src="' . $path_to_root . '/admin/includes/signature/js/jquery.signaturepad.js"></script> ';

 

if (isset($_GET['closed'])) {
	$dispatch_no = $_GET['closed'];
    echo '<ol class="rounded-list"><li>';
	display_notification_centered(sprintf(_("Job Card # %d has been closed."), $dispatch_no));
    echo '</li><li>';
	display_note(get_customer_trans_view_str(ST_CUSTDELIVERY, $dispatch_no, _("&View This Job Card"), false, '', '', $path_to_root, 
	basename($_SERVER['PHP_SELF']) ), 0, 1); 
	echo '</li><li>';
	display_note(print_document_link($dispatch_no, _("&Print Job Card"), true, ST_CUSTDELIVERY1));
	display_note(get_gl_view_str(13, $dispatch_no, _("View the GL Journal Entries for this Job Card")),1);
    echo '</li><li><span>';
	hyperlink_params("$path_to_root/sales/inquiry/schedule_inquiry.php", _("Select Another schedule"));
    echo '</span></li></ol>';
	display_footer_exit();
}

if (isset($_GET['draft'])) {
	$dispatch_no = $_GET['draft'];
    echo '<ol class="rounded-list"><li>';
	display_notification_centered(sprintf(_("Job Card # %d has been saved as draft."), $dispatch_no));
    echo '</li><li>';
	display_note(get_customer_trans_view_str(ST_CUSTDELIVERY, $dispatch_no, _("&View This Job Card"), false, '', '', $path_to_root, 
	basename($_SERVER['PHP_SELF']) ), 0, 1); 
	echo '</li><li>';
	display_note(print_document_link($dispatch_no, _("&Print Job Card"), true, ST_CUSTDELIVERY));
	display_note(get_gl_view_str(13, $dispatch_no, _("View the GL Journal Entries for this Job Card")),1);
    echo '</li><li><span>';
	hyperlink_params("$path_to_root/sales/inquiry/schedule_inquiry.php", _("Select Another schedule"));
    echo '</span></li></ol>';
	display_footer_exit();
}

if($_GET['schedule']){
    $_POST['schedule'] = $_GET['schedule'];
}

if($_GET['schedule']){
    
	$sql = "SELECT * FROM ".TB_PREF."schedules WHERE 
	id=".db_escape($_GET['schedule']);
	$schedule = db_fetch(db_query($sql));
	
	if($schedule['status']==2){
	    display_error(_("This job has already been completed"));
	    end_page();
	    exit;
	}
 
	if($schedule['delivery']){
		$ord = new Cart(ST_CUSTDELIVERY, $schedule['delivery']);
	}
	else{
		$sql = "SELECT order_no FROM ".TB_PREF."sales_order_details WHERE id=".db_escape($schedule['soline']);
		$order = db_fetch(db_query($sql))['order_no'];
		$ord = new Cart(ST_SALESORDER, $order, true, false);

		$ord->master_order = $order;

	   	foreach($ord->line_items as $item){
   			$item->qty_dispatched = $item->quantity;
	   	}
	}

	$ord->schedule_id = $schedule['id'];
   	$ord->schedule_date = sql2date($schedule['date']);
   	$ord->schedule_stime = $schedule['start_time'];
   	$ord->schedule_etime = $schedule['end_time'];
   	$ord->schedule_type = $schedule['type'];
   	$ord->Comments = $schedule['remarks'];
   	$ord->technician = $schedule['technician'];
   	
   	$sql = "SELECT stk_code FROM ".TB_PREF."sales_order_details 
   	WHERE id=".db_escape($schedule['soline']);
   	
   	$ord->MainItem = db_fetch(db_query($sql))['stk_code'];
	
	//Now if type is not installation than update cart for making direct delivery
   	if($schedule['type'] != SC_INSTALL && !$schedule['delivery']){

   		$ord->src_docs = array();
   		foreach($ord->line_items as $item){
   			$item->id = 0;
	   	}

	   	$sql = "SELECT order_no FROM ".TB_PREF."sales_order_details WHERE id=".db_escape($schedule['soline']);
		$order = db_fetch(db_query($sql))['order_no'];
		$ord->master_order = $order;
   	}

   	//If delivery is present than need to load attachments
   	if($schedule['delivery']){
   		$sql = "SELECT f.* FROM ".TB_PREF."attach_inquiry_detail AS f 
   		LEFT JOIN ".TB_PREF."attach_inquiry AS header ON f.attach_id=header.id 
   		LEFT JOIN ".TB_PREF."attach_inquiry_link_detail AS link ON link.attach_id=header.id 
   		WHERE link.trans_type=13 AND link.trans_no=".$schedule['delivery'];
   		$res = db_query($sql);


   		while($row = db_fetch($res)){

   			$counter = count($_SESSION['Items']->attach_files);
   			$format = pathinfo($row['filename'], PATHINFO_EXTENSION);
			$dir = company_path()."/attachments/attachments_inquiry/".$row['unique_name'];
			
			$ord->attach_files[$counter] = new attachment_files($row['description'], $row['filename'], 
			$format, $dir, $row['filetype'], $row['filesize']);

			$ord->attach_id = $row['attach_id'];

   		}
   	}

	$_SESSION['Items'] = $ord;
}
elseif(!$_POST['schedule']){
    display_error(_("No schedule is selected to process"));
    end_page();
    exit;
}
//-----------------------------------------------------------------------
//Processing
if(isset($_POST['AddItem'])){

	$count = count($_SESSION['Items']->line_items);

	$_SESSION['Items']->line_items[$count] = new line_details($_POST['stock_id'], input_num('qty'), input_num('price'), 0,null, null, null, null, null, null, null, null, null, null, null,null,null, null, null, null, $_POST['line_ref'], $_POST['line_date'], 0);
	$_SESSION['Items']->line_items[$count]->qty_dispatched = input_num('qty');
	$Ajax->activate('items_table');
	unset($_POST['qty'], $_POST['line_ref'], $_POST['line_date']);
}

$delete = find_submit('Delete');

if($delete != -1){
	$_SESSION['Items']->remove_from_cart($delete);
	$Ajax->activate('items_table');
}

if(isset($_POST['AddAttachment']) && can_process_attachment()){
	$counter = count($_SESSION['Items']->attach_files);
	
	$file = $_FILES['file'];
	$format = pathinfo($file['name'], PATHINFO_EXTENSION);

	$temp_dir = company_path()."/temp_repository/".uniqid(100).".".$format;
	
	move_uploaded_file($file['tmp_name'], $temp_dir);

	$_SESSION['Items']->attach_files[$counter] = new attachment_files($_POST['file_description'], $file['name'], 
	$format, $temp_dir, $file['type'], $file['size']);

	unset($_POST['file_description']);
	unset($_FILES['file']);

	$Ajax->activate('attach_table');
}

$deleteattach = find_submit('DeleteAttach');

if($deleteattach != -1){
	array_splice($_SESSION['Items']->attach_files, $deleteattach, 1);
	$Ajax->activate('attach_table');
}


if(isset($_POST['SaveDraft']) && CanProcess($_SESSION['Items'])){
	$line_no=0;
	foreach($_SESSION['Items']->line_items as $items){
		if(input_num('qty'.$line_no))
			$items->qty_dispatched = input_num('qty'.$line_no);

		if($_SESSION['Items']->schedule_type != SC_INSTALL){
			$items->price = 0;
			$items->discount_percent = 0;
		}
		$line_no++;
	}
	$_SESSION['Items']->deliver_to = $_POST['deliver_to'];
	$_SESSION['Items']->designation = $_POST['designation'];
	$trans_no = $_SESSION['Items']->write(1, 0);

	$sql = "UPDATE ".TB_PREF."schedules SET status = 1, delivery=".db_escape($trans_no)." WHERE id=".$_SESSION['Items']->schedule_id;
	db_query($sql);

	$sql = "UPDATE ".TB_PREF."debtor_trans SET draft = 1 WHERE type=13 AND trans_no=".$trans_no;
	db_query($sql);
	
	process_attachments($_SESSION['Items'], $trans_no);
	ProcessEIDAttachment($_SESSION['Items'], $_FILES['attach_emirate']);
	process_signatures($trans_no);

	meta_forward($_SERVER['PHP_SELF'], "draft=".$trans_no);
}

if(isset($_POST['CloseJob']) && CanProcess($_SESSION['Items'])){
	$line_no=0;
	foreach($_SESSION['Items']->line_items as $items){
		if(input_num('qty'.$line_no))
			$items->qty_dispatched = input_num('qty'.$line_no);
		$line_no++;
	}
	$_SESSION['Items']->deliver_to = $_POST['deliver_to'];
	$_SESSION['Items']->designation = $_POST['designation'];
	$trans_no = $_SESSION['Items']->write(1);
	$sql = "UPDATE ".TB_PREF."schedules SET status = 2, delivery=".db_escape($trans_no)." WHERE id=".$_SESSION['Items']->schedule_id;
	db_query($sql);

	$sql = "UPDATE ".TB_PREF."debtor_trans SET draft = 0 WHERE type=13 AND trans_no=".$trans_no;
	db_query($sql);

	process_attachments($_SESSION['Items'], $trans_no);
	ProcessEIDAttachment($_SESSION['Items'], $_FILES['attach_emirate']);
	process_signatures($trans_no);

	meta_forward($_SERVER['PHP_SELF'], "closed=".$trans_no);
}

if(isset($_POST['remove_tech_sign'])){

	unlink(company_path()."/images/jobcard_signatures/tech_schedule-".key($_SESSION['Items']->trans_no).".jpg");
	unset($_POST['remove_tech_sign']);
	$Ajax->activate('_page_body');
}
if(isset($_POST['remove_client_sign'])){

	unlink(company_path()."/images/jobcard_signatures/client_schedule-".key($_SESSION['Items']->trans_no).".jpg");
	unset($_POST['remove_client_sign']);
	$Ajax->activate('_page_body');
}
//----------------------------------------------------------------------
//Helper Functions

function CanProcess(&$order){
	if($order->emirates_id == ''){
		if($_FILES['attach_emirate']['name'] == '' && $_SESSION['Items']->schedule_type =! 1){
		    display_error(_("Please Attach Emirates ID"));
		    return false;
		}

	}
	
// 	$format = pathinfo($_FILES['attach_emirate']['name'], PATHINFO_EXTENSION);
// 	if($format && !in_array($format, array("jpeg", "jpg"))){
// 	    display_error(_("Only Jpg And JPEG are Allowed"));
// 	    return false;
// 	} 


	return true;

}

function can_process_attachment(){
    $file = $_FILES['file'];
	$format = pathinfo($file['name'], PATHINFO_EXTENSION);
	   
	if(!in_array($format, array("gif", "jpeg", "jpg", "png"))){
	    display_error(_("Attachment can only be an image"));
	    return false;
	}
	return true;
}
function process_signatures($trans_no){
	
	global $Ajax;

	$link =  company_path()."/images/jobcard_signatures";

	if($_POST['process_tech']){

		if($_POST['tech_link']){
			copy($_POST['tech_link'], $link."/tech_schedule-".$trans_no.".jpg");
		}
		else{
			$Ajax->addScript(true, "html2canvas([document.getElementById('sign-pad-tech')], {
		        onrendered: function (canvas){
		            var canvas_img_data = canvas.toDataURL('image/jpeg');
		            var img_data = canvas_img_data.replace(/^data:image\/(jpeg|png|jpg);base64,/, '');
	            	var trans_no = $trans_no;
		            var name= 'tech_schedule-';
		            var res = name.concat(trans_no);
		              
		            //ajax call to save image inside folder
		            $.ajax({
		              url: 'insert_sign.php',
		              data: {img_data:img_data,name:res },
		              type: 'post',
		              dataType: 'json',
		              success: function (response){
		              }
		            });
		          }
		        });");
		}
	}

	if($_POST['process_client']){
		$Ajax->addScript(true, "html2canvas([document.getElementById('sign-pad-client')], {
	        onrendered: function (canvas){
	            var canvas_img_data = canvas.toDataURL('image/jpeg');
	            var img_data = canvas_img_data.replace(/^data:image\/(jpeg|png|jpg);base64,/, '');
	            var trans_no = $trans_no;
	            var name= 'client_schedule-';
	            var res = name.concat(trans_no);
	            //ajax call to save image inside folder
	            $.ajax({
	              url: 'insert_sign.php',
	              data: {img_data:img_data,name:res },
	              type: 'post',
	              dataType: 'json',
	              success: function (response){
	              }
	            });
	          }
	        });");
	}
}


function ProcessEIDAttachment($order, $File=null){
	$FileName = $File['name'];

	if($FileName == '')
		return;

	$format = pathinfo($FileName, PATHINFO_EXTENSION);
	if(!in_array($format, array("jpeg", "jpg", "png"))){
	    display_error(_("Attachment can only be an image"));
	    return false;
	} 

	$Path = company_path()."/attachments/emirate_id/";
	if(!file_exists($Path))
		mkdir($Path);

	$FileName = $order->customer_id.'_'.$order->Branch.'_'.$FileName;
	$Path .= $FileName;
	move_uploaded_file($File['tmp_name'], $Path);

 	$sql = " UPDATE ".TB_PREF."debtors_master SET emirates_id = ".db_escape($FileName)."
			 WHERE debtor_no = ".db_escape($order->customer_id);
	db_query($sql);
	return true;
}


function process_attachments(&$order, $trans_no){

	$count = count($order->attach_files);
	$attach_id = $order->attach_id;

	$permenent_dir = company_path()."/attachments/attachments_inquiry";

	if($count){
		if(!$attach_id)
			$attach_id = add_attachment_inquiry_header($_SESSION['wa_current_user']->user);

		//First removce old lines
		delete_attachment_details($attach_id);

		foreach ($order->attach_files as $attach){

			$unique_name = $attach_id."_".date('Y_m_d_h_i_s',strtotime('now'))."_".rand(10,100).".".$attach->format;

			if(file_exists($attach->path)){
				rename($attach->path, $permenent_dir."/".$unique_name);
				add_attachment_inquiry($attach_id, $attach->description, $attach->filename, $unique_name, $attach->size, $attach->type);
			}
		}

		delete_attachment_inquiry_link_detail_by_attach_id($attach_id);
		add_attachment_inquiry_link_detail($attach_id, $trans_no, ST_CUSTDELIVERY);
	}
	elseif($attach_id){
		delete_attachment_details($attach_id);
		delete_attachment_inquiry_link_detail_by_attach_id($attach_id);
		delete_attachment_inquiry($attach_id);
	}
}



//-----------------------------------------------------------------------
//UI Functions
function display_header(&$order){
	global $path_to_root, $Ajax, $schedule_type;


	div_start('info_div');
	
	start_table(TABLESTYLE2 ,'width:90% !important ;');

	label_cells("Customer Name", $order->customer_name, "class='tableheader2'");

	$start_time = new DateTime($order->schedule_stime);
	$end_time = new DateTime($order->schedule_etime);
	label_cells("Schedule Date & Time", $order->schedule_date." ".$start_time->format('h:i a')." - ".$end_time->format('h:i a'),
	"class='tableheader2'");
	start_row();
	label_cells("Schedule Type", $schedule_type[$order->schedule_type], "class='tableheader2'");
	label_cells(_("Remarks"), $order->Comments, "class='tableheader2'");

	end_table(2);
	
	div_end();
}

function display_summary(&$order){
	global $Ajax, $SysPrefs, $schedule_type;

	div_start('items_table');
	start_table(TABLESTYLE, "style='width:100% !important;'");

	$th = array("S. No", "Description", "Qty", "Reference",  "Date", "Delete");

	table_header($th);

	$k=0;
	$i=0;	

	$sql = "SELECT * FROM ".TB_PREF."schedules WHERE id=".db_escape($order->schedule_id);
	$soline = db_fetch(db_query($sql))['soline'];

	foreach($order->line_items as $item){
		alt_table_row_color($k);

		label_cell($i+1);
		label_cell($item->stock_id." - ".$item->item_description);
		if($order->MainItem == $item->stock_id){
			label_cell($item->qty_dispatched);
			label_cell(!$item->line_ref ? 'N/A' : $item->line_ref);
			label_cell($item->line_date ==  '0020-00-00' ? 'N/A' : sql2date($item->line_date));
			label_cell("");
		}
		else{
			
			if(!$_POST['qty'.$i])
				$_POST['qty'.$i] = $item->qty_dispatched;

			$item_info = get_item_edit_info($item->stock_id);
			$dec = $item_info['decimals'];
			qty_cells(null, 'qty'.$i, $_POST['qty'.$i], null, null, $dec);

			label_cell(!$item->line_ref ? 'N/A' : $item->line_ref);
			label_cell($item->line_date ==  '0000-00-00' ? 'N/A' : sql2date($item->line_date));

			delete_button_cell("Delete$i", _("Delete"), _('Remove line from document'));
		}
		$i++;
	}

	item_controls($order, $k, $i);

	end_table(1);
	div_end();
}

function item_controls(&$order, $row_counter=0, $serial=0){

	global $Ajax;

	alt_table_row_color($row_counter);

	$item_info = get_item_edit_info($_POST['stock_id']);
	$units = $item_info["units"];
	$dec = $item_info['decimals'];
	if($order->schedule_type == SC_INSTALL){
		$price = get_kit_price($_POST['stock_id'], $order->customer_currency, $order->sales_type, $order->price_factor, get_post('OrderDate'));
		$_POST['price'] = price_format($price);
	}
	else{
		$_POST['price'] = 0;
	}

	label_cell($serial+1);
// 	kit_items_list_cells(null, 'stock_id', null, false, true, $order->MainItem);
	
	sales_items_list_cells(null, 'stock_id', null, false, true);
	
	
	qty_cells(null, 'qty', $_POST['qty'], null, null, $dec);

	text_cells(null, 'line_ref', null, 5);

	date_cells(null, 'line_date');

	submit_cells('AddItem', _("Add Item"), "colspan=2 align='left'", _('Add new item to document'), true);


	hidden('price', $_POST['price']);
}

function display_attachment(&$order){
	global $Ajax, $SysPrefs, $schedule_type;

	div_start('attach_table');
	start_table(TABLESTYLE, "style='width:100% !important;'");

	$th = array("S. No", "Description", "File", "Delete");

	table_header($th);

	$i=0;
	$k=0;
	foreach($order->attach_files as $attach){

		alt_table_row_color($k);

		label_cell($i+1);
		label_cell($attach->description);
		label_cell("<a href='".$attach->path."' target='_blank'>".$attach->filename."</a>");
		delete_button_cell("DeleteAttach$i", _("Delete Attachment"), _('Remove attachment from document'));
	}

	attachment_control($order, 0, 0);
	end_table();
	div_end();
}

function attachment_control(&$order, $row_counter=0, $serial=0){

	global $Ajax;

	alt_table_row_color($row_counter);

	label_cell($serial+1);
	text_cells(null, 'file_description', null, 25, 50, _('Attachment Name'));
	file_cells("", "file");

	submit_cells('AddAttachment', _("Add Attachment"), "colspan=2 align='left'", _('Add new attachment to document'), true);
}


function display_signature_client(&$order){

	global $Ajax;

	start_table(TABLESTYLE6_BOX,"",0,0,0,null,"25%","3px solid #656E79;");

	$client_sign = company_path()."/images/jobcard_signatures/client_schedule-".key($order->trans_no).".jpg";

	if(file_exists($client_sign)){
		$sign_img_link .= "<img id='item_img' alt = '[client.jpg]' src='".$client_sign."' width='270' height='100'  border='0'>";
		label_row("Client Signature", $sign_img_link);
		check_cells("Remove Signature", "remove_client_sign", null, true);
	}
	else{
		hidden('process_client', 1);

		label_row('Client Signature','<div id="ClientSign">
		<div class="sig sigWrapper" style="height: auto; width:280; display: block; float: right; ">
		<div class="typed"></div>
		<canvas class="sign-pad" id="sign-pad-client" width="270" height="100" ></canvas></div></div>','','',0,null,
		'style="text-align: right; !important;"'); 

		$Ajax->addScript(true, "$(document).ready(function() {
		$('#ClientSign').signaturePad({drawOnly:true, drawBezierCurves:true, lineTop:90});});");

	}
	text_row(_("Deliver To"), 'deliver_to');
	text_row(_("Designation"), 'designation');
    file_row(_("Attach EID"), 'attach_emirate');
    
    
	$stock_img_link = "";
	$check_remove_image = false;
	$FileName = $File['name'];

 	$sql = " SELECT emirates_id FROM ".TB_PREF."debtors_master
			 WHERE debtor_no = ".db_escape($order->customer_id);
			$res=  db_query($sql);
			$ans = db_fetch($res);

	
	$FileName = $ans['emirates_id'];
	
	

	if (file_exists(company_path()."/attachments/emirate_id/".$FileName )  && $FileName!=""  )
	{
	   
	  
		$nocache=rand();
		// var_dump($img_name);
	 // 31/08/08 - rand() call is necessary here to avoid caching problems.
		$stock_img_link .= "<a href='../company/0/attachments/emirate_id/".$FileName."?nocache=".$nocache." ' download> <img id='item_img' alt = '[".$FileName.
			"]' src='".company_path().'/attachments/emirate_id/'.$FileName.
			"?nocache=".$nocache."'"." height='".'80px'."' border='0'></a>";
			$check_remove_image = true;


//$imagecontent =DownloadImageFromUrl("http://localhost/ehomes/company/0/images/002.jpg?nocache=23854g");
// $savefile = fopen('myimage.png', 'r');
// fread($savefile, $imagecontent);
// fclose($savefile);
	} 
	else 
	{
		$stock_img_link .= _("No image");
	}

label_row("&nbsp;", $stock_img_link);


	end_table();

}

function display_signature_technician(&$order){

	global $Ajax;

	start_table(TABLESTYLE6_BOX,"",0,0,0,null,"25%","3px solid #656E79;");

	$tech_sign = company_path()."/images/jobcard_signatures/tech_schedule-".key($order->trans_no).".jpg";

	if(file_exists($tech_sign)){
		$sign_img_link .= "<img id='item_img' alt = '[".$selected_id.".jpg"."]' src='".$tech_sign."' width='270' height='100'  border='0'>";
		label_row("Technician Signature", $sign_img_link);
		check_cells("Remove Signature", "remove_tech_sign", null, true);

	}
	else{
		hidden('process_tech', 1);
		$tech_sign = company_path()."/images/user-".$_SESSION['wa_current_user']->user.".jpg";

		if(file_exists($tech_sign)){
			$sign_img_link .= "<img id='item_img' alt = '[".$selected_id.".jpg"."]' src='".$tech_sign."' width='270' height='100'  border='0'>";
			label_row("Technician Signature", $sign_img_link);
			hidden('tech_link', $tech_sign);
		}
		else{
			label_row('Technician Signature','<div id="TechSign">
			<div class="sig sigWrapper" style="height: auto; width:280; display: block; float: right; ">
			<div class="typed"></div>
			<canvas class="sign-pad" id="sign-pad-tech" width="270" height="100" ></canvas></div></div>','','',0,null,
			'style="text-align: right; !important;"'); 

			$Ajax->addScript(true, "$(document).ready(function() {
			$('#TechSign').signaturePad({drawOnly:true, drawBezierCurves:true, lineTop:90});});");
		}

	}


	end_table();
}


//-----------------------------------------------------------------------

start_form(true);

hidden('schedule', $_POST['schedule']);


display_header($_SESSION['Items']);

start_table(TABLESTYLE2, 'width:90% !important;', 10);
echo "<tr><td>";
display_summary($_SESSION['Items']);
echo "</td></tr>";
end_table(1);

start_table(TABLESTYLE2, 'width:60% !important;', 10);
echo "<tr><td>";
display_attachment($_SESSION['Items']);
echo "</td></tr>";
end_table(1);

start_table(TABLESTYLE2, 'width:60% !important;', 10);
echo "<tr><td>";
display_signature_client($_SESSION['Items']);
echo "</td><td>";
display_signature_technician($_SESSION['Items']);
echo "</td></tr>";
end_table(1);

hidden('trans_no', $_SESSION['Items']->trans_no[0]);

submit_center_first('CloseJob', _("Close Job"), _('Check entered data and save document'), 'default');
submit_center_last('SaveDraft', _("Save Draft"), _('Check entered data and save document'), 'default');

end_form();
end_page();
?>

<script type="text/javascript">
	
	$('#ClientSign').signaturePad({drawOnly:true, drawBezierCurves:true, lineTop:90});
	$('#TechSign').signaturePad({drawOnly:true, drawBezierCurves:true, lineTop:90});
	
</script>