<?php

$page_security = 'SA_SCHEDULE';
$path_to_root = "..";
include($path_to_root . "/sales/includes/schedule_cart.inc");
include($path_to_root . "/includes/session.inc");

include($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");

echo ' <link rel="stylesheet" href="geoapify.css"/> ';



$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 600);
if (user_use_date_picker())
	$js .= get_js_date_picker();


if($_GET['schedule'])
	$_POST['schedule'] = $_GET['schedule'];

if($_GET['complain'])
	$_POST['complain'] = $_GET['complain'];

if($_GET['maintenance'])
	$_POST['maintenance'] = $_GET['maintenance'];

if($_GET['order_no'])
	$_POST['order_no'] = $_GET['order_no'];

page(_($help_context = "Schedule Against SO"), false, false, "", $js);

start_form();
hidden('schedule', $_POST['schedule']);
hidden('complain', $_POST['complain']);
hidden('maintenance', $_POST['maintenance']);
hidden('order_no', $_POST['order_no']);

$result = get_sales_order_details($_POST['order_no'], ST_SALESORDER);
while($row=db_fetch($result)){
	$sql = " UPDATE ".TB_PREF."schedules 
			 SET order_no = ".$_POST['order_no']."
			 WHERE soline = ".$row['id'];
			 db_query($sql);
}


//-------------------------------------------------------------------------
//Address Modal
?>
<div class="container-fluid">
  	<div class="modal fade" id="addModal" role="dialog">
    	<div class="modal-dialog" style="width: 315px;">
	      	<div class="modal-content">
	        	<div class="modal-header">
	          		<a class="close" data-dismiss="modal">&times;</a>
	          		<h4 class="modal-title">Job Address</h4>
	          		<br>
	        	</div>
	        	<div class="modal-body" style="text-align: center;">
	        	    <div class="autocomplete-container" 
	        	    id="autocomplete-container"></div></td>'
	        	</div>
	        	<div class="modal-footer" style="text-align: center;">
	        	<?php
	        	    submit("SetAddress", 'Save Address', true, 
	        	    "Save schedule address");
	        	?>
	        	</div>
	      	</div>
		</div>
  	</div>
</div>
<?php
//-----------------------------------------------------------------------------
//Initial cart calls
if($_GET['line']){
	$_SESSION['schedule'] = new schedule_cart($_GET['line']);
}
//-----------------------------------------------------------------------------
//Helper Functions

function check_data($update=0){

	//Need to do this to repopulate post values of edit id in case of false from check data
	if($update)
		$_POST['_lock_date_update'] = 1;

	if(!$_POST['technician']){
		display_error("Technician must be selected");
		return false;
	}


	//If its an installation than make sure that there are no other installation scheduled
	if($_POST['type'] == SC_INSTALL){
		$count = 0;
		foreach($_SESSION['schedule']->schedules as $schedule){
			if($update && $_POST['LineNo']==$count){
				continue;
			}
			if($schedule->type == SC_INSTALL){
				display_error("Only single installation is allowed");
				return false;
			}
			$count++;
		}
	}

	if(!is_date($_POST['date'])){
		display_error(_("Enter schedule date"));
		return false;
	}



	// //Task#2400
	if(!is_date($_POST['end_date'])){
		display_error(_("Enter schedule end date"));
		return false;
	}



	// if(date2sql($_POST['date'])<date2sql($_SESSION['schedule']->order_date)){
	// 	display_error(_("Schedule  date can not be older than order date"));
	// 	return false;
	// }


	if($_POST['start_time'] == $_POST['end_time']){
		display_error(_("Start Time and end time can not be same"));
		return false;
	}

	$start_time = strtotime($_POST['start_time']);
	$end_time = strtotime($_POST['end_time']);

	if($end_time<=$start_time){
		display_error(_("Select a proper interval"));
		return false;
	}


	// //Ensure that there is no overlap for of time on current unprocessed scheduled
	foreach($_SESSION['schedule']->schedules as $lineno => $schedule){
		
		if($update && $lineno == $_POST['LineNo'])
			continue;

//-------------------------------------------------------------------------------------
//======================================Task#2390======================================

		if (explode(',',$_POST['technician']) != $schedule->technician)
			continue;
//-------------------------------------------------------------------------------------
//======================================Task#2390======================================
		$comapre_from = strtotime($schedule->start_time);
		$comapre_to = strtotime($schedule->end_time);

		if(($start_time >= $comapre_from && $start_time <= $comapre_to) || ($end_time >= $comapre_from && $end_time <= $comapre_to) || 
		($start_time <= $comapre_from && $end_time >= $compare_to)){
			display_error("Technician not available during this period");
			return false;
		}

	}

	return true;
}
//-----------------------------------------------------------------------------------------
//Processing code
if(isset($_POST['CancelInfo'])){
	$Ajax->activate('info_div');
}

if(isset($_POST['UpdateInfo'])){
	$_SESSION['schedule']->address = $_POST['address'];
	$Ajax->activate('info_div');
}

if(list_updated('item_list')){
	$Ajax->activate('items_table');
}

if(isset($_POST['CancelLine'])){
	unset($_POST['item_list']);
	$Ajax->activate('items_table');
}

if(isset($_POST['CancelItemChanges'])){
	unset($_POST['item_list']);
	$Ajax->activate('items_table');
}
    	$_POST['tech'] = implode(',',$_POST['technician']);

if(isset($_POST['AddItem']) ){
    
    $date = date2sql($_POST['date']);

    // //Task#2400
    $end_date = date2sql($_POST['end_date']);

    $frequency = $_POST['frequency'];
    	if(!$frequency)
	    		$frequency = 1;
    $months = 12/$frequency;
    
    for($i=0; $i<$frequency; $i++){

    	if(in_array(-1, $_POST['technician'])){
    		$technician = get_all_technician_ids();
    	}
    	else{
    		$technician = implode(",",$_POST['technician']);
    	}
        $_SESSION['schedule']->add_schedule(0,sql2date($date),sql2date($end_date), 
    	$_POST['start_time'],
    	$_POST['end_time'], 
    	$_POST['ov_time'], 
    	$_POST['addressline'], 
    	$_POST['type'],
     	$technician,
     	$_POST['remarks'], 0, 
    	$_POST['Cordinates'], $_POST['quantity'], $_POST['item_list']); 
	
        if($_POST['type'] == SC_INSTALL)
    	    $_POST['type'] = SC_MAINATAIN;
    	    
    	$date = date('Y-m-d', strtotime("+".$months." months", strtotime($date)));
    	// //Task#2400
    	$end_date = date('Y-m-d', strtotime("+".$months." months", strtotime($end_date)));
    }


	unset($_POST);
}



if(isset($_POST['UpdateItem']) && check_data(1)){
	$line_no = $_POST['LineNo'];

	$_SESSION['schedule']->schedules[$line_no]->date = $_POST['date'];
	// //Task#2400
	$_SESSION['schedule']->schedules[$line_no]->end_date = $_POST['end_date'];
	$_SESSION['schedule']->schedules[$line_no]->start_time =$_POST['start_time'];
	$_SESSION['schedule']->schedules[$line_no]->end_time = $_POST['end_time'];
	$_SESSION['schedule']->schedules[$line_no]->ov_time = $_POST['ov_time'];
	$_SESSION['schedule']->schedules[$line_no]->remarks = $_POST['remarks'];
	$_SESSION['schedule']->schedules[$line_no]->location =$_POST['addressline'];
	$_SESSION['schedule']->schedules[$line_no]->type = $_POST['type'];

	if($_POST['tech']==-1){
 		$_SESSION['schedule']->schedules[$line_no]->technician = get_all_technician_ids();
	}else{
		$_SESSION['schedule']->schedules[$line_no]->technician = $_POST['tech'];
	}
	$_SESSION['schedule']->schedules[$line_no]->loc_cordinates =$_POST['Cordinates'];
	unset($_POST);
}
if(isset($_POST['SetAddress'])){
    $_POST['Cordinates'] = $_POST['loc_cordinates'];
    $_POST['addressline'] = $_POST['location'];
    unset($_POST['location']);
    unset($_POST['loc_cordinates']);
}

$delete = find_submit('Delete');
if($delete != -1){
	array_splice($_SESSION['schedule']->schedules, $delete, 1);
	$Ajax->activate('items_table');
}

if($_POST['ProcessOrder']){
	add_update_schedules($_SESSION['schedule']);
	display_notification(_("Schedule Added"));
}

//-----------------------------------------------------------------------------
//UI Functions

function display_header(&$order){
	global $path_to_root, $Ajax;

	$id = find_submit('InfoEdit');

	if($id!=-1){
		$Ajax->activate('info_div');
	}

	div_start('info_div');
	
	start_table(TABLESTYLE2 ,'width:90% !important;');

	$th = array(_("Customer"), _("Address"), "");
	if($id != -1)
		$th[] = "";	
	table_header($th);

	if($id != -1){

		label_cell(get_customer_name($order->customer));
		text_cells(null, 'address', $_POST['address'], 25, 1000, _('Address'));
		button_cell('UpdateInfo', _("Update"), _('Confirm changes'), ICON_UPDATE);
		button_cell('CancelInfo', _("Cancel"), _('Cancel changes'), ICON_CANCEL);
	}
	else{	
		label_cell(get_customer_name($order->customer));
		label_cell($order->address);
		edit_button_cell("InfoEdit", _("Edit"), _('Edit Header Details'));
// 		label_cell('<a target="_blank" href="http://localhost/xpert_hr/payroll/attendance/mark_attendance_bulk.php?user_id='.$_SESSION['wa_current_user']->username.'&enc_key='.$_SESSION['wa_current_user']->password.'">Mark Attendance</a>');
		hidden('address', $order->address);
	}
	
	end_table(2);
	div_end();
}

function display_summary(&$order){
	global $Ajax, $SysPrefs, $schedule_type;


	$id = find_submit('Edit');

    if(isset($_POST['_lock_date_update'])){
		$id = $_POST['edit_id_summary'];
	}
	hidden('edit_id_summary', $id);

    div_start('items_table');

	start_table(TABLESTYLE, "style='width:100% !important;'");

	if($_POST['item_list'] && $id==-1){
		$th = array("Description", "", "Quantity", "Start Date","End Date", "Start Time", "End Time","Over Hours", "Lock Date","Technician", "Schedule Type", "Address","Frequency", "Remarks","", "","");
	}
	else{
	    $th = array("Description", "Quantity", "Start Date", "End Date", "Start Time", "End Time" , "Over Hours", "Lock Date","Technician", "Schedule Type", "Address","Frequency", "Remarks","", "" ,"");
	}
	table_header($th);

	

	if ($id==-1){
		item_controls($order, $k, 0);
	}

	$k = 0;
	$list_array[$order->soline] = $order->item_code." - ".$order->item_desc;
	$item_info = get_item_edit_info($order->item_code);
	$dec = $item_info['decimals'];

	$line_no = 0;
	foreach($order->schedules as $schedule){

		if($id!=$line_no){
			alt_table_row_color($k);

			$line = db_fetch(get_sales_order_details($order->order_no, ST_SALESORDER, $schedule->line_id));
			label_cell($order->reference);
			
			if($_POST['item_list'] && $id==-1)
				label_cell("");

			qty_cell($line['quantity'], false, $dec);
			label_cell($schedule->date);

			// //Task#2400
			label_cell($schedule->end_date);

			$start_time = new DateTime($schedule->start_time);
			label_cell($start_time->format('h:i a'));
			$end_time = new DateTime($schedule->end_time);
			label_cell($end_time->format('h:i a'));
			label_cell($schedule->ov_time);
			label_cell("-");



//-------------------------------------------------------------------------------------
//======================================Task#2390====================================== 
			

			$ExTechnician = explode(',', $schedule->technician);

			foreach($ExTechnician as $tech_id)
			{
					$TechString .= get_technician_name($tech_id).",";
			}

			label_cell($TechString);
			unset($TechString);

//======================================Task#2390======================================
//-------------------------------------------------------------------------------------	
			
			label_cell($schedule_type[$schedule->type]);  
			label_cell($schedule->location);
			label_cell($schedule->remarks);

			if(!$schedule->status){
				edit_button_cell("Edit$line_no", _("Edit"), _('Edit document line'));
				delete_button_cell("Delete$line_no", _("Delete"), _('Remove line from document'));
			}
			else{
				label_cell("Job Started", 'colspan=2');
				////Task#2400
				edit_button_cell("Edit$line_no", _("Edit"), _('Edit document line'));
				delete_button_cell("Delete$line_no", _("Delete"), _('Remove line from document'));
				////Task#2400
			}
		}
		else{
			item_controls($order, $k,  $line_no);
		}
		$line_no++;
		
	}


	end_table(2);
    div_end();
}

function item_controls(&$order, $rowcounter, $line_no){

	global $Ajax, $schedule_type;

	$Ajax->activate('items_table');

	alt_table_row_color($rowcounter);

	$list_array[$order->soline] = $order->item_code." - ".$order->item_desc;
	$item_info = get_item_edit_info($order->item_code);
	$dec = $item_info['decimals'];

	$id = find_submit('Edit');
	if(isset($_POST['_lock_date_update'])){
		$id = $_POST['edit_id'];
	}
	hidden('edit_id', $id);


	// edit old line
	if($line_no!=-1 && $line_no == $id){
		if(!isset($_POST['_lock_date_update'])){

			$_POST['lock_date'] = 1;
			$_POST['item_list'] = $order->schedules[$line_no]->line_id;

			$_POST['date'] = $order->schedules[$line_no]->date;
			////Task#2400
			$_POST['end_date'] = $order->schedules[$line_no]->end_date;
			$_POST['start_time'] = $order->schedules[$line_no]->start_time;
			$_POST['end_time'] = $order->schedules[$line_no]->end_time;
			$_POST['ov_time'] = $order->schedules[$line_no]->ov_time;
			$_POST['remarks'] = $order->schedules[$line_no]->remarks;
			$_POST['addressline'] = $order->schedules[$line_no]->location;
			$_POST['Cordinates'] = $order->schedules[$line_no]->loc_cordinates;
			$_POST['type'] = $order->schedules[$line_no]->type;


 //-------------------------------------------------------------------------------------
//======================================Task#2390======================================

		  $_POST['technician'] = explode(',', $order->schedules[$line_no]->technician);

 //-------------------------------------------------------------------------------------
//======================================Task#2390======================================
		  	
		}
		$line = db_fetch(get_sales_order_details($order->order_no, ST_SALESORDER, $_POST['item_list']));
		label_cell($line['stk_code'].' - '.$line['description']);
	}
	else{
		//Enter New Line
		if($_POST['item_list']){
			$line = db_fetch(get_sales_order_details($_POST['order_no'], ST_SALESORDER, $_POST['item_list']));
            label_cell($order->reference);
			remove_button_cell("CancelLine", ("Cancen Line"), ('Cancel'));
		}
		else{
// 			label_cell(array_selector('item_list', null, $list_array, array('spec_option' => "Select Item", 'select_submit' => true)));
			order_line_list_cells(null, 'item_list', null, true, $order->order_no, $order->schedules);
		}
	}

	if($_POST['item_list']){
		
		qty_cell($line['quantity'], false, $dec);
		hidden('quantity', $line['quantity']);

		if($_POST['lock_date']){

			label_cell($_POST['date']);
			////Task#2400
			label_cell($_POST['end_date']);

			$start_time = new DateTime($_POST['start_time']);
			label_cell($start_time->format('h:i a'));

			$end_time = new DateTime($_POST['end_time']);
			label_cell($end_time->format('h:i a'));

			label_cell($_POST['ov_time']);

			hidden('date', $_POST['date']);

			hidden('ov_time', $_POST['ov_time']);
			////Task#2400
			hidden('end_date', $_POST['end_date']);

			hidden('start_time', $_POST['start_time']);
			hidden('end_time', $_POST['end_time']);
		}
		else{

			date_cells(null, 'date', _("Schedule Date"));
			////Task#2400
			date_cells(null, 'end_date', _("Schedule End Date"));

			// amount_cells("",'ov_time',null);

			echo '<td><input type="time" id="start_time" name="start_time" value="'.$_POST['start_time'].'"></td>';
			echo '<td><input type="time" id="end_time" name="end_time" value="'.$_POST['end_time'].'"></td>';	

			amount_cells("",'ov_time',$_POST['ov_time']);
		}

		check_cells('','lock_date', null, true, _('Lock Inspection Date'));
		if($_POST['lock_date']){

			if($line_no!=-1 && $line_no == $id)
				$src_id = $order->schedules[$line_no]->id;

//-------------------------------------------------------------------------------------
//======================================Task#2390======================================

			

			tech_list_cells(null, 'technician', 1, null, true, _("All Technicians"));

//-------------------------------------------------------------------------------------
//======================================Task#2390======================================
		}
		else{
			label_cell("N/A");
		}
        if($_POST['complain']){
			label_cell($schedule_type[SC_COMPLAIN]);
			hidden('type', SC_COMPLAIN);
		}

		if($_POST['maintenance']){
			label_cell($schedule_type[SC_MAINATAIN]);
			hidden('type', SC_MAINATAIN);
		}
		if($_POST['schedule']){
			schedule_types_list_cells(null, 'type', null, false, false);
		}
		else{
			schedule_types_list_cells(null, 'type', null, false, false);
		}
		if($_POST['addressline']){
		    label_cell($_POST['addressline'].'
		    <a class="" href=javascript:modal_viewer()> <br> 
		    Change Addres</a>');
		}
		else{
		    label_cell('<a class="" href=javascript:modal_viewer()>Enter Addres</a>');    
		}
		
		hidden('Cordinates', $_POST['Cordinates']);
		hidden('addressline', $_POST['addressline']);
		
		if($line_no!=-1 && $line_no == $id){
		      label_cell("N/A");
		}
		else{
		    frequency_list_cells(null, 'frequency', null, false, false);  
		}
		
		
		textarea_cells(null, 'remarks', null, 30, 4, _("Inspection Remarks"));
		
		if($line_no!=-1 && $line_no == $id){
			button_cell('UpdateItem', _("Update"), _('Confirm changes'), ICON_UPDATE);
			button_cell('CancelItemChanges', _("Cancel"), _('Cancel changes'), ICON_CANCEL);
			hidden('LineNo', $line_no);
		}
		else{
			submit_cells('AddItem', _("Add Item"), "colspan=2 align='left'", _('Add new item to document'), true);
			////Task#2400
			label_cell();

		}
		hidden('item_list', $_POST['item_list']);
	}
	else{

		label_cell("N/A");
		label_cell("N/A");
		label_cell("N/A");
		label_cell("N/A");
		label_cell("N/A");
		label_cell("N/A");
		label_cell("N/A");
		label_cell("N/A");
		label_cell("N/A");
		label_cell("N/A");
		label_cell("N/A");
		label_cell("");
		label_cell("");
		label_cell("");
		label_cell("");
	}

}
//------------------------------------------------------------------------------------------

display_header($_SESSION['schedule']);

start_table(TABLESTYLE2, 'width:90% !important ;', 10);
echo "<tr><td>";
display_summary($_SESSION['schedule']);


echo "</td></tr>";    


end_table(1);

submit_center_first('ProcessOrder', _("Process"), _('Check entered data and save document'), 'default');
submit_center_last('CancelOrder', "Cancel", _('Cancels document entry'), false, false, null, 0);


end_form();
end_page();
?>

<script>
	 
function addressAutocomplete(containerElement, callback, options) {

  const MIN_ADDRESS_LENGTH = 3;
  const DEBOUNCE_DELAY = 100;
  
  // create container for input element
  const inputContainerElement = document.createElement("div");
  inputContainerElement.setAttribute("class", "input-container");
  containerElement.appendChild(inputContainerElement);
  var data = <?php echo json_encode($_POST) ?>;
  // create input element
  const inputElement = document.createElement("input");
  inputElement.setAttribute("type", "text");
  inputElement.setAttribute("name", "location");
  if(data.location != null)
  	inputElement.setAttribute("value", data.location);
  inputElement.setAttribute("autocomplete", "off");
  inputElement.setAttribute("placeholder", "Enter Location");
  const inputElementCordinates = document.createElement("input");
  inputElementCordinates.setAttribute("type", "hidden");
  inputElementCordinates.setAttribute("name", "loc_cordinates");
  inputElementCordinates.setAttribute("value", data.loc_cordinates);
  inputContainerElement.appendChild(inputElement);
  inputContainerElement.appendChild(inputElementCordinates);

  // add input field clear button
  const clearButton = document.createElement("div");
  clearButton.classList.add("clear-button");
  addIcon(clearButton);
  clearButton.addEventListener("click", (e) => {
    e.stopPropagation();
    inputElement.value = '';
    inputElementCordinates.value = '';
    callback(null);
    clearButton.classList.remove("visible");
    closeDropDownList();
  });
  inputContainerElement.appendChild(clearButton);

  /* We will call the API with a timeout to prevent unneccessary API activity.*/
  let currentTimeout;

  /* Save the current request promise reject function. To be able to cancel the promise when a new request comes */
  let currentPromiseReject;

  /* Focused item in the autocomplete list. This variable is used to navigate with buttons */
  let focusedItemIndex;

  /* Process a user input: */
  inputElement.addEventListener("input", function(e) {
    const currentValue = this.value;

    /* Close any already open dropdown list */
    closeDropDownList();


    // Cancel previous timeout
    if (currentTimeout) {
      clearTimeout(currentTimeout);
    }

    // Cancel previous request promise
    if (currentPromiseReject) {
      currentPromiseReject({
        canceled: true
      });
    }

    if (!currentValue) {
      clearButton.classList.remove("visible");
    }

    // Show clearButton when there is a text
    clearButton.classList.add("visible");

    // Skip empty or short address strings
    if (!currentValue || currentValue.length < MIN_ADDRESS_LENGTH) {
      return false;
    }

    /* Call the Address Autocomplete API with a delay */
    currentTimeout = setTimeout(() => {
      currentTimeout = null;

      /* Create a new promise and send geocoding request */
      const promise = new Promise((resolve, reject) => {
        currentPromiseReject = reject;

        // The API Key provided is restricted to JSFiddle website
        // Get your own API Key on https://myprojects.geoapify.com
        const apiKey = '51b437e2fd09492caf65cf8dd6667505';

        var url = `https://api.geoapify.com/v1/geocode/autocomplete?text=${encodeURIComponent(currentValue)}&format=json&filter=countrycode:ae&limit=5&apiKey=${apiKey}`;

        fetch(url)
          .then(response => {
            currentPromiseReject = null;

            // check if the call was successful
            if (response.ok) {
              response.json().then(data => resolve(data));
            } else {
              response.json().then(data => reject(data));
            }
          });
      });

      promise.then((data) => {
        // here we get address suggestions
        currentItems = data.results;

        /*create a DIV element that will contain the items (values):*/
        const autocompleteItemsElement = document.createElement("div");
        autocompleteItemsElement.setAttribute("class", "autocomplete-items");
        inputContainerElement.appendChild(autocompleteItemsElement);

        /* For each item in the results */
        data.results.forEach((result, index) => {
          /* Create a DIV element for each element: */
          const itemElement = document.createElement("div");
          /* Set formatted address as item value */
          itemElement.innerHTML = result.formatted;
          autocompleteItemsElement.appendChild(itemElement);

          /* Set the value for the autocomplete text field and notify: */
          itemElement.addEventListener("click", function(e) {
            inputElement.value = currentItems[index].formatted;
            inputElementCordinates.value = currentItems[index].lat +","+currentItems[index].lon;
            callback(currentItems[index]);
            /* Close the list of autocompleted values: */
            closeDropDownList();
          });
        });

      }, (err) => {
        if (!err.canceled) {
          console.log(err);
        }
      });
    }, DEBOUNCE_DELAY);
  });

  function setActive(items, index) {
    if (!items || !items.length) return false;

    for (var i = 0; i < items.length; i++) {
      items[i].classList.remove("autocomplete-active");
    }

    /* Add class "autocomplete-active" to the active element*/
    items[index].classList.add("autocomplete-active");

    // Change input value and notify
    inputElement.value = currentItems[index].formatted;
    console.log(currentItems[index].lat +","+currentItems[index].lon);
    inputElementCordinates.value = currentItems[index].lat +","+currentItems[index].lon;
    callback(currentItems[index]);
  }

  function closeDropDownList() {
    const autocompleteItemsElement = inputContainerElement.querySelector(".autocomplete-items");
    if (autocompleteItemsElement) {
      inputContainerElement.removeChild(autocompleteItemsElement);
    }

    focusedItemIndex = -1;
  }

  function addIcon(buttonElement) {
    const svgElement = document.createElementNS("http://www.w3.org/2000/svg", 'svg');
    svgElement.setAttribute('viewBox', "0 0 24 24");
    svgElement.setAttribute('height', "24");

    const iconElement = document.createElementNS("http://www.w3.org/2000/svg", 'path');
    iconElement.setAttribute("d", "M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z");
    iconElement.setAttribute('fill', 'currentColor');
    svgElement.appendChild(iconElement);
    buttonElement.appendChild(svgElement);
  }
  
    /* Close the autocomplete dropdown when the document is clicked. 
      Skip, when a user clicks on the input field */
  document.addEventListener("click", function(e) {
    if (e.target !== inputElement) {
      closeDropDownList();
    } else if (!containerElement.querySelector(".autocomplete-items")) {
      // open dropdown list again
      var event = document.createEvent('Event');
      event.initEvent('input', true, true);
      inputElement.dispatchEvent(event);
    }
  });
}

function modal_viewer(){
	$('#addModal').modal('show');
	addressAutocomplete(document.getElementById("autocomplete-container"), (data) => {
  console.log("Selected option: ");
  console.log(data);
}, {
  placeholder: "Enter an address here"}
  );
	$('#change').show();
}
 
</script>