<?php

//---------------------------------------------------------------------------
//
//	Entry/Modify free hand Credit Note
//
if(isset($_GET['ModifyCredit'])){
    $page_security = 'SA_SALESCREDITMODIFY';
}else{
	$page_security = 'SA_SALESCREDIT';
}
$path_to_root = "..";
include_once($path_to_root . "/sales/includes/cart_class.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/sales/includes/db/sales_types_db.inc");
include_once($path_to_root . "/sales/includes/ui/sales_credit_ui.inc");
include_once($path_to_root . "/sales/includes/ui/sales_order_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/access/mobile_detect.php");
include_once($path_to_root . "/admin/db/loyality_db.inc");



$js = "";
if ($SysPrefs->use_popup_windows) {
	$js .= get_js_open_window(900, 500);
}
if (user_use_date_picker()) {
	$js .= get_js_date_picker();
}

if(isset($_GET['NewCredit'])) {
	$_SESSION['page_title'] = _($help_context = "Customer Credit Note");
	handle_new_credit(0,$_GET['attachment']);
}else if(isset($_GET['AddedMBL'])) {
	$_SESSION['page_title'] = _($help_context = "Customer Credit Note");

	submenu_thermal_print(_("&Print Whole Order Thermal Print With Price"), ST_CUSTCREDIT, $_GET['AddedMBL'], 'prtopt', 0, 0, 1);	
	
	handle_new_credit(0);
}  
elseif (isset($_GET['ModifyCredit'])) {
	$_SESSION['page_title'] = sprintf(_("Modifying Customer Credit Note #%d"), $_GET['ModifyCredit']);
	handle_new_credit($_GET['ModifyCredit']);
	$help_context = "Modifying Customer Credit Note";
}

page($_SESSION['page_title'],false, false, "", $js);

// pk
if(isset($_GET['AddedMBL'])) {

	echo '<div class="col-sm-12">';
	echo ' &nbsp; &nbsp; &nbsp;  &nbsp; &nbsp; &nbsp;  &nbsp; &nbsp; &nbsp;<span>';
	echo get_trans_view_str(ST_CUSTCREDIT, $_GET['AddedMBL'], '<img src ="'.$path_to_root.'/themes/'.user_theme().'/images/icon/view.png" style="width: 50px;">', false, 'viewlink', null);
	echo '</span>  &nbsp; &nbsp; &nbsp;  &nbsp; &nbsp; &nbsp;  &nbsp; &nbsp; &nbsp;';

	echo '<span>';	
	echo print_document_link($_GET['AddedMBL']."-".ST_CUSTCREDIT, '<img src ="'.$path_to_root.'/themes/'.user_theme().'/images/icon/report.png" style="width: 50px;">', true, ST_CUSTCREDIT, false, 'printlink', 'prtopt', 0, 0, 'A4');
	echo '</span>';

	echo ' </div>';
}

//-----------------------------------------------------------------------------

check_db_has_stock_items(_("There are no items defined in the system."));

check_db_has_customer_branches(_("There are no Customers, or there are no Customers with branches. Please define Customers and customer branches."));

//-----------------------------------------------------------------------------

if (list_updated('branch_id')) {
	// when branch is selected via external editor also customer can change
	$br = get_branch(get_post('branch_id'));
	$_POST['customer_id'] = $br['debtor_no'];
	$Ajax->activate('customer_id');
}

if (isset($_GET['AddedID'])) {
	$credit_no = $_GET['AddedID'];
	$trans_type = ST_CUSTCREDIT;

	$detect = new Mobile_Detect();
	if ($detect->isMobile()){
		meta_forward($_SERVER['PHP_SELF'], "AddedMBL=$credit_no");
	}

	display_notification_centered(sprintf(_("Credit Note # %d has been processed"),$credit_no));
echo '<ol class="rounded-list">';
	echo '<li>';
	display_note(get_customer_trans_view_str($trans_type, $credit_no, _("&View this credit note"), false, '', '', $path_to_root, basename($_SERVER['PHP_SELF']) ), 0, 1);
echo '</li><li>';
	display_note(print_document_link($credit_no."-".$trans_type, _("&Print This Credit Invoice"), true, ST_CUSTCREDIT),0, 1);
	echo '</li><li>';
	display_note(print_document_link($credit_no."-".$trans_type, _("&Email This Credit Invoice"), true, ST_CUSTCREDIT, false, "printlink", "", 1),0, 1);
echo '</li><li>';
	display_note(get_gl_view_str($trans_type, $credit_no, _("View the GL &Journal Entries for this Credit Note")));
echo '</li><li><span>';
	hyperlink_params($_SERVER['PHP_SELF'], _("Enter Another &Credit Note"), "NewCredit=yes");
echo '</span></li><li><span>';

	hyperlink_params("$path_to_root/admin/attachments.php", _("Add an Attachment"), "filterType=$trans_type&trans_no=$credit_no");

echo '</span></li></ol>';
	display_footer_exit();
} else
	check_edit_conflicts(get_post('cart_id'));

//--------------------------------------------------------------------------------

function line_start_focus() {
  	global $Ajax;
  	$Ajax->activate('items_table');
  	$Ajax->activate('mobile_form');
  	set_focus('_stock_id_edit');
}

//-----------------------------------------------------------------------------

function copy_to_cn()
{
	$cart = &$_SESSION['Items'];
	$cart->Comments = $_POST['CreditText'];
	$cart->document_date = $_POST['OrderDate'];
	$cart->freight_cost = input_num('ChargeFreightCost');
	$cart->Location = (isset($_POST["Location"]) ? $_POST["Location"] : "");
	$cart->sales_type = $_POST['sales_type_id'];
	if ($cart->trans_no == 0)
		$cart->reference = $_POST['ref'];
	$cart->ship_via = $_POST['ShipperID'];
	$cart->dimension_id = $_POST['dimension_id'];
	$cart->dimension2_id = $_POST['dimension2_id'];
}

//-----------------------------------------------------------------------------

function copy_from_cn()
{
	$cart = &$_SESSION['Items'];
	$_POST['CreditText'] = $cart->Comments;
	$_POST['OrderDate'] = $cart->document_date;
	$_POST['ChargeFreightCost'] = price_format($cart->freight_cost);
	$_POST['Location'] = $cart->Location;
	$_POST['sales_type_id'] = $cart->sales_type;
	if ($cart->trans_no == 0)
		$_POST['ref'] = $cart->reference;
	$_POST['ShipperID'] = $cart->ship_via;
	$_POST['dimension_id'] = $cart->dimension_id;
	$_POST['dimension2_id'] = $cart->dimension2_id;
	$_POST['cart_id'] = $cart->cart_id;
}

//-----------------------------------------------------------------------------

function handle_new_credit($trans_no,$attachment_id)
{
	processing_start();
	$_SESSION['Items'] = new Cart(ST_CUSTCREDIT,$trans_no);
	if (isset($attachment_id)) {
		$_SESSION['Items']->attachment = $attachment_id;
	}
	copy_from_cn();
}

//-----------------------------------------------------------------------------

function can_process()
{
	global $Refs;

	$input_error = 0;

	if ($_SESSION['Items']->count_items() == 0 && (!check_num('ChargeFreightCost',0)))
		return false;
	if($_SESSION['Items']->trans_no == 0) {
	    if (!$Refs->is_valid($_POST['ref'], ST_CUSTCREDIT)) {
			display_error( _("You must enter a reference."));
			set_focus('ref');
			$input_error = 1;
		}
	}
	if (!is_date($_POST['OrderDate'])) {
		display_error(_("The entered date for the credit note is invalid."));
		set_focus('OrderDate');
		$input_error = 1;
	} elseif (!is_date_in_fiscalyear($_POST['OrderDate'])) {
		display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
		set_focus('OrderDate');
		$input_error = 1;
	}
	return ($input_error == 0);
}

//-----------------------------------------------------------------------------

if (isset($_POST['ProcessCredit']) && can_process()) {
	copy_to_cn();
	if ($_POST['CreditType'] == "WriteOff" && (!isset($_POST['WriteOffGLCode']) ||
		$_POST['WriteOffGLCode'] == '')) {
		display_note(_("For credit notes created to write off the stock, a general ledger account is required to be selected."), 1, 0);
		display_note(_("Please select an account to write the cost of the stock off to, then click on Process again."), 1, 0);
		exit;
	}
	if (!isset($_POST['WriteOffGLCode'])) {
		$_POST['WriteOffGLCode'] = 0;
	}
	copy_to_cn();
	$attachment_id = $_SESSION['Items']->attachment;
	$trans_type = $_SESSION['Items']->trans_type;
	
	$credit_no = $_SESSION['Items']->write($_POST['WriteOffGLCode']);
	if ($credit_no == -1)
	{
		display_error(_("The entered reference is already in use."));
		set_focus('ref');
	}
	else
	{
		new_doc_date($_SESSION['Items']->document_date);
		processing_end();
		if ($attachment_id > 0) {
			link_document($attachment_id , $credit_no, $trans_type);
		}
		meta_forward($_SERVER['PHP_SELF'], "AddedID=$credit_no");
	}
} /*end of process credit note */

  //-----------------------------------------------------------------------------

function check_item_data()
{
	if (!check_num('qty',0)) {
		display_error(_("The quantity must be greater than zero."));
		set_focus('qty');
		return false;
	}
	if (!check_num('price',0)) {
		display_error(_("The entered price is negative or invalid."));
		set_focus('price');
		return false;
	}
	if (!check_num('Disc', 0, 100)) {
		display_error(_("The entered discount percent is negative, greater than 100 or invalid."));
		set_focus('Disc');
		return false;
	}
	return true;
}

//-----------------------------------------------------------------------------

function handle_update_item()
{
	if ($_POST['UpdateItem'] != "" && check_item_data()) {
		$_SESSION['Items']->update_cart_item($_POST['line_no'], input_num('qty'),
			input_num('price'), input_num('Disc'));
	}
    line_start_focus();
}

//-----------------------------------------------------------------------------

function handle_delete_item($line_no)
{
	$_SESSION['Items']->remove_from_cart($line_no);
    line_start_focus();
}

//-----------------------------------------------------------------------------

function handle_new_item()
{

	if (!check_item_data())
		return;

	add_to_order($_SESSION['Items'], $_POST['stock_id'], input_num('qty'),
		input_num('price'), input_num('Disc') );
    line_start_focus();
}
//-----------------------------------------------------------------------------
// code for modal work
if(isset($_POST['invoice_feild_update'])){

	update_form_feild_status(11, get_post(array('pc_customer_id_checkbox', 'pc_branch_id_checkbox', 'pc_reference_checkbox', 'pc_current_credit_checkbox', 'pc_customer_discount_checkbox', 'pc_payment_checkbox' , 'pc_price_list_checkbox', 'pc_date_checkbox', 'pc_dimension_checkbox', 'pc_dimension_2_checkbox', 'pc_exchange_rate_checkbox' )), get_post(array('mbl_customer_id_checkbox', 'mbl_branch_id_checkbox', 'mbl_reference_checkbox', 'mbl_current_credit_checkbox', 'mbl_customer_discount_checkbox', 'mbl_payment_checkbox' , 'mbl_price_list_checkbox', 'mbl_date_checkbox', 'mbl_dimension_checkbox', 'mbl_dimension_2_checkbox', 'mbl_exchange_rate_checkbox', 'mbl_customer_currency_checkbox' )));
}


$id = find_submit('Delete');
if ($id!=-1)
	handle_delete_item($id);

if (isset($_POST['AddItem']))
	handle_new_item();

if (isset($_POST['UpdateItem']))
	handle_update_item();

if (isset($_POST['CancelItemChanges']))
	line_start_focus();

//-----------------------------------------------------------------------------

if (!processing_active()) {
	handle_new_credit(0);
}

//-----------------------------------------------------------------------------

start_form();
hidden('cart_id');

$detect = new Mobile_Detect();
if ($detect->isMobile()){
	if ($_SESSION["wa_current_user"]->can_access_page('INVOICE_FORM_FIELD'))
		echo "<a  class='' data-target='#modal_invoice_view' data-toggle='modal'><i style='float: right;' title='Select Table widgets' class='fa fa-plus-circle fa-2x'></i></a>";
	
	$customer_error = display_credit_header_for_mobile($_SESSION['Items']);
	if ($customer_error == "") {

		br();
		div_start('mobile_form');
		start_table(TABLESTYLE2, 'width:90% !important ;', 10);
		credit_edit_item_controls_for_mobile(_("Credit Note Items"), $_SESSION['Items']);
	    end_table();
		div_end();

		display_credit_items_for_mobile(_("Credit Note Items"), $_SESSION['Items']);
		
		credit_options_controls($_SESSION['Items']);

		echo "<center>";
		submit_cells('Update', _("Update"));
		submit_cells('ProcessCredit', _("Process Credit Note"), '', false, 'default');
		echo "</center>";



	}else{
		display_error($customer_error);
	}
}else{
	if ($_SESSION["wa_current_user"]->can_access_page('INVOICE_FORM_FIELD'))
		echo "<a  class='' data-target='#modal_invoice_view' data-toggle='modal'><i style='float: right;' title='Select Table widgets' class='fa fa-plus-circle fa-2x'></i></a>";

	$customer_error = display_credit_header($_SESSION['Items']);

	if ($customer_error == "") {
			start_table(TABLESTYLE, "style='width:100% !important'", 10);
		echo "<tr><td>";
		display_credit_items(_("Credit Note Items"), $_SESSION['Items']);
		echo "</td></tr>";
			end_table();
		start_table(TABLESTYLE, "width='80%'", 10);
		echo "<tr><td>";
		credit_options_controls($_SESSION['Items']);
		echo "</td></tr>";

		end_table();
	} else {
		display_error($customer_error);
	}

	echo "<br><center><table><tr>";
	submit_cells('Update', _("Update"));
	submit_cells('ProcessCredit', _("Process Credit Note"), '', false, 'default');
	echo "</tr></table></center>";
	echo'<br/>';
}
end_form();
end_page();


?>

<div class="container-fluid">
	<form method="post">
		<div class="modal fade" id="modal_invoice_view" role="dialog">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-header">
						<a  class="close" data-dismiss="modal">&times;</a>
						<h4 class="modal-title">Direct Invoice Form Feilds</h4>
          				<br>
          				<!-- <select data-live-search="true" name="view" class="form-control" style=" width: 25%;">
                        	<option value="pc">Pc</option>
                        	<option value="mbl">Mobile</option>
                    	</select> -->
          			</div>
          			<div class="modal-body">
          				<table class="table table-hover" style="margin-left: 113px;">
          					<thead>
          						<tr>
          							<th>Feild Name</th>
          							<th style="width: 70px;">For Pc</th>
          							<th>For Mobile</th>
          						</tr>
          					</thead>
          					<tbody>
          					<?php
          					$res = get_form_feilds_status(11);
          					while($row = db_fetch($res)){
          					echo "<tr><td>".$row['tag_name']."</td><td>".checkbox(_(null),'pc_'.$row['name'], $row['status_pc'],false)."</td><td>".checkbox(_(null),'mbl_'.$row['name'], $row['status_mbl'],false)  ."</td></tr>";
          					}
          					?>	
          						
          					</tbody>
          				</table>
          			</div>
          			<div class="modal-footer">
          				<input class="btn btn-info center-block" type="submit" value='Update' name="invoice_feild_update">
          			</div>
          		</div>
          	</div>
        </div>
    </form>
</div>
