<?php


function add_sales_group($description)
{
	$sql = "INSERT INTO ".TB_PREF."groups (description) VALUES (".db_escape($description) . ")";
   	db_query($sql,"The sales group could not be added");

   	$sql2 = "SELECT MAX(id) AS id FROM ".TB_PREF."groups";
	$result2 = db_query($sql2);
	$myrow2 = db_fetch($result2);

	add_audit_trail(SM_GROUPS, $myrow2['id'], Today(), _("Create New Sales Group"));
}

function update_sales_group($selected_id, $description)
{
	$sql = "UPDATE ".TB_PREF."groups SET description=".db_escape($description)." WHERE id = ".db_escape($selected_id);

	add_audit_trail(SM_GROUPS, $selected_id, Today(), _("Update Sales Group"));

   	db_query($sql,"The sales group could not be updated");
}

function delete_sales_group($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."groups WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete sales group");
	add_audit_trail(SM_GROUPS, $selected_id, Today(), _("Delete Sales Group"));
}

function get_sales_groups($show_inactive)
{
	$sql = "SELECT * FROM ".TB_PREF."groups";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	$sql .= " ORDER BY description";
	return db_query($sql,"could not get groups");
}

function get_sales_group($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."groups WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get group");
	return db_fetch($result);
}

function get_sales_group_name($group_no)
{
	$sql = "SELECT description FROM ".TB_PREF."groups WHERE id = ".db_escape($group_no);
	$result = db_query($sql, "could not get group");
	$row = db_fetch($result);
	return $row[0];
}

function add_sales_area($description)
{
	$sql = "INSERT INTO ".TB_PREF."areas (description) VALUES (".db_escape($description) . ")";
   	db_query($sql,"The sales area could not be added");

   	$sql2 = "SELECT MAX(area_code) AS id FROM ".TB_PREF."areas";
		$result2 = db_query($sql2);
		$myrow2 = db_fetch($result2);

	add_audit_trail(SM_SALESAREAS, $myrow2['id'], Today(), _("Create New Sales Area"));
}

function update_sales_area($selected_id, $description)
{
	$sql = "UPDATE ".TB_PREF."areas SET description=".db_escape($description)." WHERE area_code = ".db_escape($selected_id);
   	db_query($sql,"The sales area could not be updated");
   	add_audit_trail(SM_SALESAREAS, $selected_id, Today(), _("Update Sales Area"));
}

function delete_sales_area($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."areas WHERE area_code=".db_escape($selected_id);
	db_query($sql,"could not delete sales area");
	add_audit_trail(SM_SALESAREAS, $selected_id, Today(), _("Delete Sales Area"));
}

function get_sales_areas($show_inactive)
{
	$sql = "SELECT * FROM ".TB_PREF."areas";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	return db_query($sql,"could not get areas");
}

function get_sales_area($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."areas WHERE area_code=".db_escape($selected_id);

	$result = db_query($sql,"could not get area");
	return db_fetch($result);
}

function get_area_name($id)
{
	$sql = "SELECT description FROM ".TB_PREF."areas WHERE area_code=".db_escape($id);

	$result = db_query($sql, "could not get sales type");

	$row = db_fetch_row($result);
	return $row[0];
}

function add_salesman($salesman_name, $salesman_phone, $salesman_fax,
	$salesman_email, $provision, $break_pt, $provision2,$salesman_name_arabic)
{
	$sql = "INSERT INTO ".TB_PREF."salesman (salesman_name, salesman_phone, salesman_fax, salesman_email,
		provision, break_pt, provision2,salesman_name_arabic)
		VALUES (".db_escape($salesman_name) . ", "
		  .db_escape($salesman_phone) . ", "
		  .db_escape($salesman_fax) . ", "
		  .db_escape($salesman_email) . ", ".
		$provision.", ".$break_pt.", "
		.$provision2.","
		  .db_escape($salesman_name_arabic) . ")";
   	db_query($sql,"The insert of the sales person failed");

   	$sql2 = "SELECT MAX(salesman_code) AS id FROM ".TB_PREF."salesman";
		$result2 = db_query($sql2);
		$myrow2 = db_fetch($result2);

   	add_audit_trail(SM_SALESPERSON, $myrow2['id'], Today(), _("New Sales Person"));

}

function update_salesman($selected_id, $salesman_name, $salesman_phone, $salesman_fax,
	$salesman_email, $provision, $break_pt, $provision2,$salesman_name_arabic)
{
	$sql = "UPDATE ".TB_PREF."salesman SET salesman_name=".db_escape($salesman_name) . ",
		salesman_phone=".db_escape($salesman_phone) . ",
		salesman_fax=".db_escape($salesman_fax) . ",
		salesman_email=".db_escape($salesman_email) . ",
		provision=".$provision.",
		break_pt=".$break_pt.",
		provision2=".$provision2.",
		salesman_name_arabic=".db_escape($salesman_name_arabic) . "
		WHERE salesman_code = ".db_escape($selected_id);

		add_audit_trail(SM_SALESPERSON, $selected_id, Today(), _("Update Sales Person"));
   	db_query($sql,"The update of the sales person failed");
}

function delete_salesman($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."salesman WHERE salesman_code=".db_escape($selected_id);

	add_audit_trail(SM_SALESPERSON, $selected_id, Today(), _("Delete Sales Person"));
	db_query($sql,"The sales-person could not be deleted");
}

function get_salesmen($show_inactive)
{
	$sql = "SELECT * FROM ".TB_PREF."salesman";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	return db_query($sql,"could not get sales persons");
}

function get_salesman($selected_id)
{
	$sql = "SELECT *  FROM ".TB_PREF."salesman WHERE salesman_code=".db_escape($selected_id);

	$result = db_query($sql,"could not get sales person");
	return db_fetch($result);
}

function get_salesman_name($id)
{
	$sql = "SELECT salesman_name FROM ".TB_PREF."salesman WHERE salesman_code=".db_escape($id);

	$result = db_query($sql, "could not get sales type");

	$row = db_fetch_row($result);
	return $row[0];
}

///Task#2389

function add_technician($name, $salary=null,$ov_salary=null){

	
	$sql = "INSERT INTO ".TB_PREF."technician (name, salary,ov_salary) VALUES (".db_escape($name).",".db_escape($salary).",".db_escape($ov_salary).")";
   	db_query($sql,"The technician could not be added");

   	$sql2 = "SELECT MAX(id) AS id FROM ".TB_PREF."technician";
	$result2 = db_query($sql2);
	$myrow2 = db_fetch($result2);

	add_audit_trail(SM_TECHNICIAN, $myrow2['id'], Today(), _("Create New Technician"));
}

function update_technician($selected_id, $description, $salary=null,$ov_salary=null){

	$sql = "UPDATE ".TB_PREF."technician SET name=".db_escape($description).",
			salary=".db_escape($salary).",
			ov_salary=".db_escape($ov_salary)."
			WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The technician could not be updated");
   	add_audit_trail(SM_TECHNICIAN, $selected_id, Today(), _("Update Technician"));
}

function delete_technician($selected_id){

	$sql="DELETE FROM ".TB_PREF."technician WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete technician");
	add_audit_trail(SM_TECHNICIAN, $selected_id, Today(), _("Delete Technician"));
}

function get_technicians($show_inactive){

	$sql = "SELECT * FROM ".TB_PREF."technician";
	if (!$show_inactive) 
		$sql .= " WHERE !inactive";

	return db_query($sql,"could not get technicians");
}

function get_technician($selected_id){

	$sql = "SELECT * FROM ".TB_PREF."technician WHERE id=".db_escape($selected_id);
	$result = db_query($sql,"could not get technician");
	return db_fetch($result);
}

function get_technician_name($id){
	$sql = "SELECT name FROM ".TB_PREF."technician WHERE id=".db_escape($id);
	$result = db_query($sql, "could not get technician");
	$row = db_fetch_row($result);
	return $row[0];
}

function get_all_technician_ids(){
	$result = get_technicians(false);
	$technicians = '';
	while($row = db_fetch($result)){
		$technicians .= $row['id'].','; 
	}
	$technicians = trim($technicians, ",");
	return $technicians;
}

///Task#2389


