<?php


function get_sql_for_schedule_inquiry($so_ref=0, $customer=0, $FromDate=0, $ToDate=0, $stock_id=0, $status=0, $technician=null, $approved=null){
    //codi
	// if($show_unapproved == 0)
	// 	$approved = 1;
	// elseif($show_unapproved == 1)
	// 	$approved = 0;
    //codi
    
	$sql = "SELECT @a:=@a+1, so.reference, line.id, so.debtor_no, 
	CONCAT(line.stk_code, ' - ', line.description), so.inquiry_type,
	sc.type, so.ord_date,sc.date,sc.start_time, sc.location, sc.technician, 
	sc.id AS schedule_id, sc.end_time, so.order_no, sc.status, sc.loc_cordinates,
	sc.dimension_id, sc.approved  
	FROM (SELECT @a:= 0) AS a, ".TB_PREF."schedules AS sc 
	LEFT JOIN ".TB_PREF."sales_order_details AS line ON sc.soline=line.id 
	LEFT JOIN ".TB_PREF."sales_orders AS so ON so.order_no=line.order_no AND so.trans_type = line.trans_type 
	WHERE line.trans_type=30";

	if($so_ref){
		$sql .= " AND so.reference LIKE ".db_escape("%".$so_ref."%");
	}
	else{
		$sql .= " AND sc.date BETWEEN ".db_escape(date2sql($FromDate))." AND ".db_escape(date2sql($ToDate));
	}

	if($customer){
		$sql .= " AND so.debtor_no=".db_escape($customer);
	}
	if($stock_id){
		$sql .= " AND line.stk_code=".db_escape($stock_id);
	}
	if($status==1){
	    $sql .= " AND sc.status!=2";
	}
	elseif($status==2){
	    $sql .= " AND sc.status=2";
	}
	
	//codi
	if($approved)	
		$sql .= " AND sc.approved = ".db_escape(0);	
	else
		$sql .= " AND sc.approved = ".db_escape(1);	

	//codi
	if($technician)
		$sql .= " AND  ".$technician." IN (sc.technician)  ";
	   // display_error($sql);
	return $sql;
}

//codi
function scheduleSetApprove($id, $status=1){
	$status=1;
	// $transType = ST_SCHEDULE;
  	$sql = "UPDATE ".TB_PREF."schedules SET approved = ".db_escape($status)." WHERE id =".db_escape($id)."";
  	db_query($sql, "Can't change schedule approved schedulesSetApprove function ");


  	
  	// add_audit_trail(ST_SALESQUOTE, $id, date('d/m/Y'),'Sales Quotation is approved');	//pk
}
//codi


function get_sql_for_schedule_against_so($so_ref=0, $customer=0, $FromDate=0, $ToDate=0, $stock_id=0, $user=0, $status=0, $type=0){

	$sql = "SELECT @a:=@a+1, so.reference, line.id, so.debtor_no, CONCAT(line.stk_code, ' - ', line.description), 
	so.inquiry_type, so.ord_date, null as created, so.order_no, so.user, COUNT(s.id) AS scheduled
	FROM (SELECT @a:= 0) AS a, ".TB_PREF."sales_order_details AS line 
	LEFT JOIN ".TB_PREF."sales_orders AS so ON so.order_no=line.order_no AND so.trans_type=line.trans_type 
	LEFT JOIN ".TB_PREF."schedules AS s ON s.soline=line.id 
	WHERE line.trans_type=30 AND so.reference<>'auto'";

	if($so_ref){
		$sql .= " AND so.reference LIKE ".db_escape("%".$so_ref."%");
	}
	else{
		$sql .= " AND ord_date BETWEEN ".db_escape(date2sql($FromDate))." AND ".db_escape(date2sql($ToDate));
	}

	if($customer){
		$sql .= " AND so.debtor_no=".db_escape($customer);
	}
	if($stock_id){
		$sql .= " AND line.stk_code=".db_escape($stock_id);
	}
	if($user){
		$sql .= " AND so.user=".db_escape($user);
	}
	if($type){
		$sql .= " AND so.inquiry_type=".db_escape($type);
	}

	$sql .= " GROUP BY line.id";

	if($status == 1){
		$sql .= " HAVING scheduled<>0";
	}
	elseif($status==2){
		$sql .= " HAVING scheduled=0";
	}
	return $sql;
}

function get_soline_info($soline){
	$sql = "SELECT * FROM ".TB_PREF."sales_order_details AS line 
	LEFT JOIN ".TB_PREF."sales_orders AS so ON so.order_no=line.order_no AND so.trans_type=line.trans_type 
	WHERE line.trans_type=30 AND line.id=".$soline;

	return db_fetch(db_query($sql));
}

function get_schedules($soline){
	$sql = "SELECT * FROM ".TB_PREF."schedules WHERE soline=".db_escape($soline);
	return db_query($sql);
}
function get_schedule_type($ord_number){
	$sql = "SELECT type FROM ".TB_PREF."schedules WHERE 
	delivery=".db_escape($ord_number);
	return db_fetch(db_query($sql));
}

function GetSchedulsByDimension($dimension_id){
	$sql = " SELECT * FROM 	".TB_PREF."payroll_transaction WHERE dimension_id = ".db_escape($dimension_id)." 
				ORDER BY technician_id ASC ";
	return db_query($sql, "Could Not Get The Record Of Dimension", true);
}


function add_update_schedules(&$cart){

	foreach($cart->schedules as $schedule){
		if($schedule->id){
			$sql = "UPDATE ".TB_PREF."schedules SET 

			date=".db_escape(date2sql($schedule->date)).", 
			end_date=".db_escape(date2sql($schedule->end_date)).", 
			start_time=".db_escape($schedule->start_time).", 
			end_time=".db_escape($schedule->end_time).", 
			ov_time=".db_escape($schedule->ov_time).", 
			type=".db_escape($schedule->type).", 
			location=".db_escape($schedule->location).", 
			technician=".db_escape($schedule->technician).", 
			loc_cordinates=".db_escape($schedule->loc_cordinates).", 
			dimension_id=".db_escape($cart->dimension_id).", 
			remarks=".db_escape($schedule->remarks).",
			quantity=".db_escape($schedule->quantity)." 
			WHERE id=".$schedule->id;
			db_query($sql);
		}
		else{
			$sql = "INSERT INTO ".TB_PREF."schedules (soline,date,end_date, start_time, end_time,ov_time,location, type, technician, remarks, loc_cordinates, dimension_id, quantity) 
			VALUES (".db_escape($cart->soline).", ".
			db_escape(date2sql($schedule->date)).", ".
			db_escape(date2sql($schedule->end_date )).", ".
			db_escape($schedule->start_time).", ".
			db_escape($schedule->end_time).", ".
			db_escape($schedule->ov_time).", ".
			db_escape($schedule->location).", ".db_escape($schedule->type).",".
			db_escape($schedule->technician).", ".
			db_escape($schedule->remarks).",".
			db_escape($schedule->loc_cordinates).",".
			db_escape($cart->dimension_id).",".
			db_escape($schedule->quantity).")";
			db_query($sql);

			$schedule->id = db_insert_id();
			
            // Sending Message  	
            $Contact = get_soline_info($cart->soline)['contact_phone'];
            $Message = CheckMessageBodyExist($schedule->type);
             if($Message)
                SendTransactionalSMS($Contact, $Message);
            //====
			
			
		}
	}
}