<?php

$page_security = 'SA_SALESCUSTOMERINQUIRY';
$path_to_root = "../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");


$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Customer Transactions"), isset($_GET['customer_id']), false, "", $js);
if (isset($_GET['customer_id'])) {
	echo '<script src="' . $path_to_root . '/themes/'.user_theme(). '/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>';
}
//------------------------------------------------------------------------------------------------

function attach($row){

	if(!$_SESSION['wa_current_user']->can_access_page('SA_ATTACHDOCUMENT'))
		return '';
	else
		return pager_link(_("Link Document"), $path_to_root."/admin/attachments.php?filterType=".$row["type"]."&trans_no=".$row["trans_no"], ICON_ATTACH);
}



function systype_name($dummy, $type)
{
	global $systypes_array;

	return $systypes_array[$type];
}

function order_view($row)
{
	global $path_to_root;
	return $row['order_']>0 ?
		get_customer_trans_view_str(ST_SALESORDER, $row['order_'], "", false, '', '', $path_to_root) : "";
}

function trans_view($trans)
{
	global $path_to_root;
	return get_trans_view_str($trans["type"], $trans["trans_no"], "", false, '', '', $path_to_root, $page_name);
}

function due_date($row)
{
	return	$row["type"] == ST_SALESINVOICE	?sql2date($row["due_date"]) : '';
}
function s_date($row)
{
	return	sql2date($row['tran_date']);
}


function gl_view($row)
{
	return get_gl_view_str($row["type"], $row["trans_no"]);
}

function fmt_amount($row)
{
    if ($row['type']==ST_SALESINVOICE) {
		return price_format($row["TotalAmount"] - $row["ov_discount"]);
	}
	$value =
	    $row['type']==ST_CUSTCREDIT || $row['type']==ST_CUSTPAYMENT || $row['type']==ST_BANKDEPOSIT ?
		-$row["TotalAmount"] : $row["TotalAmount"];
    return price_format($value);
}

function credit_link($row)
{
	global $page_nested;

	if(!$_SESSION['wa_current_user']->can_access_page('SA_SALESCREDITINV')  &&  $row['type'] == ST_SALESINVOICE){
		return '';
	}

	if ($page_nested)
		return '';
	return $row['type'] == ST_SALESINVOICE && $row["Outstanding"] > 0 ?
		pager_link(_("Credit This") ,
			"/sales/customer_credit_invoice.php?InvoiceNumber=". $row['trans_no'], ICON_CREDIT):'';
}

//pk------------------------------------------------------------------------------------------------
function refund_link($row){

	
	if(!$_SESSION['wa_current_user']->can_access_page('SA_REFUNDDASHBOARD')){
		return '';
	}

		if($row['Allocated'] == 0 || $row['refund'] == 1)
			return '';
		
	return $row['type'] == ST_SALESINVOICE && $row["Outstanding"] > 0 ?
		pager_link(_("Refund This") ,
			"../../../gl/inquiry/refund_dashboard.php?InvoiceNumber=".$row['trans_no'], ICON_REFUND):'';
}
//pk------------------------------------------------------------------------------------------------
function is_auto_delivery($row){
	// echo "<pre>";
	// display_error(print_r(get_sales_parent_numbers(ST_SALESINVOICE, $row['trans_no'])));
	$parent_trans_array = get_sales_parent_numbers(ST_SALESINVOICE, $row['trans_no']);
	foreach ($parent_trans_array as $key => $value) {
		$sql = "SELECT `reference` FROM `0_debtor_trans` WHERE `type` = '13' AND `trans_no` = '$value'";
		$run = db_query($sql);
		$reference = db_fetch($run)['reference'];
		// display_error($reference);
		if ($reference == 'auto') {
			return true;
		}else{
			return false;
		}
	}
}
function edit_link($row)
{
	global $page_nested;

	if(!$_SESSION["wa_current_user"]->can_access_page('SA_SALESINVOICEEDIT') &&  $row['type'] ==  ST_SALESINVOICE){
		return '';
	}
	if(!$_SESSION["wa_current_user"]->can_access_page('SA_SALESDELIVERYMODIFY') &&  $row['type'] ==  ST_CUSTDELIVERY){
		return '';
	}

	if(!$_SESSION["wa_current_user"]->can_access_page('SA_SALESCREDITMODIFY') &&  $row['type'] ==  ST_CUSTCREDIT){
		return '';
	}
	
	if(!$_SESSION["wa_current_user"]->can_access_page('SA_SALESINVOICECUSTOMER') &&  $row['type'] ==  ST_CUSTPAYMENT){
		return '';
	}

	$str = '';
	if ($page_nested)
		return '';
	if (count(get_sales_parent_numbers(ST_SALESINVOICE, $row['trans_no'])) > 1 && $row['type'] == ST_SALESINVOICE) {
		return '';
	}
	if (!is_auto_delivery($row) && $row['type'] == ST_SALESINVOICE) {
		return '';
	}

	return $row['type'] == ST_CUSTCREDIT && $row['order_'] ? '' : 	// allow  only free hand credit notes edition
			trans_editor_link($row['type'], $row['trans_no']);
}

function prt_link($row)
{
  	if ($row['type'] == ST_CUSTPAYMENT || $row['type'] == ST_BANKDEPOSIT) 
		return print_document_link($row['trans_no']."-".$row['type'], _("Print Receipt"), true, ST_CUSTPAYMENT, ICON_PRINT);
  	elseif ($row['type'] == ST_BANKPAYMENT) // bank payment printout not defined yet.
		return '';
 	else{
 	    if($row['type']==ST_CUSTDELIVERY)
 	        $TYPE = ST_CUSTDELIVERY1;
        else
            $TYPE = $row['type'];
            
        return print_document_link($row['trans_no']."-".$row['type'], _("Print"), true, $TYPE, ICON_PRINT);
 	}
 		
}

function pos_prt_link($row)
{
  	if ($row['type'] == ST_SALESINVOICE)
 		return print_document_link($row['trans_no']."-".$row['type'], _("Print"), true, ST_SALESINVOICE1, ICON_PRINT);
 	else
 		'';
}
function check_overdue($row)
{
	return $row['OverDue'] == 1
		&& floatcmp($row["TotalAmount"], $row["Allocated"]) != 0;
}
//------------------------------------------------------------------------------------------------

function display_customer_summary($customer_record)
{
	$past1 = get_company_pref('past_due_days');
	$past2 = 2 * $past1;
    if ($customer_record["dissallow_invoices"] != 0)
    {
    	echo "<center><font color=red size=4><b>" . _("Customer Account Is On Hold") . "</font></b></center>";
    }

	$nowdue = "1-" . $past1 . " " . _('Days');
	$pastdue1 = $past1 + 1 . "-" . $past2 . " " . _('Days');
	$pastdue2 = _('Over') . " " . $past2 . " " . _('Days');

    //start_table(TABLESTYLE4, "width='80%'");
    start_table(TABLESTYLE5_BOX,"",0,0,0,"50%","3px solid #2CABE3;");
    $th = array(_("Currency"), _("Terms"), _("Current"), $nowdue,
    	$pastdue1, $pastdue2, _("Total Balance"));
    table_header($th,'font-weight: normal');

	start_row();
    label_cell($customer_record["curr_code"]);
    label_cell($customer_record["terms"]);
	amount_cell($customer_record["Balance"] - $customer_record["Due"]);
	amount_cell($customer_record["Due"] - $customer_record["Overdue1"]);
	amount_cell($customer_record["Overdue1"] - $customer_record["Overdue2"]);
	amount_cell($customer_record["Overdue2"]);
	amount_cell($customer_record["Balance"]);
	end_row();

	end_table();
}

if (isset($_GET['customer_id']))
{
	$_POST['customer_id'] = $_GET['customer_id'];
}

//------------------------------------------------------------------------------------------------
 div_start('ext_tbl');

start_form();
// if (get_post('Search'))
// {
// 	$Ajax->activate('trans_tbl');
// }

if (!isset($_POST['customer_id']))
	$_POST['customer_id'] = get_global_customer();

start_table(TABLESTYLE_NOBORDER,"",0,0,0,"style='width:70% !important; max-width:70% !important;'");
start_row();

if (!$page_nested){
    if($_SESSION['wa_current_user']->access == 18){
	    $user_id = $_SESSION['wa_current_user']->user;
	    customer_list_cells(_("Select a Customer: "), 'customer_id', $user_id, "All Customer", true, false, true, $user_id);
	}else
	    customer_list_cells(_("Select a Customer: "), 'customer_id', null, "All Customer", true, false, true);
}

cust_allocations_list_cells(null, 'filterType', null, true, true);

// text_cells("Ref:","",null);
ref_cells(_("Ref:"), 'reference', '',null, '', true);
dimensions_list_cells(_('Dimension:'), 'dimension',  null, 'Select', null, false, 1, true);
if ($_POST['filterType'] != '2')
{   
    start_table(TABLESTYLE_NOBORDER,"",0,0,0,"style='width:50% !important; max-width:50% !important;'");
    start_row();
    
	date_cells(_("From:"), 'TransAfterDate', '', null, -user_transaction_days(),0,0,null,true);
	date_cells(_("To:"), 'TransToDate', '', null,0,0,0,null,true);


  // 688: function date_cells($label, $name, $title = null, $check=null, $inc_days=0, 
  // 689  	$inc_months=0, $inc_years=0, $params=null, $submit_on_change=false)
}
if(isset($_POST['TransAfterDate'])){

$Ajax->activate('ext_tbl');
}


$trans_type=CUSTINQ;

// display_error(get_post('filterType'));

	echo  "<td>". print_cust_inq_dashboard_print( @$doc_no, _("<img src =".$path_to_root."/themes/".user_theme()."/images/".ICON_PRINT.">"), true, $trans_type, null, '','',
	 get_post('TransAfterDate'),get_post('TransToDate'), get_post('customer_id'), get_post('filterType'), 0) ."</td>"; 



	echo  "<td>". print_cust_inq_dashboard_print( @$doc_no, _("<img  style='width: 20px;' src =".$path_to_root."/themes/".user_theme()."/images/excel.png>"), true, $trans_type, null, '','',
	 get_post('TransAfterDate'),get_post('TransToDate'), get_post('customer_id'), get_post('filterType'), 1) ."</td>"; 



// submit_cells('RefreshInquiry', _("Search"),'',_('Refresh Inquiry'), 'default');
submit_cells('SearchOrders', _("Search"),'',_('Refresh Inquiry'), 'default');
end_row();
end_table();

set_global_customer($_POST['customer_id']);

//------------------------------------------------------------------------------------------------

div_start('totals_tbl');
if ($_POST['customer_id'] != "" && $_POST['customer_id'] != ALL_TEXT)
{
	$customer_record = get_customer_details(get_post('customer_id'), get_post('TransToDate'));
    display_customer_summary($customer_record);
    echo "<br>";
}
div_end();

if (get_post('SearchOrders') || list_updated('filterType'))
{
	$Ajax->activate('_page_body');
}
//------------------------------------------------------------------------------------------------
$sql = get_sql_for_customer_inquiry(get_post('TransAfterDate'), get_post('TransToDate'),
	get_post('customer_id'), get_post('filterType'),get_post('reference'),$_POST['dimension']);

//------------------------------------------------------------------------------------------------
//db_query("set @bal:=0");

$cols = array(
	_("Type") => array('fun'=>'systype_name', 'ord'=>''),
	_("#") => array('fun'=>'trans_view', 'ord'=>'', 'align'=>'left'),
	_("Order") => array('fun'=>'order_view', 'align'=>'left'), 
	_("Reference"), 
	_("Date") => array('fun'=>'s_date', 'ord'=>'desc'),
	_("Due Date") => array( 'fun'=>'due_date', 'align'=>'left'),
	_("Customer") => array('ord'=>''), 
	_("Branch") => array('ord'=>''), 
	_("Currency") => array('align'=>'center'),
	_("Amount") => array('align'=>'left', 'fun'=>'fmt_amount'), 
	_("Balance") => array('align'=>'left', 'type'=>'amount'),
		array('insert'=>true, 'fun'=>'gl_view'),
		array('insert'=>true, 'fun'=>'credit_link'),
		array('insert'=>true, 'fun'=>'refund_link'),
		array('insert'=>true, 'fun'=>'edit_link'),
		array('insert'=>true, 'fun'=>'prt_link'),
		array('insert'=>true, 'fun'=>'pos_prt_link'),
		array('insert'=>true, 'fun'=>'attach')
	);


if ($_POST['customer_id'] != ALL_TEXT) {
	$cols[_("Customer")] = 'skip';
	$cols[_("Currency")] = 'skip';
}
if ($_POST['filterType'] != '2')
	$cols[_("Balance")] = 'skip';

$table =& new_db_pager('trans_tbl', $sql, $cols);
$table->set_marker('check_overdue', _("Marked items are overdue."));

$table->width = "85%";

display_db_pager($table);

end_form();
end_page();
