<?php


$page_security = 'SA_LOYALITY_DASHBOARD';
$path_to_root = "../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");

$js = "";
if ($use_popup_windows)
	$js .= get_js_open_window(900, 500);
if ($use_date_picker)
	$js .= get_js_date_picker();

page(_($help_context = "loyality Points Dashboard"), isset($_GET['customer_id']), false, "", $js);

echo '<script src="' . $path_to_root . '/themes/'.user_theme(). '/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>';

if (isset($_GET['customer_id']))
{
	$_POST['customer_id'] = $_GET['customer_id'];
}
if (isset($_GET['phone']))
{
	$_POST['phone'] = $_GET['phone'];
}
if (isset($_GET['email']))
{
	$_POST['email'] = $_GET['email'];
}
if (isset($_GET['country_code']))
{
	$_POST['country_code'] = $_GET['country_code'];
}

function get_opening_balance_of_loyality($from, $customer, $country_code, $phone){
	$sql = " SELECT sum(lp.points-lp.redeem) AS opening_bal, lp.points, lp.redeem, lp.debtor_no, trans.debtor_no
		FROM ".TB_PREF."loyality_points AS lp INNER JOIN ".TB_PREF."debtor_trans AS trans 
		ON trans.trans_no = lp.trans_no AND trans.type = lp.type 
		WHERE trans.tran_date < '".date2sql($from)."' AND trans.debtor_no = '$customer' AND used = 0 AND lp.cust_phone = '$phone' AND lp.country_code = '$country_code'";
	$result = db_query($sql);
	$row = db_fetch($result);
	return $row['opening_bal'];
}

function getTransactions($from, $to, $customer, $phone, $email, $country_code){
	$sql = " SELECT lp.*, trans.* FROM ".TB_PREF."loyality_points AS lp INNER JOIN ".TB_PREF."debtor_trans AS trans 
			ON trans.trans_no = lp.trans_no AND trans.type = lp.type
			WHERE trans.tran_date >= '".date2sql($from)."' AND trans.tran_date <= '".date2sql($to)."' AND trans.debtor_no = '$customer' ";
			if ($phone != null) {
				$sql .= " AND lp.cust_phone = '$phone'";
			}
			/*if ($email != null) {
				$sql .= " AND lp.cust_email = '$email'";
			}*/
			if ($country_code != 0) {
				$sql .= " AND lp.country_code = '$country_code'";
			}

	$result = db_query($sql);
	//display_error($sql);
	return $result;
}

function get_credit_no($trans_no, $type){
	$sql = " SELECT trans_no_from AS credit_no FROM ".TB_PREF."cust_allocations WHERE trans_no_to = '$trans_no' AND trans_type_to = '$type' ";
	$res = db_query($sql);
	$row = db_fetch($res);
	return $row['credit_no'];
}

global $systypes_array, $Ajax;

if(isset($_POST['RefreshInquiry']))
	$Ajax->activate('loyality_div');


br();

start_form();
start_table(TABLESTYLE_NOBORDER, 'style="width: 50% !important;"');
start_row();

hidden('customer_id', $_POST['customer_id']);

date_cells(_("From:"), 'TransAfterDate', '', null, -30);
date_cells(_("To:"), 'TransToDate', '', null, 1);

submit_cells('RefreshInquiry', _("Search"),'',_('Refresh Inquiry'), 'default');

end_row();
end_table();

br(2);
div_start('loyality_div');
start_table(TABLESTYLE4);
$th = array(_("Type"), _("Trans #"), _("Trans Date"), _("Redeem"), _("Redeem amount"), _("Earn"), _("Earn amount"), _("Balance"));
table_header($th);

$bal_ = 0;
$Opening_balance = get_opening_balance_of_loyality($_POST['TransAfterDate'], $_POST['customer_id'],$_POST['country_code'],$_POST['phone']);
$bal_ += $Opening_balance;
start_row("class='inquirybg' style='font-weight:bold'");
label_cell(_("Opening Balance"), "colspan=5");
label_cell(price_format2($Opening_balance));
end_row();

$transactions = getTransactions($_POST['TransAfterDate'], $_POST['TransToDate'], $_POST['customer_id'],$_POST['phone'],$_POST['email'],$_POST['country_code']);
$total_redeem = $total_eran = 0;

while($trans = db_fetch($transactions)){
	start_row();
	label_cell($systypes_array[$trans['type']]);
	label_cell(get_customer_trans_view_str($trans['type'], $trans['trans_no'], "", false, '', '', $path_to_root));
	// label_cell($trans['trans_no']);
	label_cell(sql2date($trans['tran_date']));
	label_cell("(".price_format2($trans['redeem']).")");
	label_cell("(".price_format2($trans['redeem'] * $SysPrefs->prefs['loyality_points_value']).")");
	label_cell(price_format2($trans['points']));
	label_cell(price_format2($trans['points'] * $SysPrefs->prefs['loyality_points_value']));
	$bal_ += $trans['points']-$trans['redeem'];
// display_error($bal_."= ".$trans['points']." - ".$trans['redeem']);
	$total_redeem += $trans['redeem'];
	$total_redeem_amount += $trans['redeem'] * $SysPrefs->prefs['loyality_points_value'];
	$total_eran += $trans['points'];
	$total_eran_amount += $trans['points'] * $SysPrefs->prefs['loyality_points_value'];
	label_cell(price_format2($bal_));
	end_row();

	
	if($trans['used'] == 1){
		start_row();
		label_cell($systypes_array[11], $dec);
		label_cell(get_customer_trans_view_str(11, get_credit_no($trans['trans_no'], 10), "", false, '', '', $path_to_root));
		// label_cell(get_credit_no($trans['trans_no'], 10), $dec);
		label_cell(sql2date($trans['tran_date']), $dec);
		label_cell("(".price_format2($trans['points']).")", $dec);
		label_cell(price_format2($trans['redeem']), $dec);
		$bal_ -= $trans['points']-$trans['redeem'];
		
		$total_redeem += $trans['points'];
		$total_eran += $trans['redeem'];
		
		label_cell(price_format2($bal_), $dec);
		end_row();
	}
}

start_row("class='inquirybg' style='font-weight:bold'");
label_cell(_("Total"), "colspan=3");
label_cell("(".price_format2($total_redeem).")");
label_cell("(".price_format2($total_redeem_amount).")");
label_cell(price_format2($total_eran));
label_cell(price_format2($total_eran_amount));
label_cell(price_format2($bal_));
end_row();

end_table();
div_end();

br();
end_form();
end_page();

?>