<?php

global $path_to_root;
$path_to_root = '../..';
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/includes/ui.inc");
 
$page_security = 'SA_SALESTRANSVIEW';

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 600);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page($_SESSION['page_title'], false, false, "", $js);


 $trans_type = $_POST['type'] = $_GET['type'] = ST_SALESQUOTE;


// Helper Functions
function check_overdue($row)
{
	global $trans_type;
	if ($trans_type == ST_SALESQUOTE)
		return (date1_greater_date2(Today(), sql2date($row['delivery_date'])));
	else
		return ($row['type'] == 0
			&& date1_greater_date2(Today(), sql2date($row['delivery_date']))
			&& ($row['TotDelivered'] < $row['TotQuantity']));
}


function view_link($dummy, $order_no)
{
	global $trans_type, $path_to_root;
	return  get_customer_trans_view_str($trans_type, $order_no, "", false, '', '', $path_to_root);
}

function prt_link($row)
{	global $trans_type;
	if(!$_SESSION['wa_current_user']->can_access_page('SA_SALESEQUOTATIONREPORT') && $trans_type == ST_SALESQUOTE){
		return '';
	}

	return print_document_link($row['order_no'], _("Print"), true, $trans_type, ICON_PRINT);
}

function edit_link($row) 
{
	global $page_nested, $trans_type;
	if(!$_SESSION['wa_current_user']->can_access_page('SA_SALESORDERMODIFY') && $trans_type == ST_SALESORDER )
		return '';

	if (is_prepaid_order_open($row['order_no']))
		return '';

	return $page_nested ? '' : trans_editor_link($row['trans_type'], $row['order_no']);
}



function attach($row){
	if(!$_SESSION['wa_current_user']->can_access_page('SA_ATTACHDOCUMENT'))
		return '';
	else
		return pager_link(_("Link Document"), $path_to_root."/admin/attachments.php?filterType=".$row['trans_type']."&trans_no=".$row['order_no'], ICON_ATTACH);
}

function dispatch_link($row)
{
	global $trans_type;

	if ($row['ord_payments'] + $row['inv_payments'] < $row['prep_amount'])
 		return '';

 	if(!$_SESSION['wa_current_user']->can_access_page('SA_DISPATACHITEMSAGAINSTSO') && $trans_type == ST_SALESORDER){
 		return '';
 	}

	if ($trans_type == ST_SALESORDER)
  		return pager_link( _("Dispatch"),
			"/sales/customer_delivery.php?OrderNumber=" .$row['order_no'], ICON_DOC);
	else
  		return pager_link( _("Sales Order"),
			"/sales/sales_order_entry.php?OrderNumber=" .$row['order_no'], ICON_DOC);
}

function invoice_link($row)
{
	global $trans_type;
	if ($trans_type == ST_SALESORDER)
  		return pager_link( _("Invoice"),
			"/sales/sales_order_entry.php?NewInvoice=" .$row["order_no"], ICON_DOC);
	else
		return '';
}

function delivery_link($row)
{
  return pager_link( _("Delivery"),
	"/sales/sales_order_entry.php?NewDelivery=" .$row['order_no'], ICON_DOC);
}

function order_link($row)
{
	if(!$_SESSION['wa_current_user']->can_access_page('SA_SALESNEWQUOTETOSALEORDER')){
			return '';
	}
  return pager_link( _("Sales Order"),
	"/sales/sales_order_entry.php?NewQuoteToSalesOrder=" .$row['order_no'], ICON_DOC);
}

function tmpl_checkbox($row)
{
	global $trans_type, $page_nested;

	if ($trans_type == ST_SALESQUOTE || !check_sales_order_type($row['order_no']))
		return '';

	if ($page_nested)
		return '';
	$name = "chgtpl" .$row['order_no'];
	$value = $row['type'] ? 1:0;

// save also in hidden field for testing during 'Update'

 return checkbox(null, $name, $value, true,
 	_('Set this order as a template for direct deliveries/invoices'))
	. hidden('last['.$row['order_no'].']', $value, false);
}

function invoice_prep_link($row)
{
	// invoicing should be available only for partially allocated orders
	return 
		$row['inv_payments'] < $row['total'] ?
		pager_link($row['ord_payments']  ? _("Prepayment Invoice") : _("Final Invoice"),
		"/sales/customer_invoice.php?InvoicePrepayments=" .$row['order_no'], ICON_DOC) : '';
}

function checkOwner($user_id = null)
{
	$sql = " SELECT * FROM ".TB_PREF."users WHERE id = ".db_escape($user_id)." AND owner = ".db_escape(1)." ";
	$run = db_query($sql, "Couldnot run checkowner()");
	$ft = db_fetch($run);
	$numOfRows = db_num_rows($run);
	return $numOfRows;

}

function approved_link($row){
	$name = "approved".$row['order_no'];
	$value = $row['approved'] ? 1:0;

	return checkbox(null, $name,$value , true, _('Approved this quotation'))
	. hidden('last['.$row['order_no'].']', $value, false);
}


$id = find_submit('_approved');
if ($id != -1){
	salesQuotationSetApprove($id, check_value('approved'.$id));
	$trans_type = ST_SALESQUOTE;
	$_GET['type'] = ST_SALESQUOTE;
	$_POST['show_unapproved'] = 1;
	$Ajax->activate('orders_tbl');
}


$id = find_submit('_chgtpl');
if ($id != -1)
{
	sales_order_set_template($id, check_value('chgtpl'.$id));
	$Ajax->activate('orders_tbl');
}

if (isset($_POST['Update']) && isset($_POST['last'])) {
	foreach($_POST['last'] as $id => $value)
		if ($value != check_value('chgtpl'.$id))
			sales_order_set_template($id, !check_value('chgtpl'.$id));
}

// ==========================



    start_form();

    start_outer_table(TABLESTYLE5, "cellpadding='5'");
    table_section(0);
	start_row();
	hidden('order_view_mode', "Quotations");
	hidden('type', ST_SALESQUOTE);
	$checkowner = get_user($_SESSION['wa_current_user']->user)['owner'];
	ref_cells(_("#:"), 'OrderNumber', '',null, '', true);
	ref_cells(_("Ref"), 'OrderReference', '',null, '', true);
    
	date_cells(_("From:"), 'OrdersAfterDate', '', null, -user_transaction_days(),0,0,null,true);
	date_cells(_("To:"), 'OrdersToDate', '', null, 1);

	locations_list_cells(_("Location:"), 'StockLocation', null, true, true);

	end_row();

	start_row();

	stock_items_list_cells(_("Item:"), 'SelectStockFromList', null, true, true);
	customer_list_cells(_("Select a Customer"), 'customer_id', null, true, true);
	check_cells(_("Show All:"), 'show_all');

	check_cells(_("Show Unapproved :"), 'show_unapproved', $_POST['show_unapproved'], true);


	echo  "<td>". print_sal_dashboard_print(_("<img src =".$path_to_root."/themes/".user_theme()."/images/".ICON_PRINT.">"), true, $trans_type, null, '','', get_post('OrdersAfterDate'),get_post('OrdersToDate'), get_post('SelectStockFromList'), get_post('OrderReference'), get_post('StockLocation'),
	get_post('customer_id'), get_post('OrderNumber'), get_post('order_view_mode') ,0, $_POST['show_unapproved']) ." "; 


	echo  " ". print_sal_dashboard_print(_("<img  style='width: 20px;' src =".$path_to_root."/themes/".user_theme()."/images/excel.png>"), true, $trans_type, null, '','', get_post('OrdersAfterDate'),get_post('OrdersToDate'), get_post('SelectStockFromList'), get_post('OrderReference'), get_post('StockLocation'),
	get_post('customer_id'), get_post('OrderNumber'), get_post('order_view_mode') ,1, $_POST['show_unapproved']) ."</td>"; 


	
	submit_cells('SearhInquiry', _("Search"),'',_('Select Inquiry'), 'default');


	end_row();
	end_outer_table(1);
    

	if($_POST['show_unapproved'] > 0)
		display_note(_("<p style='color:green;'>Search All Unapproved Sales Order.</p>"), 0, 0, "class='overduefg'");
	else
		display_note(_("<p style='color:green;'>Search All Sales Order.</p>"), 0, 0, "class='overduefg'");



	global $Ajax;
	$Ajax->activate('_page_body');


$sql = get_sql_for_sales_orders_view(ST_SALESQUOTE, get_post('OrderNumber'), get_post('order_view_mode'),
	get_post('SelectStockFromList'), get_post('OrdersAfterDate'), get_post('OrdersToDate'), get_post('OrderReference'), get_post('StockLocation'),
	get_post('customer_id'), $_POST['show_unapproved'], $_POST['show_all']);
 

 
	$cols = array(
		_("Quote&nbsp#") => array('fun'=>'view_link', 'align'=>'left'),
		_("Ref"),
		_("Customer"),
		_("Branch"), 
		_("Cust Order Ref"),
		_("Quote Date") => 'date',
		_("Valid until") =>array('type'=>'date', 'ord'=>''),
		_("Delivery To"), 
		_("Quote Total") => array('type'=>'amount', 'ord'=>''),
		'Type' => 'skip',
		_("Currency") => array('align'=>'center')
	);
if ($_POST['order_view_mode'] == 'OutstandingOnly') {
	array_append($cols, array(
		array('insert'=>true, 'fun'=>'dispatch_link'),
		array('insert'=>true, 'fun'=>'edit_link')));

} elseif ($_POST['order_view_mode'] == 'InvoiceTemplates') {
	array_substitute($cols, 4, 1, _("Description"));
	array_append($cols, array( array('insert'=>true, 'fun'=>'invoice_link')));

} else if ($_POST['order_view_mode'] == 'DeliveryTemplates') {
	array_substitute($cols, 4, 1, _("Description"));
	array_append($cols, array(
			array('insert'=>true, 'fun'=>'delivery_link'))
	);
} else if ($_POST['order_view_mode'] == 'PrepaidOrders') {
	array_append($cols, array(
			array('insert'=>true, 'fun'=>'invoice_prep_link'))
	);

}  


if($_SESSION["wa_current_user"]->can_access_page('SA_SALESQUOTEMODIFY')){
	 array_append($cols,array(
				array('insert'=>true, 'fun'=>'edit_link')
				));
	}
	
	array_append($cols,array(
				array('insert'=>true, 'fun'=>'order_link'),
				array('insert'=>true, 'fun'=>'prt_link')));

	if($_POST['show_unapproved'] > 0)
		array_append($cols, array( _("Approve") => array('insert'=>true, 'fun'=>'approved_link')));

 

array_append($cols,array(array('insert'=>true, 'fun'=>'attach')));


$table =& new_db_pager('quotation_table', $sql, $cols);
$table->set_marker('check_overdue', _("Marked items are overdue."));

$table->width = "80% !important";

display_db_pager($table);

submit_center('Update', _("Update"), true, '', null);

end_form();
end_page();
 ?>