<?php

$page_security = 'SA_SCHEDULEINQUIRY';
$path_to_root = "../..";
include($path_to_root . "/includes/db_pager.inc");
include($path_to_root . "/includes/session.inc");

include($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/CRM/includes/db/inquiry_type_db.inc");


$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 600);
if (user_use_date_picker())
	$js .= get_js_date_picker();


page(_($help_context = "Schedule Inquiry"), false, false, "", $js);

if(!isset($_POST['status'])){
    $_POST['status'] = 1;
}
//-----------------------------------------------------------------------------------------------------------------------
//Pager Helper Functions
function trans_view($row){
    global $path_to_root;
	return get_customer_trans_view_str(ST_SALESORDER, $row['order_no'],
	$row['reference'], false, '', '', $path_to_root);
}
function cust_name($row){
	return get_customer_name($row['debtor_no']);
}
function technician($row){
	return get_technician_name($row['technician']);
}
function sc_time($row){
	$start_time = new DateTime($row['start_time']);
	$end_time = new DateTime($row['end_time']);
	return $start_time->format('h:i a')." - ".$end_time->format('h:i a');
}

function jobcard($row){
    if($row['approved'] == 0) return 'N/A';
	if($row['status']!=2)
		return pager_link(_('Create Job Card'), "/sales/job_card.php?schedule=".$row['schedule_id']."&technician=".$row['technician'], ICON_DOC);
	else
		return "Job Completed";
}

function schedule_type($row){
	global $schedule_type;

	return $schedule_type[$row['type']];
}


//codi
function approved_link($row){

	$name = "approved".$row['schedule_id'];


	$value = $row['approved'] ? 1:0;
	return checkbox(null, $name,$value , true, _('Approved this schedule'))
	. hidden($row['schedule_id'], $value, false);
}
$id = find_submit('approved');
if($id != -1){
	$_POST['show_unapproved'] = 1;
	scheduleSetApprove($id, check_value('approved'.$id));
	$Ajax->activate('schedules_tbl');
	set_focus($_POST['show_unapproved']);
}
//codi

function inquiry_name($row){
	return get_inquiry_type_name($row['inquiry_type']);
}

function loc($row){
    return '<a href="http://maps.google.com/maps?q='.$row['loc_cordinates'].'" 
    target="_blank">'.$row['location'].'</a>';
}

function mark_attendance($row){
    if($row['approved'] == 0 || $row['status'] == 2) return 'N/A';
	return '<a href="http://developer.wayzerp.net/xpert_hr/payroll/attendance/mark_attendance_bulk.php?cons_count=1&user_id='.$_SESSION['wa_current_user']->username.'&enc_key='.$_SESSION['wa_current_user']->password.'&dimension_id='.$row["dimension_id"].'&technician='.$row["technician"].'" 
    target="_blank">Mark Attendance</a>';
}

function show_dimension_view($row){
    return get_dimensions_trans_view_str(ST_DIMENSION, $row['dimension_id'], get_dimension($row['dimension_id'])['name']);
}

//codi
if($_POST['show_unapproved'] > 0)
		display_note(_("<p style='color:green;'>Search All Unapproved Sales Order.</p>"), 0, 0, "class='overduefg'");
else
	display_note(_("<p style='color:green;'>Search All Sales Order.</p>"), 0, 0, "class='overduefg'");
//codi


//------------------------------------------------------------------------------

start_form();

start_table(TABLESTYLE_NOBORDER);

ref_cells(_("Sales Order Ref #:"), 'so_ref', '',null, '', true);
customer_list_cells(_("Customer"), 'customer', null, _("Select Customer"), true);

date_cells(_("Schedule From Date:"), 'FromDate', '', null, -user_transaction_days());
date_cells(_("Schedule To Date:"), 'ToDate', '', null, 1);

stock_items_list_cells(_("Item:"), 'stock_id', null, true);
generic_list_cells(_("Job Status"), 'status', array("Job Pending", 
"Job Completed"), null, _("Show All"), true);

//codi
 if ($_SESSION["wa_current_user"]->can_access_page('SA_SCHEDULEAPPROVED')){
check_cells(_("Show Unapproved :"), 'show_unapproved', $_POST['show_unapproved'], true);
}
//codi

submit_cells('SearchOrders', _("Search"),'',_('Select documents'), 'default');
if(isset($_POST['SearchOrders'])){
	global $Ajax;
	$Ajax->activate('_page_body');
}

end_table(1);

$Technician = $_SESSION['wa_current_user']->technician;
$sql = get_sql_for_schedule_inquiry($_POST['so_ref'], $_POST['customer'], $_POST['FromDate'], $_POST['ToDate'], $_POST['stock_id'], $_POST['status'], $Technician, $_POST['show_unapproved']);

$cols = array(
	_("S.No"), 
	_("Sales Order Ref") => array('fun'=>'trans_view'), 
	_("Site Name")=> array('fun'=>'show_dimension_view'), 
	_("Customer Name") => array('fun'=>'cust_name'),
	_("Item"),
	_("Inquiry Type") => array('fun'=> 'inquiry_name'),
	_("Schedule Type") => array('fun'=>'schedule_type'), 
	_("Order Date") => array('type'=>'date'), 
	_("Schedule Date") => array('type'=>'date'), 
	_("Schedule Time") => array('fun'=>'sc_time'), 
	_("Location") =>array('fun'=>'loc'), 
	_("Technician") => array('fun'=>'technician'), 
	_("Attendance") => array('fun'=>'mark_attendance'), 
	_("Create Job Card") => array('fun'=>'jobcard'),
);

//codi
 if ($_SESSION["wa_current_user"]->can_access_page('SA_SCHEDULEAPPROVED')){
	if($_POST['show_unapproved'] > 0){
		array_append($cols, array( _("Approve") => array('insert'=>true, 'fun'=>'approved_link')));

	}
}
//codi

$table =& new_db_pager('schedule_tbl', $sql, $cols);

display_db_pager($table);


end_page();
?>