<?php

$page_security = 'SA_TECHNICIAN';
$path_to_root = "../..";
include($path_to_root . "/includes/session.inc");

page(_($help_context = "Technician"));

include($path_to_root . "/includes/ui.inc");

simple_page_mode(true);

if($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') {

	$input_error = 0;

	if(strlen($_POST['name']) == 0){
		$input_error = 1;
		display_error(_("The Technician name cannot be empty."));
		set_focus('name');
	}

	if($_POST['salary']<0){
		$input_error = 1;
		display_error(_("Incorrect Amount Entered."));
		set_focus('salary');
	}

	if($_POST['ov_salary']<0){
		$input_error = 1;
		display_error(_("Incorrect Amount Entered."));
		set_focus('ov_salary');
	}


	if($input_error != 1){
    	if($selected_id != -1){
    		update_technician($selected_id, $_POST['name'],input_num('salary'),input_num('ov_salary'));
			$note = _('Selected Technician has been updated');
    	} 
    	else{
    		add_technician($_POST['name'], input_num('salary'),input_num('ov_salary'));
			$note = _('New Technician has been added');
    	}
    
		display_notification($note);    	
		$Mode = 'RESET';
	}
} 

if ($Mode == 'Delete'){

	$cancel_delete = 0;

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'debtors_master'
	if ($cancel_delete == 0){
		delete_technician($selected_id);
		display_notification(_('Selected sales area has been deleted'));
	}
	$Mode = 'RESET';
}

if($Mode == 'RESET'){

	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}

//-------------------------------------------------------------------------------------------------

$result = get_technicians(check_value('show_inactive'));

start_form();
start_table(TABLESTYLE5_BOX,"",0,0,0,null,"25%","1px solid #2CABE3;");

$th = array(_("Technician Name"), _("Salary"),  _("Overtime Salary"));


inactive_control_column($th);

table_header($th);
$k = 0; 

while ($myrow = db_fetch($result)){
	
	alt_table_row_color($k);
		
	label_cell($myrow["name"]);
	amount_cell($myrow["salary"]);
	amount_cell($myrow["ov_salary"]);
	inactive_control_cell($myrow["id"], $myrow["inactive"], 'technician', 'id');
 	// edit_button_cell("Edit".$myrow["id"], _("Edit"));
 	// delete_button_cell("Delete".$myrow["id"], _("Delete"));
	end_row();
}
	
inactive_control_row($th);
end_table();
echo '<br>';

//-------------------------------------------------------------------------------------------------
start_table(TABLESTYLE6_BOX,"",0,0,0,null,"25%","3px solid #656E79;");

if($selected_id != -1){

 	if($Mode == 'Edit'){
		
		$myrow = get_technician($selected_id);
		$_POST['name']  = $myrow["name"];
		$_POST['salary']  = $myrow["salary"];
		$_POST['ov_salary']  = $myrow["ov_salary"];
	}
	hidden("selected_id", $selected_id);
} 

text_row_ex(_("Technician Name:"), 'name', 30); 
small_amount_row(_("Salary Per Hour:"), 'salary');
//Task#2389 Start 
small_amount_row(_("Overtime Hour:"),'ov_salary');
//Task#2389 end

end_table(1);

submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();
