<?php

//-----------------------------------------------------------------------------
//
//	Entry/Modify Sales Quotations
//	Entry/Modify Sales Order
//	Entry Direct Delivery
//	Entry Direct Invoice
//

$path_to_root = "..";
$page_security = 'SA_SALESORDER';

include_once($path_to_root . "/sales/includes/cart_class.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/sales/includes/ui/sales_order_ui.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/sales/includes/db/sales_types_db.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/access/mobile_detect.php");
include_once($path_to_root . "/manufacturing/includes/manufacturing_db.inc");
include_once($path_to_root . "/includes/db/crm_contacts_db.inc");
include_once($path_to_root . "/sales/includes/db/customers_db.inc");
include_once($path_to_root . "/sales/includes/db/branches_db.inc");
include_once($path_to_root . "/includes/sms_api/function.inc");
include_once($path_to_root . "/admin/db/loyality_db.inc");
include_once($path_to_root . "/CRM/pages/includes/db/project_db.inc");


set_page_security( @$_SESSION['Items']->trans_type,
	array(	ST_SALESORDER  =>'SA_SALESORDER',
			ST_SALESQUOTE  => 'SA_SALESQUOTE',
			ST_CUSTDELIVERY => 'SA_SALESDELIVERY',
			ST_SALESINVOICE => 'SA_SALESINVOICE'),
	array(	'NewOrder' => 'SA_SALESORDER',
			'ModifyOrderNumber' => 'SA_SALESORDERMODIFY',
			'AddedID' => 'SA_SALESORDER',
			'UpdatedID' => 'SA_SALESORDERMODIFY',
			'NewQuotation' => 'SA_SALESQUOTE',
			'ModifyQuotationNumber' => 'SA_SALESQUOTEMODIFY',
			'NewQuoteToSalesOrder' => 'SA_SALESNEWQUOTETOSALEORDER',
			'AddedQU' => 'SA_SALESQUOTE',
			'UpdatedQU' => 'SA_SALESQUOTEMODIFY',
			'NewDelivery' => 'SA_SALESDELIVERY',
			'AddedDN' => 'SA_SALESDELIVERY', 
			'NewInvoice' => 'SA_SALESINVOICE',
			'AddedDI' => 'SA_SALESINVOICE',
			'AddedMBL' => 'SA_SALESINVOICE'
			)
);
// display_error($page_security);
$js = '';

if ($SysPrefs->use_popup_windows) {
	$js .= get_js_open_window(900, 500);
}

if (user_use_date_picker()) {
	$js .= get_js_date_picker();
}
set_focus('bar_code');
if (isset($_GET['NewDelivery']) && is_numeric($_GET['NewDelivery'])) {

	$_SESSION['page_title'] = _($help_context = "Direct Sales Delivery");
	create_cart(ST_CUSTDELIVERY, $_GET['NewDelivery'],$_GET['attachment']);

} elseif (isset($_GET['NewInvoice']) && is_numeric($_GET['NewInvoice'])) {

	create_cart(ST_SALESINVOICE, $_GET['NewInvoice'],$_GET['attachment']);

	if (isset($_GET['FixedAsset'])) {
		$_SESSION['page_title'] = _($help_context = "Fixed Assets Sale");
		$_SESSION['Items']->fixed_asset = true;
  	} else
		$_SESSION['page_title'] = _($help_context = "Direct Sales Invoice");

	$_SESSION['Items']->auto_dimension = true;

}elseif (isset($_GET['AddedMBL']) && is_numeric($_GET['AddedMBL'])) {

	submenu_thermal_print(_("&Print Whole Order Thermal Print With Price"), ST_SALESINVOICE, $_GET['AddedMBL'], 'prtopt', 0, 0, 1);

	create_cart(ST_SALESINVOICE, 0);

	if (isset($_GET['FixedAsset'])) {
		$_SESSION['page_title'] = _($help_context = "Fixed Assets Sale");
		$_SESSION['Items']->fixed_asset = true;
  	} else
		$_SESSION['page_title'] = _($help_context = "Direct Sales Invoice");

} elseif (isset($_GET['ModifyOrderNumber']) && is_numeric($_GET['ModifyOrderNumber'])) {

	$help_context = 'Modifying Sales Order';
	$_SESSION['page_title'] = sprintf( _("Modifying Sales Order # %d"), $_GET['ModifyOrderNumber']);
	create_cart(ST_SALESORDER, $_GET['ModifyOrderNumber']);

} elseif (isset($_GET['ModifyQuotationNumber']) && is_numeric($_GET['ModifyQuotationNumber'])) {

	$help_context = 'Modifying Sales Quotation';
	$_SESSION['page_title'] = sprintf( _("Modifying Sales Quotation # %d"), $_GET['ModifyQuotationNumber']);
	create_cart(ST_SALESQUOTE, $_GET['ModifyQuotationNumber']);

} elseif (isset($_GET['NewOrder'])) {

	$_SESSION['page_title'] = _($help_context = "New Sales Order Entry");
	create_cart(ST_SALESORDER, 0);
	$_SESSION['Items']->auto_dimension = true;
	$sql = " SELECT * FROM ".TB_PREF;
} elseif (isset($_GET['NewQuotation'])) {

	$_SESSION['page_title'] = _($help_context = "New Sales Quotation Entry");
	create_cart(ST_SALESQUOTE, 0);
	if(isset($_GET['opp_id'])){
		$_SESSION['Items']->opp_id = $_GET['opp_id'];
		$opp_row = get_opportunity_byid($_SESSION['Items']->opp_id);
		$_SESSION['Items']->inquiry_type = $opp_row['inquiry_type'];
		$cust_row =	get_customer_by_ContactPerson($opp_row['contact_person']);
		$_POST['customer_id'] = $cust_row['debtor_no'];

		$items_array = explode(',', $opp_row['opportunity']);

		foreach($items_array as $key => $value){
			$stock_id = trim($value);
			$price_row = db_fetch(get_prices($stock_id));
			add_to_order($_SESSION['Items'], $stock_id, 1, $price_row['price']);
		}

	}



} elseif (isset($_GET['NewQuoteToSalesOrder'])) {
	$_SESSION['page_title'] = _($help_context = "Sales Order Entry");
	create_cart(ST_SALESQUOTE, $_GET['NewQuoteToSalesOrder'], null, true);
	$_SESSION['Items']->against = $_GET['NewQuoteToSalesOrder'];
	$_SESSION['Items']->quote_id = $_GET['NewQuoteToSalesOrder'];
	$_SESSION['Items']->auto_dimension = true;
}

page($_SESSION['page_title'], false, false, "", $js);

// pk
if (isset($_GET['AddedMBL']) && is_numeric($_GET['AddedMBL'])) {
	
	echo '<div class="col-sm-12">';
	echo ' &nbsp; &nbsp; &nbsp;  &nbsp; &nbsp; &nbsp;  &nbsp; &nbsp; &nbsp;<span>';
	echo get_trans_view_str(ST_SALESINVOICE, $_GET['AddedMBL'], '<img src ="'.$path_to_root.'/themes/'.user_theme().'/images/icon/view.png" style="width: 50px;">', false, 'viewlink', null);
	echo '</span>  &nbsp; &nbsp; &nbsp;  &nbsp; &nbsp; &nbsp;  &nbsp; &nbsp; &nbsp;';

	echo '<span>';	
	echo print_document_link($_GET['AddedMBL']."-".ST_SALESINVOICE, '<img src ="'.$path_to_root.'/themes/'.user_theme().'/images/icon/report.png" style="width: 50px;">', true, ST_SALESINVOICE, false, 'printlink', 'prtopt', 0, 0, 'A4');
	echo '</span>';

	echo ' </div>';
}

if (isset($_GET['ModifyOrderNumber']) && is_prepaid_order_open($_GET['ModifyOrderNumber']))
{
	display_error(_("This order cannot be edited because there are invoices or payments related to it, and prepayment terms were used."));
	end_page(); exit;
}
if (isset($_GET['ModifyOrderNumber']))
	check_is_editable(ST_SALESORDER, $_GET['ModifyOrderNumber']);
elseif (isset($_GET['ModifyQuotationNumber']))
	check_is_editable(ST_SALESQUOTE, $_GET['ModifyQuotationNumber']);

//-----------------------------------------------------------------------------

if (list_updated('branch_id')) {
	// when branch is selected via external editor also customer can change
	$br = get_branch(get_post('branch_id'));
	$_POST['customer_id'] = $br['debtor_no'];
	$Ajax->activate('customer_id');
}

if (isset($_GET['AddedID'])) {
	$order_no = $_GET['AddedID'];
		echo '<ol class="rounded-list">';
	echo '<li>';
	display_notification_centered(sprintf( _("Order # %d has been entered."),$order_no));

 echo '</li><li>';
	submenu_view(_("&View This Order"), ST_SALESORDER, $order_no, null, $path_to_root, basename($_SERVER['PHP_SELF']));
 echo '</li><li>';
	submenu_print(_("&Print This Order A4"), ST_SALESORDER, $order_no, 'prtopt',null,null,A4);
	 echo '</li><li>';
// 	submenu_print(_("&Print This Order A5"), ST_SALESORDER, $order_no, 'prtopt',null,null,A5);
	 echo '</li><li>';
	submenu_print(_("&Email This Order"), ST_SALESORDER, $order_no, null, 1);
	
 echo '</li><li>';
	set_focus('prtopt');
	 echo '</li><li>';
	submenu_option(_("Make &Delivery Against This Order"),
		"/sales/customer_delivery.php?OrderNumber=$order_no");
 echo '</li><li>';
	submenu_option(_("Work &Order Entry"),	"/manufacturing/work_order_entry.php?");
 echo '</li><li>';
	submenu_option(_("Enter a &New Order"),	"/sales/sales_order_entry.php?NewOrder=0");
 echo '</li></ol>';
	display_footer_exit();

} elseif (isset($_GET['UpdatedID'])) {
	$order_no = $_GET['UpdatedID'];
	echo '<ol class="rounded-list">';
	echo '<li>';
	display_notification_centered(sprintf( _("Order # %d has been updated."),$order_no));
 echo '</li><li>';
	submenu_view(_("&View This Order"), ST_SALESORDER, $order_no, null, $path_to_root, basename($_SERVER['PHP_SELF']));
 echo '</li><li>';
	submenu_print(_("&Print This Order A4"), ST_SALESORDER, $order_no, 'prtopt', null,null,A4);
	 echo '</li><li>';
// 	submenu_print(_("&Print This Order A5"), ST_SALESORDER, $order_no, 'prtopt',null,null,A5);
	 echo '</li><li>';
	submenu_print(_("&Email This Order"), ST_SALESORDER, $order_no, null, 1);
	 echo '</li><li>';
	set_focus('prtopt');
 echo '</li><li>';
	submenu_option(_("Confirm Order Quantities and Make &Delivery"),
		"/sales/customer_delivery.php?OrderNumber=$order_no");
 echo '</li><li>';
	submenu_option(_("Select A Different &Order"),
		"/sales/inquiry/sales_orders_view.php?OutstandingOnly=1");
echo '</li></ol>';
	display_footer_exit();

} elseif (isset($_GET['AddedQU'])) {
	$order_no = $_GET['AddedQU'];
	echo '<ol class="rounded-list">';
	echo '<li>';
	display_notification_centered(sprintf( _("Quotation # %d has been entered."),$order_no));
    echo '</li><li>';
	submenu_view(_("&View This Quotation"), ST_SALESQUOTE, $order_no, null, $path_to_root, basename($_SERVER['PHP_SELF']));
	echo '</li><li>';
	submenu_print(_("&Print This Quotation A4"), ST_SALESQUOTE, $order_no, 'prtopt',null,null,'A4');
	echo '</li><li>';
// 	submenu_print(_("&Print This Quotation A5"), ST_SALESQUOTE, $order_no, 'prtopt',null,null,'A5');
	echo '</li><li>';
	submenu_print(_("&Email This Quotation"), ST_SALESQUOTE, $order_no, null, 1);
	echo '</li><li>';
	set_focus('prtopt');
	echo '</li><li>';
	
	submenu_option(_("Make &Sales Order Against This Quotation"),
		"/sales/sales_order_entry.php?NewQuoteToSalesOrder=$order_no");
	echo '</li><li>';

	submenu_option(_("Enter a New &Quotation"),	"/sales/sales_order_entry.php?NewQuotation=0");
	echo '</li></ol>';

	display_footer_exit();

} elseif (isset($_GET['UpdatedQU'])) {
	$order_no = $_GET['UpdatedQU'];
echo '<ol class="rounded-list">';
	echo '<li>';
	display_notification_centered(sprintf( _("Quotation # %d has been updated."),$order_no));
echo '</li><li>';
	submenu_view(_("&View This Quotation"), ST_SALESQUOTE, $order_no, null, $path_to_root, basename($_SERVER['PHP_SELF']));
echo '</li><li>';
	submenu_print(_("&Print This Quotation"), ST_SALESQUOTE, $order_no, 'prtopt');
	echo '</li><li>';
	submenu_print(_("&Email This Quotation"), ST_SALESQUOTE, $order_no, null, 1);
	echo '</li><li>';
	set_focus('prtopt');
echo '</li><li>';
	submenu_option(_("Make &Sales Order Against This Quotation"),
		"/sales/sales_order_entry.php?NewQuoteToSalesOrder=$order_no");
echo '</li><li>';
	submenu_option(_("Select A Different &Quotation"),
		"/sales/inquiry/sales_orders_view.php?type=".ST_SALESQUOTE);
echo '</li></ol>';
	display_footer_exit();
} elseif (isset($_GET['AddedDN'])) {
	$delivery = $_GET['AddedDN'];
echo '<ol class="rounded-list">';
	echo '<li>';
	display_notification_centered(sprintf(_("Delivery # %d has been entered."),$delivery));
echo '</li><li>';
	submenu_view(_("&View This Delivery"), ST_CUSTDELIVERY, $delivery, null, $path_to_root, basename($_SERVER['PHP_SELF']));
echo '</li><li>';
	submenu_print(_("&Print Delivery Note A4"), ST_CUSTDELIVERY, $delivery, 'prtopt',null,null,A4);
	echo '</li><li>';
// 	submenu_print(_("&Print Delivery Note A5"), ST_CUSTDELIVERY, $delivery, 'prtopt',null,null,A5);
	echo '</li><li>';
	submenu_print(_("&Email Delivery Note"), ST_CUSTDELIVERY, $delivery, null, 1);
	echo '</li><li>';
	submenu_print(_("P&rint as Packing Slip"), ST_CUSTDELIVERY, $delivery, 'prtopt', null, 1);
	echo '</li><li>';
	submenu_print(_("E&mail as Packing Slip"), ST_CUSTDELIVERY, $delivery, null, 1, 1);
	echo '</li><li>';
	set_focus('prtopt');
echo '</li><li>';
	display_note(get_gl_view_str(ST_CUSTDELIVERY, $delivery, _("View the GL Journal Entries for this Dispatch")),0, 1);
echo '</li><li>';
	submenu_option(_("Make &Invoice Against This Delivery"),
		"/sales/customer_invoice.php?DeliveryNumber=$delivery");
echo '</li><li>';
	if ((isset($_GET['Type']) && $_GET['Type'] == 1))
		submenu_option(_("Enter a New Template &Delivery"),
			"/sales/inquiry/sales_orders_view.php?DeliveryTemplates=Yes");
	else
		submenu_option(_("Enter a &New Delivery"), 
			"/sales/sales_order_entry.php?NewDelivery=0");
echo '</li></ol>';
	display_footer_exit();

} elseif (isset($_GET['AddedDI'])) {
	$invoice = $_GET['AddedDI'];

$detect = new Mobile_Detect();
if ($detect->isMobile() && false){
	 
	meta_forward($_SERVER['PHP_SELF'], "AddedMBL=$invoice");
}

echo '<ol class="rounded-list">';
	echo '<li>';
	display_notification_centered(sprintf(_("Invoice # %d has been entered."), $invoice));
echo '</li><li>';
	submenu_view(_("&View This Invoice"), ST_SALESINVOICE, $invoice, null, $path_to_root, basename($_SERVER['PHP_SELF']));
echo '</li><li>';
	submenu_print(_("&Print Sales Invoice A4"), ST_SALESINVOICE, $invoice."-".ST_SALESINVOICE, 'prtopt',null,null,A4);
	echo '</li><li>';
// 	submenu_print(_("&Print Sales Invoice A5"), ST_SALESINVOICE, $invoice."-".ST_SALESINVOICE, 'prtopt',null,null,A5);
	echo '</li><li>';
	submenu_print(_("&Email Sales Invoice"), ST_SALESINVOICE, $invoice."-".ST_SALESINVOICE, null, 1);
	echo '</li><li>';
	set_focus('prtopt');
	echo '</li><li>';

	$row = db_fetch(get_allocatable_from_cust_transactions(null, $invoice, ST_SALESINVOICE));
	if ($row !== false)
		submenu_print(_("Print &Receipt"), $row['type'], $row['trans_no']."-".$row['type'], 'prtopt');
echo '</li><li>';
	display_note(get_gl_view_str(ST_SALESINVOICE, $invoice, _("View the GL &Journal Entries for this Invoice")),0, 1);
echo '</li><li>';
	if ((isset($_GET['Type']) && $_GET['Type'] == 1))
		submenu_option(_("Enter a &New Template Invoice"), 
			"/sales/inquiry/sales_orders_view.php?InvoiceTemplates=Yes");
	else
		submenu_option(_("Enter a &New Direct Invoice"),
			"/sales/sales_order_entry.php?NewInvoice=0");
echo '</li><li>';
	if ($row === false)
		submenu_option(_("Entry Customer payment for this invoice"), "/sales/customer_payments.php?SInvoice=".$invoice);
echo '</li><li>';
	submenu_option(_("Add an Attachment"), "/admin/attachments.php?filterType=".ST_SALESINVOICE."&trans_no=$invoice");
echo '</li></ol>';
	display_footer_exit();
} else
	check_edit_conflicts(get_post('cart_id'));
//---------------------------work for approval of sales quotation------------------------------------------
if (isset($_GET['NewQuoteToSalesOrder']) && $_SESSION['Items']->trans_type == ST_SALESORDER && $_SESSION['Items']->approvedQuotation == 0){

	display_error(_("Sales Quotation # ").$_GET['NewQuoteToSalesOrder']._(" is Unapproved, kindly Contact to Admin"));

	/*echo '<ol class="rounded-list">';
	echo '<li>';
		submenu_print(_("&Send Approval Request"), ST_SALESQUOTE, $_GET['NewQuoteToSalesOrder'], null, 2);
	echo '</li></ol>';*/

	display_footer_exit();
}

//----------------------------------------------------------------------------------------------------------

function copy_to_cart()
{
    global $Refs, $SysPrefs;
	$cart = &$_SESSION['Items'];

	// pk --- reference if entered manually 
	if(!isset($_POST['ref']))
		$cart->reference =  $Refs->get_next($_SESSION['Items']->trans_type, null, array('date' => Today()));
	else
		$cart->reference = $_POST['ref'];

	$cart->Comments =  $_POST['Comments'];

	$cart->document_date = $_POST['OrderDate'];

	$newpayment = false;

	if (isset($_POST['payment']) && ($cart->payment != $_POST['payment'])) {
		$cart->payment = $_POST['payment'];
		$cart->payment_terms = get_payment_terms($_POST['payment']);
		$newpayment = true;
	}
	if ($cart->payment_terms['cash_sale']) {
		if ($newpayment) {
			$cart->due_date = $cart->document_date;
			$cart->phone = $cart->cust_ref = $cart->delivery_address = '';
			$cart->ship_via = 0;
			$cart->deliver_to = '';
			$cart->prep_amount = 0;
		}
	} else {
		$cart->due_date = $_POST['delivery_date'];
		$cart->cust_ref = $_POST['cust_ref'];
		$cart->deliver_to = $_POST['deliver_to'];
		$cart->delivery_address = $_POST['delivery_address'];
		$cart->phone = $_POST['phone'];
		$cart->ship_via = $_POST['ship_via'];
		if (!$cart->trans_no || ($cart->trans_type == ST_SALESORDER && !$cart->is_started()))
			$cart->prep_amount = input_num('prep_amount', 0);
	}
	$cart->Location = $_POST['Location'];
	$cart->freight_cost = input_num('freight_cost');
	if (isset($_POST['email']))
		$cart->email =$_POST['email'];
	// else
	// 	$cart->email = '';
	// display_error($cart->email);
	// exit();
	$cart->customer_id	= $_POST['customer_id'];
	$cart->Branch = $_POST['branch_id'];
	$cart->sales_type = $_POST['sales_type'];
	$cart->country = $_POST['country'];
	if ($cart->trans_type!=ST_SALESORDER && $cart->trans_type!=ST_SALESQUOTE) { // 2008-11-12 Joe Hunt
		$cart->dimension_id = $_POST['dimension_id'];
		$cart->dimension2_id = $_POST['dimension2_id'];
	}
	$cart->ex_rate = input_num('_ex_rate', null);

		$cart->country_code = $_POST['country_code'];
		$cart->customer_email_ = $_POST['customer_email_'];
		$cart->customer_phone_ = $_POST['customer_phone_'];
		$cart->ov_discount = $_POST['ov_discount'];



	// if (isset($_POST['attachment'])) {
	// 	$cart->attachment = $_POST['attachment'];
	// }
	
}

//-----------------------------------------------------------------------------

function copy_from_cart()
{
	$cart = &$_SESSION['Items'];
	$_POST['ref'] = $cart->reference;
	$_POST['Comments'] = $cart->Comments;

	$_POST['OrderDate'] = $cart->document_date;
	$_POST['delivery_date'] = $cart->due_date;
	$_POST['cust_ref'] = $cart->cust_ref;
	$_POST['freight_cost'] = price_format($cart->freight_cost);

	$_POST['deliver_to'] = $cart->deliver_to;
	$_POST['delivery_address'] = $cart->delivery_address;
	$_POST['phone'] = $cart->phone;
	$_POST['Location'] = $cart->Location;
	$_POST['ship_via'] = $cart->ship_via;

	$_POST['customer_id'] = $cart->customer_id;

	$_POST['branch_id'] = $cart->Branch;
	$_POST['sales_type'] = $cart->sales_type;
	$_POST['country'] = $cart->country;
	$_POST['prep_amount'] = price_format($cart->prep_amount);
	// POS 
	$_POST['payment'] = $cart->payment;
	if ($cart->trans_type!=ST_SALESORDER && $cart->trans_type!=ST_SALESQUOTE && $cart->trans_type!=ST_SALESINVOICE) { // 2008-11-12 Joe Hunt
		$_POST['dimension_id'] = $cart->dimension_id;
		$_POST['dimension2_id'] = $cart->dimension2_id;
	}
	$_POST['cart_id'] = $cart->cart_id;
	$_POST['_ex_rate'] = $cart->ex_rate;

	$_POST['customer_email_'] = $cart->customer_email_;
	$_POST['customer_phone_'] = $cart->customer_phone_;
	$_POST['country_code'] = $cart->country_code;
	$_POST['ov_discount'] = $cart->ov_discount;
	
}
//--------------------------------------------------------------------------------

function line_start_focus() {
  	global 	$Ajax;

  	$Ajax->activate('items_table');
  	$Ajax->activate('mobile_form');
  	set_focus('_stock_id_edit');
}

//--------------------------------------------------------------------------------
function can_process() {

	global $Refs, $SysPrefs;

	copy_to_cart();

	if (!get_post('customer_id')) 
	{
		display_error(_("There is no Customer selected."));
		set_focus('customer_id');
		return false;
	} 
	
	if (!get_post('branch_id')) 
	{
		display_error(_("This Customer has no branch defined."));
		set_focus('branch_id');
		return false;
	} 
	
	if (!is_date($_POST['OrderDate'])) {
		display_error(_("The entered date is invalid."));
		set_focus('OrderDate');
		return false;
	}
	if ($_SESSION['Items']->trans_type!=ST_SALESORDER && $_SESSION['Items']->trans_type!=ST_SALESQUOTE && !is_date_in_fiscalyear($_POST['OrderDate'])) {
		display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
		set_focus('OrderDate');
		return false;
	}
	if (count($_SESSION['Items']->line_items) == 0)	{
		display_error(_("You must enter at least one non empty item line."));
		set_focus('AddItem');
		return false;
	}
	if (!$SysPrefs->allow_negative_stock() && ($low_stock = $_SESSION['Items']->check_qoh()))
	{
		display_error(_("This document cannot be processed because there is insufficient quantity for marked items"));
		return false;
	}
	if ($_SESSION['Items']->payment_terms['cash_sale'] == 0) {
		if (!$_SESSION['Items']->is_started() && ($_SESSION['Items']->payment_terms['days_before_due'] == -1) && ((input_num('prep_amount')<=0) ||
			input_num('prep_amount')>$_SESSION['Items']->get_trans_total())) {
			display_error(_("Pre-payment required have to be positive and less than total amount."));
			set_focus('prep_amount');
			return false;
		}
	
		if (strlen($_POST['deliver_to']) <= 1) {
			display_error(_("You must enter the person or company to whom delivery should be made to."));
			set_focus('deliver_to');
			return false;
		}

		if ($_SESSION['Items']->trans_type != ST_SALESQUOTE && strlen($_POST['delivery_address']) <= 1) {
			display_error( _("You should enter the street address in the box provided. Orders cannot be accepted without a valid street address."));
			set_focus('delivery_address');
			return false;
		}

		if ($_POST['freight_cost'] == "")
			$_POST['freight_cost'] = price_format(0);

		if (!check_num('freight_cost',0)) {
			display_error(_("The shipping cost entered is expected to be numeric."));
			set_focus('freight_cost');
			return false;
		}
		if (!is_date($_POST['delivery_date'])) {
			if ($_SESSION['Items']->trans_type==ST_SALESQUOTE)
				display_error(_("The Valid date is invalid."));
			else	
				display_error(_("The delivery date is invalid."));
			set_focus('delivery_date');
			return false;
		}
		
		if (date1_greater_date2($_POST['OrderDate'], $_POST['delivery_date'])) {
			if ($_SESSION['Items']->trans_type==ST_SALESQUOTE)
				display_error(_("The requested valid date is before the date of the quotation."));
			else	
				display_error(_("The requested delivery date is before the date of the order."));
			set_focus('delivery_date');
			return false;
		}
	}
	else
	{
		if (!db_has_cash_accounts())
		{
			display_error(_("You need to define a cash account for your Sales Point."));
			return false;
		}	
		
	}
	
	if (!$Refs->is_valid($_POST['ref'], $_SESSION['Items']->trans_type)) {
		display_error(_("You must enter a reference."));
		set_focus('ref');
		return false;
	}

	if (!db_has_currency_rates($_SESSION['Items']->customer_currency, $_POST['OrderDate']))
		return false;
	
	
   	if ($_SESSION['Items']->get_items_total() < 0) {
		display_error("Invoice total amount cannot be less than zero.");
		return false;
	}
	
	
	return true;
}

//-----------------------------------------------------------------------------

if (isset($_POST['update'])) {
	copy_to_cart();
	$Ajax->activate('items_table');
}
function get_so_line_detail_id($order_no,$stock_id){
	$sql = "SELECT `id` FROM `0_sales_order_details` WHERE `order_no` = '$order_no' AND `stk_code` = '$stock_id'";
	$run = db_query($sql);
	return db_fetch($run)['id'];
}
if(isset($_POST['add_points_counter'])){
	$OTP_Code = rand(1000,9999);
	add_otp_code($_POST['customer_id'], $OTP_Code,$_POST['country_code'],$_POST['customer_phone_']);
	$phone = get_branch($_POST['branch_id'])['branch_ref'];
	if($phone != null){
        $phone = "+971".substr($phone, +1);
        //send_details_to_customer_about_otp($phone, $OTP_Code);
    }

}
// for bar code
if(isset($_POST['bar_code']) && $_POST['bar_code'] != ''){
	$res = check_bar_code($_POST['bar_code']);
	if(db_num_rows($res) > 0){
		$bar_row = db_fetch($res);

		$price = get_kit_price($bar_row['stock_id'],
			$_SESSION['Items']->customer_currency, $_SESSION['Items']->sales_type,
			$_SESSION['Items']->price_factor, date('d/m/Y'));

		// display_error($price);
		add_to_order($_SESSION['Items'], $bar_row['stock_id'], $bar_row['quantity'],
		$price, 0 , /*get_post('stock_id_text')*/$bar_row['description'], 
		get_post('specc'), get_post('specc2'), get_post('specc3'), get_post('specc4'), get_post('specc5'),0,get_post('wo_type'));

	/*unset($_POST['_stock_id_edit'], $_POST['stock_id']);
		add_to_order($_SESSION['Items'], $bar_row['stock_id'], $bar_row['quantity'],
		$price, 0 , $bar_row['description'],$_POST['bar_code']);*/

	unset($_POST['_stock_id_edit'], $_POST['stock_id'],$_POST['bar_code']);
	page_modified();
	// $Ajax->activate('_page_body');
	
	$Ajax->activate('summary_div');
	$Ajax->activate('cancel_div');
	$Ajax->activate('total_price_div');
    set_focus('bar_code');
    unset($_POST['bar_code']);
	$Ajax->activate('bar_code');
	}else{
		display_error('No bar code exits');
	}

}

if (isset($_POST['ProcessOrder']) && can_process()) {
 
	if($_SESSION['Items']->auto_dimension && $_SESSION['Items']->trans_no==0){
		$dimension_ref = $Refs->get_next(ST_DIMENSION, null, today());
		$dimension_name = $_SESSION['Items']->reference.' '.$_SESSION['Items']->customer_name;
		$_SESSION['Items']->dimension_id = add_dimension($dimension_ref, $dimension_name, 1, today(), (date('d/m/').(date('Y')+1)));
		$sql = add_dimension_in_hr($dimension_name, $_SESSION['Items']->dimension_id);
		if(db_query($sql, null, true))
			update_dimension_reference_in_hr();
	} 

	$modified = ($_SESSION['Items']->trans_no != 0);
	$so_type = $_SESSION['Items']->so_type;
	$attachment_id = $_SESSION['Items']->attachment;
	$ret = $_SESSION['Items']->write(1);
	/*if ($_POST['is_wo'] == 1 && $ret != -1) {
			$bank_act = get_default_bank_account();
			$cr_lab_acc = $bank_act['account_code'];
			$cr_acc = $bank_act['account_code'];
		foreach ($_SESSION['Items']->line_items as $line){
			if (get_item($line->stock_id)['mb_flag'] == 'M') {
				$wo_ref = $Refs->get_next(ST_WORKORDER, null, $_SESSION['Items']->document_date);
				$id = add_work_order($wo_ref, $_SESSION['Items']->Location, $line->quantity,
				$line->stock_id,  $line->wo_type, $_SESSION['Items']->document_date,
				$_POST['wo_required_date'], '', 0, $cr_acc, 0, $cr_lab_acc,$ret,$line_id);
			}
		}
	
	}*/
	// exit;
	if ($ret == -1)
	{
		display_error(_("The entered reference is already in use."));
		$ref = $Refs->get_next($_SESSION['Items']->trans_type, null, array('date' => Today()));
		if ($ref != $_SESSION['Items']->reference)
		{
			unset($_POST['ref']); // force refresh reference
			display_error(_("The reference number field has been increased. Please save the document again."));
		}
		set_focus('ref');
	}
	else
	{
		if (count($messages)) { // abort on failure or error messages are lost
			$Ajax->activate('_page_body');
			display_footer_exit();
		}
		$trans_no = key($_SESSION['Items']->trans_no);
		$trans_type = $_SESSION['Items']->trans_type;
		new_doc_date($_SESSION['Items']->document_date);
		if ($trans_type == ST_SALESINVOICE && $_POST['payment'] == 4) {
			if($SysPrefs->prefs['customer_loyality_check'] == 1){
				$myrow = get_customer_trans($trans_no, ST_SALESINVOICE);
				
				if($SysPrefs->prefs['loyality_points_tax'] == 1){
					$ov_amount = $myrow['ov_amount'];
				}else{
					$ov_amount = $myrow['ov_amount']+$myrow['ov_gst'];
				}
				

				if(isset($_POST['points_check'])){
					// update_loyality_points($_POST['points_counter_hidden'], $_POST['customer_id'], $trans_type, $trans_no);
					//*str_replace(',', '', $SysPrefs->prefs['loyality_points_amount'])
					store_loyality_points($ov_amount, $_POST['customer_id'], $trans_type, $trans_no, $_POST['points_counter_hidden'],$_SESSION['Items']->customer_,$_SESSION['Items']->customer_phone_,$_SESSION['Items']->customer_email_,$_SESSION['Items']->branch,$_SESSION['Items']->country_code);
				}else{
					
					store_loyality_points($ov_amount, $_POST['customer_id'], $trans_type, $trans_no,0,$_SESSION['Items']->customer_,$_SESSION['Items']->customer_phone_,$_SESSION['Items']->customer_email_,$_SESSION['Items']->branch,$_SESSION['Items']->country_code);
				}



			}
		}
		processing_end();
		if ($modified) {
			if ($trans_type == ST_SALESQUOTE)
				meta_forward($_SERVER['PHP_SELF'], "UpdatedQU=$trans_no");
			else	
				meta_forward($_SERVER['PHP_SELF'], "UpdatedID=$trans_no");
		} elseif ($trans_type == ST_SALESORDER) {
			meta_forward($_SERVER['PHP_SELF'], "AddedID=$trans_no");
		} elseif ($trans_type == ST_SALESQUOTE) {
			meta_forward($_SERVER['PHP_SELF'], "AddedQU=$trans_no");
		} elseif ($trans_type == ST_SALESINVOICE) {
			if ($attachment_id > 0) {
				link_document($attachment_id , $trans_no, $trans_type);
			}
			meta_forward($_SERVER['PHP_SELF'], "AddedDI=$trans_no&Type=$so_type");
		} else {
			if ($attachment_id > 0) {
				link_document($attachment_id , $trans_no, $trans_type);
			}
			meta_forward($_SERVER['PHP_SELF'], "AddedDN=$trans_no&Type=$so_type");
		}
	}	
}

//--------------------------------------------------------------------------------

function check_item_data()
{
	global $SysPrefs;
	
	$is_inventory_item = is_inventory_item(get_post('stock_id'));
	if(!get_post('stock_id_text', true)) {
		display_error( _("Item description cannot be empty."));
		set_focus('stock_id_edit');
		return false;
	}
	//!check_num('Disc', 0, 100)
	elseif (!check_num('qty', 0)) {
		display_error( _("The item could not be updated because you are attempting to set the quantity ordered to less than 0, or the discount percent to more than 100."));
		set_focus('qty');
		return false;
	} elseif (!check_num('price', 0) && (!$SysPrefs->allow_negative_prices() || $is_inventory_item)) {
		display_error( _("Price for inventory item must be entered and can not be less than 0"));
		set_focus('price');
		return false;
	} elseif (isset($_POST['LineNo']) && isset($_SESSION['Items']->line_items[$_POST['LineNo']])
	    && !check_num('qty', $_SESSION['Items']->line_items[$_POST['LineNo']]->qty_done)) {

		set_focus('qty');
		display_error(_("You attempting to make the quantity ordered a quantity less than has already been delivered. The quantity delivered cannot be modified retrospectively."));
		return false;
	}
	elseif(input_num('Disc')>100 && !$_SESSION['Items']->discount_criteria){
		display_error(_("Discount can not be greater than 100%."));
		set_focus('Disc');
		return false;
	}
	elseif(input_num('Disc')>input_num('price') && $_SESSION['Items']->discount_criteria){
		display_error(_("Discount can not be greater than price."));
		set_focus('Disc');
		return false;
	}
	elseif (input_num('qty') <= 0) {
		display_error(_("Quantity cannot be less than equal to zero."));
		set_focus('qty');
		return false;
	}elseif (input_num('price') < 0) {
		display_error(_("Price cannot be less zero."));
		set_focus('price');
		return false;
	}
	elseif(input_num('Disc')<0){
		display_error(_("Discount cannot be less than zero."));
		set_focus('Disc');
		return false;
	}

	$cost_home = get_unit_cost(get_post('stock_id')); // Added 2011-03-27 Joe Hunt
	$cost = $cost_home / get_exchange_rate_from_home_currency($_SESSION['Items']->customer_currency, $_SESSION['Items']->document_date);
	if (input_num('price') < $cost)
	{
		$dec = user_price_dec();
		$curr = $_SESSION['Items']->customer_currency;
		$price = number_format2(input_num('price'), $dec);
		if ($cost_home == $cost)
			$std_cost = number_format2($cost_home, $dec);
		else
		{
			$price = $curr . " " . $price;
			$std_cost = $curr . " " . number_format2($cost, $dec);
		}
		display_warning(sprintf(_("Price %s is below Standard Cost %s"), $price, $std_cost));
	}	
	return true;
}

//--------------------------------------------------------------------------------

function handle_update_item(){

	if ($_POST['UpdateItem'] != '' && check_item_data()){
		
		if($_SESSION['Items']->discount_criteria)
			$discount = input_num('Disc');
		else
			$discount = input_num('qty')*input_num('price')*(input_num('Disc')/100);
		if(!$discount)
			$discount = 0;

		$_SESSION['Items']->update_cart_item($_POST['LineNo'], input_num('qty'), 
		input_num('price'),  round($discount, user_price_dec()), $_POST['item_description'],
		get_post('specc'), get_post('specc2'), get_post('specc3'), get_post('specc4'),
		get_post('specc5'), $_POST['spec_description']);
		
		$_SESSION['Items']->line_items[$_POST['LineNo']]->item_specs = $_POST['item_specs'];
	}
	page_modified();
  line_start_focus();
   
   global $Ajax;
	$Ajax->addScript(true, "spec_read_more();");//read spec
}
	
//--------------------------------------------------------------------------------

function handle_delete_item($line_no)
{
    if ($_SESSION['Items']->some_already_delivered($line_no) == 0) {
	    $_SESSION['Items']->remove_from_cart($line_no);
    } else {
		display_error(_("This item cannot be deleted because some of it has already been delivered."));
    }
    line_start_focus();
    
     global $Ajax;
	$Ajax->addScript(true, "spec_read_more();");//read spec
}

//--------------------------------------------------------------------------------

function handle_new_item(){

	if(!check_item_data()){
			return;
	}
	
	if($_SESSION['Items']->discount_criteria){
		$discount = input_num('Disc');
	}
	elseif(input_num('Disc')){
		$discount = input_num('price')*input_num('qty')*(input_num('Disc')/100);
	}
	if(!$discount)
		$discount = 0;

	add_to_order($_SESSION['Items'], get_post('stock_id'), input_num('qty'),
	input_num('price'),round($discount, user_price_dec()) , get_post('stock_name'), get_post('specc'), 
	get_post('specc2'), get_post('specc3'), get_post('specc4'), get_post('specc5'), 0,
	get_post('wo_type'), $_POST['stype_line'], $_POST['item_specs'], $_POST['spec_description']);

	unset($_POST['_stock_id_edit'], $_POST['stock_id']);
	$_POST['item_specs'] = array();
	page_modified();
	line_start_focus();
	
	global $Ajax;
	$Ajax->addScript(true, "spec_read_more();");//read spec
}

//--------------------------------------------------------------------------------

function  handle_cancel_order()
{
	global $path_to_root, $Ajax;


	if ($_SESSION['Items']->trans_type == ST_CUSTDELIVERY) {
		display_notification(_("Direct delivery entry has been cancelled as requested."), 1);
		submenu_option(_("Enter a New Sales Delivery"),	"/sales/sales_order_entry.php?NewDelivery=1");
	} elseif ($_SESSION['Items']->trans_type == ST_SALESINVOICE) {
		display_notification(_("Direct invoice entry has been cancelled as requested."), 1);
		submenu_option(_("Enter a New Sales Invoice"),	"/sales/sales_order_entry.php?NewInvoice=1");
	} elseif ($_SESSION['Items']->trans_type == ST_SALESQUOTE)
	{
		if ($_SESSION['Items']->trans_no != 0) 
			delete_sales_order(key($_SESSION['Items']->trans_no), $_SESSION['Items']->trans_type, $_SESSION['Items']->opp_id);
		display_notification(_("This sales quotation has been cancelled as requested."), 1);
		submenu_option(_("Enter a New Sales Quotation"), "/sales/sales_order_entry.php?NewQuotation=Yes");
	} else { // sales order
		if ($_SESSION['Items']->trans_no != 0) {
			$order_no = key($_SESSION['Items']->trans_no);
			if (sales_order_has_deliveries($order_no))
			{
				close_sales_order($order_no);
				display_notification(_("Undelivered part of order has been cancelled as requested."), 1);
				submenu_option(_("Select Another Sales Order for Edition"), "/sales/inquiry/sales_orders_view.php?type=".ST_SALESORDER);
			} else {
				delete_sales_order(key($_SESSION['Items']->trans_no), $_SESSION['Items']->trans_type, $_SESSION['Items']->opp_id);

				display_notification(_("This sales order has been cancelled as requested."), 1);
				submenu_option(_("Enter a New Sales Order"), "/sales/sales_order_entry.php?NewOrder=Yes");
			}
		} else {
			processing_end();
			meta_forward($path_to_root.'/index.php','application=maintenance');
		}
	}
	processing_end();
	display_footer_exit();
}

//-------------------------------------------------------------------------------
//Empty Cart if customer changed as discount and sales type could be different
if (list_updated('customer_id')){
	global $Ajax;
	$_SESSION['Items']->clear_items();
	$Ajax->activate('_page_body');
}
//--------------------------------------------------------------------------------

function create_cart($type, $trans_no, $attachment_id, $order_creation=false)
{ 
	global $Refs, $SysPrefs;

	if (!$SysPrefs->db_ok) // create_cart is called before page() where the check is done
		return;

	processing_start();
	if (isset($_GET['NewQuoteToSalesOrder']))
	{
		$trans_no = $_GET['NewQuoteToSalesOrder'];
		$doc = new Cart(ST_SALESQUOTE, $trans_no, true, $order_creation);
		$doc->Comments = _("Sales Quotation") . " # " . $trans_no;
		$_SESSION['Items'] = $doc;
	}	
	elseif($type != ST_SALESORDER && $type != ST_SALESQUOTE && $trans_no != 0) { // this is template

		$doc = new Cart(ST_SALESORDER, array($trans_no));
		$doc->trans_type = $type;
		$doc->trans_no = 0;

		$doc->document_date = new_doc_date();
		if ($type == ST_SALESINVOICE) {
			$doc->due_date = get_invoice_duedate($doc->payment, $doc->document_date);
			$doc->pos = get_sales_point(user_pos());
		} else
			$doc->due_date = $doc->document_date;
		if(!isset($_POST['ref']))
			$doc->reference = $Refs->get_next($doc->trans_type, null, array('date' => Today()));
		else
			$doc->reference = $_POST['ref'];
		//$doc->Comments='';
		foreach($doc->line_items as $line_no => $line) {
			$doc->line_items[$line_no]->qty_done = 0;
		}
		$_SESSION['Items'] = $doc;
	} else
		$_SESSION['Items'] = new Cart($type, array($trans_no));
		if (isset($attachment_id)) {
			$_SESSION['Items']->attachment = $attachment_id;
		}
	copy_from_cart();
// display_error(sadas);
}

//--------------------------------------------------------------------------------
// code for modal work
if(isset($_POST['invoice_feild_update'])){

	update_form_feild_status(10, get_post(array('pc_customer_id_checkbox', 'pc_branch_id_checkbox', 'pc_reference_checkbox', 'pc_current_credit_checkbox', 'pc_customer_discount_checkbox', 'pc_payment_checkbox' , 'pc_price_list_checkbox', 'pc_date_checkbox', 'pc_dimension_checkbox', 'pc_dimension_2_checkbox', 'pc_exchange_rate_checkbox' )), get_post(array('mbl_customer_id_checkbox', 'mbl_branch_id_checkbox', 'mbl_reference_checkbox', 'mbl_current_credit_checkbox', 'mbl_customer_discount_checkbox', 'mbl_payment_checkbox' , 'mbl_price_list_checkbox', 'mbl_date_checkbox', 'mbl_dimension_checkbox', 'mbl_dimension_2_checkbox', 'mbl_exchange_rate_checkbox' )));
}

if (isset($_POST['CancelOrder']))
	handle_cancel_order();

$id = find_submit('Delete');
if ($id!=-1)
	handle_delete_item($id);

if (isset($_POST['UpdateItem']))
	handle_update_item();

if (isset($_POST['AddItem']))
	handle_new_item();

if (isset($_POST['CancelItemChanges'])) {
	line_start_focus();
	
	global $Ajax;
	$Ajax->addScript(true, "spec_read_more();");//read spec
}

//--------------------------------------------------------------------------------
if ($_SESSION['Items']->fixed_asset)
	check_db_has_disposable_fixed_assets(_("There are no fixed assets defined in the system."));
else
	check_db_has_stock_items(_("There are no inventory items defined in the system."));

check_db_has_customer_branches(_("There are no Customers, or there are no Customers with branches. Please define Customers and customer branches."));

if ($_SESSION['Items']->trans_type == ST_SALESINVOICE) {
	$idate = _("Invoice Date:");
	$orderitems = _("Sales Invoice Items");
	$deliverydetails = _("Enter Delivery Details and Confirm Invoice");
	$cancelorder = _("Cancel Invoice");
	$porder = _("Place Invoice");
} elseif ($_SESSION['Items']->trans_type == ST_CUSTDELIVERY) {
	$idate = _("Delivery Date:");
	$orderitems = _("Delivery Note Items");
	$deliverydetails = _("Enter Delivery Details and Confirm Dispatch");
	$cancelorder = _("Cancel Delivery");
	$porder = _("Place Delivery");
} elseif ($_SESSION['Items']->trans_type == ST_SALESQUOTE) {
	$idate = _("Quotation Date:");
	$orderitems = _("Sales Quotation Items");
	$deliverydetails = _("Enter Delivery Details and Confirm Quotation");
	$cancelorder = _("Cancel Quotation");
	$porder = _("Place Quotation");
	$corder = _("Commit Quotations Changes");
} else {
	$idate = _("Order Date:");
	$orderitems = _("Sales Order Items");
	$deliverydetails = _("Enter Delivery Details and Confirm Order");
	$cancelorder = _("Cancel Order");
	$porder = _("Place Order");
	$corder = _("Commit Order Changes");
}
start_form();

hidden('cart_id');

br();
$detect = new Mobile_Detect();
if ($detect->isMobile() && false){
	 
	if ($_SESSION["wa_current_user"]->can_access_page('INVOICE_FORM_FIELD'))
		echo "<a  class='' data-target='#modal_invoice_view' data-toggle='modal'><i style='float: right;' title='Select Table widgets' class='fa fa-plus-circle fa-2x'></i></a>";
	
	$customer_error = display_order_header_for_mobile($_SESSION['Items'], !$_SESSION['Items']->is_started(), $idate);
	if ($customer_error == "") {
		br();
		div_start('mobile_form');
		start_table(TABLESTYLE2, 'width:90% !important ;', 10);
		sales_order_item_controls_for_mobile($orderitems, $_SESSION['Items']);
	    end_table(1);
		div_end();
		
		display_order_summary_for_mobile($orderitems, $_SESSION['Items'], true, 1);
	    
		display_delivery_details_for_mobile($_SESSION['Items']);
		


		if ($_SESSION['Items']->trans_no == 0) {

			submit_center_first('ProcessOrder', $porder,
			    _('Check entered data and save document'), 'default');
			submit_center_last('CancelOrder', $cancelorder,
		   		_('Cancels document entry or removes sales order when editing an old document'), false, false, null, 0);
			submit_js_confirm('CancelOrder', _('You are about to void this Document.\nDo you want to continue?'));
		} else {
			submit_center_first('ProcessOrder', $corder,
			    _('Validate changes and update document'), 'default');
			submit_center_last('CancelOrder', $cancelorder,
		   		_('Cancels document entry or removes sales order when editing an old document') , false, false, null, 0);
			if ($_SESSION['Items']->trans_type==ST_SALESORDER)
				submit_js_confirm('CancelOrder', _('You are about to cancel undelivered part of this order.\nDo you want to continue?'));
			else
				submit_js_confirm('CancelOrder', _('You are about to void this Document.\nDo you want to continue?'));
		}



	}else{
		display_error($customer_error);
	}
}else{
	if ($_SESSION["wa_current_user"]->can_access_page('INVOICE_FORM_FIELD'))
		echo "<a  class='' data-target='#modal_invoice_view' data-toggle='modal'><i style='float: right;' title='Select Table widgets' class='fa fa-plus-circle fa-2x'></i></a>";
	
	$customer_error = display_order_header($_SESSION['Items'], !$_SESSION['Items']->is_started(), $idate);

	if ($customer_error == "") {

		br();
		br();
		start_table(TABLESTYLE2, 'width:90% !important ;', 10);
		echo "<tr><td>";
		display_order_summary($orderitems, $_SESSION['Items'], true);
		echo "</td></tr>";

	        end_table(1);
	        	br();
		start_table(TABLESTYLE,"style='width:85% !important;'", 10);

		echo "<tr><td>";

		display_delivery_details($_SESSION['Items']);
		echo "</td></tr>";
		end_table(1);

		if ($_SESSION['Items']->trans_no == 0) {

			submit_center_first('ProcessOrder', $porder,
			    _('Check entered data and save document'), 'default');
			submit_center_last('CancelOrder', $cancelorder,
		   		_('Cancels document entry or removes sales order when editing an old document'), false, false, null, 0);
			submit_js_confirm('CancelOrder', _('You are about to void this Document.\nDo you want to continue?'));
		} else {
			submit_center_first('ProcessOrder', $corder,
			    _('Validate changes and update document'), 'default');
			submit_center_last('CancelOrder', $cancelorder,
		   		_('Cancels document entry or removes sales order when editing an old document') , false, false, null, 0);
			if ($_SESSION['Items']->trans_type==ST_SALESORDER)
				submit_js_confirm('CancelOrder', _('You are about to cancel undelivered part of this order.\nDo you want to continue?'));
			else
				submit_js_confirm('CancelOrder', _('You are about to void this Document.\nDo you want to continue?'));
		}

	} else {
		display_error($customer_error);
	}
}	
// echo '<br/>';
end_form();
end_page();
?>

<div class="container-fluid">
	<form method="post">
		<div class="modal fade" id="modal_invoice_view" role="dialog">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-header">
						<a  class="close" data-dismiss="modal">&times;</a>
						<h4 class="modal-title">Direct Invoice Form Feilds</h4>
          				<br>
          				<!-- <select data-live-search="true" name="view" class="form-control" style=" width: 25%;">
                        	<option value="pc">Pc</option>
                        	<option value="mbl">Mobile</option>
                    	</select> -->
          			</div>
          			<div class="modal-body">
          				<table class="table table-hover" style="margin-left: 113px;">
          					<thead>
          						<tr>
          							<th>Feild Name</th>
          							<th style="width: 70px;">For Pc</th>
          							<th>For Mobile</th>
          						</tr>
          					</thead>
          					<tbody>
          					<?php
          					$res = get_form_feilds_status(10);
          					while($row = db_fetch($res)){
          					echo "<tr><td>".$row['tag_name']."</td><td>".checkbox(_(null),'pc_'.$row['name'], $row['status_pc'],false)."</td><td>".checkbox(_(null),'mbl_'.$row['name'], $row['status_mbl'],false)  ."</td></tr>";
          					}
          					?>	
          						
          					</tbody>
          				</table>
          			</div>
          			<div class="modal-footer">
          				<input class="btn btn-info center-block" type="submit" value='Update' name="invoice_feild_update">
          			</div>
          		</div>
          	</div>
        </div>
    </form>
</div>

<!-- read spec -->
<script>
function spec_read_more(){
	$(document).ready(function(){
	   $('.nav-toggle').click(function(e) {
	    var collapse_content_selector = $(this).attr('href');
	    var toggle_switch = $(this);
	    $(collapse_content_selector).toggle(function () {
	      if ($(this).css('display') == 'none') {
	        toggle_switch.html(' Read More...');
	      } else {
	        toggle_switch.html(' Read Less...');
	      }
	    });
	  });
	 
	});
}

spec_read_more();
</script>