<?php


//-================================== FUNCTION ===========================

function random_color_part() {
    return str_pad( dechex( mt_rand( 0, 255 ) ), 2, '0', STR_PAD_LEFT);
}

function random_color() {
    return "#".random_color_part() . random_color_part() . random_color_part();
}

function getCustomerInfo($debtor_no){
	$sql = "SELECT * FROM ".TB_PREF."debtors_master WHERE debtor_no = '$debtor_no'";
	$res = db_query($sql);
	return db_fetch($res);
}

function getSalesManRecievables($salesman){
	$total = 0;
	$sql = "SELECT dt.*, cb.salesman FROM ".TB_PREF."debtor_trans dt JOIN ".TB_PREF."cust_branch cb ON dt.branch_code = cb.branch_code WHERE dt.type = 10 AND cb.salesman = '$salesman'";
	$result = db_query($sql);
	while ($row = db_fetch($result)) {
		$total += $row['ov_amount'] + $row1['ov_gst'];
	}
	return $total;
}



function getSalesAreaRecievables($salesarea){
	$total = 0;
	$sql = "SELECT dt.*, cb.area FROM ".TB_PREF."debtor_trans dt 
			JOIN ".TB_PREF."cust_branch cb ON dt.branch_code = cb.branch_code WHERE dt.type = 10 AND cb.area = '$salesarea'";
	$result = db_query($sql);
	while ($row = db_fetch($result)) {
		$total += $row['ov_amount'] + $row1['ov_gst'];
	}
	return $total;
}


function getYearByYearSalesData($current = true){
	
	if($current){
		$y = date('Y');
	}
	else{
		$y = date('Y');
		$y--;
	}
	$sales = array();
	for ($m=1; $m <= 12 ; $m++) { 
		$total = 0;
		$sql ="SELECT * FROM ".TB_PREF."debtor_trans WHERE type = 10 AND MONTH(tran_date) = '$m' AND YEAR(tran_date) = '$y'";
		$res = db_query($sql);
		while ($row = db_fetch($res)) {
			$total += $row['ov_amount'] + $row['ov_gst'];
		}
		array_push($sales, number_format($total));
	}

	return $sales;
}
//-=============================================================


// todays, month, yearly sales and returns

$date_ = date('Y-m-d');
$m = date('m');
$y = date('Y');
$todays = $monthly = $yearly = 0;
$todays_r = $monthly_r = $yearly_r = 0;
$sql1 ="SELECT * FROM ".TB_PREF."debtor_trans WHERE type = 10 AND tran_date = '$date_'";
$res1 = db_query($sql1);
while ($row1 = db_fetch($res1)) {
	$todays += $row1['ov_amount'] + $row1['ov_gst'];
}

$sql2 ="SELECT * FROM ".TB_PREF."debtor_trans WHERE type = 10 AND MONTH(tran_date) = '$m' AND YEAR(tran_date) = '$y'";
$res2 = db_query($sql2);
while ($row2 = db_fetch($res2)) {
	$monthly += $row2['ov_amount'] + $row2['ov_gst'];
}

$sql3 ="SELECT * FROM ".TB_PREF."debtor_trans WHERE type = 10 AND YEAR(tran_date) = '$y'";
$res3 = db_query($sql3);
while ($row3 = db_fetch($res3)) {
	$yearly += $row3['ov_amount'] + $row3['ov_gst'];
}

$sql ="SELECT * FROM ".TB_PREF."debtor_trans WHERE type = 11 AND tran_date = '$date_'";
$res4 = db_query($sql);
while ($row4 = db_fetch($res4)) {
	$todays_r += $row4['ov_amount'] + $row4['ov_gst'];
}

$sql ="SELECT * FROM ".TB_PREF."debtor_trans WHERE type = 11 AND MONTH(tran_date) = '$m' AND YEAR(tran_date) = '$y'";
$res5 = db_query($sql);
while ($row5 = db_fetch($res5)) {
	$monthly_r += $row5['ov_amount'] + $row5['ov_gst'];
}

$sql ="SELECT * FROM ".TB_PREF."debtor_trans WHERE type = 11 AND YEAR(tran_date) = '$y'";
$res6 = db_query($sql);
while ($row6 = db_fetch($res6)) {
	$yearly_r += $row6['ov_amount'] + $row6['ov_gst'];
}

?>
<div class="row">
<div class="box" style=" border-color: #fff;">
	<div class="box-header with-border">
		<h3 class="box-title"><b><i class="fa fa-fw fa-th"></i>&nbsp;&nbsp;Today's, Monthly & Yealy Sales Analysis</b></h3>
	</div>
	<div class="col-md-12">
		<div class="col-md-6">
			<table class="table" >
				<tr>
					<th></th>
					<th>Sales</th>
					<th>Return</th>
				</tr>
				<tr>
					<th>Todays</th>
					<td class="s_t"><?=number_format($todays,2)?></td>
					<td class="r_t"><?=number_format($todays_r,2)?></td>
				</tr>
				<tr>
					<th>Monthly</th>
					<td class="s_m"><?=number_format($monthly,2)?></td>
					<td class="r_m"><?=number_format($monthly_r,2)?></td>
				</tr>
				<tr>
					<th>Year</th>
					<td class="s_y"><?=number_format($yearly,2)?></td>
					<td class="r_y"><?=number_format($yearly_r,2)?></td>
				</tr>			
			</table>				
		</div>
		<div class="col-md-6">
			<div class="box-body chart-responsive">
			  <div class="chart" id="bar-chart" style="height: 300px;"></div>
			</div>			
		</div>
	</div>
</div>
</div>
<div class="row">
	<div class="col-md-6">
	<!-- Recievable Sales Man / Sales Person  -->
		<div class="box" style=" border-color: #fff;">
			<div class="box-header with-border">
				<h3 class="box-title"><b><i class="fa fa-fw fa-th"></i>&nbsp;&nbsp;Recievables Sales Person</b></h3>
			</div>
            <div class="box-body chart-responsive">
              <div class="chart" id="salesman-chart" style="height: 300px; position: relative;"></div>
            </div>			
			<table class="table">
				<tr>
					<th>Sales Person</th>
					<th>Amount</th>
				</tr>
			<?php
			$sql = "SELECT * FROM ".TB_PREF."salesman";
			$result = db_query($sql);
			$result_1 = db_query($sql);
			$i = $j = $k = 0;
			while ($myrow_1 = db_fetch($result_1)) {
              $k++;
			}	
			echo '<span style="display: none;" class="smtotal">'.$k.'</span>';		
			while ($myrow = db_fetch($result)) { ?>
				<tr>
					<td class="smname<?=$i++?>"><?=$myrow['salesman_name']?></td>
					<td class="smamount<?=$j++?>"><?=number_format(getSalesManRecievables($myrow['salesman_code']),2)?></td>				
				</tr>
			
			<?php }  ?>
			</table>


		</div>		
	</div>
	<div class="col-md-6">
			<!-- Recievable Sales Man / Sales Person  -->
		<div class="box" style=" border-color: #fff;">
			<div class="box-header with-border">
				<h3 class="box-title"><b><i class="fa fa-fw fa-th"></i>&nbsp;&nbsp;Recievables Sales Area</b></h3>
			</div>
            <div class="box-body chart-responsive">
              <div class="chart" id="salesarea-chart" style="height: 300px; position: relative;"></div>
            </div>			
			<table class="table">
				<tr>
					<th>Sales Area</th>
					<th>Amount</th>
				</tr>
			<?php
			$sql = "SELECT * FROM ".TB_PREF."areas";
			$result1 = db_query($sql);
			$result2 = db_query($sql);
			$i = $j = $k = 0;
			while ($myrow1 = db_fetch($result1)) {
              $k++;
			}
			echo '<span style="display: none;" class="satotal">'.$k.'</span>';
			while ($myrow2 = db_fetch($result2)) { ?>
				<tr>
					<td class="saname<?=$i++?>"><?=$myrow2['description']?></td>
					<td class="saamount<?=$j++?>"><?=number_format(getSalesAreaRecievables($myrow2['area_code']),2)?></td>					
				</tr>
			
			<?php }  ?>
			</table>
		</div>		
	</div>
</div>
<!-- Year to year comparision for Sales  -->
<div class="row">
<div class="box" style=" border-color: #fff;">
	<div class="box-header with-border">
		<h3 class="box-title"><b><i class="fa fa-fw fa-th"></i>&nbsp;&nbsp;Sales Year by Year comparision</b></h3>
	</div>
	<div class="col-md-12">
		<?php 
			$data1 = getYearByYearSalesData(false); // for previous year
			$data2 = getYearByYearSalesData(true);	// for current year

		?>
		<table class="table">
			<tr>
				<th></th>
				<th>Jan</th>
				<th>Feb</th>
				<th>Mar</th>
				<th>Apr</th>
				<th>May</th>
				<th>Jun</th>
				<th>Jul</th>
				<th>Aug</th>
				<th>Sep</th>
				<th>Oct</th>
				<th>Nov</th>
				<th>Dec</th>
			</tr>

			<tr>
				<th>2017</th>
				<td class="prevSales0"><?=$data1['0']?></td>
				<td class="prevSales1"><?=$data1['1']?></td>
				<td class="prevSales2"><?=$data1['2']?></td>
				<td class="prevSales3"><?=$data1['3']?></td>
				<td class="prevSales4"><?=$data1['4']?></td>
				<td class="prevSales5"><?=$data1['5']?></td>
				<td class="prevSales6"><?=$data1['6']?></td>
				<td class="prevSales7"><?=$data1['7']?></td>
				<td class="prevSales8"><?=$data1['8']?></td>
				<td class="prevSales9"><?=$data1['9']?></td>
				<td class="prevSales10"><?=$data1['10']?></td>
				<td class="prevSales11"><?=$data1['11']?></td>
			</tr>	
			<tr>
				<th>2018</th>
				<td class="currSales0"><?=$data2['0']?></td>
				<td class="currSales1"><?=$data2['1']?></td>
				<td class="currSales2"><?=$data2['2']?></td>
				<td class="currSales3"><?=$data2['3']?></td>
				<td class="currSales4"><?=$data2['4']?></td>
				<td class="currSales5"><?=$data2['5']?></td>
				<td class="currSales6"><?=$data2['6']?></td>
				<td class="currSales7"><?=$data2['7']?></td>
				<td class="currSales8"><?=$data2['8']?></td>
				<td class="currSales9"><?=$data2['9']?></td>
				<td class="currSales10"><?=$data2['10']?></td>
				<td class="currSales11"><?=$data2['11']?></td>
			</tr>	
		</table>
	</div>
	<div class="col-md-12">
		<div class="box-body chart-responsive">
		  <div class="chart" id="year-by-year-sales-chart" style="height: 300px;"></div>
		</div>			
	</div>

</div>
</div>

<!-- 10 Recent Sales Invoice  -->
<div class="row">
<div class="box" style=" border-color: #fff;">
	<div class="box-header with-border">
		<h3 class="box-title"><b><i class="fa fa-fw fa-th"></i>&nbsp;&nbsp;10 Recent Sales Invoice</b></h3>
	</div>
	<div class="col-md-12">
	<table class="table">
		<tr>
			<th>#</th>
			<th>Ref</th>
			<th>Customer</th>
			<th>Date</th>
			<th>Due Date</th>
			<th>Currency</th>
			<th>Total</th>
		</tr>
		<?php 
		$sql ="SELECT * FROM ".TB_PREF."debtor_trans WHERE type = 10 ORDER BY trans_no DESC LIMIT 10";
		$val = db_query($sql);
		while($value = db_fetch($val)) { 
			$url = $path_to_root.'/sales/view/view_invoice.php?trans_no='.$value['trans_no'].'&trans_type=10"';
		?>
		<tr>
			<td><a href="<?=$url?>"><?=$value['trans_no']?></a></td>
			<td><?=$value['reference']?></td>
			<td><?=getCustomerInfo($value['debtor_no'])['name']?></td>
			<td><?=sql2date($value['tran_date'])?></td>
			<td><?=sql2date($value['due_date'])?></td>
			<td><?=getCustomerInfo($value['debtor_no'])['curr_code']?></td>
			<td><?=number_format($value['ov_amount'] + $value['ov_gst'],2)?></td>
		</tr>
		<?php } ?>		
	</table>
	</div>
</div>
</div>

<!-- 10 Recent Delievery Note  -->
<div class="row">
<div class="box" style=" border-color: #fff;">
	<div class="box-header with-border">
		<h3 class="box-title"><b><i class="fa fa-fw fa-th"></i>&nbsp;&nbsp;10 Recent Delievery Note</b></h3>
	</div>
	<div class="col-md-12">
	<table class="table">
		<tr>
			<th>#</th>
			<th>Ref</th>
			<th>Customer</th>
			<th>Date</th>
			<th>Due Date</th>
			<th>Currency</th>
			<th>Total</th>
		</tr>
		<?php 
		$sql ="SELECT * FROM ".TB_PREF."debtor_trans WHERE type = 13 ORDER BY trans_no DESC LIMIT 10";
		$val = db_query($sql);
		while($value = db_fetch($val)) { 
		   $url = $path_to_root.'/sales/view/view_dispatch.php?trans_no='.$value['trans_no'].'&trans_type=13"';
		?>
		<tr>
			<td><a href="<?=$url?>"><?=$value['trans_no']?></a></td>
			<td><?=$value['reference']?></td>
			<td><?=getCustomerInfo($value['debtor_no'])['name']?></td>
			<td><?=sql2date($value['tran_date'])?></td>
			<td><?=sql2date($value['due_date'])?></td>
			<td><?=getCustomerInfo($value['debtor_no'])['curr_code']?></td>
			<td><?=number_format($value['ov_amount'] + $value['ov_gst'],2)?></td>
		</tr>
		<?php } ?>		
	</table>
	</div>
</div>
</div>

<!-- 10 Recent Overdue Sales Invoice  -->
<div class="row">
<div class="box" style=" border-color: #fff;">
	<div class="box-header with-border">
		<h3 class="box-title"><b><i class="fa fa-fw fa-th"></i>&nbsp;&nbsp;10 Recent Overdue Sales Invoice</b></h3>
	</div>
	<div class="col-md-12">
	<table class="table">
		<tr>
			<th>#</th>
			<th>Ref</th>
			<th>Date</th>
			<th>Due Date</th>
			<th>Customer</th>
			<th>Currency</th>
			<th>Total</th>
			<th>Remainder</th>
			<th>Days</th>
		</tr>
		<?php 

		if (!defined('FLOAT_COMP_DELTA'))	
				define('FLOAT_COMP_DELTA', 0.004);

		$today = date2sql(Today());
		$sql = "SELECT trans.trans_no, trans.reference,	trans.tran_date, trans.due_date, debtor.debtor_no, debtor.name, branch.br_name, debtor.curr_code,(trans.ov_amount + trans.ov_gst + trans.ov_freight + trans.ov_freight_tax + trans.ov_discount)	AS total, (trans.ov_amount + trans.ov_gst + trans.ov_freight + trans.ov_freight_tax + trans.ov_discount - trans.alloc) AS remainder, DATEDIFF('$today', trans.due_date) AS days  FROM ".TB_PREF."debtor_trans as trans, ".TB_PREF."debtors_master as debtor,  ".TB_PREF."cust_branch as branch WHERE debtor.debtor_no = trans.debtor_no AND trans.branch_code = branch.branch_code AND trans.type = ".ST_SALESINVOICE." AND (trans.ov_amount + trans.ov_gst + trans.ov_freight + trans.ov_freight_tax + trans.ov_discount - trans.alloc) > ".FLOAT_COMP_DELTA." AND DATEDIFF('$today', trans.due_date) > 0 ORDER BY days DESC LIMIT 10";

		$val = db_query($sql);
		while($value = db_fetch($val)) { 
			$url = $path_to_root.'/sales/view/view_invoice.php?trans_no='.$value['trans_no'].'&trans_type=10"';
		?>
		<tr>
			<td><a href="<?=$url?>"><?=$value['trans_no']?></a></td>
			<td><?=$value['reference']?></td>
			<td><?=sql2date($value['tran_date'])?></td>
			<td><?=sql2date($value['due_date'])?></td>
			<td><?=getCustomerInfo($value['debtor_no'])['name']?></td>
			<td><?=getCustomerInfo($value['debtor_no'])['curr_code']?></td>
			<td><?=number_format($value['total'],2)?></td>
			<td><?=$value['remainder']?></td>
			<td><?=$value['days']?></td>
		</tr>
		<?php } ?>		
	</table>
	</div>
</div>
</div>

<script>
  $(function () {
    "use strict";
	var s_t = $('.s_t').html().replace(/,/g , "");
	var r_t = $('.r_t').html().replace(/,/g , "");
	var s_m = $('.s_m').html().replace(/,/g , "");
	var r_m = $('.r_m').html().replace(/,/g , "");
	var s_y = $('.s_y').html().replace(/,/g , "");
	var r_y = $('.r_y').html().replace(/,/g , "");

    //BAR CHART
    var bar = new Morris.Bar({
      element: 'bar-chart',
      resize: true,
      data: [
        {y: 'Todays',  a: s_t, b: r_t},
        {y: 'Monthly', a: s_m,  b: r_m},
        {y: 'Yearly',  a: s_y,  b: r_y},
      ],
      barColors: ['#00C0EF', '#ff7701'],
      xkey: 'y',
      ykeys: ['a', 'b'],
      labels: ['Sales', 'Return'],
      hideHover: 'auto'
    });


 	//DONUT CHART
 	var smtotal = $('.smtotal').html();
 	var chartData = [];
 	var chartcolor = [];
	var smname, smamount, c;
 	for (var i = 0; i < smtotal; i++) {
		smname = $('.smname'+i).html().replace(/,/g , "");
		smamount = $('.smamount'+i).html().replace(/,/g , "");
 		chartData.push({ label: smname , value: smamount });
 		chartcolor.push('#'+(0x1000000+(Math.random())*0xffffff).toString(16).substr(1,6));
 	}
    var donut = new Morris.Donut({
      element: 'salesman-chart',
      resize: true,
      colors: chartcolor,
      data: chartData,
      hideHover: 'auto'
    });

 	//DONUT CHART
 	var satotal = $('.satotal').html();
 	// console.log(satotal);
 	var chartData = [];
 	var chartcolor = [];
	var saname, saamount;
 	for (i = 0; i < satotal; i++) {
		saname = $('.saname'+i).html().replace(/,/g , "");
		saamount = $('.saamount'+i).html().replace(/,/g , "");
 		chartData.push({ label: saname , value: saamount });
 		chartcolor.push('#'+(0x1000000+(Math.random())*0xffffff).toString(16).substr(1,6));
 	}

    var donut = new Morris.Donut({
      element: 'salesarea-chart',
      resize: true,
      colors: chartcolor,
      data: chartData,
      hideHover: 'auto'
    });



	var prevSales0 = $('.prevSales0').html().replace(/,/g , "");
	var prevSales1 = $('.prevSales1').html().replace(/,/g , "");
	var prevSales2 = $('.prevSales2').html().replace(/,/g , "");
	var prevSales3 = $('.prevSales3').html().replace(/,/g , "");
	var prevSales4 = $('.prevSales4').html().replace(/,/g , "");
	var prevSales5 = $('.prevSales5').html().replace(/,/g , "");
	var prevSales6 = $('.prevSales6').html().replace(/,/g , "");
	var prevSales7 = $('.prevSales7').html().replace(/,/g , "");
	var prevSales8 = $('.prevSales8').html().replace(/,/g , "");
	var prevSales9 = $('.prevSales9').html().replace(/,/g , "");
	var prevSales10 = $('.prevSales10').html().replace(/,/g , "");
	var prevSales11 = $('.prevSales11').html().replace(/,/g , "");
	var currSales0 = $('.currSales0').html().replace(/,/g , "");
	var currSales1 = $('.currSales1').html().replace(/,/g , "");
	var currSales2 = $('.currSales2').html().replace(/,/g , "");
	var currSales3 = $('.currSales3').html().replace(/,/g , "");
	var currSales4 = $('.currSales4').html().replace(/,/g , "");
	var currSales5 = $('.currSales5').html().replace(/,/g , "");
	var currSales6 = $('.currSales6').html().replace(/,/g , "");
	var currSales7 = $('.currSales7').html().replace(/,/g , "");
	var currSales8 = $('.currSales8').html().replace(/,/g , "");
	var currSales9 = $('.currSales9').html().replace(/,/g , "");
	var currSales10 = $('.currSales10').html().replace(/,/g , "");
	var currSales11 = $('.currSales11').html().replace(/,/g , "");

	var cuurent_year = (new Date()).getFullYear();
	var previous_year = cuurent_year--;

    //BAR CHART
    var bar = new Morris.Bar({
      element: 'year-by-year-sales-chart',
      resize: true,
      data: [
		{ y: 'Jan', a: prevSales0  , b: currSales0   },
		{ y: 'Feb', a: prevSales1  , b: currSales1   },
		{ y: 'Mar', a: prevSales2  , b: currSales2   },
		{ y: 'Apr', a: prevSales3  , b: currSales3   },
		{ y: 'May', a: prevSales4  , b: currSales4   },
		{ y: 'Jun', a: prevSales5  , b: currSales5   },
		{ y: 'Jul', a: prevSales6  , b: currSales6   },
		{ y: 'Aug', a: prevSales7  , b: currSales7   },
		{ y: 'Sep', a: prevSales8  , b: currSales8   },
		{ y: 'Oct', a: prevSales9  , b: currSales9   },
		{ y: 'Nov', a: prevSales10 , b: currSales10  },
		{ y: 'Dec', a: prevSales11 , b: currSales11  },      	
      ],
      barColors: ['#00C0EF', '#ff7701'],
      xkey: ['y'],
      ykeys: ['a', 'b'],
      labels: [ cuurent_year, previous_year],
      hideHover: 'auto'
    });

  });
</script>
</script>