<?php
/*=======================================================\
|                        FrontHrm                        |
|--------------------------------------------------------|
|   Creator: Phương                                      |
|   Date :   09-Jul-2017                                 |
|   Description: Frontaccounting Payroll & Hrm Module    |
|   Free software under GNU GPL                          |
|                                                        |
\=======================================================*/

function add_salary_structure($pay_rules=array()) {

	if(empty($pay_rules))
		return false;

	begin_transaction();
    
		foreach($pay_rules as $rule)
			insert_structure($rule['salary_scale_id'], $rule['pay_rule_id'], $rule['pay_amount'], $rule['type']);

	commit_transaction();
}

//--------------------------------------------------------------------------
function get_salary_structure_max_id(){
	$sql = "SELECT MAX(salary_scale_id) From ".TB_PREF."salary_structure";
	$run= db_query($sql);
	// return $sql;
	return db_fetch($run)[0];
}
function insert_structure($salary_scale_id, $pay_rule_id,$pay_amount, $type) {
    // display_error('in');exit;
	$date_ = date2sql(Today());
	$sql = "INSERT INTO ".TB_PREF."salary_structure(date,salary_scale_id, pay_rule_id,pay_amount,type) VALUES ('"
	    .$date_."',"
	    .db_escape($salary_scale_id).","
	    .db_escape($pay_rule_id).","
	    .db_escape($pay_amount).","
	    .db_escape($type)
	.")";

	db_query($sql, _('could not add salary structure'));
	add_audit_trail(SA_HRMSALSTRUCTURE, get_salary_structure_max_id(), Today(),'Add Salary Structure');
}

//--------------------------------------------------------------------------

function exists_salary_structure($id) {

	return check_empty_result("SELECT id FROM ".TB_PREF."salary_structure WHERE salary_scale_id = ".db_escape($id)." AND !is_basic");
}

//--------------------------------------------------------------------------

function delete_salary_structure($salary_scale_id) {

	$sql = "DELETE FROM ".TB_PREF."salary_structure WHERE salary_scale_id =".db_escape($salary_scale_id)." AND !is_basic";
    db_query($sql, _('could not delete salary structure'));
    add_audit_trail(SA_HRMSALSTRUCTURE, $salary_scale_id, Today(),'Deleted Salary Structure');
}

//--------------------------------------------------------------------------

function get_salary_structure($salary_scale_id) {

	$sql = "SELECT st.*, ac.account_name FROM ".TB_PREF."salary_structure st, ".TB_PREF."chart_master ac WHERE ac.account_code = st.pay_rule_id AND st.salary_scale_id = ".db_escape($salary_scale_id);

  	return db_query($sql, _('Could not get salary structure'));
}

//--------------------------------------------------------------------------

function get_emp_salary_structure($emp_id) {

	$sql = "SELECT s.* FROM ".TB_PREF."salary_structure s, ".TB_PREF."employee e WHERE s.salary_scale_id = e.salary_scale_id AND e.emp_id = ".db_escape($emp_id);

	return db_query($sql, _('Could not get employee salary structure'));
}