<?php

// Link to printing single document with bulk report template file.
// Ex. label_cell(print_document_link($myrow['order_no'], _("Print")), $type);
// or display_note(print_document_link($order_no, _("Print this order")));
// You only need full parameter list for invoices/credit notes
function print_sal_dashboard_print($link_text, $link=true, $trans_type='', 
	$icon=false, $class='printlink', $id='',$from = '', $to = '', $stocklist= '', $ref='', $loc='' , $cust_id='', $order_no='', $order_view='',$dest=0 )
{


global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);
	switch ($trans_type)
	{
	
       case ST_SALESQUOTE :
			$rep = 850;
			$ar = array(
				'PARAM_0' => $dest,
			    'PARAM_1' => $trans_type,
				'PARAM_2' => $from, 
				'PARAM_3' => $to,
				'PARAM_4' => $stocklist,
				'PARAM_5' => $ref,
				'PARAM_6' => $loc,
				'PARAM_7' => $cust_id,
				'PARAM_8' => $order_no,
				'PARAM_9' => $order_view,
				'PARAM_10' => $def_orientation);
			break;

	   case ST_SALESORDER :
			$rep = 850;
			$ar = array(
				'PARAM_0' => $dest,
			    'PARAM_1' => $trans_type,
				'PARAM_2' => $from, 
				'PARAM_3' => $to,
				'PARAM_4' => $stocklist,
				'PARAM_5' => $ref,
				'PARAM_6' => $loc,
				'PARAM_7' => $cust_id,
				'PARAM_8' => $order_no,
				'PARAM_9' => $order_view,
				'PARAM_10' => $def_orientation);
			break;
     //---------------------------------------------------------
	

	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}


//------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------

//zeeshan-------------------------------------------------------------------------------------------------------------------
function print_cust_inq_dashboard_print($doc_no, $link_text, $link=true, $trans_type='', 
	$icon=false, $class='printlink', $id='',$from='', $to= '', $cust_id='', $filter='', $destination=0 )
{

global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case CUSTINQ :
			$rep = 851;
			$ar = array(
			    'PARAM_0' => $trans_type,
				'PARAM_1' => $from, 
				'PARAM_2' => $to,
				'PARAM_3' => $cust_id,
				'PARAM_4' => $filter,
				'PARAM_5' => $destination,
				'PARAM_6' => $def_orientation);
			break;

 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}
//------------------------------------------------------------------------------------------------------------------------


//--------------------zeeshan------------------------------------------------------------------------------
function print_pur_dashboard_print($dest=0, $link_text, $also_closed=false, $link=true, $trans_type='', 
	$icon=false, $class='printlink', $id='',$from='', $to= '', $supplier_id='', $stocklocation='', $order_no='',
	$stocklist='')
{


global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case PURINQ :
			$rep = 950;
			$ar = array(
                'PARAM_0' => $dest,
                'PARAM_1' => $also_closed,
			    'PARAM_2' => $trans_type,
                'PARAM_3' => $from, 
                'PARAM_4' => $to,
                'PARAM_5' => $stocklist,
                'PARAM_6' => $supplier_id,
                'PARAM_7' => $stocklocation,
                'PARAM_8' => $order_no,
                'PARAM_9' => $def_orientation);
			break;
		
		case ST_LOCTRANSFER :
			case ST_INVADJUST :
			
			$rep = 953;
			$ar = array(
                'PARAM_0' => $dest,  
                'PARAM_1' => $also_closed, // from location 
			    'PARAM_2' => $trans_type,   //  filter type
                'PARAM_3' => $from,   // from date
                'PARAM_4' => $to,    // todate 
                'PARAM_5' => $supplier_id,  //  items
                'PARAM_6' => $stocklocation,  // to location 
                'PARAM_7' => $order_no,   // order no
                'PARAM_8' => $order_no,
                'PARAM_9' => $def_orientation
            );
			break;

 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}

//zeeshan------------------------------------------------------------------------------------------------------------------------
function print_supp_alloc_dashboard_print($dest=0, $link_text, $link=true, $trans_type='', 
	$icon=false, $class='', $id='',$frm='', $to= '', $filter='', $supp_id='', $show_settled='' )
{
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case SUPPALLOC :
			$rep = 952;
			$ar = array(
                'PARAM_0' => $show_settled,
                'PARAM_1' => $filter,
                'PARAM_2' => $dest,
			    'PARAM_3' => $trans_type,
                'PARAM_4' => $frm, 
                'PARAM_5' => $to,
                'PARAM_6' => $supp_id,
                'PARAM_7' => $def_orientation);
				
					break;
 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}


//zeeshan------------------------------------------------------------------------------------------------------------------------


function print_pur_supp_inq_dashboard_print($doc_no, $link_text, $link=true, $trans_type='', 
	$icon=false, $class='printlink', $id='',$from='', $to= '', $supplier_id='', $filter, $destination=0 )
{


global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case SUPINQ :
			$rep = 951;
			$ar = array(
			    'PARAM_0' => $trans_type,
                'PARAM_1' => $from, 
                'PARAM_2' => $to,
                'PARAM_3' => $supplier_id,
                'PARAM_4' => $filter,
                'PARAM_5' => $destination,
                'PARAM_6' => $def_orientation);
			break;

 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}

//----------------------------------------------------------------------------------------------------------------------------

	


function print_stck_mov_dashboard_print($dest=0, $link_text, $link=true, $trans_type='', 
	$icon=false, $class='', $id='',$stock_id='', $aft_date= '', $bef_date='', $stock_loc='' , $type=0  )
{
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case ITEMMOV :
			$rep = 960;
			$ar = array(
                'PARAM_0' => $stock_loc,
                'PARAM_1' => $dest,
                'PARAM_2' => $trans_type,
                'PARAM_3' => $aft_date,
			    'PARAM_4' => $bef_date,
                'PARAM_5' => $stock_id, 
                'PARAM_6' => $def_orientation,
                'PARAM_7' => $trans_type
                );
				
					break;
		 case FIXEDMOV :
			$rep = 960;
			$ar = array(
                'PARAM_0' => $stock_loc,
                'PARAM_1' => $dest,
                'PARAM_2' => $trans_type,
                'PARAM_3' => $aft_date,
			    'PARAM_4' => $bef_date,
                'PARAM_5' => $stock_id, 
                'PARAM_6' => $def_orientation,
                'PARAM_7' => $trans_type
                );
				
					break;
					
 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}

//-------------------------------------------------------------------------------------------------------------------

function print_stck_stat_dashboard_print($dest=0, $link_text, $link=true, $trans_type='', 
	$icon=false, $class='', $id='',$stock_id='' )
{
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");
	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case ITEMSTAT :
			$rep = 961;
			$ar = array(
                'PARAM_0' => $stock_id,
                'PARAM_1' => $dest,
                'PARAM_2' => $trans_type,
                'PARAM_3' => $def_orientation);
				
					break;
 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}



//-----------------------------------------------------------------------------------------------------------------------

function print_journal_inquiry_dashboard_print($dest=0, $reference=0, $link_text, $link=true, $trans_type='', 
	$icon=false, $class='', $id='', $filter='', $from, $to,  $memo, $also_closed, $user_id='' )

{
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");
	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
		
       case JOURINQ :
			$rep = 970;
			$ar = array(
                'PARAM_0' => $reference,
                'PARAM_1' => $user_id,
                'PARAM_2' => $also_closed,
                'PARAM_3' => $dest,
                'PARAM_4' => $trans_type,
                'PARAM_5' => $filter,
                'PARAM_6' => $from,
                'PARAM_7' => $to,
                'PARAM_8' => $memo,
				'PARAM_9' => $def_orientation);
				
					break;
 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}


//------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------


function print_account_inquiry_dashboard_print($dest=0, $link_text, $link=true, $trans_type='', 
	$icon=false, $class='', $id='', $fromdate, $todate, $trans_no=0, $account, $dimension1, $dimension2, $amount_min=0, $amount_max=0 )

{
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");
	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
		
       case BANKINQ :
			$rep = 971;
			// from, to, currency, email, comments, orientation
			$ar = array(
                'PARAM_0' => $account,
                'PARAM_1' => $dest,
                'PARAM_2' => $fromdate,
                'PARAM_3' => $todate,
                'PARAM_4' => $trans_no,
                'PARAM_5' => $dimension1,
                'PARAM_6' => $dimension2,
                'PARAM_7' => $amount_min,
                'PARAM_8' => $amount_max,         
				'PARAM_9' => $def_orientation);
				
				break;
 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}


//------------------------------------------------------------------------------------------------------------------------


function print_bank_dashboard_print($dest=0, $bank_acc, $link_text, $link=true, $trans_type=0, 
	$icon=false, $class='printlink', $id='',$from = '', $to = '')
{


global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);


	switch ($trans_type)
	{
       case BNKINQ :
			$rep = 972;
			$ar = array(
				'PARAM_0' => $dest,
				'PARAM_1' => $from, 
				'PARAM_2' => $to,
				'PARAM_3' => $bank_acc,
			    'PARAM_4' => $trans_type,
				'PARAM_5' => $def_orientation);
			break;

}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}


//-----------------------zeeshan---------------------------------------------------------------------------------------





function print_tax_dashboard_print($dest=0, $link_text, $link=true, $trans_type=0, 
	$icon=false, $class='printlink', $id='',$from = '', $to = '')
{


global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);
// display_error($to);

// display_error($from.'   '.$to);

	switch ($trans_type)
	{
       case TAXINQ :
			$rep = 973;
			$ar = array(
				'PARAM_0' => $dest,
				'PARAM_1' => $from, 
				'PARAM_2' => $to,
			    'PARAM_3' => $trans_type,
				'PARAM_4' => $def_orientation);
			break;

}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}


//------------------------------------------------------------------------------------------------------------------------

// function pprint_tax_dashboard_print($dest=0, $link_text, $link=true, $trans_type=0, 
// 	$icon=false, $class='printlink', $id='',$dimension1 = '', $dimension2 = '', $from='', $to, $balance)
// {


// global $path_to_root;
// 	include_once($path_to_root . "/includes/types.inc");

// 	$url = $path_to_root.'/reporting/prn_redirect.php?';
// 	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);
// // display_error($to);

// display_error($balance);

// 	switch ($trans_type)
// 	{
//        case TRIALINQ :
// 			$rep = 974;
// 			$ar = array(
// 				'PARAM_0' => $dest,
// 				'PARAM_1' => $from, 
// 				'PARAM_2' => $to,
// 			    'PARAM_3' => $trans_type,
// 			    'PARAM_4' => $dimension1,
// 			    'PARAM_5' => $dimension2,
// 			    'PARAM_6' => $balance,
// 			    'PARAM_7' => $def_orientation);
// 			break;

// }
// return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
// }
//-------------------------------------------------------------------------------------------


function print_dim_dashboard_print($dest=0, $opencheck=0, $duecheck=0, $link_text, $link=true, $trans_type=0, 
	$icon=false, $class='printlink', $id='',$from = '', $to = '', $order_no='', $type_)
{

global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case DIMINQ :
			$rep = 980;
			$ar = array(
				'PARAM_0' => $dest,
				'PARAM_1' => $from, 
				'PARAM_2' => $to,
			    'PARAM_3' => $trans_type,
			    'PARAM_4' => $order_no,
			    'PARAM_5' => $type_,
			    'PARAM_6' => @$open_only,
			    'PARAM_7' => @$due_only,
			    'PARAM_8' => @$def_orientation);

			break;

}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}
//----------------------------------------------------------------------------------------------------------------

function print_used_dashboard_print($dest=0, $link_text, $link=true, $trans_type=0, 
	$icon=false, $class='printlink', $id='', $stock_id)
{

global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case USEDINQ :
			$rep = 990;
			$ar = array(
				'PARAM_0' => $dest,
				'PARAM_1' => $stock_id,
			    'PARAM_2' => $def_orientation);

			break;

}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}

//----------------------------------------------------------------------------------------------------------







function print_document_link($doc_no, $link_text, $link=true, $type_no, 
	$icon=false, $class='printlink', $id='', $email=0, $extra=0, $size='A4')
{
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");
 
	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);
	switch ($type_no)
	{
	

	         
	case ST_BAR_CODE :
    case ST_QR_CODE  :

			$rep = 3033;
			// from, to, email, comments, orientation
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => $type_no, 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => '', 
				'PARAM_6' => ($rep == 3033 || $rep == 1071 ) ? '' : $def_orientation);
			if ($rep == 3033 || $rep == 1071 )
				$ar['PARAM_7'] = $def_orientation;
			break;

		
	        case ST_SALESINVOICE1 :
			$rep = 19099;
			$ar = array(
				'PARAM_0' => $doc_no,
				'PARAM_1' => $doc_no,
				'PARAM_2' => '',
				'PARAM_3' => $email,
				'PARAM_4' => 0,
				'PARAM_5' => '',
				'PARAM_6' => $def_orientation);
			break;
	 
	
	
	
	
	
	
	
	
	
	
	
  case ST_SALESQUOTE :
		if($size=='A4')
			$rep = 111;

		if($size=='A5')
			$rep = 1111;

			// from, to, currency, email, comments, orientation
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => $def_orientation);
			break;

	case 850 :
			$rep = 850;
			// from, to, currency, email, comments, orientation
			$ar = array(
					'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => $def_orientation,
				'PARAM_6' => $view_mode, 
				'PARAM_7' => $stocklist, 
				'PARAM_8' => $orders_AD, 
				'PARAM_9' => $orders_TD, 
				'PARAM_10' => $orders_ref, 
				'PARAM_11' => $stock_loc,
				'PARAM_12' => $cust_id ,
				'PARAM_13' => $trans_type );



			break;

		case ST_SALESORDER :

		if($size=='A4')
			$rep = 109;
		
		if($size=='A5')
			$rep = 1091;

			// from, to, currency, email, quote, comments, orientation
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => 0, 
				'PARAM_5' => '',
				'PARAM_6' => $def_orientation);
			break;
		case ST_CUSTDELIVERY :
		if($size=='A4')
			$rep = 110;

		if($size=='A5')
			$rep = 1101;
			// from, to, email, packing slip, comments, orientation
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => $email,
				'PARAM_3' => $extra,
				'PARAM_4' => '',
				'PARAM_5' => $def_orientation);
			break;
		case ST_SALESINVOICE : // Sales Invoice
		case ST_CUSTCREDIT : // Customer Credit Note

		if($size=='A4')
			$rep = $type_no==ST_CUSTCREDIT ? 113 : 107;

		if($size=='A5')
			$rep = $type_no==ST_CUSTCREDIT ? 113 : 1071;

			// from, to, currency, email, paylink, comments, orientation
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => '', 
				'PARAM_6' => ($rep == 107 || $rep == 1071 ) ? '' : $def_orientation);
			if ($rep == 107 || $rep == 1071 )
				$ar['PARAM_7'] = $def_orientation;
			break;
		case ST_PURCHORDER :
			$rep = 209;
			// from, to, currency, email, comments, orientation
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => $def_orientation);
			break;


		 case ST_LOCTRANSFER : // Sales Invoice
		case ST_INVADJUST : // Customer Credit Note
		$rep = 1092;
		      	$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => 0, 
				'PARAM_5' => '',
				'PARAM_6' => $def_orientation);
			break;

		case ST_CUSTPAYMENT :
			// from, to, currency, comments, orientation
		if($size=='A4')
			$rep = 112;
		
		if($size=='A5')
			$rep = 1121;
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => '',
				'PARAM_4' => $def_orientation);
			break;
		case ST_SUPPAYMENT :
			$rep = 210;
			// from, to, currency, email, comments, orientation
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => $def_orientation);
			break;
		case ST_WORKORDER :
			$rep = 409;
			// from, to, email, comments, orientation
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => $email, 
				'PARAM_3' => '', 
				'PARAM_4' => $def_orientation);
			break;
		default:
			return null;
	}

	return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}
//
//	Universal link to any kind of report.
//
function print_link($link_text, $rep, $pars = array(), $dir = '', 
	$icon=false, $class='printlink', $id='')
{
	
	global $path_to_root, $SysPrefs;
    //      if($_SESSION['SysPrefs']->prefs['rep_style']=='NEW')
    // 	$url = $dir == '' ?  $path_to_root.'/reporting2/prn_redirect.php?' : $dir; 
    // else
	$url = $dir == '' ?  $path_to_root.'/reporting/prn_redirect.php?' : $dir;

	$id = default_focus($id);
	foreach($pars as $par => $val) {
		$pars[$par] = "$par=".urlencode($val);
	}
	$pars[] = 'REP_ID='.urlencode($rep);
	$url .= implode ('&', $pars);

	if ($class != '')
		$class = $SysPrefs->pdf_debug ? '' : " class='$class'";
	if ($id != '')
		$id = " id='$id'";
	$pars = access_string($link_text);
	if (user_graphic_links() && $icon)
		$pars[0] = set_icon($icon, $pars[0]);
	return "<a target='_blank' href='$url'$id$class $pars[1]>$pars[0]</a>";
}


//------------------------------------------------------------------------------------------------------------------------


function parse_notes_params($str, $sep=" ", $delim="#") {
    $str_params = explode($sep, $str);
    $param_array=Array('notes' => '');
    foreach ($str_params AS $str_param) {
        $param_set=explode($delim, trim($str_param));
        $key = (array_key_exists(0, $param_set) ? trim($param_set[0]) : '');
        $val = (array_key_exists(1, $param_set) ? trim($param_set[1]) : '');
        if (strlen($key) > 0 && strlen($val) > 0) {
            $param_array[$key]=$val;
        } else {
            // stop at first missing parameter set
            // break;
            // Collect the rest into notes
            $param_array['notes'] .= (" " .  $str_param);
        }
    }
    $param_array['notes'] = trim($param_array['notes']);
    return $param_array;
}
