<?php
$page_security = 'SA_PAYROLL_ALLOCTION';
$path_to_root="../../.."; 

include($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");

add_access_extensions();

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");

include($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/includes/banking.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/includes/db/manufacturing_db.inc");

include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_db.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_ui.inc');




$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

page(_($help_context = "Payroll Allocation Inquiry"), false, false, "", $js);

//-----------------------------------------------------------------------------------
// Ajax updates
//
if (get_post('SearchOrders'))
{
	$Ajax->activate('journal_tbl');
}
//--------------------------------------------------------------------------------------
if (!isset($_POST['filterType']))
	$_POST['filterType'] = -1;



div_start('_page_body');
start_form();

start_table(TABLESTYLE_NOBORDER);
start_row();

ref_cells(_("Reference:"), 'Ref', '',null, _('Enter reference fragment or leave empty'));


// $type_array=$arrayName = array('ST_BANKPAYMENT' =>  'payment' , 'ST_BANKTRANSFER'=> 'Payment transfer' );
journal_types_list_cells(_("Type:"), "filterType",null,true,2);
// hidden("filterType",'1');

date_cells(_("From:"), 'FromDate', '', null, 0, -1, 0);
date_cells(_("To:"), 'ToDate');

end_row();
start_row(2);
// ref_cells(_("Memo:"), 'Memo', '',null, _('Enter memo fragment or leave empty'));
// users_list_cells(_("User:"), 'userid', null, false);
// user_list_cells(_("User Person :"), 'userid', $_POST['userid'], true, false, _('Select'),0,'15,2,10');
employee_list_cells("Employee :", "EmpId", null, _('All employees'), true, false, get_post('DeptId'));

if (get_company_pref('use_dimension') && isset($_POST['dimension'])) // display dimension only, when started in dimension mode
	dimensions_list_cells(_('Dimension:'), 'dimension', null, true, null, true);
// check_cells( _("Show closed:"), 'AlsoClosed', null);



$trans_type=JOURINQ;
	 
	echo  "<td>". print_journal_inquiry_dashboard_print( 0, get_post('Ref'), _("<img src =".$path_to_root."/themes/".user_theme()."/images/".ICON_PRINT.">"), true, $trans_type, null,
		 '','', get_post('filterType', -1), get_post('FromDate'), get_post('ToDate'), 
		get_post('Memo'), check_value('AlsoClosed'), get_post('userid')    ) ."</td>"; 
	
	echo  "<td>". print_journal_inquiry_dashboard_print( 1, get_post('Ref'), _("<img  style='width: 20px;' src =".$path_to_root."/themes/".user_theme()."/images/excel.png>"), true, $trans_type, null, '','', 
		get_post('filterType', -1), get_post('FromDate'), get_post('ToDate'),  
		get_post('Memo'), check_value('AlsoClosed'), get_post('userid')    ) ."</td>"; 

// 	submit_cells('Search', _("Search"), '', '', 'default');
	submit_cells('SearchOrders', _("Search"),'',_('Refresh Inquiry'), 'default');



if (list_updated('userid') || get_post('Ref') || list_updated('filterType') )
   {	
$Ajax->activate('_page_body');
$Ajax->activate('journal_tbl');
refresh_pager('_page_body');


}
// zee start----------------------------------------------------------------------------------

end_row(2);
end_table();

function journal_pos($row)
{
	return $row['gl_seq'] ? $row['gl_seq'] : '-';
}

function systype_name($row)
{
	global $systypes_array;
	
   if($row['person_type_id']==6 && $row['advance_salary']==1)
   	return 'Employee Advance';
   elseif ($row['person_type_id']==7) 
   	return 'Payroll';
   elseif ($row['person_type_id']==6 ) {
   	   	return 'Employee PV';
   	# code...
   }

	// return $systypes_array[$type];
}

function prt_link($row)
{
  	if ($row['trans_type'] == ST_BANKPAYMENT) 
		return print_document_link($row['trans_no']."-".$row['trans_type']."-".$_POST['show_paid']."-".$_POST['show_stemp'], _("Print Receipt"), true, ST_BANKPAYMENT, ICON_PRINT);
  	
}

function view_link($row) 
{
	return viewer_link($row["trans_no"],"gl/view/gl_payment_view.php?trans_no=".$row["trans_no"]);
	// return get_trans_view_str($row["trans_type"], $row["trans_no"]);
}

function gl_link($row) 
{
	return get_gl_view_str($row["trans_type"], $row["trans_no"]);
}

function edit_link($row)
{
	global $path_to_root;
	$ok = true;
	if ($row['trans_type'] == ST_SALESINVOICE)
	{
		     if($row['alloc']>0)
		$myrow = get_customer_trans($row["trans_no"], $row["trans_type"]);
		if ($myrow['alloc'] != 0 || get_voided_entry(ST_SALESINVOICE, $row["trans_no"]) !== false)
			$ok = false;
	}

	// if ($ok) {
	// 	// echo "<pre>";
	// 	// print_r($row);
	// 	if ($row["person_type_id"] == 5) {
	// 		return $path_to_root."/gl/gl_bank_payment.php?ModifyPayment=Yes&trans_no=".$row["trans_no"]."&trans_type=".$row["trans_type"];
	// 	}else
	// 		return trans_editor_link( $row["trans_type"], $row["trans_no"]);
	// }else{
	// 	return '';
	// }
	if($row['alloc']>0)
      return '';
		else
	return $ok ? trans_editor_link( $row["trans_type"], $row["trans_no"], $row["person_type_id"]) : '';
}
function ApprovedBankPayment($id,$un_app=0)
{
	$val=($un_app)?0:1;
	$sql=" UPDATE ".TB_PREF."bank_trans SET approved='".$val."'  WHERE id=".db_escape($id);
	// display_error($sql);
	db_query($sql);

}

function get_memo($row)
{
		$comments = get_comments( $row["trans_type"], $row["trans_no"]);
		$comment = db_fetch($comments);
		return  nl2br($comment["memo_"]);

}
function get_emp_name($row){
		return ($row['person_id']) ? get_employees($row['person_id'])['name'] : '-';
}

function invoice_supp_reference($row)
{
	return $row['supp_reference'];
}

function alloc_link($row)
{
  
 //    $res=get_all_payroll_alloc_from($row["trans_type"],$row["trans_no"],1);
	// $alloc_row=db_fetch($res);
	// echo "<pre>";
	// print_r($row);
	// display_error($row["amount"]." != ".$row['alloc'] ."    ===  ".$row["t   qrans_no"]);
    if($row["amount"]!=$row['alloc'])
	$link = 
	pager_link(_("Payroll Allocation"),
		"/modules/FrontHrm/inquiry/payroll_allocate.php?trans_no=" . $row["trans_no"] 
		."&trans_type=" . $row["trans_type"]."&person_id=" . $row["person_id"]."&person_type_id=" . $row["person_type_id"], ICON_ALLOC);
       if($row["approved"])
	return $link;


}
function app_check_box($row)
{
	global $trans_type, $page_nested;

	// if ($row['person_type_id'] !=5 )
	// 	return '';

	// if ($page_nested)
	// 	return '';
	// display_error($row['bt_id']);
	$name = "_approved" .$row['bt_id'];
	$value = $row['approved'] ? 1:0;
	 if($row['approved']==1)
	 {

	 	$name = "_Un_approved" .$row['bt_id'];
	    $value = $row['approved'] ? 0:1;
	      if($row['alloc']>0)
         return "<span style='color:green;'> <strong>Approved</strong></span>";
	      	else
	    return checkbox(null, $name, $value, true,
	 	_('Set this order as a template for direct deliveries/invoices'))
		. hidden('last['.$row['bt_id'].']', $value, false)."<span style='color:green;'> <strong>Approved</strong></span>";
	 }

// save also in hidden field for testing during 'Update'

 return checkbox(null, $name, $value, true,
 	_('Set this order as a template for direct deliveries/invoices'))
	. hidden('last['.$row['bt_id'].']', $value, false)."<span style='color:red;'> Not Approved</span>";
}


$id = find_submit('_Un_approved');
if ($id != -1){
	ApprovedBankPayment($id,1);
	$Ajax->activate('journal_tbl');
display_notification(_("Payment has been Un-approved"));		
}

$id = find_submit('_approved');
if ($id != -1){
	// display_error($id);
	ApprovedBankPayment($id);
	$Ajax->activate('journal_tbl');
display_notification(_("Payment has been approved"));
		
}
// display_error(get_post('filterType'));
$sql = get_sql_for_payroll_allocation( get_post('filterType'), get_post('FromDate'),
	get_post('ToDate'), get_post('Ref'),'',$_POST['EmpId']);

$cols = array(
	_("Trans #") => array('fun'=>'view_link'), 
 	_("")=> 'skip', //=> array('ord' => ''),
	// _("#") => array('fun'=>'journal_pos', 'align'=>'center'), 
	_("Date") =>array('name'=>'tran_date','type'=>'date','ord'=>'desc'),
	_("Type") => array('fun'=>'systype_name'), 
	_("Supplier's Reference") => 'skip',
	_("Reference"), 
	_("Amount") => array('type'=>'amount'),
	_("Memo") => array('fun'=>'get_memo'),
	_("User")=> array('fun'=>'get_emp_name'),
	_("View") => array('insert'=>true, 'fun'=>'gl_link'),
	array('insert'=>true, 'fun'=>'edit_link'),
	array('insert'=>true, 'fun'=>'app_check_box'),
		array('insert'=>true, 'fun'=>'prt_link'),
		array('insert'=>true, 'fun'=>'alloc_link')

);

if (!check_value('AlsoClosed')) {
	$cols[_("#")] = 'skip';
}

if($_POST['filterType'] == ST_SUPPINVOICE) //add the payment column if shown supplier invoices only
{
	$cols[_("Supplier's Reference")] = array('fun'=>'invoice_supp_reference', 'align'=>'center');
}

$table =& new_db_pager('journal_tbl', $sql, $cols);

$table->width = "80%";

display_db_pager($table);

end_form();
div_end();
end_page();