<?php
/*=======================================================\
|                        FrontHrm                        |
|--------------------------------------------------------|
|   Creator: Phương                                      |
|   Date :   09-Jul-2017                                 |
|   Description: Frontaccounting Payroll & Hrm Module    |
|   Free software under GNU GPL                          |
|                                                        |
\=======================================================*/

$page_security = 'SA_HRMATTENDANCE';
$path_to_root  = '../../..';

include_once($path_to_root . '/includes/session.inc');
add_access_extensions();

$js = '';
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

include_once($path_to_root . '/includes/ui.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_db.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_ui.inc');

//--------------------------------------------------------------------------

function can_process() {

	if(!is_date($_POST['from_date'])) {
		display_error(_('The entered date is invalid.'));
		set_focus('from_date');
		return false;
	}
	elseif(!is_date($_POST['to_date'])) {
		display_error(_('The entered date is invalid.'));
		set_focus('to_date');
		return false;
	}
	elseif(date_comp($_POST['from_date'], Today()) > 0) {

		display_error(_('Cannot make attendance for the date in the future.'));
		set_focus('from_date');
		return false;
	}
	elseif(date_comp($_POST['to_date'], Today()) > 0) {

		display_error(_('Cannot make attendance for the date in the future.'));
		set_focus('to_date');
		return false;
	}
	
	elseif (check_weekend(date('l', strtotime(date2sql($_POST['to_date']))))) {

			display_error(_('The selected  date is weekend. can not add attendance.'));
            	set_focus('to_date');
			# code...
		}
	elseif (check_holiday(date2sql($_POST['to_date']))) {
			display_error(_('The selected  date is holidy. can not add attendance.'));
            	set_focus('to_date');
		    # code...
	}
	foreach(db_query(get_employees(false, false, get_post('DeptId'))) as $emp) {
		
		if(strlen($_POST[$emp['emp_id'].'-0']) != 0 && (!preg_match("/^(?(?=\d{2})(?:2[0-3]|[01][0-9])|[0-9]):[0-5][0-9]$/", $_POST[$emp['emp_id'].'-0']) && (!is_numeric($_POST[$emp['emp_id'].'-0']) || $_POST[$emp['emp_id'].'-0'] >= 24))) {
			display_error(_('Attendance input data must be less than 24 hours and formatted in <b>HH:MM</b> or <b>Integer</b>, example - 02:25 , 2:25, 8, 23:59 ...'));
			set_focus($emp['emp_id'].'-0');
			return false;
		}
		foreach(db_query(get_overtime()) as $ot) {
			
			if(strlen($_POST[$emp['emp_id'].'-'.$ot['overtime_id']]) != 0 && (!preg_match("/^(?(?=\d{2})(?:2[0-3]|[01][0-9])|[0-9]):[0-5][0-9]$/", $_POST[$emp['emp_id'].'-'.$ot['overtime_id']]) && (!is_numeric($_POST[$emp['emp_id'].'-'.$ot['overtime_id']]) || $_POST[$emp['emp_id'].'-'.$ot['overtime_id']] >= 24))) {
				
				display_error(_('Attendance input data must be less than 24 hours and formatted in <b>HH:MM</b> or <b>Integer</b>, example - 02:25 , 2:25, 8, 23:59 ...'));
				set_focus($emp['emp_id'].'-'.$ot['overtime_id']);
				return false;
			}
		}
	}
	return true;
}

function write_attendance_range($emp_id, $time_type, $value, $rate, $from, $to,$time_in='',$time_out='') {

// display_error($from." - ".$to."   ==   ".$emp_id );
	// $from = date2sql($from);
	// $to = date2sql($to);
	// $begin = new DateTime($from);
	// $end = new DateTime($to);
	// $end = $end->modify('+1 day');
	// $interval = DateInterval::createFromDateString('1 day');

	// 	// display_error($begin."  =  ".$end."  = ".$interval);

	// $period = new DatePeriod($begin, $interval, $end);

	// foreach ($period as $dt) {
		// $day = $dt->format("Y-m-d");
		// $day = sql2date($day);
		$day = $to;
		// display_error($time_in ." ".$time_out ." ".$emp_id);
		if($time_type==0)
		{

	   $time_in=  ($time_in) ? date2sql($day)." ". date("H:i:s",strtotime($time_in)) : '';
       $time_out= ($time_out)? date2sql($day)." ". date("H:i:s",strtotime($time_out)) : '';
           // display_error($time_in."  ===-- ".$time_out);
        // display_error($time_in ." ".$emp_id." ".$time_type);
        // display_error($time_out." ".$emp_id." ".$time_type);
		}
		write_attendance_all($emp_id, $time_type, $value, $rate, $day,0,$time_in,$time_out);
	// }
}

function check_paid_in_range($emp_id, $from, $to) {

	$from = date2sql($from);
	$to = date2sql($to);
	$begin = new DateTime($from);
	$end = new DateTime($to);
	$end = $end->modify('+1 day');
	$interval = DateInterval::createFromDateString('1 day');
	$period = new DatePeriod($begin, $interval, $end);

	foreach ($period as $dt) {
		$day = $dt->format("Y-m-d");
		$day = sql2date($day);
		// display_error($dt->format("m")." - ".$dt->format("Y"));
		 if(check_payslip($emp_id,$dt->format("m"),$dt->format("Y")))                  //if(check_date_paid($emp_id, 
			return true;
	}
	return false;
}

//--------------------------------------------------------------------------

page(_($help_context = 'Employees Attendance'), false, false, '', $js);

start_form();



//--------------------------------------------------------------------------

if(!db_has_employee())
	display_error(_('There are no employees for attendance.'));

if(isset($_POST['addatt'])) {

	$employees = db_query(get_employees(false, false, get_post('DeptId')));
$emp_ids = array();

$k = 0;
foreach ($employees as $emp) {
	$emp_ids[$k] = $emp['emp_id'];
	$k++;
}

$overtimes = db_query(get_overtime());

$overtime_id    = array();
$k=0;
while($overtime = db_fetch($overtimes)) {
    $remaining_cols[$k] = $overtime['overtime_name'];
    $overtime_id[$k] = $overtime['overtime_id'];
    $k++;
}

#form  date and to_date is balance ;
$_POST['from_date']=$_POST['to_date'];	

	if(!can_process())
		return;
    
    $att_items = 0;
    foreach($emp_ids as $emp_id) {
        
        // display_error($_POST['from_date']." 0" $_POST['to_date']);
		if($_POST['time_in-'.$emp_id] && check_payslip($emp_id,date('m',strtotime(date2sql($_POST['to_date']))), get_selected_years_to_id(date('Y',strtotime(date2sql($_POST['to_date'])))) )  ) {
			
			display_error(_('The selected  date  has been process payslip. can not add attendance for Employee ').$emp_id);
            	set_focus('time_in-'.$emp_id);
			// exit();
		}
		elseif (check_leave($emp_id,date2sql($_POST['to_date']))){

        	display_error(_('The selected  date  has been leave mark. can not add attendance for Employee ').$emp_id);
            	set_focus('time_in-'.$emp_id);

			# code...
		}

		else {
			// display_error($_POST['time_in-'.$emp_id]." - ".$emp_id);
			if(strlen($_POST['time_in-'.$emp_id]) > 0)
			{
                $att_items ++;
			// display_error($_POST['from_date']." == ". $_POST['to_date']." == ".$emp_id);
                // display_error(time_to_float($Work_hours)." = ".$Work_hours);
			write_attendance_range($emp_id, 0, time_to_float($Work_hours), 1, $_POST['from_date'], $_POST['to_date'],$_POST['time_in-'.$emp_id],$_POST['time_out-'.$emp_id]);
			}
		}
        
        foreach($overtime_id as $ot) {
		 // check_date_paid($emp_id, $_POST['from_date'])
			if($_POST[$emp_id.'-0'] && 	check_payslip($emp_id,date('m',strtotime(date2sql($_POST['to_date']))),get_selected_years_to_id(date('Y',strtotime(date2sql($_POST['to_date'])))) )) { 
			
				display_error(_('The selected  date  has been process payslip . can not add overtime for Employee ').$emp_id);
            	set_focus($emp_id.'-'.$ot);
				// exit();
			}
			else {
				// $rate = get_overtime($ot)['overtime_rate'];

				 $rate = get_ot_weekend(date('l', strtotime(date2sql($_POST['to_date']))))['ot_factor'];

				if(strlen($_POST[$emp_id.'-0']) > 0)
				    {$att_items ++;
				// display_error($_POST[$emp_id.'-0']."  == ".$emp_id);
				write_attendance_range($emp_id, 1, time_to_float($_POST[$emp_id.'-0']), $rate, $_POST['from_date'], $_POST['to_date']);
		            }
			}
        }
    }
	if($att_items > 0)
		display_notification(_('Attendance has been saved.'));
	else
		display_notification(_('Nothing attendance saved'));
	$Ajax->activate('_page_body');
}



























start_table(TABLESTYLE_NOBORDER);
start_row();
// date_cells(_('From').':', 'from_date', _('Attendance date begin'));
// date_cells(_('To').':', 'to_date', _('Aattendance date end'));
date_cells(_('To Date').':', 'to_date', _('Aattendance '));

// department_list_cells(_('For department').':', 'DeptId', null, _('All departments'), true);
$ot_row=get_ot_weekend(date('l', strtotime(date2sql($_POST['to_date']))));
label_cells(_("OT Factor"),$ot_row['ot_factor']);

submit_cells('bulk', _('Bulk'), '', _('Record all as regular work'), true);


submit_cells('search', _('Search'), '', _('Search All Records'), true);

// display_error(date('m',strtotime(date2sql($_POST['to_date']))));

end_row();
end_table(1);

start_table(TABLESTYLE2);
$initial_cols = array('ID', _('Employee'), _('check In'), _('check Out'));
$overtimes = db_query(get_overtime());
$remaining_cols = array();
$overtime_id    = array();
$k=0;
while($overtime = db_fetch($overtimes)) {
    $remaining_cols[$k] = $overtime['overtime_name'];
    $overtime_id[$k] = $overtime['overtime_id'];
    $k++;
}

$th = array_merge($initial_cols, $remaining_cols);
$employees = db_query(get_employees(false, false, get_post('DeptId')));
$emp_ids = array();

$k = 0;
foreach ($employees as $emp) {
	$emp_ids[$k] = $emp['emp_id'];
	$k++;
}

if(isset($_POST['bulk'])) {
	foreach($emp_ids as $emp_id) {

    $_POST['time_in-'.$emp_id]=  '09:00';
    $_POST['time_out-'.$emp_id]=   '17:00';


		// if(get_post($emp_id) == 1)
		//     $_POST[$emp_id.'-0'] = $Work_hours;
		// else
		// 	$_POST[$emp_id.'-0'] = '';
	}
	$Ajax->activate('_page_body');
}


if(isset($_POST['search'])) {
   #refrress all records
	foreach($emp_ids as $emp_id) {

unset($_POST['time_in-'.$emp_id]);
unset($_POST['time_out-'.$emp_id]);
unset($_POST[$emp_id.'-0']);
    
}


 unset($row_in);
      unset($ot_row);

	global $Ajax;
	$Ajax->activate('_page_body');
}




table_header($th);

foreach($employees as $employee) {
    
    start_row();
    // checkbox(null, $employee['emp_id'], isset($_POST[$employee['emp_id']]) ? $_POST[$employee['emp_id']] : 1)
    label_cell($employee['emp_id']);
    label_cell($employee['name']);
    // $name1 = $employee['emp_id'].'-0';
    // text_cells(null, $name1, null, 10, 10);
      // display_error($_POST['time_in-'.$employee['emp_id']]." == ".$employee['emp_id']);

    	$row_in=get_attended($employee['emp_id'], 0, $_POST['to_date']);
        // print_r($row_in);

      if($row_in)
      {
      	// display_error($row_in['t_in']."  == ".$employee['emp_id']);
      	$_POST['time_in-'.$employee['emp_id']]=$row_in['t_in'];
      	$_POST['time_out-'.$employee['emp_id']]=$row_in['t_out'];
      }

      $time_in_name='time_in-'.$employee['emp_id'];
      $time_out_name='time_out-'.$employee['emp_id'];

      // display_error();
      	$month_no = date('n',strtotime(date2sql($_POST['to_date'])));
      		$to_date = date2sql($_POST['to_date']);
      if(check_leave($employee['emp_id'],date2sql($_POST['to_date'])))
      {
      	label_cell('<spam style="color:red;"> UPL<spam>');
      	label_cell('<spam style="color:red;"> UPL<spam>');
      	      	label_cell('<spam style="color:red;"> UPL<spam>');

      }
      elseif (check_payslip($employee['emp_id'],$month_no,get_selected_years_to_id(date("Y", strtotime($to_date))) )) {

      	      	label_cell('<spam style="color:green;"> Payslip processed<spam>');
      	label_cell('<spam style="color:green;"> Payslip processed<spam>');
      	      	label_cell('<spam style="color:green;"> Payslip processed<spam>');
       	# code...
       } 
      elseif (check_weekend(date('l', strtotime(date2sql($_POST['to_date']))))) {

      	      	label_cell('<spam style="color:red;"> WE<spam>');
      	label_cell('<spam style="color:red;"> WE<spam>');
				 $i=0;
					    while($i < count($remaining_cols)) {
					    	$ot_row=get_attended($employee['emp_id'], 1, $_POST['to_date']);
					    	if($ot_row){
					    	  $_POST[$employee['emp_id'].'-0']=$ot_row['hours_no'];	
					    	}
					        $name2 = $employee['emp_id'].'-0'; //.$overtime_id[$i];
					        text_cells(null, $name2, null, 10, 10);
					        $i++;
				      }      	# code...
      }
      elseif (check_holiday(date2sql($_POST['to_date']))) {
      	label_cell('<spam style="color:red;"> Holiday<spam>');
      	label_cell('<spam style="color:red;"> Holiday<spam>');
				 $i=0;
					    while($i < count($remaining_cols)) {
					    	$ot_row=get_attended($employee['emp_id'], 1, $_POST['to_date']);
					    	if($ot_row){
					    	  $_POST[$employee['emp_id'].'-0']=$ot_row['hours_no'];	
					    	}
					        $name2 = $employee['emp_id'].'-0'; //.$overtime_id[$i];
					        text_cells(null, $name2, null, 10, 10);
					        $i++;
				      }
      	# code...
      }
      else
      {

    label_cell('<input type="time" name='.$time_in_name.' class=" searchbox form-control"
	  value="'.$_POST['time_in-'.$employee['emp_id']].'">');
	label_cell('<input type="time" name='.$time_out_name.' class=" searchbox form-control"
	  value="'.$_POST['time_out-'.$employee['emp_id']].'">');
	    $i=0;
	    while($i < count($remaining_cols)) {
	    	$ot_row=get_attended($employee['emp_id'], 1, $_POST['to_date']);
	    	if($ot_row){
	    	  $_POST[$employee['emp_id'].'-0']=$ot_row['hours_no'];	
	    	}
	        $name2 = $employee['emp_id'].'-0'; //.$overtime_id[$i];
	        text_cells(null, $name2, null, 10, 10);
	        $i++;
      }
      unset($row_in);
    
    }
    end_row();
}

end_table(1);
    
submit_center('addatt', _('Save attendance'), true, '', 'default');


end_form();
end_page();
