<?php
/*=======================================================\
|                        FrontHrm                        |
|--------------------------------------------------------|
|   Creator: Phương                                      |
|   Date :   09-Jul-2017                                 |
|   Description: Frontaccounting Payroll & Hrm Module    |
|   Free software under GNU GPL                          |
|                                                        |
\=======================================================*/

$page_security = 'SA_HRMATTENDANCE_CHECK_IN';
$path_to_root  = '../../..';

include_once($path_to_root . '/includes/session.inc');
add_access_extensions();

$page_security = 'SA_HRMATTENDANCE_CHECK_IN';

include_once($path_to_root . '/includes/ui.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_db.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_ui.inc');
$js = "";
if ($SysPrefs->use_popup_windows) {
	$js .= get_js_open_window(900, 500);
}
if (user_use_date_picker()) {
	$js .= get_js_date_picker();
}
page(_($help_context = 'Employees Attendance'), false, false, "", $js);


//--------------------------------------------------------------------------

function can_process() {

	if(!is_date($_POST['from_date'])) {
		display_error(_('The entered date is invalid.'));
		set_focus('from_date');
		return false;
	}
	elseif(!is_date($_POST['to_date'])) {
		display_error(_('The entered date is invalid.'));
		set_focus('to_date');
		return false;
	}
	elseif(date_comp($_POST['from_date'], Today()) > 0) {

		display_error(_('Cannot make attendance for the date in the future.'));
		set_focus('from_date');
		return false;
	}
	elseif(date_comp($_POST['to_date'], Today()) > 0) {

		display_error(_('Cannot make attendance for the date in the future.'));
		set_focus('to_date');
		return false;
	}
	
	// foreach(db_query(get_employees(false, false, get_post('DeptId'))) as $emp) {
		
	// 	if(strlen($_POST[$emp['emp_id'].'-0']) != 0 && (!preg_match("/^(?(?=\d{2})(?:2[0-3]|[01][0-9])|[0-9]):[0-5][0-9]$/", $_POST[$emp['emp_id'].'-0']) && (!is_numeric($_POST[$emp['emp_id'].'-0']) || $_POST[$emp['emp_id'].'-0'] >= 24))) {
	// 		display_error(_('Attendance input data must be less than 24 hours and formatted in <b>HH:MM</b> or <b>Integer</b>, example - 02:25 , 2:25, 8, 23:59 ...'));
	// 		set_focus($emp['emp_id'].'-0');
	// 		return false;
	// 	}
	// 	// foreach(db_query(get_overtime()) as $ot) {
			
	// 	// 	if(strlen($_POST[$emp['emp_id'].'-'.$ot['overtime_id']]) != 0 && (!preg_match("/^(?(?=\d{2})(?:2[0-3]|[01][0-9])|[0-9]):[0-5][0-9]$/", $_POST[$emp['emp_id'].'-'.$ot['overtime_id']]) && (!is_numeric($_POST[$emp['emp_id'].'-'.$ot['overtime_id']]) || $_POST[$emp['emp_id'].'-'.$ot['overtime_id']] >= 24))) {
				
	// 	// 		display_error(_('Attendance input data must be less than 24 hours and formatted in <b>HH:MM</b> or <b>Integer</b>, example - 02:25 , 2:25, 8, 23:59 ...'));
	// 	// 		set_focus($emp['emp_id'].'-'.$ot['overtime_id']);
	// 	// 		return false;
	// 	// 	}
	// 	// }
	// }
	return true;
}

function write_attendance_range($emp_id, $time_type, $value, $rate, $from, $to,$in_out) {

	$from = date2sql($from);
	$to = date2sql($to);
	$begin = new DateTime($from);
	$end = new DateTime($to);
	$end = $end->modify('+1 day');
	$interval = DateInterval::createFromDateString('1 day');
	$period = new DatePeriod($begin, $interval, $end);
	foreach ($period as $dt) {
		$day = $dt->format("Y-m-d");
		$day = sql2date($day);
		write_attendance($emp_id, $time_type, $value, $rate, $day,$in_out);
	}
}

function check_paid_in_range($emp_id, $from, $to) {

	$from = date2sql($from);
	$to = date2sql($to);
	$begin = new DateTime($from);
	$end = new DateTime($to);
	$end = $end->modify('+1 day');
	$interval = DateInterval::createFromDateString('1 day');
	$period = new DatePeriod($begin, $interval, $end);

	foreach ($period as $dt) {
		$day = $dt->format("Y-m-d");
		$day = sql2date($day);
		if(check_date_paid($emp_id, $day))
			return true;
	}
	return false;
}


// display_error($_POST['check_in']."   ===   ".$_POST['check_out']);
if($_POST['check_in']!=null || $_POST['check_out']!=null) {
	
	if(!can_process())
		return;
    
    $employees = db_query(get_employees(false, false, get_post('DeptId'),$_SESSION['wa_current_user']->user));
    
$emp_ids = array();

$k = 0;
foreach ($employees as $emp) {
	$emp_ids[$k] = $emp['emp_id'];
	$k++;
}
    $att_items = 0;

    foreach($emp_ids as $emp_id) {

    	// display_error($emp_id);
         $_POST['to_date']= $_POST['from_date'];  // from date is current

    	if(get_post($emp_id) == 1)
		    $_POST[$emp_id.'-0'] = $Work_hours;
		else
			$_POST[$emp_id.'-0'] = '';
        
		if($_POST[$emp_id.'-0'] &&  check_payslip($emp_id,date('m',strtotime(date2sql($_POST['to_date']))), get_selected_years_to_id(date('Y',strtotime(date2sql($_POST['to_date'])))) )) {
			
			display_error(_('The selected date range includes a date that has been approved, cannot be updated.'));
            set_focus('from_date');
			exit();
		}
		else {
			if(strlen($_POST[$emp_id.'-0']) > 0)
                $att_items ++;
			// display_error('in');
			write_attendance_range($emp_id, 0, time_to_float($_POST[$emp_id.'-0']), 1, $_POST['from_date'], $_POST['to_date'],(@$_POST['check_in']) ? 1 : 2);
		}
        
   //      foreach($overtime_id as $ot) {
			
			// if($_POST[$emp_id.'-0'] && check_date_paid($emp_id, $_POST['from_date'])){
			
			// 	display_error(_('Selected date has already paid for Employee ').$emp_id);
   //          	set_focus($emp_id.'-'.$ot);
			// 	exit();
			// }
			// else {
			// 	$rate = get_overtime($ot)['overtime_rate'];
			// 	if(strlen($_POST[$emp_id.'-'.$ot]) > 0)
			// 	    $att_items ++;
			// 	write_attendance_range($emp_id, $ot, time_to_float($_POST[$emp_id.'-'.$ot]), $rate, $_POST['from_date'], $_POST['to_date']);
			// }
   //      }
    }
    global $Ajax;
	// $Ajax->activate('controls');
	if($_POST['check_in'])
		display_notification(_('Check in marked.'));
	else
		display_notification(_('Check Out marked.'));
	$Ajax->activate('_page_body');


	
}
if($_POST['check_in']!=null || $_POST['check_out']!=null)
{
	global $Ajax;

	$Ajax->activate('controls');
		// $Ajax->activate('controls');

}
//--------------------------------------------------------------------------


start_form();

start_table(TABLESTYLE2);
start_row();
// date_cells(_('From').':', 'from_date', _('Attendance date begin'));
// date_cells(_('To').':', 'to_date', _('Aattendance date end'));
hidden('from_date',date('d/m/Y'));
hidden('to_date',date('d/m/Y'));
label_cells('Date :' , date('d-m-Y'), "class='tableheader2'",
	"");
// department_list_cells(_('For department').':', 'DeptId', null, _('All departments'), true);
// submit_cells('bulk', _('Bulk'), '', _('Record all as regular work'), true);
end_row();
end_table(1);

$initial_cols = array('ID', _('Employee'), _('check In'), _('check Out'),_(""));
$overtimes = db_query(get_overtime());
$remaining_cols = array();
$overtime_id    = array();
$k=0;
// while($overtime = db_fetch($overtimes)) {
//     $remaining_cols[$k] = $overtime['overtime_name'];
//     $overtime_id[$k] = $overtime['overtime_id'];
//     $k++;
// }

$th = array_merge($initial_cols, $remaining_cols);



// start_table();
// div_start('controls');
// // display_error(check_attended($emp_ids[0], 0, date('d/m/Y'),1));
//     if(!check_attended($emp_ids[0], 0, date('d/m/Y'),1))
// submit_cells('check_in', _(' Check In'), true, '', 'default');
// 	echo  "<td>&nbsp  </td>";
//     if(check_attended($emp_ids[0], 0, date('d/m/Y'),1))
// submit_cells('check_out', _(' Check out'), true, '', 'default');
//      echo  "<td>&nbsp  </td>";

// 	div_end();
		// $Ajax->activate('_page_body');

// end_table(1);
start_table(TABLESTYLE2);

div_start('controls');
$employees = db_query(get_employees(false, false, get_post('DeptId'),$_SESSION['wa_current_user']->user));
// $emp_ids = array();
// display_error(db_num_rows($employees))
    if(db_num_rows($employees)==0)
    {
    	display_error(_("Current User can not link by employee ."));
    }
// $k = 0;
// foreach ($employees as $emp) {
// 	$emp_ids[$k] = $emp['emp_id'];
// 	$k++;
// }
// if(isset($_POST['bulk'])) {
// 	foreach($emp_ids as $emp_id) {
// 		if(get_post($emp_id) == 1)
// 		    $_POST[$emp_id.'-0'] = $Work_hours;
// 		else
// 			$_POST[$emp_id.'-0'] = '';
// 	}
	// $Ajax->activate('_page_body');
// }

table_header($th);

foreach($employees as $employee) {
		$Ajax->activate('_page_body');

    
    start_row();
    label_cell($employee['emp_id'].checkbox(null, $employee['emp_id'], isset($_POST[$employee['emp_id']]) ? $_POST[$employee['emp_id']] : 1));
    label_cell($employee['name']);
    		    $_POST[$employee['emp_id'].'-0'] = $Work_hours;

    $name1 = $employee['emp_id'].'-0';
@$row_in  =get_attended($employee['emp_id'], 0, date('d/m/Y'));


		if(check_leave($employee['emp_id'],date2sql(date('d/m/Y'))))
		{
			label_cell('<spam style="color:red;"> UPL<spam>');
			label_cell('<spam style="color:red;"> UPL<spam>');
			label_cell('<spam style="color:red;"> UPL<spam>');

		}
		elseif (check_weekend(date('l', strtotime(date2sql(date('d/m/Y')))))) {

			label_cell('<spam style="color:red;"> WE<spam>');
			label_cell('<spam style="color:red;"> WE<spam>');
			label_cell('<spam style="color:red;"> WE<spam>');

		}
		elseif (check_holiday(date2sql(date('d/m/Y')))) {
			label_cell('<spam style="color:red;"> Holiday<spam>');
			label_cell('<spam style="color:red;"> Holiday<spam>');
			label_cell('<spam style="color:red;"> Holiday<spam>');

		}
		else
		{


			label_cell((@$row_in['time_in']) ? date("h:i: A ", strtotime(@$row_in['time_in']) ) : '' );
			// text_cells(null, $name1, null, 10, 10,false,'','','',1);
			// $row_out = get_attended($employee['emp_id'], 0, date('d/m/Y'),2);
			label_cell((@$row_in['time_out']) ? date("h:i: A ", strtotime(@$row_in['time_out']) ) : '');

			if(!$row_in['time_in'])
			   submit_cells('check_in', _(' Check In'), true, '', 'default');
			// echo  "<td>&nbsp  </td>";
			if($row_in['time_in'] &&  !$row_in['time_out'])
			  submit_cells('check_out', _(' Check out'), true, '', 'default');
		}

     // echo  "<td>&nbsp  </td>";
    
    // $i=0;
    // while($i < count($remaining_cols)) {
    //     $name2 = $employee['emp_id'].'-'.$overtime_id[$i];
    //     text_cells(null, $name2, null, 10, 10,false,'','','',1);
    //     $i++;
    // }
    end_row();
}
	

		div_end();

end_table();


//--------------------------------------------------------------------------

if(!db_has_employee())
	display_error(_('There are no employees for attendance.'));

// display_error($_POST['check_in']."   ==  ".$_POST['check_out']);


end_form();
end_page();
