<?php
/*=======================================================\
|                      Wayz Consulting	                 |
|--------------------------------------------------------|
|   Creator: Prem                                        |
|   Date :   24-May-2019                                 |
|   Description: Frontaccounting Payroll & Hrm Module    |
|   Free software under GNU GPL                          |
|                                                        |
\=======================================================*/

$page_security = 'SA_HRMLEAVE';
$path_to_root  = '../../..';

include_once($path_to_root . '/includes/session.inc');
add_access_extensions();

$js = '';
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

include_once($path_to_root . '/includes/ui.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_db.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_ui.inc');

page(_($help_context = 'Apply Leave'), false, false, '', $js);
global $Ajax;
if(isset($_GET['id']) || $_POST['Selected_id'])
{
	$Selected_id=($_GET['id'])? $_GET['id'] :$_POST['Selected_id'];
	// $_POST['date']=$date=$_GET['date'];
	// $_POST['emp_id']=$emp_id=$_GET['emp_id'];
}
//--------------------------------------------------------------------------
function can_process(){

	if($_POST['FromDate'] == ''){
		display_error("From date can not be empty");
		return false;
	}
	if($_POST['ToDate'] == ''){
		display_error("To date can not be empty");
		return false;
	}
	if($_POST['memo_'] == ''){
		display_error("Description can not empty");
		return false;
	}
	if(date('Y-m-d',strtotime(date2sql($_POST['FromDate']))) > date('Y-m-d',strtotime(date2sql($_POST['ToDate'])))){
		display_error("Enter a correct date Please");
		return false;	
	}
	if(check_attended_added($_POST['emp_id'], 0, $_POST['FromDate'], $_POST['ToDate']) > 0){
		display_error("Leave Can not be marked because attendence is already marked");
		return false;
	}
	// if(payslip_generated_for_date($_POST['FromDate'], $_POST['emp_id'])) {
 //        display_error(_('Selected date has already paid for this person'));
 //        set_focus('from_date');
 //        return false;
 //    }
 //    if(payslip_generated_for_date($_POST['ToDate'], $_POST['emp_id'])) {
 //        display_error(_('Selected date has already paid for this person'));
 //        set_focus('ToDate');
 //        return false;
 //    }

	$month_no = date('n',strtotime(date2sql($_POST['FromDate'])));
      		$to_date = date2sql($_POST['FromDate']);
      		// display_error($sq)
   if (check_payslip($_POST['emp_id'],$month_no,get_selected_years_to_id(date("Y", strtotime($to_date))) ))
   {
   	display_error(_(' employee payslip is process for selected month'));
        set_focus('emp_id');
        return false;

   }


   $month_no = date('n',strtotime(date2sql($_POST['ToDate'])));
      		$to_date = date2sql($_POST['ToDate']);
   if (check_payslip($_POST['emp_id'],$month_no,get_selected_years_to_id(date("Y", strtotime($to_date))) ))
   {
   	display_error(_(' employee payslip is process for selected month'));
        set_focus('emp_id');
        return false;

   }








	$from = date2sql($_POST['FromDate']);
	$to = date2sql($_POST['ToDate']);
	$begin = new DateTime($from);
	$end = new DateTime($to);
	$end = $end->modify('+1 day');
	$interval = DateInterval::createFromDateString('1 day');
	$period = new DatePeriod($begin, $interval, $end);
   $is_leave=0;
	foreach ($period as $dt) {
       // display_error($dt->format("Y-m-d"));
       if(check_leave($_POST['emp_id'],$dt->format("Y-m-d"),$_POST['Selected_id']))
       {
       	display_error(sql2date($dt->format("Y-m-d"))." has  already marked leave for this person" );
       	$is_leave=1;
       }
		// $day = $dt->format("Y-m-d");
		// $day = sql2date($day);
		// if(check_date_paid($emp_id, $day))
		// 	return true;
	}
	if($is_leave)
	return false;
	
	return true;
}


function delete_leave($id){

	$sql="DELETE FROM ".TB_PREF."attendance WHERE id=".db_escape($id) ;
	        db_query($sql);
}
if (isset($_POST['Process']) && can_process()){

	delete_leave($_POST['Selected_id']);
	add_leave_of_employee($_POST['emp_id'],$_POST['FromDate'],$_POST['ToDate'],$_POST['memo_'],$_POST['paid_leave'],$_POST['approved']);
	display_notification("Leave Has been Added");
	unset($_POST['FromDate']);
	unset($_POST['ToDate']);
	unset($_POST['memo_']);
	  meta_forward($path_to_root.'/modules/FrontHrm/inquiry/leave_inquiry.php','',1);

	
}

start_form();

 $row=get_leave($Selected_id);
 $_POST['emp_id']=$row['emp_id'];
  $_POST['paid_leave']=$row['leave_type'];
   $_POST['approved']=$row['approved'];
   
// display_leave_header();
start_table(TABLESTYLE5_BOX,"",0,0,0,null,"28%","1px solid #656E79;",'11px 10px 10px -8px #2f67ac');
label_cells(_('Employee Name:'),get_employees($_POST['emp_id'])['name']);
	// employee_list_cells(_('Employee Name').':&nbsp;', 'emp_id', null, _("Select employee"), true, false);
check_row(_("Paid Leave"),'paid_leave', null,false,_(" set the paid leave mark"));
check_row(_("Approved"),'approved', null,false,_(" Approved"));

	end_table(1);


br();
 $_POST['FromDate']=sql2date($row['from_leave']);
 $_POST['ToDate']=sql2date($row['to_leave']);

 $_POST['memo_']=$row['reason'];


display_leave_summary();

hidden('emp_id',$_POST['emp_id']);
hidden('Selected_id',$Selected_id);

// hidden('date',$_POST['date']);
if ($_POST['emp_id'] != ""){
	leave_remarks_footer();
	br();
	echo "<center>";
	submit_cells('Process', _("Process Leave"), '',  'default');
	echo "</center>";
}





end_form();
end_page();