<?php
/*=======================================================\
|                        FrontHrm                        |
|--------------------------------------------------------|
|   Creator: Phương                                      |
|   Date :   09-Jul-2017                                 |
|   Description: Frontaccounting Payroll & Hrm Module    |
|   Free software under GNU GPL                          |
|                                                        |
\=======================================================*/

$path_to_root = '../../..';
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . '/reporting/includes/tcpdf.php');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_db.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_ui.inc');

include_once($path_to_root . "/admin/db/tags_db.inc");

$pdf = new TCPDF("P", 'mm', 'A4', true, 'UTF-8');

$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$pdf->SetMargins(16,0,16);

$pdf->SetAutoPageBreak(TRUE, 2);

if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}

//--------------------------------------------------------------------------

$x = $pdf->getPageWidth();
$y = $pdf->getPageHeight();
$img_width = 80;

$val=explode('-', $_POST['PARAM_0']);
$employee_id=$val[0];
$month=$val[1];
$year=$val[2];
// $payslip = get_payslip(false, $_POST['PARAM_0']);
$emp = get_employees($employee_id);
$emp_name = $emp['emp_first_name'].' '.$emp['emp_last_name'];
$emp_id = $emp['emp_id'];
if($emp['department_id'] != 0)
	$emp_dept = get_departments($emp['department_id'])['dept_name'];
else
	$emp_dept = _('Not set');
$payslip_no = $payslip['payslip_no'];
  $fdate = date('d/m/Y',strtotime($emp["emp_hiredate"]));
     $monthName = date('F', mktime(0, 0, 0, $month, 10));
// $from = get_pay_period($payslip_no)[0];
// $to = get_pay_period($payslip_no)[1];
$process_payslip=0;
if(check_payslip($emp['emp_id'],$month,$year))
{
		$row2=check_payslip($emp['emp_id'],$month,$year);  


		if($row2['alloc_amount']>0)
		{
			$res=get_all_payroll_alloc_to(ST_PAYSLIP,$row2['id']); 
			$alloc_row=db_fetch($res);
			// echo "<pre>";
			// print_r($alloc_row);
			// get_trans_view_str($alloc_row["trans_type_from"], $alloc_row["trans_no_from"])
			// display_error($row2['total_salary']." != ".round($row2['alloc_amount'],2));
			if(round($row2['total_salary'],2)!=round($row2['alloc_amount'],2))  
			$text.="<span style='color:green;'> <strong> ".viewer_link(_('Partial Paid'), "modules/FrontHrm/view/view_payroll_allocation_detail.php?id=".$row2['id'])." </strong></span>";
			else 
			$text.= "<span style='color:green;'> <strong> ".viewer_link(_('Paid'), "modules/FrontHrm/view/view_payroll_allocation_detail.php?id=".$row2['id'])." </strong></span>";
		}
		else
			$text.="<span style='color:green;'> <strong> "._("Processed").". </strong></span>";

		$alloc_this_month=$row2['alloc_amount'];



 $process_payslip=1;
}
else 
$text.="<span style='color:red;'>  "._("Un Process")."</span>";


// if($_SESSION['wa_current_user']->access !=2)
// 		$text= strip_tags($text);

$myrow = get_company_prefs();
$comp_name = $myrow['coy_name'];
$comp_adrs = $myrow['postal_address'];
$comp_phone = $myrow['phone'];
$comp_logo = $myrow['coy_logo'];

$company=($process_payslip) ? get_dimension($row2['dimension2_id'],true)['name'] : get_dimension($emp['dimension2_id'],true)['name'];
$project= ($process_payslip) ? get_dimension($row2['dimension_id'],true)['name'] : get_dimension($emp['dimension_id'],true)['name'];
$tag= ($process_payslip) ? get_tag_name($row['d1_tag']) :  get_tag_name($emp['d1_tag']) ;

 
   //ID : $emp_id <br />
$head = "<table border='0.5' cellpadding='5'>
			<tr>
				<td colspan=2>
					"._("Employee:")." $emp_name <br />
					"._("Department:")." $emp_dept <br />
					"._("Designation:")." ".get_salary_scale($emp['salary_scale_id'])['scale_name']." <br />
					"._("Date of Joining:")." $fdate <br />
					"._("Salary Month:")." ".$monthName."-".get_selected_years($year)."<br />
					"._("".get_dimension_label(2)." : ")." $company <br />
					"._("".get_dimension_label(1)." : ")." $project <br />
					"._("Tag : ")." $tag 
				</td>
				<td>
					"._("Print Date:")." ".date("d-M-Y")."<br /> 
					"._("Receipt #:")."  ".$row2['id']."<br />
					"._("Status :")." ".$text."<br />
					"._("payment ID :")." ".get_payment_id($emp['emp_id'],$month,$year)."
				</td>
			</tr>
		</table>";

$title = "<table border='0.5' cellpadding='3'>
		    <tr>
		        <td>"._("Description")."</td>
		 	    <td>"._("Quantity")."</td>
			    <td>"._("Leaves")."</td>
			    <td>"._("Earning")."</td>
			</tr>
		</table>";


$title2 = "<table >
<hr/>
		    <tr>
		 	    <td align='left' ><b>"._("Description")."</b></td>
		        <td ></td>
			    <td><b>"._("Days")."</b></td>
			    <td></td>
			        <td></td>
			            <td><b>AED</b></td>
			                <td><b>AED</b></td>
			</tr>
			<hr/>";
	$basic_salary=($process_payslip)?number_format($row2['basic_salary'],2):number_format($emp['emp_salary'],2);		
$title2 .= "<tr colspan='4' >
			    <td align='left' >"._("Basic Salary")."</td>
			     <td></td>
			      <td></td>
			       <td></td>
			        <td></td>
			        <td></td>
			         <td>".$basic_salary."</td>

              </tr> ";

  $title2 .= "<br/><tr colspan='4' >
			    <td align='left'>"._("Allowance(s)")."</td>
              </tr> "; 
               if($process_payslip)
               $trans =get_payslip_allowance_deduct($emp['emp_id'],$month,$year,1);
               else
               $trans =get_allowances($emp['emp_id']);
                       // display_error(db_num_rows($trans));

                        while($row = db_fetch($trans)){

							$title2 .= "<tr colspan='4'  border='0.5'  cellpadding='5' >
							<td></td>
							<td align='left' colspan='2'   >".$row["allowances"]."</td>
							<td></td>
						
							<td></td>
							<td>".number_format($row["amount"],2)."</td>
							<td></td>
							</tr> "; 
							$sum_allown+=$row["amount"];
                        }           
              	
              	 // $result = getsum_allowances($emp['emp_id']);
                //                 $row1 = db_fetch($result);
                                $all = $sum_allown;

$title2 .= "<tr colspan='4'  style='color:green;' >
							<td colspan='2' align='left' ><b>"._("Total Allowances")."</b></td>
				
							<td></td>
							<td></td>
							<td></td>
								<td></td>
							<td>".number_format($sum_allown,2)."</td>
						
							</tr> "; 




  $title2 .= "<br/><tr align='left'>
			    <td>"._("Deduction(s)")."</td>
              </tr> ";    
			if($process_payslip)
			$trans =get_payslip_allowance_deduct($emp['emp_id'],$month,$year,2);
			else
			$trans =get_deductions($emp['emp_id']);
                        while($row = db_fetch($trans)){

	           $title2 .= "<tr colspan='4' >
							<td></td>
							<td colspan='2'  align='left' >".$row["deductions"]."</td>
							<td></td>
							<td></td>
						
							<td>".number_format($row["amount"],2)."</td>
							<td></td>
							</tr> "; 

                             $sum_deduction+=$row["amount"];
                        }

          // $result = getsum_deductions($emp['emp_id']);
          //                       $row = db_fetch($result);
                                $newAmount-=$sum_deduction;
                                $total_deduction=$sum_deduction;


$title2 .= "<tr style='color:red;' >
							<td  align='left'  colspan='2'><b>"._("Total Deductions")."</b></td>
							<td ></td>
						
							<td></td>
							<td></td>
								<td></td>
							<td> (".number_format($total_deduction,2).") </td>
						
							</tr><hr/> "; 


 
				  $gsalary = ($emp['emp_salary'] + $all)-$total_deduction;
                            $newAmount+=$gsalary;

  $title2 .= "<tr colspan='4' >
			    <td  align='left'>"._("Gross Salary")."</td>
				<td ></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td>".number_format($gsalary,2)."</td>
              </tr> ";   

$limit = cal_days_in_month(CAL_GREGORIAN,$month,get_selected_years($year));
                $leave_days=0;
                for($d=1; $d<=$limit; $d++)
                {
                $time=mktime(12, 0, 0, $month, $d, get_selected_years($year));          
                $is_leave =   check_leave($employee_id,date('Y-m-d', $time),0,0);
                if($is_leave)
                $leave_days++;
                }

    if($leave_days==$limit)
             $leave_days=30;

  $title2 .= "<tr colspan='4' >
			    <td align='left' >"._("UPL")."</td>
			    <td ></td>
				<td>".$leave_days."-Day(s) </td>
				<td></td>
				<td></td>
				<td></td>
              </tr> "; 
             $Work_days = get_company_pref('payroll_month_work_days');
			 $limit = cal_days_in_month(CAL_GREGORIAN,$month,get_selected_years($year));
				$pl_leave_days=0;
				for($d=1; $d<=$limit; $d++)
				{
					$time=mktime(12, 0, 0, $month, $d, get_selected_years($year));          
					$is_leave =   check_leave($employee_id,date('Y-m-d', $time),0,1);
					if($is_leave)
					$pl_leave_days++;
			    }

            if($pl_leave_days==$limit)
             $pl_leave_days=30;	
             $title2 .= "<tr colspan='4' >
			    <td align='left' >"._("PL")."</td>
			    <td ></td>
				<td>".$pl_leave_days."-Day(s) </td>
				<td></td>
				<td></td>
				<td>".number_format( ($emp['emp_salary']/$Work_days )*$pl_leave_days ,2 )."</td>
              </tr> ";
            $pl_salary=($emp['emp_salary']/$Work_days )*$pl_leave_days;
			$overtime_hrs = get_OverTime_hrs($employee_id,$month,get_selected_years($year) ); //payment_days($array_row);
			$Work_days = get_company_pref('payroll_month_work_days');
			$Work_hours = get_company_pref('payroll_work_hours');
			// display_error($Work_days ." == ".$overtime_hrs ); exit();
			$overtime_salary=( ($emp['emp_salary'] / $Work_days )/ $Work_hours ) * get_OverTime_hrs($employee_id,$month,get_selected_years($year) ,1) ;
			// display_error($overtime_hr."   --  ".price_format($overtime_salary)); exit();
    $title2 .= "<tr colspan='4' >
				<td align='left' >"._("Over Time")."</td>
				<td ></td>
				<td>".number_format($overtime_hrs,2)."-hr(s) </td>
				<td></td>
				<td></td>
				<td>".price_format($overtime_salary)."</td>
				</tr> "; 



			$weekends=get_weekends_in_month($month,get_selected_years($year),$employee_id);
			$holiday=get_holiday_in_month($month,get_selected_years($year),$employee_id);
			// $totaldays = get_month_days($employee_id,$month,get_selected_years($year))+$weekends+$holiday; 

			//payment_days($array_row);
			// $days=cal_days_in_month(CAL_GREGORIAN,$month,get_selected_years($year));
			// if($totaldays==$days)
			//   $normal_days_salary =  $gsalary; 
			// else

           if(($leave_days+$pl_leave_days)==$limit)
                $totaldays=0;
               else
			$totaldays =30-($leave_days+$pl_leave_days);
			   $normal_days_salary =   ($gsalary / $Work_days) * $totaldays;

  $title2 .= "<tr colspan='4' >
             <td colspan='2' align='left' >"._("Normal Days")."</td>
           
				<td>".$totaldays."-Day(s)</td>
				<td></td>
				<td></td>
				<td>".number_format( $normal_days_salary ,2 )."</td>
              </tr><hr/> "; 
      $title2 .= " <tr>
             <td colspan='3' align='left' ><b>Salary for the month of ".$monthName."-".get_selected_years($year)."</b></td>
              <td></td>
				<td></td>
				<td></td>
				
				<td align='right'><b>".price_format( $overtime_salary+$normal_days_salary+$pl_salary)."</b></td>

              </tr> "; 
         if($alloc_this_month>0)
       { $title2 .= " <tr>
             <td colspan='3' align='left' ><b>Total payment for the month of ".$monthName."-".get_selected_years($year)."</b></td>
              <td></td>
				<td></td>
				<td></td>
				
				<td align='right'><b>".price_format( $alloc_this_month)."</b></td>

              </tr> ";
            $title2 .= " <tr>
             <td colspan='3' align='left' ><b>Left to allocate for the month of ".$monthName."-".get_selected_years($year)."</b></td>
              <td></td>
				<td></td>
				<td></td>
				
				<td align='right'><b>".price_format( ( $overtime_salary+$normal_days_salary+$pl_salary)-$alloc_this_month)."</b></td>

              </tr> ";

     }
		 $title2 .= "<hr/></table>";



     function get_payment_id($emp_id,$month,$year){

	$row2=check_payslip($emp_id,$month,$year); 
	$result=get_all_payroll_alloc_to(ST_PAYSLIP,$row2['id']) ;
	$view='';
	while ($alloc_row=db_fetch($result)) {
		if($view=='')
		$view.=get_trans_view_str($alloc_row["trans_type_from"], $alloc_row["trans_no_from"]);
		else
		$view.=' , '.get_trans_view_str($alloc_row["trans_type_from"], $alloc_row["trans_no_from"]);

	# code...
	} 

		if($_SESSION['wa_current_user']->access !=2)
			return strip_tags($view);
			else
	return $view;

}

// function get_selected_years($year)
// {
// 	$sql = "SELECT * FROM ".TB_PREF."fiscal_year WHERE id = '$year' ";
//         $result = db_query($sql,"no year found");
//         $myrow = db_fetch($result);
// 		return date("Y" , strtotime($myrow['begin']));
// }
// function get_payslip_allowance($payslip_no) {
//     $sql = "SELECT * FROM ".TB_PREF."payslip_details WHERE payslip_no = ".db_escape($payslip_no);
//     return db_query($sql, _('Could not get payslip details'));
// }
function get_pay_period($payslip_no) {
	
	$sql = "SELECT from_date, to_date FROM ".TB_PREF."payslip WHERE payslip_no = $payslip_no";
	$result = db_fetch(db_query($sql, 'Could not get payslip details.'));
	$from = $result['from_date'];
	$to = $result['to_date'];
	
	return array($from, $to);
}
function get_emp_att($payslip_no, $emp) {
	global $from, $to;
	
	$sql = "SELECT * FROM ".TB_PREF."attendance WHERE emp_id = ".db_escape($emp)." AND att_date BETWEEN '$from' AND '$to'";
	$result = db_query($sql, 'Could not get employee attendance data.');

	return $result;
}
function get_day_amount($payslip_no) {
	global $work_days;
	$sql = "SELECT salary_amount, deductable_leaves FROM ".TB_PREF."payslip WHERE payslip_no = ".db_escape($payslip_no);
	
	$result = db_query($sql, "could not get payslip details.");
	$row = db_fetch($result);

    $amount = ($row['salary_amount'] / ($work_days + $row['deductable_leaves']));

    return $amount;
}
function get_payslip_allocated_advances($payslip_no) {
	$sql = "SELECT SUM(a.amount) FROM ".TB_PREF."employee_advance_allocation a, ".TB_PREF."employee_trans t WHERE t.id = a.trans_no_from AND t.payslip_no = ".db_escape($payslip_no);
	$result = db_query($sql, _('could not get employee allocations amount'));
	$row = db_fetch($result);

	return $row[0];
}

//--------------------------------------------------------------------------

$pdf->AddPage('P', 'A4');

/*display_error(company_path().'/images/'.$comp_logo);
exit;*/
if(get_user($_SESSION['wa_current_user']->user)['language'] == 'ar_EG')
    $pdf->setRTL(true);
if($comp_logo)
	$logo_path = company_path().'/images/'.$comp_logo;
else
	$logo_path = $path_to_root . '/themes/default/images/logo_frontaccounting.jpg';

// $pdf->Image($logo_path, $x/2 - $img_width/2, 20, $img_width);
// $pdf->AddImage($logo_path, $ccol, $pdf->row, 0, 40);
if($pdf->getRTL()){
   $pdf->Image($logo_path, 15, 10, 40); 
}else{
    $pdf->Image($logo_path, 160, 10, 40);
}

$pdf->setFont('helvetica', '', 14);
$pdf->writeHTMLCell(2*$x/3-30, 0, 15, 10, $comp_name, 0, 0, 0, true);
$pdf->setFont('helvetica', '', 10);
// $pdf->newLine();
// $pdf->MultiCell(55, 5, '[LEFT] '.$comp_adrs, 1, 'R', 1, 0, '', '', true);
$pdf->SetFont('dejavusans', '', '', '', true);
if($pdf->getRTL()){
    $pdf->MultiCell(80, 5, _('Address:'), 0, 'R', 1, 1, 15 ,16, true);
$pdf->MultiCell(80, 5, $comp_adrs, 0, 'L', 1, 1, 15 ,16, true);
}else{
    $pdf->MultiCell(80, 5, _('Address:').''.$comp_adrs, 0, 'L', 1, 1, 15 ,16, true);
}
// $pdf->MultiCell(80, 5, _('Address:').''.$comp_adrs, 0, 'L', 1, 1, 15 ,16, true);
// $w, $h, $txt, $border=0, $align='J', $fill=0, $ln=1, $x='', $y='', $reseth=true, $stretch=0, $ishtml=false)

// $pdf->writeHTMLCell($x, 0, 15, 15, _('Address:').'&nbsp;'.$comp_adrs, 0, 0, 0, true);


// $pdf->MultiCell(40, 40, '[VERTICAL ALIGNMENT - TOP] '.$txt, 1, 'J', 1, 0, '', '', true, 0, false, true, 40, 'T');
// $pdf->newLine();

$pdf->writeHTMLCell($x/3-30, 0, 15, 25, _('Date:').'&nbsp;'.Today(), 0, 0, 0, true);

$pdf->writeHTMLCell($x, 0, 15, 30, _('Phone:'), 0, 0, 0, true);
$pdf->writeHTMLCell($x, 0, 30, 30, $comp_phone, 0, 0, 0, true);

if($pdf->getRTL()){
 // $pdf->SetFont('dejavusans',  'BI', 30);
 $pdf->Write(0, _('Payslip'), '', 0, 'C', true, 0, false, false, 0);
 // $pdf->SetFont('dejavusans', '', 10);
}else{
// $pdf->SetFont('helvetica', 'BI', 30);
$pdf->Write(0, _('Payslip'), '', 0, 'C', true, 0, false, false, 0);

// $pdf->SetFont('helvetica', '', 10);
}


// $pdf->SetFont('dejavusans', '', '', '', true);

$pdf->writeHTMLCell($x-30, 0, 15, 60, $head, 0, 0, 0, true);

$pdf->writeHTML("");


// $pdf->SetFont('helvetica', '', 10);
$pdf->writeHTMLCell($x-30, 0, 15, 100, $title2, 0, 0, 0, true, 'C');
// echo 'i ash12dn';
// exit();

 $img_name='user-'.$_SESSION['wa_current_user']->user.'.jpg';
      $is_image =company_path().'/images/'.$img_name;
       // Image($file, $x='', $y='', $w=0, $h=0)
      if (file_exists($is_image))
   $pdf->Image($is_image, 155, 210, 40,20);

$emp=get_employees($emp_id);
 $emp_img_name='user-'.$emp['user_id'].'.jpg';
      $is_emp_image =company_path().'/images/'.$emp_img_name;
       // Image($file, $x='', $y='', $w=0, $h=0)
      if (file_exists($is_emp_image))
   $pdf->Image($is_emp_image, 20, 210, 40,20);
if($pdf->getRTL()){
$pdf->MultiCell(80, 5, _('Employee Signature'), 0, 'R', 1, 1, 20 ,230, true);
$pdf->MultiCell(80, 5, _('Admin Signature'), 0, 'R', 1, 1, 160 ,230, true);
}else{
    $pdf->MultiCell(80, 5, _('Employee Signature'), 0, 'L', 1, 1, 20 ,230, true);
$pdf->MultiCell(80, 5, _('Admin Signature'), 0, 'L', 1, 1, 160 ,230, true);
}


// $pdf->writeHTMLCell($x-30, 0, 15, 150.5, $title, 0, 0, 0, true, 'C');
// $pdf->setFont('helvetica', '', 10);
// $pdf->writeHTMLCell($x-30, 0, 15, 160, $contents, 0, 0, 0, true);


//--------------------------------------------------------------------------

$pdf->Output($path_to_root . '/modules/FrontHrm/reports/payslip_'.$payslip_no.'.pdf', 'I');
?>
<style type="text/css">
	tr.border_bottom td {
  border-bottom:1pt solid black;
}
</style>