<?php
/*=======================================================\
|                        FrontHrm                        |
|--------------------------------------------------------|
|   Creator: Phương                                      |
|   Date :   09-Jul-2017                                 |
|   Description: Frontaccounting Payroll & Hrm Module    |
|   Free software under GNU GPL                          |
|                                                        |
\=======================================================*/

include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_db.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_ui.inc');

define('RC_HRM', 8);

function employees($name, $type) {
	if($type == 'EMPLOYEE')
		return employee_list($name, null, _('No employee filter'), false, false, get_post('PARAM_0'));
}

$reports->register_controls('employees');

// employee_list($name, $id = null, $spec_option = false, $submit_on_change = false, $show_inactive = false, $dept = false, $dim_id=0, $dim_type=0)
function employees_dim_wise($name, $type) {
	if (isset($_GET['REP_ID'])) {
		$rep_id = $_GET['REP_ID'];
	}else{
		$rep_id = $_POST['REP_ID'];
	}
	
	if ($rep_id == '821') {
		
		$department_id = $_POST['PARAM_0'];
     	
	}
	if($type == 'EMPLOYEE_DEM_WISE')
		return employee_list($name, null, _('No employee filter'), false, true, $department_id);
}

$reports->register_controls('employees_dim_wise');

function departments($name, $type) {
	if($type == 'DEPARTMENT')
		return department_list($name, null, _('No department filter'), true);
}

$reports->register_controls('departments');

function departments2_dim_wise($name, $type) {
	// global $rep_id;
	if (isset($_GET['REP_ID'])) {
		$rep_id = $_GET['REP_ID'];
	}else{
		$rep_id = $_POST['REP_ID'];
	}
	// display_error($rep_id);
	if ( $rep_id == '10331'|| $rep_id == '8903'||$rep_id == '8902' || $rep_id = '8902') {
		$dimensions2_id = $_POST['PARAM_1'];
	}
	if ($rep_id == '821' || $rep_id=='8901' ) {
		$dimensions2_id = $_POST['PARAM_0'];
	}
	if($type == 'DEPARTMENT_DIM_WISE')
		return department_list($name, null, _('No department filter'), true,false,$dimensions2_id,2);
}

$reports->register_controls('departments2_dim_wise');

function gender($name, $type) {
	if($type == 'EMPGENDER')
	    return gender_list_($name, null, false);
	   // return "<select name = '".$name."'><option value='-1'>"._('No gender filter')."</option><option value='1'>"._('Male')."</option><option value='0'>"._('Female')."</option><option value='2'>"._('Other')."</option></select>";
}

$reports->register_controls('gender');

function startmonthlist($name, $type) {
	if($type =='STARTMONTHLIST')
		return  salary_month_report(null,$name);
	   
}

$reports->register_controls('startmonthlist');

function fromyearlist($name, $type) {
	if($type =='FROM_YEAR')
		return  years_list($name);
	   
}

$reports->register_controls('fromyearlist');

function dimensions1($name, $type) {

	if($type =='DIMENSIONS1')
	  return dimensions_list($name, null,  _("No Dimension Filter"),'', true, true, 1);
	   
}

$reports->register_controls('dimensions1');

function dimensions2($name, $type) {
	global $myrow_user;
	if ($rep_id == '821' ||$rep_id == '8901' || $rep_id == '10331' || $rep_id = '8902' ) {
		$dimensions2_id = $_POST['PARAM_0'];
	}
	if($type =='DIMENSIONS2')
		return dimensions_list($name, ($myrow_user['dimension_2'])?$myrow_user['dimension_2']:null,($myrow_user['dimension_2'])?null:_("No Dimension Filter"), '', true, false,2, $myrow_user['dimension_2']);
	   
}

$reports->register_controls('dimensions2');

function dimensionassoc($name, $type) {
	if (isset($_GET['REP_ID'])) {
		$rep_id = $_GET['REP_ID'];
	}else{
		$rep_id = $_POST['REP_ID'];
	}
	if ($rep_id == '821' || $rep_id == '8901' || $rep_id == '10331'  || $rep_id = '8902') {
		$dimensions2_id = $_POST['PARAM_0'];
	}
	if($type =='dimensionassoc')
		return associated_dim1_list($name,null,_("No ".get_dimension_label(1)." Filter"),
							'',true,1,true,$dimensions2_id,false,1);
	   
}

$reports->register_controls('dimensionassoc');


function tagassoc($name, $type) {
	if (isset($_GET['REP_ID'])) {
		$rep_id = $_GET['REP_ID'];
	}else{
		$rep_id = $_POST['REP_ID'];
	}
	if ($rep_id == '821' || $rep_id == '8901'  || $rep_id == '10331'  || $rep_id = '8902'  ) {
		$dimensions2_id = $_POST['PARAM_0'];
		$dimensions_id = $_POST['PARAM_1'];
	}
	if($type =='tagassoc')
		return tag_list_dim($name, null, false, _("No Tag Filter"), $dimensions_id,true, false, 
			$dimensions2_id,1);
	   
}


$reports->register_controls('tagassoc');


function leave_type($name, $type) {
	global $myrow_user;
	if($type =='LEAVE_TYPE')
		return leave_type_list_rep( $name, null);
	   
}

$reports->register_controls('leave_type');

function leave_status($name, $type) {
	global $myrow_user;
	if($type =='LEAVE_STATUS')
		return ApprovedUnApproved_list_rep( $name, null);
	   
}

$reports->register_controls('leave_status');

function secrutiry_roles($name, $type) {
	if($type == 'SECURITYROLES')
		return security_roles_list($name, null, true,false,false,true);
}

$reports->register_controls('secrutiry_roles');

function designation($name, $type) {
	if($type == 'DESIGNATION')
		return salaryscale_list_rep($name,null,_('No designation filter'),false,false);
}

$reports->register_controls('designation');

function rep_destination($name, $type) {
	if($type == 'REP_DESTINATION'){
		$sel = array(_("PDF/Printer"), "Excel");
			$def = 0;
		if (user_def_print_destination() == 1)
			$def = 1;
		return array_selector($name, $def, $sel);
	}
}

$reports->register_controls('rep_destination');

//------------------------------------------------------------------------------
$reports->addReportClass(_('Human Resource'), RC_HRM);

$reports->addReport(RC_HRM, '821', _('Employee &Listing'),
	array(	
	
			_('Department') => 'DEPARTMENT_DIM_WISE',
			_('Employee') => 'EMPLOYEE',
			_('Designation') => 'DESIGNATION',
			_('Role') => 'SECURITYROLES',
			_('Gender') => 'EMPGENDER',
			_('Destination') => 'REP_DESTINATION')
		);			

$reports->addReport(RC_HRM, '8901', _('Payslip'),
	array(	
			_('Department') => 'DEPARTMENT_DIM_WISE',
			_('Employee') => 'EMPLOYEE',
			_('Month') => 'STARTMONTHLIST',
		    _('Year') => 'FROM_YEAR',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'
));

$reports->addReport(RC_HRM, '10331', _('Salary Report'),
	array(	
			// _(get_dimension_label(2)) => 'DIMENSIONS2',
			// _(get_dimension_label(1)) => 'dimensionassoc',
			// _("Tag") => 'tagassoc',
			_('Department') => 'DEPARTMENT_DIM_WISE',
			_('Employee') => 'EMPLOYEE_DEM_WISE',
			_('Month') => 'STARTMONTHLIST',
		    _('Year') => 'FROM_YEAR',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'
));

$reports->addReport(RC_HRM, '8902', _('Time Sheet'),
	array(	
			// _(get_dimension_label(2)) => 'DIMENSIONS2',
			// _(get_dimension_label(1)) => 'dimensionassoc',
			// _("Tag") => 'tagassoc',
			_('Department') => 'DEPARTMENT_DIM_WISE',
			_('Employee') => 'EMPLOYEE_DEM_WISE',
			_('Month') => 'STARTMONTHLIST',
		    _('Year') => 'FROM_YEAR',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'
));



$reports->addReport(RC_HRM, '8903', _('Leave Management Report'),
	array(	
		 //    _(get_dimension_label(2)) => 'DIMENSIONS2',
			// _(get_dimension_label(1)) => 'dimensionassoc',
			// _("Tag") => 'tagassoc',
			_('Department') => 'DEPARTMENT_DIM_WISE',
			_('Employee') => 'EMPLOYEE_DEM_WISE',
			_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Leave Type') => 'LEAVE_TYPE',
			_('Leave Status') => 'LEAVE_STATUS',
			// _('Month') => 'STARTMONTHLIST',
		 //    _('Year') => 'FROM_YEAR',
			// _('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'
));